/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.storeutil;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.collection.Dependencies;
import org.neo4j.commandline.dbms.storeutil.LenientInputChunkIterator;
import org.neo4j.commandline.dbms.storeutil.LenientNodeReader;
import org.neo4j.commandline.dbms.storeutil.LenientRelationshipReader;
import org.neo4j.commandline.dbms.storeutil.ReadOnlyTokenRead;
import org.neo4j.commandline.dbms.storeutil.RecreatingTokenHolder;
import org.neo4j.commandline.dbms.storeutil.StoreCopyFilter;
import org.neo4j.commandline.dbms.storeutil.StoreCopyStats;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionMonitors;
import org.neo4j.internal.batchimport.staging.SpectrumExecutionMonitor;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.storemigration.IndexConfigMigrator;
import org.neo4j.kernel.impl.storemigration.IndexProviderMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.SchemaStorage;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStorage35;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStore35;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.DuplicatingLogProvider;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.procedure.builtin.SchemaStatementProcedure;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokensLoader;

public class StoreCopy {
    private final DatabaseLayout from;
    private final Config config;
    private final boolean verbose;
    private final FormatEnum format;
    private final List<String> deleteNodesWithLabels;
    private final List<String> skipLabels;
    private final List<String> skipProperties;
    private final List<String> skipRelationships;
    private final PrintStream out;
    private StoreCopyFilter storeCopyFilter;
    private MutableMap<String, List<NamedToken>> recreatedTokens;
    private TokenHolders tokenHolders;
    private NodeStore nodeStore;
    private PropertyStore propertyStore;
    private RelationshipStore relationshipStore;
    private StoreCopyStats stats;

    public StoreCopy(DatabaseLayout from, Config config, FormatEnum format, List<String> deleteNodesWithLabels, List<String> skipLabels, List<String> skipProperties, List<String> skipRelationships, boolean verbose, PrintStream out) {
        this.from = from;
        this.config = config;
        this.format = format;
        this.deleteNodesWithLabels = deleteNodesWithLabels;
        this.skipLabels = skipLabels;
        this.skipProperties = skipProperties;
        this.skipRelationships = skipRelationships;
        this.out = out;
        this.verbose = verbose;
    }

    public void copyTo(DatabaseLayout toDatabaseLayout, String fromPageCacheMemory, String toPageCacheMemory) throws Exception {
        Path logFilePath = StoreCopy.getLogFilePath(this.config);
        try (BufferedOutputStream logFile = new BufferedOutputStream(Files.newOutputStream(logFilePath, new OpenOption[0]));){
            DuplicatingLogProvider logProvider = new DuplicatingLogProvider(new LogProvider[]{this.getLog(logFile), this.getLog(this.out)});
            Log log = logProvider.getLog("StoreCopy");
            try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
                 JobScheduler scheduler = JobSchedulerFactory.createInitialisedScheduler();
                 PageCache fromPageCache = StoreCopy.createPageCache((FileSystemAbstraction)fs, fromPageCacheMemory, scheduler);
                 PageCache toPageCache = StoreCopy.createPageCache((FileSystemAbstraction)fs, toPageCacheMemory, scheduler);
                 NeoStores neoStores = new StoreFactory(this.from, this.config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), fromPageCache, (FileSystemAbstraction)fs, (LogProvider)NullLogProvider.getInstance()).openAllNeoStores();){
                this.out.println("Starting to copy store, output will be saved to: " + logFilePath.toAbsolutePath());
                this.nodeStore = neoStores.getNodeStore();
                this.propertyStore = neoStores.getPropertyStore();
                this.relationshipStore = neoStores.getRelationshipStore();
                this.recreatedTokens = Maps.mutable.empty();
                this.stats = new StoreCopyStats(log);
                this.tokenHolders = this.createTokenHolders(neoStores);
                this.storeCopyFilter = StoreCopy.convertFilter(this.deleteNodesWithLabels, this.skipLabels, this.skipProperties, this.skipRelationships, this.tokenHolders, this.stats);
                RecordFormats recordFormats = StoreCopy.setupRecordFormats(neoStores.getRecordFormats(), this.format);
                ExecutionMonitor executionMonitor = this.verbose ? new SpectrumExecutionMonitor(2L, TimeUnit.SECONDS, this.out, 100) : ExecutionMonitors.defaultVisible();
                log.info("### Copy Data ###");
                log.info("Source: %s (page cache %s)", new Object[]{this.from.databaseDirectory(), fromPageCacheMemory});
                log.info("Target: %s (page cache %s)", new Object[]{toDatabaseLayout.databaseDirectory(), toPageCacheMemory});
                log.info("Empty database created, will start importing readable data from the source.");
                BatchImporter batchImporter = BatchImporterFactory.withHighestPriority().instantiate(toDatabaseLayout, (FileSystemAbstraction)fs, toPageCache, Configuration.DEFAULT, (LogService)new SimpleLogService((LogProvider)logProvider), executionMonitor, AdditionalInitialIds.EMPTY, this.config, recordFormats, ImportLogic.NO_MONITOR, null, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer());
                batchImporter.doImport(Input.input(this::nodeIterator, this::relationshipIterator, (org.neo4j.internal.batchimport.input.IdType)org.neo4j.internal.batchimport.input.IdType.INTEGER, (Input.Estimates)this.getEstimates(), (ReadableGroups)new Groups()));
                this.stats.printSummary();
                log.info("### Extracting schema ###");
                log.info("Trying to extract schema...");
                Collection<String> schemaStatements = neoStores.getRecordFormats().hasCapability((Capability)RecordStorageCapability.FLEXIBLE_SCHEMA_STORE) ? StoreCopy.getSchemaStatements40(this.stats, neoStores.getSchemaStore(), this.tokenHolders) : this.getSchemaStatements35(log, neoStores.getRecordFormats(), fromPageCache, (FileSystemAbstraction)fs, this.tokenHolders);
                int schemaCount = schemaStatements.size();
                if (schemaCount == 0) {
                    log.info("... found %d schema definitions.", new Object[]{schemaCount});
                } else {
                    log.info("... found %d schema definitions. The following can be used to recreate the schema:", new Object[]{schemaCount});
                    String newLine = System.lineSeparator();
                    log.info(newLine + newLine + String.join((CharSequence)(";" + newLine), schemaStatements));
                    log.info("You have to manually apply the above commands to the database when it is stared to recreate the indexes and constraints. The commands are saved to " + logFilePath.toAbsolutePath() + " as well for reference.");
                }
                if (this.recreatedTokens.notEmpty()) {
                    log.info("The following tokens were recreated (with new names) in order to not leave data behind:");
                    this.recreatedTokens.forEach((type, tokens) -> {
                        for (NamedToken token : tokens) {
                            log.info("   `%s` (with id %s(%s)).", new Object[]{token.name(), type, token.id()});
                        }
                    });
                }
            }
        }
    }

    private TokenHolders createTokenHolders(NeoStores neoStores) {
        TokenHolder propertyKeyTokens = this.createTokenHolder("PropertyKey");
        TokenHolder labelTokens = this.createTokenHolder("Label");
        TokenHolder relationshipTypeTokens = this.createTokenHolder("RelationshipType");
        TokenHolders tokenHolders = new TokenHolders(propertyKeyTokens, labelTokens, relationshipTypeTokens);
        tokenHolders.setInitialTokens(this.filterDuplicateTokens(StoreTokens.allReadableTokens((NeoStores)neoStores)));
        return tokenHolders;
    }

    private TokenHolder createTokenHolder(String tokenType) {
        return new RecreatingTokenHolder(tokenType, this.stats, this.recreatedTokens);
    }

    private TokensLoader filterDuplicateTokens(final TokensLoader loader) {
        return new TokensLoader(){

            public List<NamedToken> getPropertyKeyTokens() {
                return this.unique(loader.getPropertyKeyTokens());
            }

            public List<NamedToken> getLabelTokens() {
                return this.unique(loader.getLabelTokens());
            }

            public List<NamedToken> getRelationshipTypeTokens() {
                return this.unique(loader.getRelationshipTypeTokens());
            }

            private List<NamedToken> unique(List<NamedToken> tokens) {
                if (!tokens.isEmpty()) {
                    HashSet<String> names = new HashSet<String>(tokens.size());
                    int i = 0;
                    while (i < tokens.size()) {
                        if (names.add(tokens.get(i).name())) {
                            ++i;
                            continue;
                        }
                        this.removeUnordered(tokens, i);
                    }
                }
                return tokens;
            }

            private void removeUnordered(List<NamedToken> list, int index) {
                int lastIndex = list.size() - 1;
                NamedToken endToken = list.remove(lastIndex);
                if (index < lastIndex) {
                    list.set(index, endToken);
                }
            }
        };
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystem, String memory, JobScheduler jobScheduler) {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.open(fileSystem);
        MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator((String)memory, (MemoryAllocationTracker)EmptyMemoryTracker.INSTANCE);
        return new MuninnPageCache((PageSwapperFactory)swapperFactory, memoryAllocator, PageCacheTracer.NULL, (PageCursorTracerSupplier)DefaultPageCursorTracerSupplier.INSTANCE, EmptyVersionContextSupplier.EMPTY, jobScheduler);
    }

    private LogProvider getLog(OutputStream out) {
        return FormattedLogProvider.withZoneId((ZoneId)((LogTimeZone)this.config.get(GraphDatabaseSettings.db_timezone)).getZoneId()).withDefaultLogLevel(this.verbose ? Level.DEBUG : Level.INFO).toOutputStream(out);
    }

    private static Path getLogFilePath(Config config) {
        return ((Path)config.get(GraphDatabaseSettings.logs_directory)).resolve(String.format("neo4j-admin-copy-%s.log", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(new Date())));
    }

    private static Collection<String> getSchemaStatements40(StoreCopyStats stats, SchemaStore schemaStore, TokenHolders tokenHolders) {
        HashMap<String, IndexDescriptor> indexes = new HashMap<String, IndexDescriptor>();
        ArrayList<ConstraintDescriptor> constraints = new ArrayList<ConstraintDescriptor>();
        SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)schemaStore, (TokenHolders)tokenHolders);
        schemaRuleAccess.indexesGetAllIgnoreMalformed().forEachRemaining(i -> indexes.put(i.getName(), (IndexDescriptor)i));
        schemaRuleAccess.constraintsGetAllIgnoreMalformed().forEachRemaining(constraints::add);
        return StoreCopy.getSchemaStatements(stats, tokenHolders, indexes, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getSchemaStatements35(Log log, RecordFormats recordFormats, PageCache fromPageCache, FileSystemAbstraction fs, TokenHolders tokenHolders) {
        HashMap<String, IndexDescriptor> indexes = new HashMap<String, IndexDescriptor>();
        ArrayList<ConstraintDescriptor> constraints = new ArrayList<ConstraintDescriptor>();
        LifeSupport life = new LifeSupport();
        try (SchemaStore35 schemaStore35 = new SchemaStore35(this.from.schemaStore(), this.from.idSchemaStore(), this.config, IdType.SCHEMA, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), fromPageCache, (LogProvider)NullLogProvider.getInstance(), recordFormats, new OpenOption[0]);){
            schemaStore35.initialise(true);
            SchemaStorage35 schemaStorage35 = new SchemaStorage35((RecordStore)schemaStore35);
            Dependencies deps = new Dependencies();
            Monitors monitors = new Monitors();
            deps.satisfyDependencies(new Object[]{fs, this.config, fromPageCache, NullLogService.getInstance(), monitors, RecoveryCleanupWorkCollector.immediate()});
            DatabaseExtensionContext extensionContext = new DatabaseExtensionContext(this.from, DatabaseInfo.UNKNOWN, (DependencySatisfier)deps);
            Collection extensionFactories = Services.loadAll(ExtensionFactory.class);
            DatabaseExtensions databaseExtensions = (DatabaseExtensions)life.add((Lifecycle)new DatabaseExtensions(extensionContext, (Iterable)extensionFactories, deps, ExtensionFailureStrategies.ignore()));
            DefaultIndexProviderMap indexProviderMap = (DefaultIndexProviderMap)life.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)databaseExtensions, this.config));
            life.start();
            LinkedHashMap ruleById = new LinkedHashMap();
            schemaStorage35.getAll().forEach(rule -> ruleById.put(rule.getId(), rule));
            RecordStorageMigrator.schemaGenerateNames((SchemaStorage)schemaStorage35, (TokenHolders)tokenHolders, ruleById);
            for (Map.Entry entry : ruleById.entrySet()) {
                SchemaRule schemaRule = (SchemaRule)entry.getValue();
                if (schemaRule instanceof IndexDescriptor) {
                    IndexDescriptor indexDescriptor = (IndexDescriptor)schemaRule;
                    try {
                        indexDescriptor = (IndexDescriptor)IndexConfigMigrator.migrateIndexConfig((SchemaRule)indexDescriptor, (DatabaseLayout)this.from, (FileSystemAbstraction)fs, (PageCache)fromPageCache, (IndexProviderMap)indexProviderMap, (Log)log);
                        indexDescriptor = (IndexDescriptor)IndexProviderMigrator.upgradeIndexProvider((SchemaRule)indexDescriptor);
                        indexes.put(indexDescriptor.getName(), indexDescriptor);
                    }
                    catch (IOException e) {
                        this.stats.invalidIndex(indexDescriptor, e);
                    }
                    continue;
                }
                if (!(schemaRule instanceof ConstraintDescriptor)) continue;
                constraints.add((ConstraintDescriptor)schemaRule);
            }
        }
        catch (Exception e) {
            log.error(String.format("Failed to read schema store %s with 3.5 parser", this.from.schemaStore()), (Throwable)e);
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            life.shutdown();
        }
        return StoreCopy.getSchemaStatements(this.stats, tokenHolders, indexes, constraints);
    }

    private static Collection<String> getSchemaStatements(StoreCopyStats stats, TokenHolders tokenHolders, Map<String, IndexDescriptor> indexes, List<ConstraintDescriptor> constraints) {
        ReadOnlyTokenRead tokenRead = new ReadOnlyTokenRead(tokenHolders);
        HashMap<String, String> schemaStatements = new HashMap<String, String>();
        for (IndexDescriptor index : indexes.values()) {
            try {
                if (index.isUnique()) continue;
                schemaStatements.put(index.getName(), SchemaStatementProcedure.createStatement((TokenRead)tokenRead, (IndexDescriptor)index));
            }
            catch (Exception e) {
                stats.invalidIndex(index, e);
            }
        }
        for (ConstraintDescriptor constraint : constraints) {
            try {
                schemaStatements.put(constraint.getName(), SchemaStatementProcedure.createStatement(indexes::get, (TokenRead)tokenRead, (ConstraintDescriptor)constraint));
            }
            catch (Exception e) {
                stats.invalidConstraint(constraint, e);
            }
        }
        return schemaStatements.values();
    }

    private static RecordFormats setupRecordFormats(RecordFormats fromRecordFormat, FormatEnum format) {
        if (format == FormatEnum.same) {
            return (RecordFormats)RecordFormatSelector.findLatestFormatInFamily((RecordFormats)fromRecordFormat).orElseThrow(() -> new IllegalArgumentException("This version do not support format family " + fromRecordFormat.getFormatFamily()));
        }
        if (format == FormatEnum.high_limit) {
            try {
                return RecordFormatSelector.selectForConfig((Config)Config.defaults((Setting)GraphDatabaseSettings.record_format, (Object)"high_limit"), (LogProvider)NullLogProvider.getInstance());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unable to load high-limit format, make sure you are using the correct version of neo4j.", e);
            }
        }
        return Standard.LATEST_RECORD_FORMATS;
    }

    private static StoreCopyFilter convertFilter(List<String> deleteNodesWithLabels, List<String> skipLabels, List<String> skipProperties, List<String> skipRelationships, TokenHolders tokenHolders, StoreCopyStats stats) {
        int[] deleteNodesWithLabelsIds = StoreCopy.getTokenIds(deleteNodesWithLabels, tokenHolders.labelTokens());
        int[] skipLabelsIds = StoreCopy.getTokenIds(skipLabels, tokenHolders.labelTokens());
        int[] skipPropertyIds = StoreCopy.getTokenIds(skipProperties, tokenHolders.propertyKeyTokens());
        int[] skipRelationshipIds = StoreCopy.getTokenIds(skipRelationships, tokenHolders.relationshipTypeTokens());
        return new StoreCopyFilter(stats, deleteNodesWithLabelsIds, skipLabelsIds, skipPropertyIds, skipRelationshipIds);
    }

    private static int[] getTokenIds(List<String> tokenNames, TokenHolder tokenHolder) {
        int[] labelIds = new int[tokenNames.size()];
        int i = 0;
        for (String tokenName : tokenNames) {
            int labelId = tokenHolder.getIdByName(tokenName);
            if (labelId == -1) {
                throw new RuntimeException("Unable to find token: " + tokenName);
            }
            labelIds[i++] = labelId;
        }
        return labelIds;
    }

    private Input.Estimates getEstimates() {
        long propertyStoreSize = StoreCopy.storeSize((CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader>)this.propertyStore) / 2L + StoreCopy.storeSize((CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader>)this.propertyStore.getStringStore()) / 2L + StoreCopy.storeSize((CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader>)this.propertyStore.getArrayStore()) / 2L;
        return Input.knownEstimates((long)this.nodeStore.getNumberOfIdsInUse(), (long)this.relationshipStore.getNumberOfIdsInUse(), (long)this.propertyStore.getNumberOfIdsInUse(), (long)this.propertyStore.getNumberOfIdsInUse(), (long)(propertyStoreSize / 2L), (long)(propertyStoreSize / 2L), (long)this.tokenHolders.labelTokens().size());
    }

    private static long storeSize(CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader> store) {
        try {
            return store.getStoreSize();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private LenientInputChunkIterator nodeIterator() {
        return new LenientInputChunkIterator((CommonAbstractStore)this.nodeStore){

            public InputChunk newChunk() {
                return new LenientNodeReader(StoreCopy.this.stats, StoreCopy.this.nodeStore, StoreCopy.this.propertyStore, StoreCopy.this.tokenHolders, StoreCopy.this.storeCopyFilter);
            }
        };
    }

    private LenientInputChunkIterator relationshipIterator() {
        return new LenientInputChunkIterator((CommonAbstractStore)this.relationshipStore){

            public InputChunk newChunk() {
                return new LenientRelationshipReader(StoreCopy.this.stats, StoreCopy.this.relationshipStore, StoreCopy.this.propertyStore, StoreCopy.this.tokenHolders, StoreCopy.this.storeCopyFilter);
            }
        };
    }

    public static enum FormatEnum {
        same,
        standard,
        high_limit;

    }
}

