/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.storeutil;

import java.io.IOException;
import org.neo4j.commandline.dbms.storeutil.LenientStoreInputChunk;
import org.neo4j.commandline.dbms.storeutil.StoreCopyFilter;
import org.neo4j.commandline.dbms.storeutil.StoreCopyStats;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

class LenientRelationshipReader
extends LenientStoreInputChunk {
    private final RelationshipStore relationshipStore;
    private final RelationshipRecord record;
    private final StoreCopyFilter.TokenLookup tokenLookup;

    LenientRelationshipReader(StoreCopyStats stats, RelationshipStore relationshipStore, PropertyStore propertyStore, TokenHolders tokenHolders, StoreCopyFilter storeCopyFilter) {
        super(stats, propertyStore, tokenHolders, relationshipStore.openPageCursorForReading(0L), storeCopyFilter);
        this.relationshipStore = relationshipStore;
        this.record = (RelationshipRecord)relationshipStore.newRecord();
        TokenHolder tokenHolder = tokenHolders.relationshipTypeTokens();
        this.tokenLookup = id -> tokenHolder.getTokenById(id).name();
    }

    @Override
    void readAndVisit(long id, InputEntityVisitor visitor) throws IOException {
        this.relationshipStore.getRecordByCursor(id, (AbstractBaseRecord)this.record, RecordLoad.NORMAL, this.cursor);
        if (this.record.inUse()) {
            this.relationshipStore.ensureHeavy((AbstractBaseRecord)this.record);
            int relType = this.record.getType();
            String relName = this.storeCopyFilter.filterRelationship(relType, this.tokenLookup);
            if (relName != null) {
                visitor.type(relName);
                visitor.startId((Object)this.record.getFirstNode(), Group.GLOBAL);
                visitor.endId((Object)this.record.getSecondNode(), Group.GLOBAL);
                this.visitPropertyChainNoThrow(visitor, (PrimitiveRecord)this.record);
                visitor.endOfEntity();
            } else {
                this.stats.removed.increment();
            }
        } else {
            this.stats.unused.increment();
        }
    }

    @Override
    String recordType() {
        return "Relationship";
    }
}

