/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Utils;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;

public class Loader {
    public void load(Path archive, Path databaseDestination, Path transactionLogsDirectory) throws IOException, IncorrectFormat {
        this.validatePath(databaseDestination);
        this.validatePath(transactionLogsDirectory);
        this.createDestination(databaseDestination);
        this.createDestination(transactionLogsDirectory);
        try (ArchiveInputStream stream = Loader.openArchiveIn(archive);){
            ArchiveEntry entry;
            while ((entry = this.nextEntry(stream, archive)) != null) {
                Path destination = Loader.determineEntryDestination(entry, databaseDestination, transactionLogsDirectory);
                this.loadEntry(destination, stream, entry);
            }
        }
    }

    private void createDestination(Path destination) throws IOException {
        if (!destination.toFile().exists()) {
            Files.createDirectories(destination, new FileAttribute[0]);
        }
    }

    private void validatePath(Path path) throws FileSystemException {
        if (Files.exists(path, new LinkOption[0])) {
            throw new FileAlreadyExistsException(path.toString());
        }
        Utils.checkWritableDirectory(path.getParent());
    }

    private static Path determineEntryDestination(ArchiveEntry entry, Path databaseDestination, Path transactionLogsDirectory) {
        String entryName = Paths.get(entry.getName(), new String[0]).getFileName().toString();
        return TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(null, entryName) ? transactionLogsDirectory : databaseDestination;
    }

    private ArchiveEntry nextEntry(ArchiveInputStream stream, Path archive) throws IncorrectFormat {
        try {
            return stream.getNextEntry();
        }
        catch (IOException e) {
            throw new IncorrectFormat(archive, e);
        }
    }

    private void loadEntry(Path destination, ArchiveInputStream stream, ArchiveEntry entry) throws IOException {
        Path file = destination.resolve(entry.getName());
        if (!file.normalize().startsWith(destination)) {
            throw new IOException("Zip entry outside destination path.");
        }
        if (entry.isDirectory()) {
            Files.createDirectories(file, new FileAttribute[0]);
        } else {
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                Utils.copy((InputStream)stream, output);
            }
        }
    }

    private static ArchiveInputStream openArchiveIn(Path archive) throws IOException, IncorrectFormat {
        GzipCompressorInputStream compressor;
        InputStream input = Files.newInputStream(archive, new OpenOption[0]);
        try {
            compressor = new GzipCompressorInputStream(input);
        }
        catch (IOException e) {
            input.close();
            throw new IncorrectFormat(archive, e);
        }
        return new TarArchiveInputStream((InputStream)compressor);
    }
}

