/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.StoreLayout;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.locker.GlobalStoreLocker;
import org.neo4j.kernel.internal.locker.StoreLocker;

class StoreLockChecker
implements Closeable {
    private final FileSystemAbstraction fileSystem;
    private final StoreLocker storeLocker;

    private StoreLockChecker(FileSystemAbstraction fileSystem, StoreLayout storeLayout) {
        this.fileSystem = fileSystem;
        this.storeLocker = new GlobalStoreLocker(fileSystem, storeLayout);
    }

    static Closeable check(StoreLayout storeLayout) throws CannotWriteException {
        Path lockFile = storeLayout.storeLockFile().toPath();
        if (Files.exists(lockFile, new LinkOption[0])) {
            if (Files.isWritable(lockFile)) {
                StoreLockChecker storeLocker = new StoreLockChecker((FileSystemAbstraction)new DefaultFileSystemAbstraction(), storeLayout);
                try {
                    storeLocker.checkLock();
                    return storeLocker;
                }
                catch (StoreLockException le) {
                    try {
                        storeLocker.close();
                    }
                    catch (IOException e) {
                        le.addSuppressed((Throwable)e);
                    }
                    throw le;
                }
            }
            throw new CannotWriteException(lockFile);
        }
        return () -> {};
    }

    private void checkLock() {
        this.storeLocker.checkLock();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.storeLocker, this.fileSystem});
    }
}

