/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Connector;

public class ConfigLoader {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";

    private ConfigLoader() {
    }

    public static Config loadConfig(Optional<File> homeDir, Optional<File> configFile, Pair<String, String> ... configOverrides) {
        Map<String, String> overriddenSettings = ConfigLoader.calculateSettings(homeDir, configOverrides);
        return Config.embeddedDefaults(configFile, overriddenSettings);
    }

    public static Config loadServerConfig(Optional<File> configFile, Pair<String, String> ... configOverrides) throws IOException {
        return ConfigLoader.loadServerConfig(Optional.empty(), configFile, configOverrides, Collections.emptyList());
    }

    public static Config loadServerConfig(Optional<File> homeDir, Optional<File> configFile, Pair<String, String>[] configOverrides, Collection<ConfigurationValidator> additionalValidators) {
        Map<String, String> overriddenSettings = ConfigLoader.calculateSettings(homeDir, configOverrides);
        return Config.serverDefaults(configFile, overriddenSettings, additionalValidators);
    }

    public static Config loadConfigWithConnectorsDisabled(Optional<File> homeDir, Optional<File> configFile, Pair<String, String> ... configOverrides) {
        Map<String, String> overriddenSettings = ConfigLoader.calculateSettings(homeDir, configOverrides);
        return ConfigLoader.disableAllConnectors(Config.embeddedDefaults(configFile, overriddenSettings));
    }

    private static Map<String, String> calculateSettings(Optional<File> homeDir, Pair<String, String>[] configOverrides) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.putAll(ConfigLoader.toMap(configOverrides));
        settings.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.map(File::getAbsolutePath).orElse(System.getProperty("user.dir")));
        return settings;
    }

    private static Map<String, String> toMap(Pair<String, String>[] configOverrides) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        for (Pair<String, String> configOverride : configOverrides) {
            overrides.put((String)configOverride.first(), (String)configOverride.other());
        }
        return overrides;
    }

    private static Config disableAllConnectors(Config config) {
        return config.with(config.allConnectorIdentifiers().stream().collect(Collectors.toMap(id -> new Connector((String)id).enabled.name(), id -> "false")));
    }
}

