/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.Importer;
import org.neo4j.commandline.dbms.config.WrappedBatchImporterConfigurationForNeo4jAdmin;
import org.neo4j.commandline.dbms.config.WrappedCsvInputConfigurationForNeo4jAdmin;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.tooling.ImportTool;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

class CsvImporter
implements Importer {
    private final Collection<Args.Option<File[]>> nodesFiles;
    private final Collection<Args.Option<File[]>> relationshipsFiles;
    private final IdType idType;
    private final Charset inputEncoding;
    private final Config databaseConfig;
    private final Args args;
    private final OutsideWorld outsideWorld;
    private final String reportFileName;
    private final boolean ignoreBadRelationships;
    private final boolean ignoreDuplicateNodes;
    private final boolean ignoreExtraColumns;

    CsvImporter(Args args, Config databaseConfig, OutsideWorld outsideWorld) throws IncorrectUsage {
        this.args = args;
        this.outsideWorld = outsideWorld;
        this.nodesFiles = ImportTool.extractInputFiles((Args)args, (String)"nodes", (PrintStream)outsideWorld.errorStream());
        this.relationshipsFiles = ImportTool.extractInputFiles((Args)args, (String)"relationships", (PrintStream)outsideWorld.errorStream());
        this.reportFileName = (String)args.interpretOption("report-file", Converters.withDefault((Object)"import.report"), s -> s, new Validator[0]);
        this.ignoreExtraColumns = args.getBoolean("ignore-extra-columns", Boolean.valueOf(false));
        this.ignoreDuplicateNodes = args.getBoolean("ignore-duplicate-nodes", Boolean.valueOf(false));
        this.ignoreBadRelationships = args.getBoolean("ignore-missing-nodes", Boolean.valueOf(false));
        try {
            ImportTool.validateInputFiles(this.nodesFiles, this.relationshipsFiles);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        this.idType = (IdType)args.interpretOption("id-type", Converters.withDefault((Object)IdType.STRING), from -> IdType.valueOf((String)from.toUpperCase()), new Validator[0]);
        this.inputEncoding = Charset.forName(args.get("input-encoding", Charset.defaultCharset().name()));
        this.databaseConfig = databaseConfig;
    }

    @Override
    public void doImport() throws IOException {
        FileSystemAbstraction fs = this.outsideWorld.fileSystem();
        File storeDir = (File)this.databaseConfig.get(DatabaseManagementSystemSettings.database_path);
        File logsDir = (File)this.databaseConfig.get(GraphDatabaseSettings.logs_directory);
        File reportFile = new File(this.reportFileName);
        BufferedOutputStream badOutput = new BufferedOutputStream(fs.openAsOutputStream(reportFile, false));
        Collector badCollector = Collectors.badCollector((OutputStream)badOutput, (int)(this.isIgnoringSomething() ? -1 : 0), (int)Collectors.collect((boolean)this.ignoreBadRelationships, (boolean)this.ignoreDuplicateNodes, (boolean)this.ignoreExtraColumns));
        WrappedBatchImporterConfigurationForNeo4jAdmin configuration = new WrappedBatchImporterConfigurationForNeo4jAdmin(ImportTool.importConfiguration(null, (boolean)false, (Config)this.databaseConfig));
        CsvInput input = new CsvInput(ImportTool.nodeData((Charset)this.inputEncoding, this.nodesFiles), DataFactories.defaultFormatNodeFileHeader(), ImportTool.relationshipData((Charset)this.inputEncoding, this.relationshipsFiles), DataFactories.defaultFormatRelationshipFileHeader(), this.idType, (org.neo4j.unsafe.impl.batchimport.input.csv.Configuration)new WrappedCsvInputConfigurationForNeo4jAdmin(ImportTool.csvConfiguration((Args)this.args, (boolean)false)), badCollector, configuration.maxNumberOfProcessors());
        ImportTool.doImport((PrintStream)this.outsideWorld.errorStream(), (PrintStream)this.outsideWorld.errorStream(), (File)storeDir, (File)logsDir, (File)reportFile, (FileSystemAbstraction)fs, this.nodesFiles, this.relationshipsFiles, (boolean)false, (Input)input, (Config)this.databaseConfig, (OutputStream)badOutput, (Configuration)configuration);
    }

    private boolean isIgnoringSomething() {
        return this.ignoreBadRelationships || this.ignoreDuplicateNodes || this.ignoreExtraColumns;
    }
}

