/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.dbms.Importer;
import org.neo4j.commandline.dbms.ImporterFactory;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.server.configuration.ConfigLoader;

public class ImportCommand
implements AdminCommand {
    public static final String DEFAULT_REPORT_FILE_NAME = "import.report";
    private static final String[] allowedModes = new String[]{"database", "csv"};
    private static final Arguments databaseArguments = new Arguments().withArgument((NamedArgument)new MandatoryNamedArg("mode", "database", "Import a pre-3.0 installation."){

        public String usage() {
            return String.format("--%s=%s", this.name(), this.exampleValue());
        }
    }).withDatabase().withAdditionalConfig().withArgument((NamedArgument)new OptionalNamedArg("from", "source-directory", "", "The location of the pre-3.0 database (e.g. <neo4j-root>/data/graph.db)."));
    private static final Arguments csvArguments = new Arguments().withArgument((NamedArgument)new OptionalNamedArg("mode", "csv", "csv", "Import a collection of CSV files."){

        public String usage() {
            return String.format("[--%s=%s]", this.name(), this.exampleValue());
        }
    }).withDatabase().withAdditionalConfig().withArgument((NamedArgument)new OptionalNamedArg("report-file", "filename", "import.report", "File in which to store the report of the csv-import.")).withArgument((NamedArgument)new OptionalNamedArg("nodes[:Label1:Label2]", "\"file1,file2,...\"", "", "Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks.")).withArgument((NamedArgument)new OptionalNamedArg("relationships[:RELATIONSHIP_TYPE]", "\"file1,file2,...\"", "", "Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks.")).withArgument((NamedArgument)new OptionalNamedArg("id-type", new String[]{"STRING", "INTEGER", "ACTUAL"}, "STRING", "Each node must provide a unique id. This is used to find the correct nodes when creating relationships. Possible values are\n  STRING: arbitrary strings for identifying nodes,\n  INTEGER: arbitrary integer values for identifying nodes,\n  ACTUAL: (advanced) actual node ids.\nFor more information on id handling, please see the Neo4j Manual: https://neo4j.com/docs/operations-manual/current/tools/import/")).withArgument((NamedArgument)new OptionalNamedArg("input-encoding", "character-set", "UTF-8", "Character set that input data is encoded in."));
    private static final Arguments allArguments = new Arguments().withDatabase().withAdditionalConfig().withArgument((NamedArgument)new OptionalNamedArg("mode", allowedModes, "csv", "Import a collection of CSV files or a pre-3.0 installation.")).withArgument((NamedArgument)new OptionalNamedArg("from", "source-directory", "", "The location of the pre-3.0 database (e.g. <neo4j-root>/data/graph.db).")).withArgument((NamedArgument)new OptionalNamedArg("report-file", "filename", "import.report", "File in which to store the report of the csv-import.")).withArgument((NamedArgument)new OptionalNamedArg("nodes[:Label1:Label2]", "\"file1,file2,...\"", "", "Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks.")).withArgument((NamedArgument)new OptionalNamedArg("relationships[:RELATIONSHIP_TYPE]", "\"file1,file2,...\"", "", "Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks.")).withArgument((NamedArgument)new OptionalNamedArg("id-type", new String[]{"STRING", "INTEGER", "ACTUAL"}, "STRING", "Each node must provide a unique id. This is used to find the correct nodes when creating relationships. Possible values are:\n  STRING: arbitrary strings for identifying nodes,\n  INTEGER: arbitrary integer values for identifying nodes,\n  ACTUAL: (advanced) actual node ids.\nFor more information on id handling, please see the Neo4j Manual: https://neo4j.com/docs/operations-manual/current/tools/import/")).withArgument((NamedArgument)new OptionalNamedArg("input-encoding", "character-set", "UTF-8", "Character set that input data is encoded in."));
    private final Path homeDir;
    private final Path configDir;
    private final OutsideWorld outsideWorld;
    private final ImporterFactory importerFactory;

    public static Arguments databaseArguments() {
        return databaseArguments;
    }

    public static Arguments csvArguments() {
        return csvArguments;
    }

    public static Arguments allArguments() {
        return allArguments;
    }

    public ImportCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this(homeDir, configDir, outsideWorld, new ImporterFactory());
    }

    ImportCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld, ImporterFactory importerFactory) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
        this.importerFactory = importerFactory;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Optional additionalConfigFile;
        String database;
        String mode;
        try {
            mode = allArguments.parse("mode", args);
            database = allArguments.parse("database", args);
            additionalConfigFile = allArguments.parseOptionalPath("additional-config", args);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        try {
            Config config = ImportCommand.loadNeo4jConfig(this.homeDir, this.configDir, database, this.loadAdditionalConfig(additionalConfigFile));
            Validators.CONTAINS_NO_EXISTING_DATABASE.validate(config.get(DatabaseManagementSystemSettings.database_path));
            Importer importer = this.importerFactory.getImporterForMode(mode, Args.parse((String[])args), config, this.outsideWorld);
            importer.doImport();
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> loadAdditionalConfig(Optional<Path> additionalConfigFile) {
        if (additionalConfigFile.isPresent()) {
            try {
                return MapUtil.load((File)additionalConfigFile.get().toFile());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read configuration file [%s]", additionalConfigFile), e);
            }
        }
        return new HashMap<String, String>();
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName, Map<String, String> additionalConfig) {
        ConfigLoader configLoader = new ConfigLoader(ImportCommand.settings());
        Config config = configLoader.loadOfflineConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()));
        additionalConfig.put(DatabaseManagementSystemSettings.active_database.name(), databaseName);
        return config.with(additionalConfig, new Class[0]);
    }

    private static List<Class<?>> settings() {
        return Arrays.asList(GraphDatabaseSettings.class, DatabaseManagementSystemSettings.class);
    }
}

