/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.CsvImporter;
import org.neo4j.commandline.dbms.DatabaseImporter;
import org.neo4j.commandline.dbms.Importer;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.configuration.Config;

class ImporterFactory {
    ImporterFactory() {
    }

    Importer getImporterForMode(String mode, Args parsedArgs, Config config, OutsideWorld outsideWorld) throws IncorrectUsage, CommandFailed {
        Importer importer;
        switch (mode) {
            case "database": {
                importer = new DatabaseImporter(parsedArgs, config, outsideWorld);
                break;
            }
            case "csv": {
                importer = new CsvImporter(parsedArgs, config, outsideWorld);
                break;
            }
            default: {
                throw new CommandFailed("Invalid mode specified.");
            }
        }
        return importer;
    }
}

