/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.CsvImporter;
import org.neo4j.commandline.dbms.DatabaseImporter;
import org.neo4j.commandline.dbms.Importer;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.server.configuration.ConfigLoader;

public class ImportCommand
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;
    private final OutsideWorld outsideWorld;
    private final String[] allowedModes = new String[]{"database", "csv"};
    private String database;

    ImportCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        File additionalConfigFile;
        String mode;
        Args parsedArgs = Args.parse((String[])args);
        try {
            mode = (String)parsedArgs.interpretOption("mode", Converters.mandatory(), s -> s, new Validator[]{Validators.inList((String[])this.allowedModes)});
            this.database = (String)parsedArgs.interpretOption("database", Converters.mandatory(), s -> s, new Validator[0]);
            additionalConfigFile = (File)parsedArgs.interpretOption("additional-config", Converters.optional(), Converters.toFile(), new Validator[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        try {
            Importer importer;
            Config config = ImportCommand.loadNeo4jConfig(this.homeDir, this.configDir, this.database, this.loadAdditionalConfig(additionalConfigFile));
            switch (mode) {
                case "database": {
                    importer = new DatabaseImporter(parsedArgs, config, this.outsideWorld);
                    break;
                }
                case "csv": {
                    importer = new CsvImporter(parsedArgs, config, this.outsideWorld);
                    break;
                }
                default: {
                    throw new CommandFailed("Invalid mode specified.");
                }
            }
            importer.doImport();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> loadAdditionalConfig(File additionalConfigFile) {
        if (additionalConfigFile == null) {
            return new HashMap<String, String>();
        }
        try {
            return MapUtil.load((File)additionalConfigFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read configuration file [%s]", additionalConfigFile), e);
        }
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName, Map<String, String> additionalConfig) {
        ConfigLoader configLoader = new ConfigLoader(ImportCommand.settings());
        Config config = configLoader.loadConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()), new Pair[0]);
        additionalConfig.put(DatabaseManagementSystemSettings.active_database.name(), databaseName);
        return config.with(additionalConfig, new Class[0]);
    }

    private static List<Class<?>> settings() {
        return Arrays.asList(GraphDatabaseSettings.class, DatabaseManagementSystemSettings.class);
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("import", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("--mode={database|csv} --database=<database-name> [--additional-config=<config-file-path>] " + DatabaseImporter.arguments() + " " + CsvImporter.arguments());
        }

        public String description() {
            return "Import a collection of CSV files with --mode=csv, or a database from a\npre-3.0 installation with --mode=database.\n" + DatabaseImporter.description() + "\n\n" + CsvImporter.description();
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new ImportCommand(homeDir, configDir, outsideWorld);
        }
    }
}

