/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.internal.StoreLocker;
import org.neo4j.server.configuration.ConfigLoader;

public class DumpCommand
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;
    private final Dumper dumper;

    public DumpCommand(Path homeDir, Path configDir, Dumper dumper) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.dumper = dumper;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        String database = (String)this.parse(args, "database", Converters.identity());
        Path archive = this.calculateArchive(database, this.parse(args, "to", x$0 -> Paths.get(x$0, new String[0])));
        Path databaseDirectory = this.toDatabaseDirectory(database);
        try (Closeable ignored = this.withLock(databaseDirectory);){
            this.dump(database, databaseDirectory, archive);
        }
        catch (StoreLockException e) {
            throw new CommandFailed("the database is in use -- stop Neo4j and try again", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.wrapIOException(e);
        }
    }

    private <T> T parse(String[] args, String argument, Function<String, T> converter) throws IncorrectUsage {
        try {
            return (T)Args.parse((String[])args).interpretOption(argument, Converters.mandatory(), converter, new Validator[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
    }

    private Path toDatabaseDirectory(String databaseName) {
        return ((File)new ConfigLoader(Arrays.asList(DatabaseManagementSystemSettings.class, GraphDatabaseSettings.class)).loadConfig(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile()), new Pair[0]).with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]).get(DatabaseManagementSystemSettings.database_path)).toPath();
    }

    private Path calculateArchive(String database, Path to) {
        return Files.isDirectory(to, new LinkOption[0]) ? to.resolve(database + ".dump") : to;
    }

    private Closeable withLock(Path databaseDirectory) throws CommandFailed {
        Path lockFile = databaseDirectory.resolve("store_lock");
        if (Files.exists(lockFile, new LinkOption[0])) {
            if (Files.isWritable(lockFile)) {
                StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)new DefaultFileSystemAbstraction());
                storeLocker.checkLock(databaseDirectory.toFile());
                return () -> ((StoreLocker)storeLocker).release();
            }
            throw new CommandFailed("you do not have permission to dump the database -- is Neo4j running as a different user?");
        }
        return () -> {};
    }

    private void dump(String database, Path databaseDirectory, Path archive) throws CommandFailed {
        try {
            this.dumper.dump(databaseDirectory, archive, this::isStoreLock);
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailed("archive already exists: " + e.getMessage(), (Exception)e);
        }
        catch (NoSuchFileException e) {
            if (Paths.get(e.getMessage(), new String[0]).toAbsolutePath().equals(databaseDirectory.toAbsolutePath())) {
                throw new CommandFailed("database does not exist: " + database, (Exception)e);
            }
            this.wrapIOException(e);
        }
        catch (IOException e) {
            this.wrapIOException(e);
        }
    }

    private boolean isStoreLock(Path path) {
        return Objects.equals(path.getFileName().toString(), "store_lock");
    }

    private void wrapIOException(IOException e) throws CommandFailed {
        throw new CommandFailed(String.format("unable to dump database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), (Exception)e);
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("dump", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("--database=<database> --to=<destination-path>");
        }

        public String description() {
            return "Dump a database into a single-file archive. The archive can be used by the load command. <destination-path> can be a file or directory (in which case a file called <database>.dump will be created). It is not possible to dump a database that is mounted in a running Neo4j server.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new DumpCommand(homeDir, configDir, new Dumper());
        }
    }
}

