/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.neo4j.dbms.archive.Utils;

public class Dumper {
    public void dump(Path root, Path archive) throws IOException {
        Utils.checkWritableDirectory(archive.getParent());
        try (Stream<Path> files = Files.walk(root, new FileVisitOption[0]);
             ArchiveOutputStream stream = Dumper.openArchiveOut(archive);){
            files.forEach(file -> Dumper.dumpFile(file, root, stream));
        }
        catch (TunnellingException e) {
            throw e.getWrapped();
        }
    }

    private static ArchiveOutputStream openArchiveOut(Path archive) throws IOException {
        TarArchiveOutputStream tarball = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(Files.newOutputStream(archive, StandardOpenOption.CREATE_NEW)));
        tarball.setLongFileMode(3);
        return tarball;
    }

    private static void dumpFile(Path file, Path root, ArchiveOutputStream archive) {
        try {
            ArchiveEntry entry = Dumper.createEntry(file, root, archive);
            archive.putArchiveEntry(entry);
            if (Files.isRegularFile(file, new LinkOption[0])) {
                Dumper.writeFile(file, archive);
            }
            archive.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new TunnellingException(e);
        }
    }

    private static ArchiveEntry createEntry(Path file, Path root, ArchiveOutputStream archive) throws IOException {
        return archive.createArchiveEntry(file.toFile(), "./" + root.relativize(file).toString());
    }

    private static void writeFile(Path file, ArchiveOutputStream archiveStream) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            Utils.copy(in, (OutputStream)archiveStream);
        }
    }

    private static class TunnellingException
    extends RuntimeException {
        public TunnellingException(IOException e) {
            super(e);
        }

        public IOException getWrapped() {
            return (IOException)this.getCause();
        }
    }
}

