/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;

public class ConfigLoader {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";
    private final Function<Map<String, String>, Iterable<Class<?>>> settingsClassesSupplier;

    public ConfigLoader(Function<Map<String, String>, Iterable<Class<?>>> settingsClassesSupplier) {
        this.settingsClassesSupplier = settingsClassesSupplier;
    }

    public ConfigLoader(List<Class<?>> settingsClasses) {
        this((Map<String, String> settings) -> settingsClasses);
    }

    public Config loadConfig(Optional<File> configFile, Pair<String, String> ... configOverrides) throws IOException {
        return this.loadConfig(Optional.empty(), configFile, configOverrides);
    }

    public Config loadConfig(Optional<File> homeDir, Optional<File> configFile, Pair<String, String> ... configOverrides) {
        Map<String, String> overriddenSettings = this.calculateSettings(homeDir, configOverrides);
        return new Config(configFile, overriddenSettings, ConfigLoader::overrideEmbeddedDefaults, this.settingsClassesSupplier);
    }

    private Map<String, String> calculateSettings(Optional<File> homeDir, Pair<String, String>[] configOverrides) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.putAll(this.toMap(configOverrides));
        settings.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.map(File::getAbsolutePath).orElse(System.getProperty("user.dir")));
        return settings;
    }

    private Map<String, String> toMap(Pair<String, String>[] configOverrides) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        for (Pair<String, String> configOverride : configOverrides) {
            overrides.put((String)configOverride.first(), (String)configOverride.other());
        }
        return overrides;
    }

    private static void overrideEmbeddedDefaults(Map<String, String> config) {
        config.putIfAbsent(GraphDatabaseSettings.auth_enabled.name(), "true");
    }
}

