/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.shell.ShellSettings;

public class ConfigLoader {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";
    private final SettingsClasses settingsClasses;

    public ConfigLoader(SettingsClasses settingsClasses) {
        this.settingsClasses = settingsClasses;
    }

    public ConfigLoader(List<Class<?>> settingsClasses) {
        this((Map<String, String> settings) -> settingsClasses);
    }

    public Config loadConfig(Optional<File> configFile, Log log, Pair<String, String> ... configOverrides) {
        return this.loadConfig(Optional.empty(), configFile, log, configOverrides);
    }

    public Config loadConfig(Optional<File> homeDir, Optional<File> configFile, Log log, Pair<String, String> ... configOverrides) {
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        Map<String, String> settings = this.calculateSettings(homeDir, configFile, log, configOverrides);
        Config config = new Config(settings, this.settingsClasses.calculate(settings));
        config.setLogger(log);
        return config;
    }

    private Map<String, String> calculateSettings(Optional<File> homeDir, Optional<File> config, Log log, Pair<String, String>[] configOverrides) {
        HashMap<String, String> settings = new HashMap<String, String>();
        config.ifPresent(c -> settings.putAll(ConfigLoader.loadFromFile(log, c)));
        settings.putAll(this.toMap(configOverrides));
        ConfigLoader.overrideEmbeddedDefaults(settings);
        settings.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.map(File::getAbsolutePath).orElse(System.getProperty("user.dir")));
        return settings;
    }

    private Map<String, String> toMap(Pair<String, String>[] configOverrides) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        for (Pair<String, String> configOverride : configOverrides) {
            overrides.put((String)configOverride.first(), (String)configOverride.other());
        }
        return overrides;
    }

    private static void overrideEmbeddedDefaults(Map<String, String> config) {
        config.putIfAbsent(ShellSettings.remote_shell_enabled.name(), "true");
        config.putIfAbsent(GraphDatabaseSettings.auth_enabled.name(), "true");
        File authStoreDirectory = (File)DatabaseManagementSystemSettings.auth_store_directory.apply(name -> (String)config.get(name));
        config.putIfAbsent(GraphDatabaseSettings.auth_store.name(), new File(authStoreDirectory, "auth").toString());
    }

    private static Map<String, String> loadFromFile(Log log, File file) {
        if (!file.exists()) {
            log.warn("Config file [%s] does not exist.", new Object[]{file});
            return new HashMap<String, String>();
        }
        try {
            return MapUtil.load((File)file);
        }
        catch (IOException e) {
            log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
            return new HashMap<String, String>();
        }
    }

    public static interface SettingsClasses {
        public Iterable<Class<?>> calculate(Map<String, String> var1);
    }
}

