/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadataV1;

public class BackupMetadataV2
extends BackupMetadataV1 {
    public static final int VERSION = 2;
    private static final String METADATA_SCRIPT_FIELD = "metadataScript";
    private static final String COMPRESSED_METADATA_SCRIPT_FIELD = "compressedMetadataScript";
    private static final String TOPOLOGY_VERSION = "1";
    private static final String TOPOLOGY_VERSION_FIELD = "topology_version";
    private static final String VIRTUAL_NAME_FIELD = "virtual_name";
    private static final String VIRTUAL_ID_FIELD = "virtual_id";
    private static final String INDEX_FIELD = "shard_index";
    private static final String SHARD_COUNT_FIELD = "shard_count";
    private static final Set<String> KEYS_OF_COMPRESSED_VALUES = Set.of("compressedMetadataScript");
    private final BackupMetadataV1 backupMetadataV1;
    private final Map<String, String> additionalFields;

    public static BackupMetadataV2 readFromStream(InputStream inputStream) throws IOException {
        return BackupMetadataV2.readMetadataV2(inputStream);
    }

    public static BackupMetadataV2 from(BackupDescription description) {
        BackupMetadataV1 backupMetadataV1 = new BackupMetadataV1(description);
        String metadataScript = description.getMetadataScript();
        HashMap<String, String> additionalFields = new HashMap<String, String>();
        if (metadataScript != null) {
            additionalFields.put(COMPRESSED_METADATA_SCRIPT_FIELD, metadataScript);
        }
        description.getTopology().ifPresent(t -> BackupMetadataV2.writeV1Topology(t, additionalFields));
        return new BackupMetadataV2(backupMetadataV1, additionalFields);
    }

    static BackupMetadataV2 readMetadataV2(InputStream inputStream) throws IOException {
        BackupMetadataV1 backupMetadataV1 = BackupMetadataV2.readMetadataV1(inputStream);
        Map<String, String> additionalFields = BackupMetadataV2.readMap(inputStream);
        return new BackupMetadataV2(backupMetadataV1, additionalFields);
    }

    private BackupMetadataV2(BackupMetadataV1 backupMetadataV1, Map<String, String> additionalFields) {
        super(backupMetadataV1.getDatabaseName(), backupMetadataV1.getStoreId(), backupMetadataV1.getDatabaseId(), backupMetadataV1.getBackupTime(), backupMetadataV1.getLowestAppendIndex(), backupMetadataV1.getHighestAppendIndex(), backupMetadataV1.isRecovered(), backupMetadataV1.isCompressed(), backupMetadataV1.isFull());
        this.backupMetadataV1 = backupMetadataV1;
        this.additionalFields = additionalFields;
    }

    public void writeToStreamV2(OutputStream compressionStream) throws IOException {
        this.writeToStreamV1(compressionStream);
        this.writeMap(compressionStream, this.additionalFields);
    }

    private void writeMap(OutputStream compressionStream, Map<String, String> additionalFields) throws IOException {
        DataOutputStream dataStream = new DataOutputStream(compressionStream);
        int mapSize = additionalFields.size();
        dataStream.writeInt(mapSize);
        for (Map.Entry<String, String> field : additionalFields.entrySet()) {
            BackupMetadataV2.writeString(dataStream, field.getKey());
            if (KEYS_OF_COMPRESSED_VALUES.contains(field.getKey())) {
                BackupMetadataV2.writeCompressedString(dataStream, field.getValue());
                continue;
            }
            BackupMetadataV2.writeString(dataStream, field.getValue());
        }
        dataStream.flush();
    }

    private static Map<String, String> readMap(InputStream inputStream) throws IOException {
        HashMap<String, String> deserializedMap = new HashMap<String, String>();
        DataInputStream dataStream = new DataInputStream(inputStream);
        int mapSize = dataStream.readInt();
        for (int i = 0; i < mapSize; ++i) {
            String key = BackupMetadataV2.readString(dataStream);
            String value = KEYS_OF_COMPRESSED_VALUES.contains(key) ? BackupMetadataV2.readCompressedString(dataStream) : BackupMetadataV2.readString(dataStream);
            deserializedMap.put(key, value);
        }
        return deserializedMap;
    }

    private static void writeString(DataOutputStream outputStream, String value) throws IOException {
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        outputStream.writeInt(data.length);
        outputStream.write(data);
    }

    private static String readString(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        return new String(inputStream.readNBytes(length), StandardCharsets.UTF_8);
    }

    @Override
    public BackupDescription toBackupDescription() {
        String metadataScript = Optional.ofNullable(this.additionalFields.get(COMPRESSED_METADATA_SCRIPT_FIELD)).orElseGet(() -> this.additionalFields.get(METADATA_SCRIPT_FIELD));
        BackupDescription.Topology topology = Optional.ofNullable(this.additionalFields.get(TOPOLOGY_VERSION_FIELD)).filter(TOPOLOGY_VERSION::equals).map(ignore -> this.readV1Topology()).orElse(null);
        return super.toBackupDescription().withMetadataScript(metadataScript).withTopology(topology);
    }

    private BackupDescription.Topology readV1Topology() {
        String virtualName = this.additionalFields.get(VIRTUAL_NAME_FIELD);
        UUID virtualId = UUID.fromString(this.additionalFields.get(VIRTUAL_ID_FIELD));
        int shardCount = Integer.parseInt(this.additionalFields.get(SHARD_COUNT_FIELD));
        Optional<Integer> shardIndex = Optional.ofNullable(this.additionalFields.get(INDEX_FIELD)).map(Integer::parseInt);
        return new BackupDescription.Topology(virtualName, virtualId, shardCount, shardIndex);
    }

    private static void writeV1Topology(BackupDescription.Topology topology, HashMap<String, String> additionalFields) {
        additionalFields.put(TOPOLOGY_VERSION_FIELD, TOPOLOGY_VERSION);
        additionalFields.put(VIRTUAL_NAME_FIELD, topology.virtualName());
        additionalFields.put(VIRTUAL_ID_FIELD, topology.virtualId().toString());
        additionalFields.put(SHARD_COUNT_FIELD, String.valueOf(topology.shardCount()));
        topology.index().ifPresent(index -> additionalFields.put(INDEX_FIELD, String.valueOf(index)));
    }

    private static void writeCompressedString(DataOutputStream outputStream, String value) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)output);){
            cos.write(value.getBytes(StandardCharsets.UTF_8));
        }
        outputStream.writeInt(output.size());
        outputStream.write(output.toByteArray());
    }

    private static String readCompressedString(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        ByteArrayInputStream input = new ByteArrayInputStream(inputStream.readNBytes(length));
        try (CompressorInputStream cis = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)input);){
            String string = new String(cis.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupMetadataV2 that = (BackupMetadataV2)o;
        return Objects.equals(this.backupMetadataV1, that.backupMetadataV1) && Objects.equals(this.additionalFields, that.additionalFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backupMetadataV1, this.additionalFields);
    }

    public String toString() {
        return "BackupMetadataV2{backupMetadataV1=" + String.valueOf(this.backupMetadataV1) + ", additionalFields=" + String.valueOf(this.additionalFields) + "}";
    }
}

