/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.storageengine.api.StoreId;

public class BackupDescription
implements Comparable<BackupDescription> {
    private final String databaseName;
    private final StoreId storeId;
    private final DatabaseId databaseId;
    private final LocalDateTime backupTime;
    private final boolean recovered;
    private final boolean compressed;
    private final boolean full;
    private final long lowestAppendIndex;
    private final long highestAppendIndex;
    private final String metadataScript;
    private final Topology topology;

    public BackupDescription(String databaseName, StoreId storeId, DatabaseId databaseId, LocalDateTime backupTime, boolean recovered, boolean compressed, boolean full, long lowestAppendIndex, long highestAppendIndex) {
        this(databaseName, storeId, databaseId, backupTime, recovered, compressed, full, lowestAppendIndex, highestAppendIndex, null, null);
    }

    protected BackupDescription(String databaseName, StoreId storeId, DatabaseId databaseId, LocalDateTime backupTime, boolean recovered, boolean compressed, boolean full, long lowestAppendIndex, long highestAppendIndex, String metadataScript, Topology topology) {
        this.databaseName = NormalizedDatabaseName.normalize((String)databaseName);
        this.storeId = storeId;
        this.databaseId = databaseId;
        this.backupTime = backupTime.truncatedTo(ChronoUnit.SECONDS);
        this.recovered = recovered;
        this.compressed = compressed;
        this.full = full;
        this.lowestAppendIndex = lowestAppendIndex;
        this.highestAppendIndex = highestAppendIndex;
        this.metadataScript = metadataScript;
        this.topology = topology;
    }

    public BackupDescription withMetadataScript(String metadataScript) {
        return new BackupDescription(this.databaseName, this.storeId, this.databaseId, this.backupTime, this.recovered, this.compressed, this.full, this.lowestAppendIndex, this.highestAppendIndex, metadataScript, this.topology);
    }

    public BackupDescription withTopology(Topology topology) {
        return new BackupDescription(this.databaseName, this.storeId, this.databaseId, this.backupTime, this.recovered, this.compressed, this.full, this.lowestAppendIndex, this.highestAppendIndex, this.metadataScript, topology);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    public LocalDateTime getBackupTime() {
        return this.backupTime;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public boolean isFull() {
        return this.full;
    }

    public long getLowestAppendIndex() {
        return this.lowestAppendIndex;
    }

    public long getHighestAppendIndex() {
        return this.highestAppendIndex;
    }

    public String getMetadataScript() {
        return this.metadataScript;
    }

    public Optional<Topology> getTopology() {
        return Optional.ofNullable(this.topology);
    }

    public boolean isEmpty() {
        return this.lowestAppendIndex == 0L && this.highestAppendIndex == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupDescription that = (BackupDescription)o;
        return this.recovered == that.recovered && this.compressed == that.compressed && this.full == that.full && this.lowestAppendIndex == that.lowestAppendIndex && this.highestAppendIndex == that.highestAppendIndex && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.storeId, that.storeId) && Objects.equals(this.databaseId, that.databaseId) && Objects.equals(this.backupTime, that.backupTime) && Objects.equals(this.metadataScript, that.metadataScript) && Objects.equals(this.topology, that.topology);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.storeId, this.databaseId, this.backupTime, this.recovered, this.compressed, this.full, this.lowestAppendIndex, this.highestAppendIndex, this.metadataScript, this.topology);
    }

    public String toString() {
        return "BackupDescription{databaseName='" + this.databaseName + "', storeId=" + String.valueOf(this.storeId) + ", databaseId=" + String.valueOf(this.databaseId) + ", backupTime=" + String.valueOf(this.backupTime) + ", recovered=" + this.recovered + ", compressed=" + this.compressed + ", full=" + this.full + ", lowestAppendIndex=" + this.lowestAppendIndex + ", highestAppendIndex=" + this.highestAppendIndex + ", metadataScript='" + this.metadataScript + "', topology='" + String.valueOf(this.topology) + "'}";
    }

    @Override
    public int compareTo(BackupDescription o) {
        int nameCompared = this.getDatabaseName().compareTo(o.getDatabaseName());
        if (nameCompared != 0) {
            return nameCompared;
        }
        int dbIdCompared = this.getDatabaseId().uuid().compareTo(o.getDatabaseId().uuid());
        if (dbIdCompared != 0) {
            return dbIdCompared;
        }
        if (this.isEmpty() || o.isEmpty()) {
            return this.getBackupTime().compareTo(o.getBackupTime());
        }
        return Long.compare(this.getHighestAppendIndex(), o.getHighestAppendIndex());
    }

    public record Topology(String virtualName, UUID virtualId, int shardCount, Optional<Integer> index) {
    }
}

