/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.neo4j.dbms.archive.backup.BackupCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadataV2;

public class BackupTarFormatV2
implements BackupCompressionFormat {
    static final String MAGIC_HEADER = "BTV2";
    private BackupMetadataV2 metadata;

    @Override
    public void setMetadata(BackupDescription description) {
        this.metadata = BackupMetadataV2.from(description);
    }

    @Override
    public OutputStream compress(OutputStream stream) throws IOException {
        stream.write(MAGIC_HEADER.getBytes());
        this.writeDescriptionToStream(stream);
        return stream;
    }

    @Override
    public InputStream decompress(InputStream stream) throws IOException {
        BackupTarFormatV2.readMetadataFromStream(stream);
        return stream;
    }

    @Override
    public BackupCompressionFormat.StreamWithDescription decompressAndDescribe(InputStream stream) throws IOException {
        BackupDescription description = BackupTarFormatV2.readMetadataFromStream(stream).toBackupDescription();
        return new BackupCompressionFormat.StreamWithDescription(stream, description);
    }

    @Override
    public BackupDescription readMetadata(InputStream inputStream) throws IOException {
        return BackupTarFormatV2.readMetadataFromStream(inputStream).toBackupDescription();
    }

    private void writeDescriptionToStream(OutputStream outputStream) throws IOException {
        int metadataVersion = 2;
        outputStream.write(metadataVersion);
        this.metadata.writeToStreamV2(outputStream);
    }

    private static BackupMetadataV2 readMetadataFromStream(InputStream inputStream) throws IOException {
        int metadataVersion = inputStream.read();
        switch (metadataVersion) {
            case 2: {
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported metadata version %d found in backup", metadataVersion));
            }
        }
        return BackupMetadataV2.readFromStream(inputStream);
    }
}

