/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CreateFulltextIndexOptionsConverter;
import org.neo4j.cypher.internal.CreateIndexWithFullOptions;
import org.neo4j.cypher.internal.CreateLookupIndexOptionsConverter;
import org.neo4j.cypher.internal.CreatePointIndexOptionsConverter;
import org.neo4j.cypher.internal.CreatePointIndexOptionsConverter$;
import org.neo4j.cypher.internal.CreateRangeIndexOptionsConverter;
import org.neo4j.cypher.internal.CreateTextIndexOptionsConverter;
import org.neo4j.cypher.internal.CreateTextIndexOptionsConverter$;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.IndexBackedConstraintsOptionsConverter;
import org.neo4j.cypher.internal.IndexOptionsConverter;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.PropertyExistenceConstraintOptionsConverter;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.logical.plans.ConstraintType;
import org.neo4j.cypher.internal.logical.plans.CreateFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.CreateLookupIndex;
import org.neo4j.cypher.internal.logical.plans.CreateNodeKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateNodePropertyUniquenessConstraint;
import org.neo4j.cypher.internal.logical.plans.CreatePointIndex;
import org.neo4j.cypher.internal.logical.plans.CreateRangeIndex;
import org.neo4j.cypher.internal.logical.plans.CreateRelationshipKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateRelationshipPropertyUniquenessConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateTextIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex;
import org.neo4j.cypher.internal.logical.plans.DropConstraintOnName;
import org.neo4j.cypher.internal.logical.plans.DropIndexOnName;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeKey$;
import org.neo4j.cypher.internal.logical.plans.NodePropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.NodeUniqueness$;
import org.neo4j.cypher.internal.logical.plans.RelationshipKey$;
import org.neo4j.cypher.internal.logical.plans.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.RelationshipUniqueness$;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.procs.IgnoredResult$;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan$;
import org.neo4j.cypher.internal.procs.SchemaExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult$;
import org.neo4j.cypher.internal.runtime.InternalQueryType;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.SCHEMA_WRITE$;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class SchemaCommandRuntime$
implements CypherRuntime<RuntimeContext> {
    public static final SchemaCommandRuntime$ MODULE$ = new SchemaCommandRuntime$();
    private static final PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            A1 A1 = x1;
            if (A1 instanceof CreateNodeKeyConstraint) {
                CreateNodeKeyConstraint createNodeKeyConstraint = (CreateNodeKeyConstraint)A1;
                Option source = createNodeKeyConstraint.source();
                LabelName label = createNodeKeyConstraint.label();
                Seq props = createNodeKeyConstraint.props();
                Option name = createNodeKeyConstraint.name();
                Options options = createNodeKeyConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodeKeyConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter("node key constraint", (QueryContext)ctx);
                    Options x$12 = options;
                    MapValue x$2 = params;
                    Option<Config> x$3 = qual$1.convert$default$3();
                    Option indexProvider = qual$1.convert(x$12, x$2, x$3).flatMap((Function1 & Serializable)x$1 -> x$1.provider());
                    int labelId = ctx.getOrCreateLabelId(label.name());
                    Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$4(ctx, p)));
                    ctx.createNodeKeyConstraint(labelId, propertyKeyIds, name, indexProvider);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$2 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$2, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateRelationshipKeyConstraint) {
                CreateRelationshipKeyConstraint createRelationshipKeyConstraint = (CreateRelationshipKeyConstraint)A1;
                Option source = createRelationshipKeyConstraint.source();
                RelTypeName relType = createRelationshipKeyConstraint.typeName();
                Seq props = createRelationshipKeyConstraint.props();
                Option name = createRelationshipKeyConstraint.name();
                Options options = createRelationshipKeyConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipKeyConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    IndexBackedConstraintsOptionsConverter qual$2 = new IndexBackedConstraintsOptionsConverter("relationship key constraint", (QueryContext)ctx);
                    Options x$4 = options;
                    MapValue x$5 = params;
                    Option<Config> x$6 = qual$2.convert$default$3();
                    Option indexProvider = qual$2.convert(x$4, x$5, x$6).flatMap((Function1 & Serializable)x$3 -> x$3.provider());
                    int relId = ctx.getOrCreateRelTypeId(relType.name());
                    Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$10(ctx, p)));
                    ctx.createRelationshipKeyConstraint(relId, propertyKeyIds, name, indexProvider);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$4 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$4, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateNodePropertyUniquenessConstraint) {
                CreateNodePropertyUniquenessConstraint createNodePropertyUniquenessConstraint = (CreateNodePropertyUniquenessConstraint)A1;
                Option source = createNodePropertyUniquenessConstraint.source();
                LabelName label = createNodePropertyUniquenessConstraint.label();
                Seq props = createNodePropertyUniquenessConstraint.props();
                Option name = createNodePropertyUniquenessConstraint.name();
                Options options = createNodePropertyUniquenessConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyUniquenessConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    IndexBackedConstraintsOptionsConverter qual$3 = new IndexBackedConstraintsOptionsConverter("uniqueness constraint", (QueryContext)ctx);
                    Options x$7 = options;
                    MapValue x$8 = params;
                    Option<Config> x$9 = qual$3.convert$default$3();
                    Option indexProvider = qual$3.convert(x$7, x$8, x$9).flatMap((Function1 & Serializable)x$5 -> x$5.provider());
                    int labelId = ctx.getOrCreateLabelId(label.name());
                    Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$16(ctx, p)));
                    ctx.createNodeUniqueConstraint(labelId, propertyKeyIds, name, indexProvider);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$6 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$6, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateRelationshipPropertyUniquenessConstraint) {
                CreateRelationshipPropertyUniquenessConstraint createRelationshipPropertyUniquenessConstraint = (CreateRelationshipPropertyUniquenessConstraint)A1;
                Option source = createRelationshipPropertyUniquenessConstraint.source();
                RelTypeName relType = createRelationshipPropertyUniquenessConstraint.typeName();
                Seq props = createRelationshipPropertyUniquenessConstraint.props();
                Option name = createRelationshipPropertyUniquenessConstraint.name();
                Options options = createRelationshipPropertyUniquenessConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyUniquenessConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    IndexBackedConstraintsOptionsConverter qual$4 = new IndexBackedConstraintsOptionsConverter("relationship uniqueness constraint", (QueryContext)ctx);
                    Options x$10 = options;
                    MapValue x$11 = params;
                    Option<Config> x$12 = qual$4.convert$default$3();
                    Option indexProvider = qual$4.convert(x$10, x$11, x$12).flatMap((Function1 & Serializable)x$7 -> x$7.provider());
                    int relTypeId = ctx.getOrCreateRelTypeId(relType.name());
                    Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$22(ctx, p)));
                    ctx.createRelationshipUniqueConstraint(relTypeId, propertyKeyIds, name, indexProvider);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$8 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$8, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateNodePropertyExistenceConstraint) {
                CreateNodePropertyExistenceConstraint createNodePropertyExistenceConstraint = (CreateNodePropertyExistenceConstraint)A1;
                Option source = createNodePropertyExistenceConstraint.source();
                LabelName label = createNodePropertyExistenceConstraint.label();
                Property prop = createNodePropertyExistenceConstraint.prop();
                Option name = createNodePropertyExistenceConstraint.name();
                Options options = createNodePropertyExistenceConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    PropertyExistenceConstraintOptionsConverter qual$5 = new PropertyExistenceConstraintOptionsConverter("node", (QueryContext)ctx);
                    Options x$13 = options;
                    MapValue x$14 = params;
                    Option<Config> x$15 = qual$5.convert$default$3();
                    qual$5.convert(x$13, x$14, x$15);
                    ((Function3 & Serializable)(Function3 & Serializable)(labelId, propertyKeyId, name) -> {
                        anonfun.1.$anonfun$applyOrElse$27(ctx, BoxesRunTime.unboxToInt((Object)labelId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                        return BoxedUnit.UNIT;
                    }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName((QueryContext)ctx, label, prop.propertyKey(), (Option<String>)name));
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$9 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$9, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateRelationshipPropertyExistenceConstraint) {
                CreateRelationshipPropertyExistenceConstraint createRelationshipPropertyExistenceConstraint = (CreateRelationshipPropertyExistenceConstraint)A1;
                Option source = createRelationshipPropertyExistenceConstraint.source();
                RelTypeName relType = createRelationshipPropertyExistenceConstraint.typeName();
                Property prop = createRelationshipPropertyExistenceConstraint.prop();
                Option name = createRelationshipPropertyExistenceConstraint.name();
                Options options = createRelationshipPropertyExistenceConstraint.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    PropertyExistenceConstraintOptionsConverter qual$6 = new PropertyExistenceConstraintOptionsConverter("relationship", (QueryContext)ctx);
                    Options x$16 = options;
                    MapValue x$17 = params;
                    Option<Config> x$18 = qual$6.convert$default$3();
                    qual$6.convert(x$16, x$17, x$18);
                    ((Function3 & Serializable)(Function3 & Serializable)(relTypeId, propertyKeyId, name) -> {
                        anonfun.1.$anonfun$applyOrElse$32(ctx, BoxesRunTime.unboxToInt((Object)relTypeId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                        return BoxedUnit.UNIT;
                    }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName((QueryContext)ctx, relType, prop.propertyKey(), (Option<String>)name));
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$10 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$10, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof DropConstraintOnName) {
                DropConstraintOnName dropConstraintOnName = (DropConstraintOnName)A1;
                String name = dropConstraintOnName.name();
                boolean ifExists = dropConstraintOnName.ifExists();
                return (B1)(Function1 & Serializable)x$11 -> new SchemaExecutionPlan("DropConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, x$12) -> {
                    block0: {
                        if (ifExists && !ctx.constraintExists(name)) break block0;
                        ctx.dropNamedConstraint(name);
                    }
                    return SuccessResult$.MODULE$;
                }, SchemaExecutionPlan$.MODULE$.apply$default$3());
            }
            if (A1 instanceof CreateRangeIndex) {
                CreateRangeIndex createRangeIndex = (CreateRangeIndex)A1;
                Option source = createRangeIndex.source();
                Either entityName = createRangeIndex.entityName();
                List props = createRangeIndex.propertyKeyNames();
                Option name = createRangeIndex.name();
                Options options = createRangeIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    String string;
                    EntityType entityType;
                    Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int entityId = tuple2._1$mcI$sp();
                    EntityType entityType2 = (EntityType)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType2);
                    int entityId2 = tuple22._1$mcI$sp();
                    EntityType entityType3 = entityType = (EntityType)tuple22._2();
                    if (EntityType.NODE.equals(entityType3)) {
                        string = "range node property index";
                    } else if (EntityType.RELATIONSHIP.equals(entityType3)) {
                        string = "range relationship property index";
                    } else {
                        throw new MatchError((Object)entityType3);
                    }
                    String schemaType = string;
                    CreateRangeIndexOptionsConverter qual$7 = new CreateRangeIndexOptionsConverter(schemaType, (QueryContext)ctx);
                    Options x$19 = options;
                    MapValue x$20 = params;
                    Option<Config> x$21 = qual$7.convert$default$3();
                    Option provider = qual$7.convert(x$19, x$20, x$21).flatMap((Function1 & Serializable)x$14 -> x$14.provider());
                    List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$40(ctx, p)));
                    ctx.addRangeIndexRule(entityId2, entityType, (Seq)propertyKeyIds, name, provider);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$15 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$15, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateLookupIndex) {
                CreateLookupIndex createLookupIndex = (CreateLookupIndex)A1;
                Option source = createLookupIndex.source();
                EntityType entityType = createLookupIndex.entityType();
                Option name = createLookupIndex.name();
                Options options = createLookupIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    CreateLookupIndexOptionsConverter qual$8 = new CreateLookupIndexOptionsConverter((QueryContext)ctx);
                    Options x$22 = options;
                    MapValue x$23 = params;
                    Option<Config> x$24 = qual$8.convert$default$3();
                    Option provider = qual$8.convert(x$22, x$23, x$24).flatMap((Function1 & Serializable)x$16 -> x$16.provider());
                    ctx.addLookupIndexRule(entityType, name, provider);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$17 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$17, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateFulltextIndex) {
                CreateFulltextIndex createFulltextIndex = (CreateFulltextIndex)A1;
                Option source = createFulltextIndex.source();
                Either entityNames = createFulltextIndex.entityNames();
                List props = createFulltextIndex.propertyKeyNames();
                Option name = createFulltextIndex.name();
                Options options = createFulltextIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Some some;
                    CreateIndexWithFullOptions createIndexWithFullOptions;
                    Tuple2 tuple2;
                    CreateFulltextIndexOptionsConverter qual$9 = new CreateFulltextIndexOptionsConverter((QueryContext)ctx);
                    Options x$25 = options;
                    MapValue x$26 = params;
                    Option<Config> x$27 = qual$9.convert$default$3();
                    Option<CreateIndexWithFullOptions> option = qual$9.convert(x$25, x$26, x$27);
                    if (None$.MODULE$.equals(option)) {
                        tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                    } else if (option instanceof Some && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(some = (Some)option).value()) != null) {
                        Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                        IndexConfig config = createIndexWithFullOptions.config();
                        tuple2 = new Tuple2(provider, (Object)config);
                    } else {
                        throw new MatchError(option);
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Option indexProvider = (Option)tuple22._1();
                    IndexConfig indexConfig = (IndexConfig)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                    Option indexProvider2 = (Option)tuple23._1();
                    IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                    Tuple2<List<Object>, EntityType> tuple24 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo((Either<List<LabelName>, List<RelTypeName>>)entityNames, (QueryContext)ctx);
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    List entityIds = (List)tuple24._1();
                    EntityType entityType = (EntityType)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)entityIds, (Object)entityType);
                    List entityIds2 = (List)tuple25._1();
                    EntityType entityType2 = (EntityType)tuple25._2();
                    List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$50(ctx, p)));
                    ctx.addFulltextIndexRule(entityIds2, entityType2, (Seq)propertyKeyIds, name, indexProvider2, indexConfig2);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$20 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$20, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreateTextIndex) {
                CreateTextIndex createTextIndex = (CreateTextIndex)A1;
                Option source = createTextIndex.source();
                Either entityName = createTextIndex.entityName();
                List props = createTextIndex.propertyKeyNames();
                Option name = createTextIndex.name();
                Options options = createTextIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    CreateTextIndexOptionsConverter qual$10 = new CreateTextIndexOptionsConverter((QueryContext)ctx);
                    Options x$28 = options;
                    MapValue x$29 = params;
                    Option<Config> x$30 = qual$10.convert$default$3();
                    Option provider = qual$10.convert(x$28, x$29, x$30).flatMap((Function1 & Serializable)x$21 -> x$21.provider());
                    Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int entityId = tuple2._1$mcI$sp();
                    EntityType entityType = (EntityType)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                    int entityId2 = tuple22._1$mcI$sp();
                    EntityType entityType2 = (EntityType)tuple22._2();
                    List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$56(ctx, p)));
                    ctx.addTextIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, name, provider);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$23 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$23, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof CreatePointIndex) {
                CreatePointIndex createPointIndex = (CreatePointIndex)A1;
                Option source = createPointIndex.source();
                Either entityName = createPointIndex.entityName();
                List props = createPointIndex.propertyKeyNames();
                Option name = createPointIndex.name();
                Options options = createPointIndex.options();
                return (B1)(Function1 & Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    Some some;
                    CreateIndexWithFullOptions createIndexWithFullOptions;
                    Tuple2 tuple2;
                    CreatePointIndexOptionsConverter qual$11 = new CreatePointIndexOptionsConverter((QueryContext)ctx);
                    Options x$31 = options;
                    MapValue x$32 = params;
                    Option<Config> x$33 = qual$11.convert$default$3();
                    Option<CreateIndexWithFullOptions> option = qual$11.convert(x$31, x$32, x$33);
                    if (None$.MODULE$.equals(option)) {
                        tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                    } else if (option instanceof Some && (createIndexWithFullOptions = (CreateIndexWithFullOptions)(some = (Some)option).value()) != null) {
                        Option<IndexProviderDescriptor> provider = createIndexWithFullOptions.provider();
                        IndexConfig config = createIndexWithFullOptions.config();
                        tuple2 = new Tuple2(provider, (Object)config);
                    } else {
                        throw new MatchError(option);
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Option indexProvider = (Option)tuple22._1();
                    IndexConfig indexConfig = (IndexConfig)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                    Option indexProvider2 = (Option)tuple23._1();
                    IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
                    Tuple2<Object, EntityType> tuple24 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    int entityId = tuple24._1$mcI$sp();
                    EntityType entityType = (EntityType)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                    int entityId2 = tuple25._1$mcI$sp();
                    EntityType entityType2 = (EntityType)tuple25._2();
                    List propertyKeyIds = props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$61(ctx, p)));
                    ctx.addPointIndexRule(entityId2, entityType2, (Seq)propertyKeyIds, name, indexProvider2, indexConfig2);
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)source.map((Function1 & Serializable)x$26 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$26, (Function1 & Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
            }
            if (A1 instanceof DropIndexOnName) {
                DropIndexOnName dropIndexOnName = (DropIndexOnName)A1;
                String name = dropIndexOnName.name();
                boolean ifExists = dropIndexOnName.ifExists();
                return (B1)(Function1 & Serializable)x$27 -> new SchemaExecutionPlan("DropIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, x$28) -> {
                    block0: {
                        if (ifExists && !ctx.indexExists(name)) break block0;
                        ctx.dropIndexRule(name);
                    }
                    return SuccessResult$.MODULE$;
                }, SchemaExecutionPlan$.MODULE$.apply$default$3());
            }
            if (A1 instanceof DoNothingIfExistsForIndex) {
                DoNothingIfExistsForIndex doNothingIfExistsForIndex = (DoNothingIfExistsForIndex)A1;
                Either entityName = doNothingIfExistsForIndex.entityName();
                List propertyKeyNames = doNothingIfExistsForIndex.propertyKeyNames();
                org.neo4j.graphdb.schema.IndexType indexType = doNothingIfExistsForIndex.indexType();
                Option name = doNothingIfExistsForIndex.name();
                Options options = doNothingIfExistsForIndex.options();
                return (B1)(Function1 & Serializable)x$29 -> {
                    Tuple2 tuple2;
                    org.neo4j.graphdb.schema.IndexType indexType = indexType;
                    if (org.neo4j.graphdb.schema.IndexType.POINT.equals(indexType)) {
                        tuple2 = new Tuple2((Object)IndexType.POINT, (Object)CreatePointIndexOptionsConverter$.MODULE$);
                    } else if (org.neo4j.graphdb.schema.IndexType.RANGE.equals(indexType)) {
                        tuple2 = new Tuple2((Object)IndexType.RANGE, (Function1 & Serializable)ctx -> new CreateRangeIndexOptionsConverter("range index", (QueryContext)ctx));
                    } else if (org.neo4j.graphdb.schema.IndexType.TEXT.equals(indexType)) {
                        tuple2 = new Tuple2((Object)IndexType.TEXT, (Object)CreateTextIndexOptionsConverter$.MODULE$);
                    } else {
                        throw new IllegalStateException("Did not expect index type " + indexType + " here: only point, range or text indexes.");
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    IndexType innerIndexType = (IndexType)tuple22._1();
                    Function1 optionsConverter = (Function1)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)innerIndexType, (Object)optionsConverter);
                    IndexType innerIndexType2 = (IndexType)tuple23._1();
                    Function1 optionsConverter2 = (Function1)tuple23._2();
                    return new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                        IndexOptionsConverter qual$12 = (IndexOptionsConverter)optionsConverter2.apply(ctx);
                        Options x$34 = options;
                        MapValue x$35 = params;
                        Option<Config> x$36 = qual$12.convert$default$3();
                        qual$12.convert(x$34, x$35, x$36);
                        Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        int entityId = tuple2._1$mcI$sp();
                        EntityType entityType = (EntityType)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                        int entityId2 = tuple22._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple22._2();
                        List propertyKeyIds = propertyKeyNames.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$69(ctx, p)));
                        if (Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.indexReference(innerIndexType2, entityId2, entityType2, (Seq)propertyKeyIds).getName()).isSuccess()) {
                            return IgnoredResult$.MODULE$;
                        }
                        if (name.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$71(ctx, name)))) {
                            return IgnoredResult$.MODULE$;
                        }
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                };
            }
            if (A1 instanceof DoNothingIfExistsForLookupIndex) {
                DoNothingIfExistsForLookupIndex doNothingIfExistsForLookupIndex = (DoNothingIfExistsForLookupIndex)A1;
                EntityType entityType = doNothingIfExistsForLookupIndex.entityType();
                Option name = doNothingIfExistsForLookupIndex.name();
                Options options = doNothingIfExistsForLookupIndex.options();
                return (B1)(Function1 & Serializable)x$32 -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    CreateLookupIndexOptionsConverter qual$13 = new CreateLookupIndexOptionsConverter((QueryContext)ctx);
                    Options x$37 = options;
                    MapValue x$38 = params;
                    Option<Config> x$39 = qual$13.convert$default$3();
                    qual$13.convert(x$37, x$38, x$39);
                    if (Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.lookupIndexReference(entityType).getName()).isSuccess()) {
                        return IgnoredResult$.MODULE$;
                    }
                    if (name.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$75(ctx, name)))) {
                        return IgnoredResult$.MODULE$;
                    }
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof DoNothingIfExistsForFulltextIndex) {
                DoNothingIfExistsForFulltextIndex doNothingIfExistsForFulltextIndex = (DoNothingIfExistsForFulltextIndex)A1;
                Either entityNames = doNothingIfExistsForFulltextIndex.entityNames();
                List propertyKeyNames = doNothingIfExistsForFulltextIndex.propertyKeyNames();
                Option name = doNothingIfExistsForFulltextIndex.name();
                Options options = doNothingIfExistsForFulltextIndex.options();
                return (B1)(Function1 & Serializable)x$33 -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    CreateFulltextIndexOptionsConverter qual$14 = new CreateFulltextIndexOptionsConverter((QueryContext)ctx);
                    Options x$40 = options;
                    MapValue x$41 = params;
                    Option<Config> x$42 = qual$14.convert$default$3();
                    qual$14.convert(x$40, x$41, x$42);
                    Tuple2<List<Object>, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo((Either<List<LabelName>, List<RelTypeName>>)entityNames, (QueryContext)ctx);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    List entityIds = (List)tuple2._1();
                    EntityType entityType = (EntityType)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)entityIds, (Object)entityType);
                    List entityIds2 = (List)tuple22._1();
                    EntityType entityType2 = (EntityType)tuple22._2();
                    List propertyKeyIds = propertyKeyNames.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$78(ctx, p)));
                    if (Try$.MODULE$.apply((Function0 & Serializable)() -> ctx.fulltextIndexReference(entityIds2, entityType2, (Seq)propertyKeyIds).getName()).isSuccess()) {
                        return IgnoredResult$.MODULE$;
                    }
                    if (name.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$80(ctx, name)))) {
                        return IgnoredResult$.MODULE$;
                    }
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)None$.MODULE$);
            }
            if (A1 instanceof DoNothingIfExistsForConstraint) {
                DoNothingIfExistsForConstraint doNothingIfExistsForConstraint = (DoNothingIfExistsForConstraint)A1;
                Either entityName = doNothingIfExistsForConstraint.entityName();
                Seq props = doNothingIfExistsForConstraint.props();
                ConstraintType assertion = doNothingIfExistsForConstraint.assertion();
                Option name = doNothingIfExistsForConstraint.name();
                Options options = doNothingIfExistsForConstraint.options();
                return (B1)(Function1 & Serializable)x$35 -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable)(ctx, params) -> {
                    ConstraintType constraintType = assertion;
                    if (NodeKey$.MODULE$.equals(constraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$15 = new IndexBackedConstraintsOptionsConverter("node key constraint", (QueryContext)ctx);
                        Options x$43 = options;
                        MapValue x$44 = params;
                        Option<Config> x$45 = qual$15.convert$default$3();
                        qual$15.convert(x$43, x$44, x$45);
                    } else if (RelationshipKey$.MODULE$.equals(constraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$16 = new IndexBackedConstraintsOptionsConverter("relationship key constraint", (QueryContext)ctx);
                        Options x$46 = options;
                        MapValue x$47 = params;
                        Option<Config> x$48 = qual$16.convert$default$3();
                        qual$16.convert(x$46, x$47, x$48);
                    } else if (NodeUniqueness$.MODULE$.equals(constraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$17 = new IndexBackedConstraintsOptionsConverter("uniqueness constraint", (QueryContext)ctx);
                        Options x$49 = options;
                        MapValue x$50 = params;
                        Option<Config> x$51 = qual$17.convert$default$3();
                        qual$17.convert(x$49, x$50, x$51);
                    } else if (RelationshipUniqueness$.MODULE$.equals(constraintType)) {
                        IndexBackedConstraintsOptionsConverter qual$18 = new IndexBackedConstraintsOptionsConverter("relationship uniqueness constraint", (QueryContext)ctx);
                        Options x$52 = options;
                        MapValue x$53 = params;
                        Option<Config> x$54 = qual$18.convert$default$3();
                        qual$18.convert(x$52, x$53, x$54);
                    } else if (NodePropertyExistence$.MODULE$.equals(constraintType)) {
                        PropertyExistenceConstraintOptionsConverter qual$19 = new PropertyExistenceConstraintOptionsConverter("node", (QueryContext)ctx);
                        Options x$55 = options;
                        MapValue x$56 = params;
                        Option<Config> x$57 = qual$19.convert$default$3();
                        qual$19.convert(x$55, x$56, x$57);
                    } else if (RelationshipPropertyExistence$.MODULE$.equals(constraintType)) {
                        PropertyExistenceConstraintOptionsConverter qual$20 = new PropertyExistenceConstraintOptionsConverter("relationship", (QueryContext)ctx);
                        Options x$58 = options;
                        MapValue x$59 = params;
                        Option<Config> x$60 = qual$20.convert$default$3();
                        qual$20.convert(x$58, x$59, x$60);
                    } else {
                        throw new MatchError((Object)constraintType);
                    }
                    Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int entityId = tuple2._1$mcI$sp();
                    int entityId2 = entityId;
                    Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$83(ctx, p)));
                    if (ctx.constraintExists(SchemaCommandRuntime$.MODULE$.convertConstraintTypeToConstraintMatcher(assertion), entityId2, propertyKeyIds)) {
                        return IgnoredResult$.MODULE$;
                    }
                    if (name.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$84(ctx, name)))) {
                        return IgnoredResult$.MODULE$;
                    }
                    return SuccessResult$.MODULE$;
                }, (Option<ExecutionPlan>)None$.MODULE$);
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(LogicalPlan x1) {
            LogicalPlan logicalPlan = x1;
            if (logicalPlan instanceof CreateNodeKeyConstraint) {
                return true;
            }
            if (logicalPlan instanceof CreateRelationshipKeyConstraint) {
                return true;
            }
            if (logicalPlan instanceof CreateNodePropertyUniquenessConstraint) {
                return true;
            }
            if (logicalPlan instanceof CreateRelationshipPropertyUniquenessConstraint) {
                return true;
            }
            if (logicalPlan instanceof CreateNodePropertyExistenceConstraint) {
                return true;
            }
            if (logicalPlan instanceof CreateRelationshipPropertyExistenceConstraint) {
                return true;
            }
            if (logicalPlan instanceof DropConstraintOnName) {
                return true;
            }
            if (logicalPlan instanceof CreateRangeIndex) {
                return true;
            }
            if (logicalPlan instanceof CreateLookupIndex) {
                return true;
            }
            if (logicalPlan instanceof CreateFulltextIndex) {
                return true;
            }
            if (logicalPlan instanceof CreateTextIndex) {
                return true;
            }
            if (logicalPlan instanceof CreatePointIndex) {
                return true;
            }
            if (logicalPlan instanceof DropIndexOnName) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForIndex) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForLookupIndex) {
                return true;
            }
            if (logicalPlan instanceof DoNothingIfExistsForFulltextIndex) {
                return true;
            }
            return logicalPlan instanceof DoNothingIfExistsForConstraint;
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$4(QueryContext ctx$1, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$1, p.propertyKey()).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$10(QueryContext ctx$2, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$2, p.propertyKey()).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$16(QueryContext ctx$3, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$3, p.propertyKey()).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$22(QueryContext ctx$4, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$4, p.propertyKey()).id();
        }

        public static final /* synthetic */ void $anonfun$applyOrElse$27(QueryContext ctx$5, int labelId, int propertyKeyId, Option name) {
            ctx$5.createNodePropertyExistenceConstraint(labelId, propertyKeyId, name);
        }

        public static final /* synthetic */ void $anonfun$applyOrElse$32(QueryContext ctx$6, int relTypeId, int propertyKeyId, Option name) {
            ctx$6.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId, name);
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$40(QueryContext ctx$7, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$7, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$50(QueryContext ctx$8, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$8, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$56(QueryContext ctx$9, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$9, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$61(QueryContext ctx$10, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$10, p).id();
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$69(QueryContext ctx$11, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$11, p).id();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$71(QueryContext ctx$11, String name) {
            return ctx$11.indexExists(name);
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$75(QueryContext ctx$12, String name) {
            return ctx$12.indexExists(name);
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$78(QueryContext ctx$13, PropertyKeyName p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$13, p).id();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$80(QueryContext ctx$13, String name) {
            return ctx$13.indexExists(name);
        }

        public static final /* synthetic */ int $anonfun$applyOrElse$83(QueryContext ctx$14, Property p) {
            return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$14, p.propertyKey()).id();
        }

        public static final /* synthetic */ boolean $anonfun$applyOrElse$84(QueryContext ctx$14, String name) {
            return ctx$14.constraintExists(name);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$10$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$11(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$12(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$13(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$14(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$15(org.neo4j.cypher.internal.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$16$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$17(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$18(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$19(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$20(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$21(org.neo4j.cypher.internal.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$22$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$23(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$24(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$25(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$26(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$27$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$28(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$29(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$30(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$31(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$32$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$33(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$34(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$35(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$36(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$37(scala.util.Either org.neo4j.cypher.internal.ast.Options scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$38(scala.util.Either org.neo4j.cypher.internal.ast.Options scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$39(org.neo4j.cypher.internal.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$4$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$40$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$41(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$42(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$43(org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$44(org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$45(org.neo4j.cypher.internal.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$46(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex ), $anonfun$applyOrElse$47(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$48(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$49(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$50$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$51(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex ), $anonfun$applyOrElse$52(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$53(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$54(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$55(org.neo4j.cypher.internal.CreateIndexProviderOnlyOptions ), $anonfun$applyOrElse$56$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$57(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$58(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$59(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$6(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$60(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$61$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$62(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$63(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$64(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$65(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$66(org.neo4j.graphdb.schema.IndexType org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$67(org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$68(scala.Function1 org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List org.neo4j.internal.schema.IndexType scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$69$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$7(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$70(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.internal.schema.IndexType int org.neo4j.common.EntityType scala.collection.immutable.List ), $anonfun$applyOrElse$71$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$72(org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$73(org.neo4j.cypher.internal.ast.Options org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$74(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.common.EntityType ), $anonfun$applyOrElse$75$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$76(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$77(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$78$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$79(org.neo4j.cypher.internal.runtime.QueryContext scala.collection.immutable.List org.neo4j.common.EntityType scala.collection.immutable.List ), $anonfun$applyOrElse$8(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.RelTypeName scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$80$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$81(org.neo4j.cypher.internal.logical.plans.ConstraintType org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$82(org.neo4j.cypher.internal.logical.plans.ConstraintType org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$83$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$84$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$9(org.neo4j.cypher.internal.CreateIndexProviderOnlyOptions )}, serializedLambda);
        }
    };

    @Override
    public String name() {
        return "schema";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return None$.MODULE$;
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery state, RuntimeContext context) {
        return (ExecutionPlan)((Function1)this.logicalToExecutable().applyOrElse((Object)state.logicalPlan(), (Function1 & Serializable)unknownPlan -> MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply((Object)context);
    }

    public Nothing$ throwCantCompile(LogicalPlan unknownPlan) {
        throw new CantCompileQueryException("Plan is not a schema command: " + unknownPlan.getClass().getSimpleName());
    }

    public Option<InternalQueryType> queryType(LogicalPlan logicalPlan) {
        if (this.logicalToExecutable().isDefinedAt((Object)logicalPlan)) {
            return new Some((Object)SCHEMA_WRITE$.MODULE$);
        }
        return None$.MODULE$;
    }

    public PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable() {
        return logicalToExecutable;
    }

    public Tuple2<Object, EntityType> org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(Either<LabelName, RelTypeName> entityName, QueryContext ctx) {
        Either<LabelName, RelTypeName> either = entityName;
        if (either instanceof Left) {
            Left left = (Left)either;
            LabelName label = (LabelName)left.value();
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)EntityType.NODE);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            RelTypeName relType = (RelTypeName)right.value();
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)EntityType.RELATIONSHIP);
        }
        throw new MatchError(either);
    }

    public Tuple2<List<Object>, EntityType> org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo(Either<List<LabelName>, List<RelTypeName>> entityName, QueryContext ctx) {
        Either<List<LabelName>, List<RelTypeName>> either = entityName;
        if (either instanceof Left) {
            Left left = (Left)either;
            List labels = (List)left.value();
            return new Tuple2((Object)labels.map((Function1 & Serializable)label -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name()))), (Object)EntityType.NODE);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            List relTypes = (List)right.value();
            return new Tuple2((Object)relTypes.map((Function1 & Serializable)relType -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name()))), (Object)EntityType.RELATIONSHIP);
        }
        throw new MatchError(either);
    }

    public boolean isApplicable(LogicalPlanState logicalPlanState) {
        return this.logicalToExecutable().isDefinedAt(logicalPlanState.maybeLogicalPlan().get());
    }

    public Function1<ConstraintDescriptor, Object> convertConstraintTypeToConstraintMatcher(ConstraintType assertion) {
        ConstraintType constraintType = assertion;
        if (NodePropertyExistence$.MODULE$.equals(constraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodePropertyExistenceConstraint());
        }
        if (RelationshipPropertyExistence$.MODULE$.equals(constraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipPropertyExistenceConstraint());
        }
        if (NodeUniqueness$.MODULE$.equals(constraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeUniquenessConstraint());
        }
        if (RelationshipUniqueness$.MODULE$.equals(constraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipUniquenessConstraint());
        }
        if (NodeKey$.MODULE$.equals(constraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeKeyConstraint());
        }
        if (RelationshipKey$.MODULE$.equals(constraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipKeyConstraint());
        }
        throw new MatchError((Object)constraintType);
    }

    public PropertyKeyId org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(QueryContext ctx, PropertyKeyName property) {
        return new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName(QueryContext ctx, LabelName label, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName(QueryContext ctx, RelTypeName relType, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    private SchemaCommandRuntime$() {
    }
}

