/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.schema;

import java.io.Serializable;
import java.util.Optional;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ast.CreateConstraint;
import org.neo4j.cypher.internal.ast.CreateConstraint$;
import org.neo4j.cypher.internal.ast.CreateConstraintType;
import org.neo4j.cypher.internal.ast.CreateFulltextIndex;
import org.neo4j.cypher.internal.ast.CreateFulltextIndex$;
import org.neo4j.cypher.internal.ast.CreateIndexType;
import org.neo4j.cypher.internal.ast.CreateLookupIndex;
import org.neo4j.cypher.internal.ast.CreateLookupIndex$;
import org.neo4j.cypher.internal.ast.CreateSingleLabelPropertyIndex;
import org.neo4j.cypher.internal.ast.CreateSingleLabelPropertyIndex$;
import org.neo4j.cypher.internal.ast.DropConstraintOnName;
import org.neo4j.cypher.internal.ast.DropIndexOnName;
import org.neo4j.cypher.internal.ast.IfExistsDo;
import org.neo4j.cypher.internal.ast.IfExistsDoNothing$;
import org.neo4j.cypher.internal.ast.NodeKey;
import org.neo4j.cypher.internal.ast.NodePropertyExistence$;
import org.neo4j.cypher.internal.ast.NodePropertyType;
import org.neo4j.cypher.internal.ast.NodePropertyUniqueness$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.OptionsParam;
import org.neo4j.cypher.internal.ast.PointCreateIndex$;
import org.neo4j.cypher.internal.ast.RangeCreateIndex;
import org.neo4j.cypher.internal.ast.RelationshipKey;
import org.neo4j.cypher.internal.ast.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.ast.RelationshipPropertyType;
import org.neo4j.cypher.internal.ast.RelationshipPropertyUniqueness$;
import org.neo4j.cypher.internal.ast.TextCreateIndex$;
import org.neo4j.cypher.internal.ast.VectorCreateIndex$;
import org.neo4j.cypher.internal.expressions.ElementTypeName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.optionsmap.CreateFulltextIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions;
import org.neo4j.cypher.internal.optionsmap.CreateIndexWithFullOptions;
import org.neo4j.cypher.internal.optionsmap.CreateLookupIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreatePointIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateRangeIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateTextIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.CreateVectorIndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.IndexBackedConstraintsOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.IndexOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.PropertyExistenceOrTypeConstraintOptionsConverter;
import org.neo4j.cypher.internal.procs.PropertyTypeMapper$;
import org.neo4j.cypher.internal.runtime.IndexProviderContext;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.values.virtual.MapValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tme\u0001\u0002\f\u0018\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%IA\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005W!A\u0001\u0007\u0001BC\u0002\u0013%\u0011\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u00033\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001d1\u0005A1A\u0005\n\u001dCa\u0001\u0015\u0001!\u0002\u0013A\u0005bB)\u0001\u0005\u0004%IA\u0015\u0005\u00073\u0002\u0001\u000b\u0011B*\t\u000bi\u0003A\u0011A.\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!!7\u0001\t\u0013\tY\u000eC\u0004\u0002f\u0002!I!a:\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B6\u0001\u0011%!Q\u000e\u0005\b\u0005w\u0002A\u0011\u0002B?\u0005Y\u00196\r[3nC\u000e{W.\\1oI\u000e{gN^3si\u0016\u0014(B\u0001\r\u001a\u0003\u0019\u00198\r[3nC*\u0011!dG\u0001\tS:$XM\u001d8bY*\u0011A$H\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005yy\u0012!\u00028f_RR'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g-A\u0007dsBDWM\u001d,feNLwN\\\u000b\u0002WA\u0011A&L\u0007\u00023%\u0011a&\u0007\u0002\u000e\u0007f\u0004\b.\u001a:WKJ\u001c\u0018n\u001c8\u0002\u001d\rL\b\u000f[3s-\u0016\u00148/[8oA\u0005AB.\u0019;fgR4Vm\u0019;pe&sG-\u001a=WKJ\u001c\u0018n\u001c8\u0016\u0003I\u0002\"aM\u001f\u000e\u0003QR!!\u000e\u001c\u0002\rY,7\r^8s\u0015\tArG\u0003\u00029s\u0005!\u0011.\u001c9m\u0015\tQ4(A\u0002ba&T!\u0001P\u000f\u0002\r-,'O\\3m\u0013\tqDG\u0001\nWK\u000e$xN]%oI\u0016Dh+\u001a:tS>t\u0017!\u00077bi\u0016\u001cHOV3di>\u0014\u0018J\u001c3fqZ+'o]5p]\u0002\na\u0001P5oSRtDc\u0001\"E\u000bB\u00111\tA\u0007\u0002/!)\u0011&\u0002a\u0001W!)\u0001'\u0002a\u0001e\u0005aQI\u0015*P%~\u001bVK\u0012$J1V\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006!A.\u00198h\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003\rM#(/\u001b8h\u00035)%KU(S?N+fIR%YA\u0005y\u0001O]8wS\u0012,'oQ8oi\u0016DH/F\u0001T!\t!v+D\u0001V\u0015\t1\u0016$A\u0004sk:$\u0018.\\3\n\u0005a+&\u0001F%oI\u0016D\bK]8wS\u0012,'oQ8oi\u0016DH/\u0001\tqe>4\u0018\u000eZ3s\u0007>tG/\u001a=uA\u0005)\u0011\r\u001d9msR\u0011AL\u0019\t\u0003;\u0002l\u0011A\u0018\u0006\u00031}S!AG\u000f\n\u0005\u0005t&!D*dQ\u0016l\u0017mQ8n[\u0006tG\rC\u0003d\u0015\u0001\u0007A-A\u0004d_6l\u0017M\u001c3\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dL\u0012aA1ti&\u0011\u0011M\u001a\u0015\u0004\u0015)|\bc\u0001\u0013l[&\u0011A.\n\u0002\u0007i\"\u0014xn^:\u0011\u00059dhBA8{\u001d\t\u0001\u0018P\u0004\u0002rq:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u0006\na\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0005yy\u0012B\u0001\u000e\u001e\u0013\tAr,\u0003\u0002|=\u0006i1k\u00195f[\u0006\u001cu.\\7b]\u0012L!! @\u00039M\u001b\u0007.Z7b\u0007>lW.\u00198e%\u0016\fG-\u001a:Fq\u000e,\u0007\u000f^5p]*\u00111PX\u0019\b=\u0005\u0005\u0011qBA!!\u0011\t\u0019!a\u0003\u000f\t\u0005\u0015\u0011q\u0001\t\u0003g\u0016J1!!\u0003&\u0003\u0019\u0001&/\u001a3fM&\u0019q*!\u0004\u000b\u0007\u0005%Q%M\u0005$\u0003#\tI\"a\u000e\u0002\u001cU!\u00111CA\u000b+\t\t\t\u0001B\u0004\u0002\u0018\u0005\u0012\r!!\t\u0003\u0003QKA!a\u0007\u0002\u001e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!a\b&\u0003\u0019!\bN]8xgF!\u00111EA\u0015!\r!\u0013QE\u0005\u0004\u0003O)#a\u0002(pi\"Lgn\u001a\t\u0005\u0003W\t\tDD\u0002%\u0003[I1!a\f&\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\r\u00026\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003_)\u0013'C\u0012\u0002:\u0005m\u0012QHA\u0010\u001d\r!\u00131H\u0005\u0004\u0003?)\u0013'\u0002\u0012%K\u0005}\"!B:dC2\f\u0017G\u0001\u0014n\u0003%\u0019\u0007.Z2l\u001d\u0006lW\r\u0006\u0004\u0002\u0002\u0005\u001d\u00131\r\u0005\b\u0003\u0013Z\u0001\u0019AA&\u0003\u0011q\u0017-\\3\u0011\u0011\u00055\u00131KA\u0001\u0003/rA!a\u0014\u0002.9\u00191/!\u0015\n\u0003\u0019JA!!\u0016\u00026\t1Q)\u001b;iKJ\u0004B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;J\u0012aC3yaJ,7o]5p]NLA!!\u0019\u0002\\\tI\u0001+\u0019:b[\u0016$XM\u001d\u0005\b\u0003KZ\u0001\u0019AA\u0001\u0003\u001diWm]:bO\u0016DCa\u00036\u0002jE:a$!\u0001\u0002l\u0005E\u0014'C\u0012\u0002\u0012\u0005e\u0011QNA\u000ec%\u0019\u0013\u0011HA\u001e\u0003_\ny\"M\u0003#I\u0015\ny$\r\u0002'[\u0006IAo\\6f]:\u000bW.\u001a\u000b\u0005\u0003\u0003\t9\bC\u0004\u0002J1\u0001\r!!\u001f\u0011\t\u0005e\u00131P\u0005\u0005\u0003{\nYFA\bFY\u0016lWM\u001c;UsB,g*Y7fQ\u0011a!.!!2\u000fy\t\t!a!\u0002\nFJ1%!\u0005\u0002\u001a\u0005\u0015\u00151D\u0019\nG\u0005e\u00121HAD\u0003?\tTA\t\u0013&\u0003\u007f\t$AJ7\u0002\u0017%4gj\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0003\u001f\u000b)\nE\u0002%\u0003#K1!a%&\u0005\u001d\u0011un\u001c7fC:Dq!a&\u000e\u0001\u0004\tI*\u0001\u0006jM\u0016C\u0018n\u001d;t\t>\u00042!ZAN\u0013\r\tiJ\u001a\u0002\u000b\u0013\u001a,\u00050[:ug\u0012{\u0017\u0001\u00049s_ZLG-\u001a:P]2LH\u0003BAR\u0003k\u0003b!!*\u0002,\u0006=VBAAT\u0015\r\tI\u000bT\u0001\u0005kRLG.\u0003\u0003\u0002.\u0006\u001d&\u0001C(qi&|g.\u00197\u0011\u0007u\u000b\t,C\u0002\u00024z\u0013q#\u00138eKb\u0004&o\u001c<jI\u0016\u0014H)Z:de&\u0004Ho\u001c:\t\u000f\u0005]f\u00021\u0001\u0002:\u0006y\u0001O]8wS\u0012,'o\u00149uS>t7\u000fE\u0003%\u0003w\u000by,C\u0002\u0002>\u0016\u0012aa\u00149uS>t\u0007\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015\u0017$\u0001\u0006paRLwN\\:nCBLA!!3\u0002D\nq2I]3bi\u0016Le\u000eZ3y!J|g/\u001b3fe>sG._(qi&|gn]\u0001\u0013aJ|g/\u001b3fe^KG\u000f[\"p]\u001aLw\r\u0006\u0003\u0002$\u0006=\u0007bBA\\\u001f\u0001\u0007\u0011\u0011\u001b\t\u0006I\u0005m\u00161\u001b\t\u0005\u0003\u0003\f).\u0003\u0003\u0002X\u0006\r'AG\"sK\u0006$X-\u00138eKb<\u0016\u000e\u001e5Gk2dw\n\u001d;j_:\u001c\u0018aC5oI\u0016D8i\u001c8gS\u001e$B!!8\u0002dB\u0019Q,a8\n\u0007\u0005\u0005hLA\u0006J]\u0012,\u0007pQ8oM&<\u0007bBA\\!\u0001\u0007\u0011\u0011[\u0001\u0010m\u0006d\u0017\u000eZ1uK>\u0003H/[8ogV!\u0011\u0011^Ay)\u0019\tY/!@\u0003\bA)A%a/\u0002nB!\u0011q^Ay\u0019\u0001!q!a=\u0012\u0005\u0004\t)P\u0001\u0004P!RKuJT\t\u0005\u0003G\t9\u0010E\u0002%\u0003sL1!a?&\u0005\r\te.\u001f\u0005\b\u0003\u007f\f\u0002\u0019\u0001B\u0001\u0003\u001dy\u0007\u000f^5p]N\u00042!\u001aB\u0002\u0013\r\u0011)A\u001a\u0002\b\u001fB$\u0018n\u001c8t\u0011\u001d\u0011I!\u0005a\u0001\u0005\u0017\t\u0011bY8om\u0016\u0014H/\u001a:\u0011\r\u0005\u0005'QBAw\u0013\u0011\u0011y!a1\u0003+%sG-\u001a=PaRLwN\\:D_:4XM\u001d;fe\"\"\u0011C\u001bB\nc\u001dq\u0012\u0011\u0001B\u000b\u00057\t\u0014bIA\t\u00033\u00119\"a\u00072\u0013\r\nI$a\u000f\u0003\u001a\u0005}\u0011'\u0002\u0012%K\u0005}\u0012G\u0001\u0014n\u0003\u0019\t7\u000fT5tiV!!\u0011\u0005B\u0016)\u0011\u0011\u0019Ca\f\u0011\r\u0005\u0015&Q\u0005B\u0015\u0013\u0011\u00119#a*\u0003\t1K7\u000f\u001e\t\u0005\u0003_\u0014Y\u0003B\u0004\u0003.I\u0011\r!!>\u0003\tQK\u0006+\u0012\u0005\b\u0005c\u0011\u0002\u0019\u0001B\u001a\u0003\u0011a\u0017n\u001d;\u0011\r\tU\"1\bB\u0015\u001b\t\u00119DC\u0002\u0003:\u0015\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iDa\u000e\u0003\u0007M+\u0017/A\u0006tKRd\u0015n[3MSN$X\u0003\u0002B\"\u0005\u0013\"\u0002B!\u0012\u0003L\t]#1\f\t\u0007\u0003K\u0013)Ca\u0012\u0011\t\u0005=(\u0011\n\u0003\b\u0005[\u0019\"\u0019AA{\u0011\u001d\u0011\td\u0005a\u0001\u0005\u001b\u0002bAa\u0014\u0003V\t\u001dSB\u0001B)\u0015\u0011\u0011\u0019Fa\u000e\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002B\u0014\u0005#BqA!\u0017\u0014\u0001\u0004\t\t!\u0001\u0003eKN\u001c\u0007b\u0002B/'\u0001\u0007\u0011\u0011A\u0001\u0006i>\\WM\u001c\u0015\u0005')\u0014\t'M\u0004\u001f\u0003\u0003\u0011\u0019G!\u001b2\u0013\r\n\t\"!\u0007\u0003f\u0005m\u0011'C\u0012\u0002:\u0005m\"qMA\u0010c\u0015\u0011C%JA c\t1S.\u0001\btS:<G.\u001a)s_B,'\u000f^=\u0015\t\u0005\u0005!q\u000e\u0005\b\u0005c\"\u0002\u0019\u0001B:\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0007\u0005k\u0011YD!\u001e\u0011\t\u0005e#qO\u0005\u0005\u0005s\nYF\u0001\u0005Qe>\u0004XM\u001d;z\u0003)\u0019\u0018N\\4mK&#X-\\\u000b\u0007\u0005\u007f\u0012yIa!\u0015\r\t\u0005%q\u0011BI!\u0011\tyOa!\u0005\u000f\t\u0015UC1\u0001\u0002v\n1!+R*V\u0019RCqA!#\u0016\u0001\u0004\u0011Y)A\u0002tKF\u0004bA!\u000e\u0003<\t5\u0005\u0003BAx\u0005\u001f#qA!\f\u0016\u0005\u0004\t)\u0010C\u0004\u0003\u0014V\u0001\rA!&\u0002\r5\f\u0007\u000f]3s!\u001d!#q\u0013BG\u0005\u0003K1A!'&\u0005%1UO\\2uS>t\u0017\u0007")
public class SchemaCommandConverter {
    private final CypherVersion cypherVersion;
    private final VectorIndexVersion latestVectorIndexVersion;
    private final String ERROR_SUFFIX;
    private final IndexProviderContext providerContext;

    private CypherVersion cypherVersion() {
        return this.cypherVersion;
    }

    private VectorIndexVersion latestVectorIndexVersion() {
        return this.latestVectorIndexVersion;
    }

    private String ERROR_SUFFIX() {
        return this.ERROR_SUFFIX;
    }

    private IndexProviderContext providerContext() {
        return this.providerContext;
    }

    public SchemaCommand apply(org.neo4j.cypher.internal.ast.SchemaCommand command) throws SchemaCommand.SchemaCommandReaderException {
        CreateConstraint createConstraint;
        Some some;
        CreateSingleLabelPropertyIndex createSingleLabelPropertyIndex;
        Some some2;
        CreateFulltextIndex createFulltextIndex;
        Some some3;
        CreateLookupIndex createLookupIndex;
        Some some4;
        org.neo4j.cypher.internal.ast.SchemaCommand schemaCommand = command;
        if (schemaCommand instanceof DropConstraintOnName) {
            DropConstraintOnName dropConstraintOnName = (DropConstraintOnName)schemaCommand;
            Either name = dropConstraintOnName.name();
            boolean ifExists = dropConstraintOnName.ifExists();
            Option option = dropConstraintOnName.useGraph();
            if (None$.MODULE$.equals(option)) {
                return new SchemaCommand.ConstraintCommand.Drop(this.checkName((Either<String, Parameter>)name, "constraint name"), ifExists);
            }
        }
        if (schemaCommand instanceof DropIndexOnName) {
            DropIndexOnName dropIndexOnName = (DropIndexOnName)schemaCommand;
            Either name = dropIndexOnName.name();
            boolean ifExists = dropIndexOnName.ifExists();
            Option option = dropIndexOnName.useGraph();
            if (None$.MODULE$.equals(option)) {
                return new SchemaCommand.IndexCommand.Drop(this.checkName((Either<String, Parameter>)name, "index name"), ifExists);
            }
        }
        if (schemaCommand instanceof CreateLookupIndex && !(some4 = CreateLookupIndex$.MODULE$.unapply(createLookupIndex = (CreateLookupIndex)schemaCommand)).isEmpty()) {
            boolean isNodeIndex = BoxesRunTime.unboxToBoolean((Object)((Tuple7)some4.get())._2());
            Option indexName = (Option)((Tuple7)some4.get())._4();
            CreateIndexType indexType = (CreateIndexType)((Tuple7)some4.get())._5();
            IfExistsDo ifExistsDo = (IfExistsDo)((Tuple7)some4.get())._6();
            Options options = (Options)((Tuple7)some4.get())._7();
            String desc = isNodeIndex ? indexType.nodeDescription() : indexType.relDescription();
            String name = (String)indexName.map((Function1 & Serializable)n -> this.checkName((Either<String, Parameter>)n, desc + " name")).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            boolean notExists = this.ifNotExists(ifExistsDo);
            Optional<IndexProviderDescriptor> config = this.providerOnly(this.validateOptions(options, new CreateLookupIndexOptionsConverter(this.providerContext())));
            if (isNodeIndex) {
                return new SchemaCommand.IndexCommand.Create.NodeLookup(name, notExists, config);
            }
            return new SchemaCommand.IndexCommand.Create.RelationshipLookup(name, notExists, config);
        }
        if (schemaCommand instanceof CreateFulltextIndex && !(some3 = CreateFulltextIndex$.MODULE$.unapply(createFulltextIndex = (CreateFulltextIndex)schemaCommand)).isEmpty()) {
            Either entityNames = (Either)((Tuple7)some3.get())._2();
            List properties = (List)((Tuple7)some3.get())._3();
            Option indexName = (Option)((Tuple7)some3.get())._4();
            IfExistsDo ifExistsDo = (IfExistsDo)((Tuple7)some3.get())._6();
            Options options = (Options)((Tuple7)some3.get())._7();
            Option<CreateIndexWithFullOptions> config = this.validateOptions(options, new CreateFulltextIndexOptionsConverter(this.providerContext()));
            String desc = createFulltextIndex.entityIndexDescription();
            String name = (String)indexName.map((Function1 & Serializable)n -> this.checkName((Either<String, Parameter>)n, desc + " name")).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            java.util.List props = this.setLikeList(properties.map((Function1 & Serializable)p -> p.propertyKey().name()), desc, "property");
            Either either = entityNames;
            if (either instanceof Left) {
                Left left = (Left)either;
                List labels = (List)left.value();
                return new SchemaCommand.IndexCommand.Create.NodeFulltext(name, this.setLikeList(labels.map((Function1 & Serializable)l -> l.name()), desc, "label"), props, this.ifNotExists(ifExistsDo), this.providerWithConfig(config), this.indexConfig(config));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                List types = (List)right.value();
                return new SchemaCommand.IndexCommand.Create.RelationshipFulltext(name, this.setLikeList(types.map((Function1 & Serializable)t -> t.name()), desc, "relationship"), props, this.ifNotExists(ifExistsDo), this.providerWithConfig(config), this.indexConfig(config));
            }
            throw new MatchError((Object)either);
        }
        if (schemaCommand instanceof CreateSingleLabelPropertyIndex && !(some2 = CreateSingleLabelPropertyIndex$.MODULE$.unapply(createSingleLabelPropertyIndex = (CreateSingleLabelPropertyIndex)schemaCommand)).isEmpty()) {
            ElementTypeName elementName = (ElementTypeName)((Tuple7)some2.get())._2();
            List properties = (List)((Tuple7)some2.get())._3();
            Option indexName = (Option)((Tuple7)some2.get())._4();
            CreateIndexType indexType = (CreateIndexType)((Tuple7)some2.get())._5();
            IfExistsDo ifExistsDo = (IfExistsDo)((Tuple7)some2.get())._6();
            Options options = (Options)((Tuple7)some2.get())._7();
            String desc = createSingleLabelPropertyIndex.entityIndexDescription();
            boolean isNode = createSingleLabelPropertyIndex.isNodeIndex();
            String name = (String)indexName.map((Function1 & Serializable)n -> this.checkName((Either<String, Parameter>)n, desc + " name")).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            String entityName = this.tokenName(elementName);
            CreateIndexType createIndexType = indexType;
            if (createIndexType instanceof RangeCreateIndex) {
                java.util.List props = this.setLikeList(properties.map((Function1 & Serializable)p -> p.propertyKey().name()), desc, "property");
                Option<CreateIndexProviderOnlyOptions> config = this.validateOptions(options, new CreateRangeIndexOptionsConverter(desc, this.providerContext()));
                if (isNode) {
                    return new SchemaCommand.IndexCommand.Create.NodeRange(name, entityName, props, this.ifNotExists(ifExistsDo), this.providerOnly(config));
                }
                return new SchemaCommand.IndexCommand.Create.RelationshipRange(name, entityName, props, this.ifNotExists(ifExistsDo), this.providerOnly(config));
            }
            if (TextCreateIndex$.MODULE$.equals(createIndexType)) {
                Option<CreateIndexProviderOnlyOptions> config = this.validateOptions(options, new CreateTextIndexOptionsConverter(this.providerContext()));
                if (isNode) {
                    return new SchemaCommand.IndexCommand.Create.NodeText(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo), this.providerOnly(config));
                }
                return new SchemaCommand.IndexCommand.Create.RelationshipText(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo), this.providerOnly(config));
            }
            if (PointCreateIndex$.MODULE$.equals(createIndexType)) {
                Option<CreateIndexWithFullOptions> config = this.validateOptions(options, new CreatePointIndexOptionsConverter(this.providerContext()));
                if (isNode) {
                    return new SchemaCommand.IndexCommand.Create.NodePoint(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo), this.providerWithConfig(config), this.indexConfig(config));
                }
                return new SchemaCommand.IndexCommand.Create.RelationshipPoint(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo), this.providerWithConfig(config), this.indexConfig(config));
            }
            if (VectorCreateIndex$.MODULE$.equals(createIndexType)) {
                Option<CreateIndexWithFullOptions> config = this.validateOptions(options, new CreateVectorIndexOptionsConverter(this.providerContext(), this.latestVectorIndexVersion()));
                if (isNode) {
                    return new SchemaCommand.IndexCommand.Create.NodeVector(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo), this.providerWithConfig(config), this.indexConfig(config));
                }
                return new SchemaCommand.IndexCommand.Create.RelationshipVector(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo), this.providerWithConfig(config), this.indexConfig(config));
            }
            throw new SchemaCommand.SchemaCommandReaderException("Unrecognised index change found: " + command.getClass().getSimpleName());
        }
        if (schemaCommand instanceof CreateConstraint && !(some = CreateConstraint$.MODULE$.unapply(createConstraint = (CreateConstraint)schemaCommand)).isEmpty()) {
            ElementTypeName elementName = (ElementTypeName)((Tuple7)some.get())._2();
            scala.collection.immutable.Seq properties = (scala.collection.immutable.Seq)((Tuple7)some.get())._3();
            Option constraintName = (Option)((Tuple7)some.get())._4();
            CreateConstraintType constraintType = (CreateConstraintType)((Tuple7)some.get())._5();
            IfExistsDo ifExistsDo = (IfExistsDo)((Tuple7)some.get())._6();
            Options options = (Options)((Tuple7)some.get())._7();
            String desc = constraintType.description();
            String name = (String)constraintName.map((Function1 & Serializable)n -> this.checkName((Either<String, Parameter>)n, desc + " name")).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            String entityName = this.tokenName(elementName);
            CreateConstraintType createConstraintType = constraintType;
            if (createConstraintType instanceof NodeKey) {
                Option<CreateIndexProviderOnlyOptions> config = this.validateOptions(options, new IndexBackedConstraintsOptionsConverter("range index", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.NodeKey(name, entityName, this.asList((Seq)properties.map((Function1 & Serializable)p -> p.propertyKey().name())), this.ifNotExists(ifExistsDo), this.providerOnly(config));
            }
            if (createConstraintType instanceof RelationshipKey) {
                Option<CreateIndexProviderOnlyOptions> config = this.validateOptions(options, new IndexBackedConstraintsOptionsConverter("range index", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.RelationshipKey(name, entityName, this.asList((Seq)properties.map((Function1 & Serializable)p -> p.propertyKey().name())), this.ifNotExists(ifExistsDo), this.providerOnly(config));
            }
            if (NodePropertyUniqueness$.MODULE$.equals(createConstraintType)) {
                Option<CreateIndexProviderOnlyOptions> config = this.validateOptions(options, new IndexBackedConstraintsOptionsConverter("range index", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.NodeUniqueness(name, entityName, this.asList((Seq)properties.map((Function1 & Serializable)p -> p.propertyKey().name())), this.ifNotExists(ifExistsDo), this.providerOnly(config));
            }
            if (RelationshipPropertyUniqueness$.MODULE$.equals(createConstraintType)) {
                Option<CreateIndexProviderOnlyOptions> config = this.validateOptions(options, new IndexBackedConstraintsOptionsConverter("range index", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.RelationshipUniqueness(name, entityName, this.asList((Seq)properties.map((Function1 & Serializable)p -> p.propertyKey().name())), this.ifNotExists(ifExistsDo), this.providerOnly(config));
            }
            if (NodePropertyExistence$.MODULE$.equals(createConstraintType)) {
                this.validateOptions(options, new PropertyExistenceOrTypeConstraintOptionsConverter("node", "existence", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.NodeExistence(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo));
            }
            if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
                this.validateOptions(options, new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "existence", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.RelationshipExistence(name, entityName, this.singleProperty((Seq<Property>)properties), this.ifNotExists(ifExistsDo));
            }
            if (createConstraintType instanceof NodePropertyType) {
                NodePropertyType nodePropertyType = (NodePropertyType)createConstraintType;
                CypherType propType = nodePropertyType.propType();
                this.validateOptions(options, new PropertyExistenceOrTypeConstraintOptionsConverter("node", "type", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.NodePropertyType(name, entityName, this.singleProperty((Seq<Property>)properties), PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propType), this.ifNotExists(ifExistsDo));
            }
            if (createConstraintType instanceof RelationshipPropertyType) {
                RelationshipPropertyType relationshipPropertyType = (RelationshipPropertyType)createConstraintType;
                CypherType propType = relationshipPropertyType.propType();
                this.validateOptions(options, new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "type", this.providerContext()));
                return new SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType(name, entityName, this.singleProperty((Seq<Property>)properties), PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propType), this.ifNotExists(ifExistsDo));
            }
            throw new MatchError((Object)createConstraintType);
        }
        throw new SchemaCommand.SchemaCommandReaderException("Unrecognised schema change found: " + command.getClass().getSimpleName());
    }

    private String checkName(Either<String, Parameter> name, String message) throws SchemaCommand.SchemaCommandReaderException {
        return (String)name.swap().getOrElse((Function0 & Serializable)() -> {
            throw new SchemaCommand.SchemaCommandReaderException("Parameters are not allowed to be used as a %s%s".formatted(message, this.ERROR_SUFFIX()));
        });
    }

    private String tokenName(ElementTypeName name) throws SchemaCommand.SchemaCommandReaderException {
        ElementTypeName elementTypeName = name;
        if (elementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)elementTypeName;
            String n = labelName.name();
            return n;
        }
        if (elementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)elementTypeName;
            String n = relTypeName.name();
            return n;
        }
        throw new SchemaCommand.SchemaCommandReaderException("Unrecognised entity token type: " + name);
    }

    private boolean ifNotExists(IfExistsDo ifExistsDo) {
        return ifExistsDo == IfExistsDoNothing$.MODULE$;
    }

    private Optional<IndexProviderDescriptor> providerOnly(Option<CreateIndexProviderOnlyOptions> providerOptions) {
        return Optional.ofNullable(providerOptions.flatMap((Function1 & Serializable)opts -> opts.provider()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Optional<IndexProviderDescriptor> providerWithConfig(Option<CreateIndexWithFullOptions> providerOptions) {
        return Optional.ofNullable(providerOptions.flatMap((Function1 & Serializable)opts -> opts.provider()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private IndexConfig indexConfig(Option<CreateIndexWithFullOptions> providerOptions) {
        return (IndexConfig)providerOptions.map((Function1 & Serializable)opts -> opts.config()).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)IndexConfig.empty())).get();
    }

    private <OPTION> Option<OPTION> validateOptions(Options options, IndexOptionsConverter<OPTION> converter) throws SchemaCommand.SchemaCommandReaderException {
        if (options instanceof OptionsParam) {
            throw new SchemaCommand.SchemaCommandReaderException("Parameterised options are not allowed" + this.ERROR_SUFFIX());
        }
        return converter.convert(this.cypherVersion(), options, MapValue.EMPTY, (Option<Config>)Option$.MODULE$.empty()).toOption();
    }

    private <TYPE> java.util.List<TYPE> asList(Seq<TYPE> list) {
        return Lists.mutable.withAll(CollectionConverters$.MODULE$.IterableHasAsJava(list).asJava());
    }

    private <TYPE> java.util.List<TYPE> setLikeList(List<TYPE> list, String desc, String token) throws SchemaCommand.SchemaCommandReaderException {
        MutableList values = Lists.mutable.empty();
        MutableSet unique = Sets.mutable.empty();
        list.foreach((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)SchemaCommandConverter.$anonfun$setLikeList$1(unique, desc, token, values, value)));
        return values;
    }

    private String singleProperty(Seq<Property> properties) {
        return (String)this.singleItem(properties, (Function1 & Serializable)p -> p.propertyKey().name());
    }

    private <TYPE, RESULT> RESULT singleItem(Seq<TYPE> seq, Function1<TYPE, RESULT> mapper) {
        Object object;
        try {
            object = Iterables.single((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)seq.map(mapper)).asJava());
        }
        catch (Throwable ex) {
            throw new SchemaCommand.SchemaCommandReaderException("Expected only a single property", ex);
        }
        return (RESULT)object;
    }

    public static final /* synthetic */ boolean $anonfun$setLikeList$1(MutableSet unique$1, String desc$5, String token$1, MutableList values$1, Object value) {
        if (!unique$1.add(value)) {
            throw new SchemaCommand.SchemaCommandReaderException("Invalid %s as %s '%s' is duplicated".formatted(desc$5, token$1, value));
        }
        return values$1.add(value);
    }

    public SchemaCommandConverter(CypherVersion cypherVersion, VectorIndexVersion latestVectorIndexVersion) {
        this.cypherVersion = cypherVersion;
        this.latestVectorIndexVersion = latestVectorIndexVersion;
        this.ERROR_SUFFIX = " in import schema commands.";
        this.providerContext = (x$1, providerString, indexType, x$2) -> {
            IndexType actualType;
            AllIndexProviderDescriptors.ProviderDescriptorDetails details = (AllIndexProviderDescriptors.ProviderDescriptorDetails)AllIndexProviderDescriptors.providerDescriptorDetails((String)providerString).orElseThrow(() -> new IndexProviderNotFoundException("Unable to find the IndexProviderDescriptor for the name: " + providerString));
            IndexType indexType2 = actualType = details.type();
            IndexType indexType3 = indexType;
            if (indexType2 == null ? indexType3 != null : !indexType2.equals(indexType3)) {
                throw new SchemaCommand.SchemaCommandReaderException("The provider '%s' of type %s does not match the expected type of %s".formatted(providerString, actualType, indexType));
            }
            return details.descriptor();
        };
    }
}

