/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.UserFunctionSignature;
import org.neo4j.cypher.internal.logical.plans.CanGetValue$;
import org.neo4j.cypher.internal.logical.plans.DoNotGetValue$;
import org.neo4j.cypher.internal.logical.plans.GetValueFromIndexBehavior;
import org.neo4j.cypher.internal.planner.spi.DatabaseMode$;
import org.neo4j.cypher.internal.planner.spi.EventuallyConsistent$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexOrderCapability;
import org.neo4j.cypher.internal.planner.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.TokenIndexDescriptor;
import org.neo4j.cypher.internal.runtime.QueryTransactionalContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionalContextWrapper;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundPlanContext$;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.PropertyKeyId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r5u!B A\u0011\u0003Ye!B'A\u0011\u0003q\u0005\"B+\u0002\t\u00031\u0006\"B,\u0002\t\u0003A\u0006b\u0002Bs\u0003\u0011\u00051\u0011\u000e\u0005\b\u0007\u0007\tA\u0011ABC\r\u0011i\u0005\t\u0001.\t\u001154!\u0011!Q\u0001\n9D\u0001\"\u001d\u0004\u0003\u0002\u0003\u0006IA\u001d\u0005\tq\u001a\u0011\t\u0011)A\u0005s\"AAP\u0002B\u0001B\u0003%Q\u0010\u0003\u0004V\r\u0011\u0005\u00111\u0001\u0005\b\u0003\u001b1A\u0011IA\b\u0011\u001d\tID\u0002C!\u0003wAq!!\u0011\u0007\t\u0003\n\u0019\u0005C\u0004\u0002H\u0019!\t%!\u0013\t\u000f\u00055c\u0001\"\u0011\u0002P!9\u00111\u000b\u0004\u0005B\u0005U\u0003bBA-\r\u0011%\u00111\f\u0005\b\u0003o2A\u0011BA=\u0011\u001d\tyH\u0002C!\u0003\u0003Cq!a!\u0007\t\u0003\n)\tC\u0004\u0002\u0010\u001a!\t%!%\t\u000f\u0005Ue\u0001\"\u0011\u0002\u0018\"9\u0011\u0011\u0018\u0004\u0005B\u0005m\u0006bBAa\r\u0011\u0005\u00131\u0019\u0005\b\u0003\u00134A\u0011IAf\u0011\u001d\t\u0019N\u0002C!\u0003+Dq!a7\u0007\t\u0003\ni\u000eC\u0004\u0002d\u001a!I!!:\t\u000f\u00055h\u0001\"\u0003\u0002p\"9\u0011q\u001f\u0004\u0005\n\u0005e\bb\u0002B\u0005\r\u0011\u0005#1\u0002\u0005\b\u0005'1A\u0011\tB\u000b\u0011\u001d\u0011YB\u0002C!\u0005;AqAa\t\u0007\t\u0003\u0012)\u0003C\u0004\u0003,\u0019!\tE!\f\t\u000f\tMb\u0001\"\u0011\u00036!9!1\b\u0004\u0005\n\tu\u0002b\u0002B$\r\u0011%!\u0011\n\u0005\b\u0005G2A\u0011\tB3\u0011\u001d\u00119G\u0002C!\u0005KBqA!\u001b\u0007\t\u0003\u0012Y\u0007C\u0004\u0003r\u0019!\tEa\u001d\t\u000f\tud\u0001\"\u0003\u0003\u0000!9!Q\u0012\u0004\u0005B\t=\u0005b\u0002BK\r\u0011\u0005#q\u0013\u0005\b\u000573A\u0011\tBO\u0011\u001d\u0011yJ\u0002C!\u0005CCqA!.\u0007\t\u0003\u00129\fC\u0004\u0003D\u001a!\tE!2\t\u000f\t5g\u0001\"\u0011\u0003P\"I!1\u001b\u0004C\u0002\u0013\u0005#Q\u001b\u0005\b\u0005/4\u0001\u0015!\u0003z\u0011%\u0011IN\u0002b\u0001\n\u0003\u0012Y\u000e\u0003\u0005\u0003d\u001a\u0001\u000b\u0011\u0002Bo\u0011\u001d\u0011)O\u0002C!\u0005ODqaa\u0001\u0007\t\u0003\u001a)\u0001C\u0004\u0004\u0012\u0019!\tea\u0005\t\u000f\rUa\u0001\"\u0011\u0004\u0018!91\u0011\u0004\u0004\u0005B\rm\u0001bBB\u0012\r\u0011\u00053Q\u0005\u0005\b\u0007S1A\u0011IB\u0016\u0003m!&/\u00198tC\u000e$\u0018n\u001c8C_VtG\r\u00157b]\u000e{g\u000e^3yi*\u0011\u0011IQ\u0001\u0004gBL'BA\"E\u0003!Ig\u000e^3s]\u0006d'BA#G\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\tS\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0013\u0006\u0019qN]4\u0004\u0001A\u0011A*A\u0007\u0002\u0001\nYBK]1og\u0006\u001cG/[8o\u0005>,h\u000e\u001a)mC:\u001cuN\u001c;fqR\u001c\"!A(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1*A\u0003baBd\u0017\u0010F\u0005Z\u0007'\u001a)fa\u0016\u0004hA\u0011AJB\n\u0005\rm\u001b'\u000e\u0005\u0002]C6\tQL\u0003\u0002_?\u0006Y\u0011N\u001c;feB\u0014X\r^3e\u0015\t\u0001')A\u0004sk:$\u0018.\\3\n\u0005\tl&\u0001\t+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e%\u0016\fG\rV8lK:\u001cuN\u001c;fqR\u0004\"\u0001\u001a5\u000e\u0003\u0015T!!\u00114\u000b\u0005\u001d\u0014\u0015a\u00029mC:tWM]\u0005\u0003S\u0016\u00141\u0002\u00157b]\u000e{g\u000e^3yiB\u0011Aj[\u0005\u0003Y\u0002\u0013A$\u00138eKb$Um]2sSB$xN]\"p[B\fG/\u001b2jY&$\u00180\u0001\u0002uGB\u0011Al\\\u0005\u0003av\u00131\u0004\u0016:b]N\f7\r^5p]\u0006d7i\u001c8uKb$xK]1qa\u0016\u0014\u0018A\u00027pO\u001e,'\u000f\u0005\u0002tm6\tAO\u0003\u0002v\u0005\u0006!Q\u000f^5m\u0013\t9HO\u0001\u000eJ]R,'O\\1m\u001d>$\u0018NZ5dCRLwN\u001c'pO\u001e,'/A\bhe\u0006\u0004\bn\u0015;bi&\u001cH/[2t!\t!'0\u0003\u0002|K\nY\u0012J\\:ueVlWM\u001c;fI\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\fQbY=qQ\u0016\u0014h+\u001a:tS>t\u0007C\u0001@\u0000\u001b\u0005\u0011\u0015bAA\u0001\u0005\ni1)\u001f9iKJ4VM]:j_:$\u0012\"WA\u0003\u0003\u000f\tI!a\u0003\t\u000b5\\\u0001\u0019\u00018\t\u000bE\\\u0001\u0019\u0001:\t\u000ba\\\u0001\u0019A=\t\u000bq\\\u0001\u0019A?\u0002/I\fgnZ3J]\u0012,\u00070Z:HKR4uN\u001d'bE\u0016dG\u0003BA\t\u0003_\u0001b!a\u0005\u0002$\u0005%b\u0002BA\u000b\u0003?qA!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037Q\u0015A\u0002\u001fs_>$h(C\u0001S\u0013\r\t\t#U\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)#a\n\u0003\u0011%#XM]1u_JT1!!\tR!\r!\u00171F\u0005\u0004\u0003[)'aD%oI\u0016DH)Z:de&\u0004Ho\u001c:\t\u000f\u0005EB\u00021\u0001\u00024\u00059A.\u00192fY&#\u0007c\u0001)\u00026%\u0019\u0011qG)\u0003\u0007%sG/A\rsC:<W-\u00138eKb,7oR3u\r>\u0014(+\u001a7UsB,G\u0003BA\t\u0003{Aq!a\u0010\u000e\u0001\u0004\t\u0019$A\u0005sK2$\u0016\u0010]3JI\u00061B/\u001a=u\u0013:$W\r_3t\u000f\u0016$hi\u001c:MC\n,G\u000e\u0006\u0003\u0002\u0012\u0005\u0015\u0003bBA\u0019\u001d\u0001\u0007\u00111G\u0001\u0019i\u0016DH/\u00138eKb,7oR3u\r>\u0014(+\u001a7UsB,G\u0003BA\t\u0003\u0017Bq!a\u0010\u0010\u0001\u0004\t\u0019$A\fq_&tG/\u00138eKb,7oR3u\r>\u0014H*\u00192fYR!\u0011\u0011CA)\u0011\u001d\t\t\u0004\u0005a\u0001\u0003g\t\u0011\u0004]8j]RLe\u000eZ3yKN<U\r\u001e$peJ+G\u000eV=qKR!\u0011\u0011CA,\u0011\u001d\ty$\u0005a\u0001\u0003g\t!#\u001b8eKb,7oR3u\r>\u0014H*\u00192fYR1\u0011\u0011CA/\u0003?Bq!!\r\u0013\u0001\u0004\t\u0019\u0004C\u0004\u0002bI\u0001\r!a\u0019\u0002\u0013%tG-\u001a=UsB,\u0007#\u0002)\u0002f\u0005%\u0014bAA4#\n1q\n\u001d;j_:\u0004B!a\u001b\u0002t5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0004tG\",W.\u0019\u0006\u0003\u0007\u001aKA!!\u001e\u0002n\tI\u0011J\u001c3fqRK\b/Z\u0001\u0015S:$W\r_3t\u000f\u0016$hi\u001c:SK2$\u0016\u0010]3\u0015\r\u0005E\u00111PA?\u0011\u001d\tyd\u0005a\u0001\u0003gAq!!\u0019\u0014\u0001\u0004\t\u0019'A\u000bqe>\u0004XM\u001d;z\u0013:$W\r_3t\u000f\u0016$\u0018\t\u001c7\u0015\u0005\u0005E\u0011aE5oI\u0016DX\t_5tiN4uN\u001d'bE\u0016dG\u0003BAD\u0003\u001b\u00032\u0001UAE\u0013\r\tY)\u0015\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t$\u0006a\u0001\u0003g\tQ#\u001b8eKb,\u00050[:ug\u001a{'OU3m)f\u0004X\r\u0006\u0003\u0002\b\u0006M\u0005bBA -\u0001\u0007\u00111G\u0001\"i\u0016DH/\u00138eKb<U\r\u001e$pe2\u000b'-\u001a7B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u00033\u000bY*a,\u0011\u000bA\u000b)'!\u000b\t\u000f\u0005uu\u00031\u0001\u0002 \u0006IA.\u00192fY:\u000bW.\u001a\t\u0005\u0003C\u000bIK\u0004\u0003\u0002$\u0006\u0015\u0006cAA\f#&\u0019\u0011qU)\u0002\rA\u0013X\rZ3g\u0013\u0011\tY+!,\u0003\rM#(/\u001b8h\u0015\r\t9+\u0015\u0005\b\u0003c;\u0002\u0019AAZ\u00031\u0001(o\u001c9feRL8*Z=t!\u0019\t\u0019\"!.\u0002 &!\u0011qWA\u0014\u0005\r\u0019V-]\u0001#e\u0006tw-Z%oI\u0016Dx)\u001a;G_Jd\u0015MY3m\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005e\u0015QXA`\u0011\u001d\ti\n\u0007a\u0001\u0003?Cq!!-\u0019\u0001\u0004\t\u0019,\u0001\u0012q_&tG/\u00138eKb<U\r\u001e$pe2\u000b'-\u001a7B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u00033\u000b)-a2\t\u000f\u0005u\u0015\u00041\u0001\u0002 \"9\u0011\u0011W\rA\u0002\u0005M\u0016a\t;fqRLe\u000eZ3y\u000f\u0016$hi\u001c:SK2$\u0016\u0010]3B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u00033\u000bi-!5\t\u000f\u0005='\u00041\u0001\u0002 \u0006Y!/\u001a7UsB,g*Y7f\u0011\u001d\t\tL\u0007a\u0001\u0003g\u000bAE]1oO\u0016Le\u000eZ3y\u000f\u0016$hi\u001c:SK2$\u0016\u0010]3B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u00033\u000b9.!7\t\u000f\u0005=7\u00041\u0001\u0002 \"9\u0011\u0011W\u000eA\u0002\u0005M\u0016\u0001\n9pS:$\u0018J\u001c3fq\u001e+GOR8s%\u0016dG+\u001f9f\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005e\u0015q\\Aq\u0011\u001d\ty\r\ba\u0001\u0003?Cq!!-\u001d\u0001\u0004\t\u0019,A\u000fj]\u0012,\u0007pR3u\r>\u0014H*\u00192fY\u0006sG\r\u0015:pa\u0016\u0014H/[3t)!\tI*a:\u0002j\u0006-\bbBA1;\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003;k\u0002\u0019AAP\u0011\u001d\t\t,\ba\u0001\u0003g\u000bq$\u001b8eKb<U\r\u001e$peJ+G\u000eV=qK\u0006sG\r\u0015:pa\u0016\u0014H/[3t)!\tI*!=\u0002t\u0006U\bbBA1=\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003\u001ft\u0002\u0019AAP\u0011\u001d\t\tL\ba\u0001\u0003g\u000b1$\u001b8eKb<U\r\u001e$peN\u001b\u0007.Z7b\t\u0016\u001c8M]5qi>\u0014H\u0003BA~\u0005\u000f!B!!'\u0002~\"9\u0011q`\u0010A\u0002\t\u0005\u0011A\u00033fg\u000e\u0014\u0018\u000e\u001d;peB!\u00111\u000eB\u0002\u0013\u0011\u0011)!!\u001c\u0003!M\u001b\u0007.Z7b\t\u0016\u001c8M]5qi>\u0014\bbBA1?\u0001\u0007\u0011\u0011N\u0001%i\u0016DH/\u00138eKb,\u00050[:ug\u001a{'\u000fT1cK2\fe\u000e\u001a)s_B,'\u000f^5fgR1\u0011q\u0011B\u0007\u0005\u001fAq!!(!\u0001\u0004\ty\nC\u0004\u0003\u0012\u0001\u0002\r!a-\u0002\u0017A\u0014x\u000e]3sif\\U-_\u0001&e\u0006tw-Z%oI\u0016DX\t_5tiN4uN\u001d'bE\u0016d\u0017I\u001c3Qe>\u0004XM\u001d;jKN$b!a\"\u0003\u0018\te\u0001bBAOC\u0001\u0007\u0011q\u0014\u0005\b\u0005#\t\u0003\u0019AAZ\u0003\u0015\u0002x.\u001b8u\u0013:$W\r_#ySN$8OR8s\u0019\u0006\u0014W\r\\!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\b\n}!\u0011\u0005\u0005\b\u0003;\u0013\u0003\u0019AAP\u0011\u001d\u0011\tB\ta\u0001\u0003g\u000ba\u0005^3yi&sG-\u001a=Fq&\u001cHo\u001d$peJ+G\u000eV=qK\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\t9Ia\n\u0003*!9\u0011qZ\u0012A\u0002\u0005}\u0005b\u0002B\tG\u0001\u0007\u00111W\u0001(e\u0006tw-Z%oI\u0016DX\t_5tiN4uN\u001d*fYRK\b/Z!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\b\n=\"\u0011\u0007\u0005\b\u0003\u001f$\u0003\u0019AAP\u0011\u001d\u0011\t\u0002\na\u0001\u0003g\u000bq\u0005]8j]RLe\u000eZ3y\u000bbL7\u000f^:G_J\u0014V\r\u001c+za\u0016\fe\u000e\u001a)s_B,'\u000f^5fgR1\u0011q\u0011B\u001c\u0005sAq!a4&\u0001\u0004\ty\nC\u0004\u0003\u0012\u0015\u0002\r!a-\u0002\u001d\u001d,Go\u00148mS:,\u0017J\u001c3fqR!\u0011\u0011\u0014B \u0011\u001d\u0011\tE\na\u0001\u0005\u0007\n\u0011B]3gKJ,gnY3\u0011\t\u0005-$QI\u0005\u0005\u0003[\ti'A\fhKR$vn[3o\u0013:$W\r\u001f#fg\u000e\u0014\u0018\u000e\u001d;peR!!1\nB*!\u0015\u0001\u0016Q\rB'!\r!'qJ\u0005\u0004\u0005#*'\u0001\u0006+pW\u0016t\u0017J\u001c3fq\u0012+7o\u0019:jaR|'\u000fC\u0004\u0003V\u001d\u0002\rAa\u0016\u0002\u000f%tG-\u001a=fgB1!\u0011\fB1\u0005\u0007j!Aa\u0017\u000b\u0007U\u0014iF\u0003\u0002\u0003`\u0005!!.\u0019<b\u0013\u0011\t)Ca\u0017\u0002\u001d9|G-\u001a+pW\u0016t\u0017J\u001c3fqV\u0011!1J\u0001\u0017e\u0016d\u0017\r^5p]ND\u0017\u000e\u001d+pW\u0016t\u0017J\u001c3fq\u0006\u0011\u0003.Y:O_\u0012,\u0007K]8qKJ$\u00180\u0012=jgR,gnY3D_:\u001cHO]1j]R$b!a\"\u0003n\t=\u0004bBAOU\u0001\u0007\u0011q\u0014\u0005\b\u0005#Q\u0003\u0019AAP\u0003!:W\r\u001e(pI\u0016\u0004&o\u001c9feRLWm],ji\",\u00050[:uK:\u001cWmQ8ogR\u0014\u0018-\u001b8u)\u0011\u0011)Ha\u001f\u0011\r\u0005\u0005&qOAP\u0013\u0011\u0011I(!,\u0003\u0007M+G\u000fC\u0004\u0002\u001e.\u0002\r!a(\u0002K\u001d,G\u000f\u0015:pa\u0016\u0014H/[3t\rJ|W.\u0012=jgR,gnY3D_:\u001cHO]1j]R\u001cH\u0003\u0002B;\u0005\u0003CqAa!-\u0001\u0004\u0011))A\u0006d_:\u001cHO]1j]R\u001c\bCBA\n\u0003G\u00119\t\u0005\u0003\u0002l\t%\u0015\u0002\u0002BF\u0003[\u0012AcQ8ogR\u0014\u0018-\u001b8u\t\u0016\u001c8M]5qi>\u0014\u0018A\u000b5bgJ+G.\u0019;j_:\u001c\b.\u001b9Qe>\u0004XM\u001d;z\u000bbL7\u000f^3oG\u0016\u001cuN\\:ue\u0006Lg\u000e\u001e\u000b\u0007\u0003\u000f\u0013\tJa%\t\u000f\u0005=W\u00061\u0001\u0002 \"9!\u0011C\u0017A\u0002\u0005}\u0015\u0001M4fiJ+G.\u0019;j_:\u001c\b.\u001b9Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5Fq&\u001cH/\u001a8dK\u000e{gn\u001d;sC&tG\u000f\u0006\u0003\u0003v\te\u0005bBAh]\u0001\u0007\u0011qT\u0001%O\u0016$\bK]8qKJ$\u0018.Z:XSRDW\t_5ti\u0016t7-Z\"p]N$(/Y5oiV\u0011!QO\u0001\u001eQ\u0006\u001chj\u001c3f!J|\u0007/\u001a:usRK\b/Z\"p]N$(/Y5oiRA\u0011q\u0011BR\u0005K\u00139\u000bC\u0004\u0002\u001eB\u0002\r!a(\t\u000f\tE\u0001\u00071\u0001\u0002 \"9!\u0011\u0016\u0019A\u0002\t-\u0016AC2za\",'\u000fV=qKB!!Q\u0016BY\u001b\t\u0011yK\u0003\u0003\u0003\u0004\u00065\u0014\u0002\u0002BZ\u0005_\u0013qbU2iK6\fg+\u00197vKRK\b/Z\u0001$O\u0016$hj\u001c3f!J|\u0007/\u001a:uS\u0016\u001cx+\u001b;i)f\u0004XmQ8ogR\u0014\u0018-\u001b8u)\u0011\u0011IL!1\u0011\u0011\u0005\u0005&1XAP\u0005\u007fKAA!0\u0002.\n\u0019Q*\u00199\u0011\r\u0005M\u0011Q\u0017BV\u0011\u001d\ti*\ra\u0001\u0003?\u000bQ\u0005[1t%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d)s_B,'\u000f^=UsB,7i\u001c8tiJ\f\u0017N\u001c;\u0015\u0011\u0005\u001d%q\u0019Be\u0005\u0017Dq!a43\u0001\u0004\ty\nC\u0004\u0003\u0012I\u0002\r!a(\t\u000f\t%&\u00071\u0001\u0003,\u0006Ys-\u001a;SK2\fG/[8og\"L\u0007\u000f\u0015:pa\u0016\u0014H/[3t/&$\b\u000eV=qK\u000e{gn\u001d;sC&tG\u000f\u0006\u0003\u0003:\nE\u0007bBAhg\u0001\u0007\u0011qT\u0001\u000bgR\fG/[:uS\u000e\u001cX#A=\u0002\u0017M$\u0018\r^5ti&\u001c7\u000fI\u0001\u001aY\u0006\u001cHoQ8n[&$H/\u001a3Uq&#\u0007K]8wS\u0012,'/\u0006\u0002\u0003^B\u0019aPa8\n\u0007\t\u0005(IA\rMCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\u0018A\u00077bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\u0004\u0013A\u00059s_\u000e,G-\u001e:f'&<g.\u0019;ve\u0016$BA!;\u0003zB!!1\u001eB{\u001b\t\u0011iO\u0003\u0003\u0003p\nE\u0018A\u00029iCN,7OC\u0002\u0003t\n\u000b\u0001B\u001a:p]R,g\u000eZ\u0005\u0005\u0005o\u0014iO\u0001\nQe>\u001cW\rZ;sKNKwM\\1ukJ,\u0007b\u0002B~q\u0001\u0007!Q`\u0001\u0005]\u0006lW\r\u0005\u0003\u0003l\n}\u0018\u0002BB\u0001\u0005[\u0014Q\"U;bY&4\u0017.\u001a3OC6,\u0017!\u00054v]\u000e$\u0018n\u001c8TS\u001et\u0017\r^;sKR!1qAB\b!\u0015\u0001\u0016QMB\u0005!\u0011\u0011Yoa\u0003\n\t\r5!Q\u001e\u0002\u0016+N,'OR;oGRLwN\\*jO:\fG/\u001e:f\u0011\u001d\u0011Y0\u000fa\u0001\u0005{\f!C\\8uS\u001aL7-\u0019;j_:dunZ4feR\t!/A\tuqN#\u0018\r^3ICN\u001c\u0005.\u00198hKN$\"!a\"\u00023A\u0014xnY3ekJ,7+[4oCR,(/\u001a,feNLwN\\\u000b\u0003\u0007;\u00012\u0001UB\u0010\u0013\r\u0019\t#\u0015\u0002\u0005\u0019>tw-\u0001\fxSRDgj\u001c;jM&\u001c\u0017\r^5p]2{wmZ3s)\r\u00197q\u0005\u0005\u0007\u0007#i\u0004\u0019\u0001:\u0002\u0019\u0011\fG/\u00192bg\u0016lu\u000eZ3\u0016\u0005\r5\u0002\u0003BB\u0018\u0007\u001brAa!\r\u0004J9!11GB$\u001d\u0011\u0019)d!\u0012\u000f\t\r]21\t\b\u0005\u0007s\u0019\tE\u0004\u0003\u0004<\r}b\u0002BA\f\u0007{I\u0011!S\u0005\u0003\u000f\"K!!\u0012$\n\u0005\r#\u0015BA4C\u0013\t\te-C\u0002\u0004L\u0015\fA\u0002R1uC\n\f7/Z'pI\u0016LAaa\u0014\u0004R\taA)\u0019;bE\u0006\u001cX-T8eK*\u001911J3\t\u000b5\u001c\u0001\u0019\u00018\t\u000bE\u001c\u0001\u0019\u0001:\t\u000f\re3\u00011\u0001\u0004\\\u0005\u0019An\\4\u0011\t\ru31M\u0007\u0003\u0007?R1a!\u0019G\u0003\u001dawnZ4j]\u001eLAa!\u001a\u0004`\tY\u0011J\u001c;fe:\fG\u000eT8h\u0011\u0015a8\u00011\u0001~)!\u0011Ioa\u001b\u0004\u0000\r\u0005\u0005bBB7\t\u0001\u00071qN\u0001\u0003ib\u0004Ba!\u001d\u0004|5\u001111\u000f\u0006\u0005\u0007k\u001a9(A\u0002ba&T1a!\u001fG\u0003\u0019YWM\u001d8fY&!1QPB:\u0005EYUM\u001d8fYR\u0013\u0018M\\:bGRLwN\u001c\u0005\b\u0005w$\u0001\u0019\u0001B\u007f\u0011\u0019\u0019\u0019\t\u0002a\u0001{\u00069a/\u001a:tS>tG\u0003CB\u0004\u0007\u000f\u001bIia#\t\u000f\r5T\u00011\u0001\u0004p!9!1`\u0003A\u0002\tu\bBBBB\u000b\u0001\u0007Q\u0010")
public class TransactionBoundPlanContext
extends TransactionBoundReadTokenContext
implements PlanContext,
IndexDescriptorCompatibility {
    private final TransactionalContextWrapper tc;
    private final InternalNotificationLogger logger;
    private final InstrumentedGraphStatistics graphStatistics;
    private final CypherVersion cypherVersion;
    private final InstrumentedGraphStatistics statistics;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;

    public static TransactionBoundPlanContext apply(TransactionalContextWrapper tc, InternalNotificationLogger logger, InternalLog log, CypherVersion cypherVersion) {
        return TransactionBoundPlanContext$.MODULE$.apply(tc, logger, log, cypherVersion);
    }

    @Override
    public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
    }

    @Override
    public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
    }

    @Override
    public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
        return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
    }

    @Override
    public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
        return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
    }

    @Override
    public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
    }

    @Override
    public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForLabel(int labelId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$1(it, x$2));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$2(x$3));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getLabelIndexesNonLocking(labelId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForRelType(int relTypeId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$1(it, x$4));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$2(x$5));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getRelTypeIndexesNonLocking(relTypeId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> propertyIndexesGetAll() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexesGetAllNonLocking()).asScala().flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public boolean indexExistsForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public boolean indexExistsForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.TEXT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.RANGE, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.POINT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.TEXT, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.RANGE, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.POINT, relTypeName, propertyKeys);
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForLabelAndProperties(IndexType indexType, String labelName, Seq<String> propertyKeys) {
        Option<LabelSchemaDescriptor> descriptor2 = this.toLabelSchemaDescriptor(this, labelName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForRelTypeAndProperties(IndexType indexType, String relTypeName, Seq<String> propertyKeys) {
        Option<RelationTypeSchemaDescriptor> descriptor2 = this.toRelTypeSchemaDescriptor(this, relTypeName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForSchemaDescriptor(IndexType indexType, SchemaDescriptor descriptor) {
        Iterator itr = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexForSchemaNonLocking(descriptor)).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexGetForSchemaDescriptor$1(indexType, x$6))).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
        if (itr.hasNext()) {
            return new Some(itr.next());
        }
        return None$.MODULE$;
    }

    public boolean textIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.textIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.rangeIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.pointIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean textIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.textIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.rangeIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.pointIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> getOnlineIndex(IndexDescriptor reference) {
        Object object;
        block7: {
            try {
                InternalIndexState internalIndexState = this.tc.schemaRead().indexGetStateNonLocking(reference);
                if (InternalIndexState.ONLINE.equals(internalIndexState) && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()))) {
                    CanGetValue$ valueCapability;
                    IndexDescriptor.EntityType$.Node node;
                    int tokenId = reference.schema().getEntityTokenIds()[0];
                    EntityType entityType = reference.schema().entityType();
                    if (EntityType.NODE.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Node(new LabelId(tokenId));
                    } else if (EntityType.RELATIONSHIP.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Relationship(new RelTypeId(tokenId));
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    IndexDescriptor.EntityType$.Node entityType2 = node;
                    PropertyKeyId[] properties = (PropertyKeyId[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()), (Function1)PropertyKeyId$.MODULE$, ClassTag$.MODULE$.apply(PropertyKeyId.class));
                    boolean isUnique = reference.isUnique();
                    Set behaviours = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])reference.getCapability().behaviours()), (Function1 & Serializable)behaviour -> this.kernelToCypher((IndexBehaviour)behaviour), ClassTag$.MODULE$.apply(org.neo4j.cypher.internal.planner.spi.IndexBehaviour.class))).toSet();
                    IndexOrderCapability.BOTH$ orderCapability = reference.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
                    Object object2 = valueCapability = reference.getCapability().supportsReturningValues() ? CanGetValue$.MODULE$ : DoNotGetValue$.MODULE$;
                    object = behaviours.contains((Object)EventuallyConsistent$.MODULE$) ? None$.MODULE$ : (isUnique && this.tc.schemaRead().indexGetOwningUniquenessConstraintIdNonLocking(reference) == null ? None$.MODULE$ : this.kernelToCypher(reference.getIndexType()).map(arg_0 -> TransactionBoundPlanContext.$anonfun$getOnlineIndex$2((Product)entityType2, properties, behaviours, (Product)orderCapability, (Product)valueCapability, reference, isUnique, arg_0)));
                    break block7;
                }
                object = None$.MODULE$;
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                object = None$.MODULE$;
            }
        }
        return object;
    }

    private Option<TokenIndexDescriptor> getTokenIndexDescriptor(java.util.Iterator<IndexDescriptor> indexes) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(indexes).asScala().nextOption().map((Function1 & Serializable)kernelIndexDescriptor -> {
            EntityType typ = kernelIndexDescriptor.schema().entityType();
            IndexOrderCapability.BOTH$ orderCapability = kernelIndexDescriptor.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
            return new TokenIndexDescriptor(typ, (IndexOrderCapability)orderCapability);
        });
    }

    public Option<TokenIndexDescriptor> nodeTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR));
    }

    public Option<TokenIndexDescriptor> relationshipTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR));
    }

    public boolean hasNodePropertyExistenceConstraint(String labelName, String propertyKey) {
        boolean bl;
        try {
            int labelId = this.getLabelId(labelName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getNodePropertiesWithExistenceConstraint(String labelName) {
        Set<String> set;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    private Set<String> getPropertiesFromExistenceConstraints(Iterator<ConstraintDescriptor> constraints) {
        Iterator existsConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence()));
        Set distinctPropertyIds = existsConstraints.flatMap((Function1 & Serializable)x$7 -> Predef$.MODULE$.wrapIntArray(x$7.schema().getPropertyIds())).toSet();
        return (Set)distinctPropertyIds.map((Function1 & Serializable)id -> TransactionBoundPlanContext.$anonfun$getPropertiesFromExistenceConstraints$3(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public boolean hasRelationshipPropertyExistenceConstraint(String relTypeName, String propertyKey) {
        boolean bl;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getRelationshipPropertiesWithExistenceConstraint(String relTypeName) {
        Set<String> set;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public Set<String> getPropertiesWithExistenceConstraint() {
        Set<String> set;
        try {
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetAllNonLocking()).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public boolean hasNodePropertyTypeConstraint(String labelName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getNodePropertiesWithTypeConstraint(labelName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getNodePropertiesWithTypeConstraint(String labelName) {
        Map map;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$8 -> x$8.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public boolean hasRelationshipPropertyTypeConstraint(String relTypeName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getRelationshipPropertiesWithTypeConstraint(relTypeName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getRelationshipPropertiesWithTypeConstraint(String relTypeName) {
        Map map;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$9 -> x$9.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public InstrumentedGraphStatistics statistics() {
        return this.statistics;
    }

    public LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ProcedureSignature procedureSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.procedureSignature(this.tc.kernelTransaction(), name, this.cypherVersion);
    }

    public Option<UserFunctionSignature> functionSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.functionSignature(this.tc.kernelTransaction(), name, this.cypherVersion);
    }

    public InternalNotificationLogger notificationLogger() {
        return this.logger;
    }

    public boolean txStateHasChanges() {
        return this.tc.dataRead().transactionStateHasChanges();
    }

    public long procedureSignatureVersion() {
        return this.tc.procedures().signatureVersion();
    }

    public PlanContext withNotificationLogger(InternalNotificationLogger notificationLogger) {
        return new TransactionBoundPlanContext(this.tc, notificationLogger, this.graphStatistics, this.cypherVersion);
    }

    public Enumeration.Value databaseMode() {
        TransactionalContext.DatabaseMode databaseMode = this.tc.kernelTransactionalContext().databaseMode();
        if (TransactionalContext.DatabaseMode.SINGLE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SINGLE();
        }
        if (TransactionalContext.DatabaseMode.COMPOSITE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.COMPOSITE();
        }
        if (TransactionalContext.DatabaseMode.SHARDED.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SHARDED();
        }
        throw new MatchError((Object)databaseMode);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$1(IndexType it$1, IndexDescriptor x$2) {
        IndexType indexType = x$2.getIndexType();
        IndexType indexType2 = it$1;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$2(IndexDescriptor x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$1(IndexType it$2, IndexDescriptor x$4) {
        IndexType indexType = x$4.getIndexType();
        IndexType indexType2 = it$2;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$2(IndexDescriptor x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexGetForSchemaDescriptor$1(IndexType indexType$3, IndexDescriptor x$6) {
        IndexType indexType = x$6.getIndexType();
        IndexType indexType2 = indexType$3;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ org.neo4j.cypher.internal.planner.spi.IndexDescriptor $anonfun$getOnlineIndex$2(Product entityType$1, PropertyKeyId[] properties$1, Set behaviours$1, Product orderCapability$1, Product valueCapability$1, IndexDescriptor reference$1, boolean isUnique$1, IndexDescriptor.IndexType indexType) {
        return new org.neo4j.cypher.internal.planner.spi.IndexDescriptor(indexType, (IndexDescriptor.EntityType)entityType$1, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)properties$1), behaviours$1, (IndexOrderCapability)orderCapability$1, (GetValueFromIndexBehavior)valueCapability$1, (Option)new Some((Object)reference$1.getCapability()), isUnique$1);
    }

    public static final /* synthetic */ String $anonfun$getPropertiesFromExistenceConstraints$3(TransactionBoundPlanContext $this, int id) {
        return $this.tc.tokenRead().propertyKeyName(id);
    }

    public TransactionBoundPlanContext(TransactionalContextWrapper tc, InternalNotificationLogger logger, InstrumentedGraphStatistics graphStatistics, CypherVersion cypherVersion) {
        this.tc = tc;
        this.logger = logger;
        this.graphStatistics = graphStatistics;
        this.cypherVersion = cypherVersion;
        super((QueryTransactionalContext)tc);
        IndexDescriptorCompatibility.$init$(this);
        this.statistics = graphStatistics;
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(tc.graph());
    }
}

