/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.optionsmap;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.cypher.internal.optionsmap.OptionsConverter;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015ca\u0002\u0006\f!\u0003\r\tA\u0006\u0005\u0006[\u0001!\tA\f\u0005\u0006e\u00011\tb\r\u0005\u0006u\u0001!\tb\u000f\u0005\u0006Q\u00021\t\"\u001b\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\ti\u0001\u0001C\t\u0003\u001fAq!a\n\u0001\t#\tI\u0003C\u0004\u00022\u0001!\t\"a\r\t\u000f\u0005m\u0002\u0001\"\u0005\u0002>\t)\u0012J\u001c3fq>\u0003H/[8og\u000e{gN^3si\u0016\u0014(B\u0001\u0007\u000e\u0003)y\u0007\u000f^5p]Nl\u0017\r\u001d\u0006\u0003\u001d=\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003!E\taaY=qQ\u0016\u0014(B\u0001\n\u0014\u0003\u0015qWm\u001c\u001bk\u0015\u0005!\u0012aA8sO\u000e\u0001QCA\f%'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0007}\u0001#%D\u0001\f\u0013\t\t3B\u0001\tPaRLwN\\:D_:4XM\u001d;feB\u00111\u0005\n\u0007\u0001\t\u0015)\u0003A1\u0001'\u0005\u0005!\u0016CA\u0014+!\tI\u0002&\u0003\u0002*5\t9aj\u001c;iS:<\u0007CA\r,\u0013\ta#DA\u0002B]f\fa\u0001J5oSR$C#A\u0018\u0011\u0005e\u0001\u0014BA\u0019\u001b\u0005\u0011)f.\u001b;\u0002\u000f\r|g\u000e^3yiV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\u001b\u00059!/\u001e8uS6,\u0017BA\u001d7\u00051\tV/\u001a:z\u0007>tG/\u001a=u\u0003=9W\r^(qi&|gn\u001d)beR\u001cH\u0003\u0002\u001fM-\u000e\u0004B!G\u001f@\u0013&\u0011aH\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007e\u0001%)\u0003\u0002B5\t1q\n\u001d;j_:\u0004\"aQ$\u000e\u0003\u0011S!!\u0012$\u0002\rM\u001c\u0007.Z7b\u0015\tq\u0011#\u0003\u0002I\t\n9\u0012J\u001c3fqB\u0013xN^5eKJ$Um]2sSB$xN\u001d\t\u0003\u0007*K!a\u0013#\u0003\u0017%sG-\u001a=D_:4\u0017n\u001a\u0005\u0006\u001b\u000e\u0001\rAT\u0001\b_B$\u0018n\u001c8t!\tyE+D\u0001Q\u0015\t\t&+A\u0004wSJ$X/\u00197\u000b\u0005M\u000b\u0012A\u0002<bYV,7/\u0003\u0002V!\nAQ*\u00199WC2,X\rC\u0003X\u0007\u0001\u0007\u0001,\u0001\u0006tG\",W.\u0019+za\u0016\u0004\"!\u00171\u000f\u0005is\u0006CA.\u001b\u001b\u0005a&BA/\u0016\u0003\u0019a$o\\8u}%\u0011qLG\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`5!)Am\u0001a\u0001K\u0006I\u0011N\u001c3fqRK\b/\u001a\t\u0003\u0007\u001aL!a\u001a#\u0003\u0013%sG-\u001a=UsB,\u0017!H1tg\u0016\u0014HOV1mS\u0012\fe\u000e\u001a+sC:\u001chm\u001c:n\u0007>tg-[4\u0015\t)Dhp \t\u0005WBD&/D\u0001m\u0015\tig.\u0001\u0003vi&d'\"A8\u0002\t)\fg/Y\u0005\u0003c2\u00141!T1q!\t\u0019h/D\u0001u\u0015\t)h.\u0001\u0003mC:<\u0017BA<u\u0005\u0019y%M[3di\")\u0011\u0010\u0002a\u0001u\u000611m\u001c8gS\u001e\u0004\"a\u001f?\u000e\u0003IK!! *\u0003\u0011\u0005s\u0017PV1mk\u0016DQa\u0016\u0003A\u0002aCa!!\u0001\u0005\u0001\u0004y\u0014!D5oI\u0016D\bK]8wS\u0012,'/\u0001\rbgN,'\u000f\u001e,bY&$\u0017J\u001c3fqB\u0013xN^5eKJ$rAQA\u0004\u0003\u0013\tY\u0001\u0003\u0004\u0002\u0002\u0015\u0001\rA\u001f\u0005\u0006/\u0016\u0001\r\u0001\u0017\u0005\u0006I\u0016\u0001\r!Z\u0001\u001aG\",7m\u001b$peB{\u0017N\u001c;D_:4\u0017n\u001a,bYV,7\u000fF\u00040\u0003#\t\t#!\n\t\u000f\u0005Ma\u00011\u0001\u0002\u0016\u0005\u0011\u0001\u000f\u001d\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004*\u0002\u000bU$\u0018\u000e\\:\n\t\u0005}\u0011\u0011\u0004\u0002\u000e!J,G\u000f^=Qe&tG/\u001a:\t\r\u0005\rb\u00011\u0001O\u0003!IG/Z7t\u001b\u0006\u0004\b\"B,\u0007\u0001\u0004A\u0016\u0001H2iK\u000e\\gi\u001c:Gk2dG/\u001a=u\u0007>tg-[4WC2,Xm\u001d\u000b\b_\u0005-\u0012QFA\u0018\u0011\u001d\t\u0019b\u0002a\u0001\u0003+Aa!a\t\b\u0001\u0004q\u0005\"B,\b\u0001\u0004A\u0016AG2iK\u000e\\gi\u001c:WK\u000e$xN]\"p]\u001aLwMV1mk\u0016\u001cHcB\u0018\u00026\u0005]\u0012\u0011\b\u0005\b\u0003'A\u0001\u0019AA\u000b\u0011\u0019\t\u0019\u0003\u0003a\u0001\u001d\")q\u000b\u0003a\u00011\u0006\t\u0012m]:feR,U\u000e\u001d;z\u0007>tg-[4\u0015\u000f)\fy$!\u0011\u0002D!)\u00110\u0003a\u0001u\")q+\u0003a\u00011\")A-\u0003a\u00011\u0002")
public interface IndexOptionsConverter<T>
extends OptionsConverter<T> {
    public QueryContext context();

    public static /* synthetic */ Tuple2 getOptionsParts$(IndexOptionsConverter $this, MapValue options, String schemaType, IndexType indexType) {
        return $this.getOptionsParts(options, schemaType, indexType);
    }

    default public Tuple2<Option<IndexProviderDescriptor>, IndexConfig> getOptionsParts(MapValue options, String schemaType, IndexType indexType) {
        if (MapValueOps$.MODULE$.Ops(options).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexOptionsConverter.$anonfun$getOptionsParts$1(x0$1)))) {
            throw new InvalidArgumentsException("Failed to create " + schemaType + ": Invalid option provided, valid options are `indexProvider` and `indexConfig`.");
        }
        Option<AnyValue> maybeIndexProvider = MapValueOps$.MODULE$.Ops(options).getOption("indexprovider");
        Option<AnyValue> maybeConfig = MapValueOps$.MODULE$.Ops(options).getOption("indexconfig");
        Option indexProvider = maybeIndexProvider.map((Function1 & Serializable)x$1 -> this.assertValidIndexProvider((AnyValue)x$1, schemaType, indexType));
        Map configMap = (Map)maybeConfig.map((Function1 & Serializable)x$2 -> this.assertValidAndTransformConfig((AnyValue)x$2, schemaType, (Option<IndexProviderDescriptor>)indexProvider)).getOrElse((Function0 & Serializable)() -> Collections.emptyMap());
        IndexConfig indexConfig = IndexSettingUtil.toIndexConfigFromStringObjectMap((Map)configMap);
        return new Tuple2((Object)indexProvider, (Object)indexConfig);
    }

    public Map<String, Object> assertValidAndTransformConfig(AnyValue var1, String var2, Option<IndexProviderDescriptor> var3);

    private IndexProviderDescriptor assertValidIndexProvider(AnyValue indexProvider, String schemaType, IndexType indexType) {
        AnyValue anyValue = indexProvider;
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            return this.context().validateIndexProvider(schemaType, textValue.stringValue(), indexType);
        }
        throw new InvalidArgumentsException("Could not create " + schemaType + " with specified index provider '" + indexProvider + "'. Expected String value.");
    }

    public static /* synthetic */ void checkForPointConfigValues$(IndexOptionsConverter $this, PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        $this.checkForPointConfigValues(pp, itemsMap, schemaType);
    }

    default public void checkForPointConfigValues(PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        if (MapValueOps$.MODULE$.Ops(itemsMap).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexOptionsConverter.$anonfun$checkForPointConfigValues$1(x0$1)))) {
            itemsMap.writeTo((AnyValueWriter)pp);
            throw new InvalidArgumentsException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not create " + schemaType + " with specified index config '" + pp.value() + "', contains spatial config settings options.\n           |To create point index, please use 'CREATE POINT INDEX ...'.")));
        }
    }

    public static /* synthetic */ void checkForFulltextConfigValues$(IndexOptionsConverter $this, PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        $this.checkForFulltextConfigValues(pp, itemsMap, schemaType);
    }

    default public void checkForFulltextConfigValues(PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        if (MapValueOps$.MODULE$.Ops(itemsMap).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexOptionsConverter.$anonfun$checkForFulltextConfigValues$1(x0$1)))) {
            itemsMap.writeTo((AnyValueWriter)pp);
            throw new InvalidArgumentsException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not create " + schemaType + " with specified index config '" + pp.value() + "', contains fulltext config options.\n           |To create fulltext index, please use 'CREATE FULLTEXT INDEX ...'.")));
        }
    }

    public static /* synthetic */ void checkForVectorConfigValues$(IndexOptionsConverter $this, PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        $this.checkForVectorConfigValues(pp, itemsMap, schemaType);
    }

    default public void checkForVectorConfigValues(PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        if (MapValueOps$.MODULE$.Ops(itemsMap).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexOptionsConverter.$anonfun$checkForVectorConfigValues$1(x0$1)))) {
            itemsMap.writeTo((AnyValueWriter)pp);
            throw new InvalidArgumentsException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not create " + schemaType + " with specified index config '" + pp.value() + "', contains vector config options.\n           |To create vector index, please use 'CREATE VECTOR INDEX ...'.")));
        }
    }

    public static /* synthetic */ Map assertEmptyConfig$(IndexOptionsConverter $this, AnyValue config, String schemaType, String indexType) {
        return $this.assertEmptyConfig(config, schemaType, indexType);
    }

    default public Map<String, Object> assertEmptyConfig(AnyValue config, String schemaType, String indexType) {
        PrettyPrinter pp = new PrettyPrinter();
        AnyValue anyValue = config;
        if (anyValue instanceof MapValue) {
            MapValue mapValue = (MapValue)anyValue;
            this.checkForFulltextConfigValues(pp, mapValue, schemaType);
            this.checkForPointConfigValues(pp, mapValue, schemaType);
            this.checkForVectorConfigValues(pp, mapValue, schemaType);
            if (!mapValue.isEmpty()) {
                mapValue.writeTo((AnyValueWriter)pp);
                throw new InvalidArgumentsException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not create " + schemaType + " with specified index config '" + pp.value() + "': " + indexType + " indexes have no valid config values.")));
            }
            return Collections.emptyMap();
        }
        anyValue.writeTo((AnyValueWriter)pp);
        throw new InvalidArgumentsException("Could not create " + schemaType + " with specified index config '" + pp.value() + "'. Expected a map.");
    }

    public static /* synthetic */ boolean $anonfun$getOptionsParts$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !k.equalsIgnoreCase("indexProvider") && !k.equalsIgnoreCase("indexConfig");
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$checkForPointConfigValues$1(Tuple2 x0$1) {
        String p;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (p = (String)tuple2._1()) != null) {
            String string = p;
            return string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_3D_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_3D_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_3D_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_3D_MAX.getSettingName());
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$checkForFulltextConfigValues$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String p = (String)tuple2._1();
            return p.equalsIgnoreCase(IndexSettingImpl.FULLTEXT_ANALYZER.getSettingName()) || p.equalsIgnoreCase(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT.getSettingName());
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$checkForVectorConfigValues$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String p = (String)tuple2._1();
            return p.equalsIgnoreCase(IndexSettingImpl.VECTOR_DIMENSIONS.getSettingName()) || p.equalsIgnoreCase(IndexSettingImpl.VECTOR_SIMILARITY_FUNCTION.getSettingName());
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(IndexOptionsConverter $this) {
    }
}

