/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExecutionPlanWithNotifications;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.UnknownRuntime;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.options.CypherRuntimeOption$default$;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.RuntimeUnsupportedException;
import org.neo4j.notifications.RuntimeUnsupportedNotification;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0003\u0006\u0001'!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015\u0011\u0006\u0001\"\u0003T\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015)\u0007\u0001\"\u0003g\u0005=1\u0015\r\u001c7cC\u000e\\'+\u001e8uS6,'BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001U\u0011A#I\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\rE\u0002\u001d;}i\u0011AC\u0005\u0003=)\u0011QbQ=qQ\u0016\u0014(+\u001e8uS6,\u0007C\u0001\u0011\"\u0019\u0001!QA\t\u0001C\u0002\r\u0012qaQ(O)\u0016CF+\u0005\u0002%OA\u0011a#J\u0005\u0003M]\u0011qAT8uQ&tw\r\u0005\u0002\u001dQ%\u0011\u0011F\u0003\u0002\u000f%VtG/[7f\u0007>tG/\u001a=u\u0003!\u0011XO\u001c;j[\u0016\u001c\bc\u0001\u0017579\u0011QF\r\b\u0003]Ej\u0011a\f\u0006\u0003aI\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u0005M:\u0012a\u00029bG.\fw-Z\u0005\u0003kY\u0012!\"\u00138eKb,GmU3r\u0015\t\u0019t#\u0001\tsKF,Xm\u001d;fIJ+h\u000e^5nKB\u0011\u0011\bP\u0007\u0002u)\u00111HC\u0001\b_B$\u0018n\u001c8t\u0013\ti$HA\nDsBDWM\u001d*v]RLW.Z(qi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004\u0001\u0006\u0013\u0005c\u0001\u000f\u0001?!)!f\u0001a\u0001W!)qg\u0001a\u0001q\u0005!a.Y7f+\u0005)\u0005C\u0001$K\u001d\t9\u0005\n\u0005\u0002//%\u0011\u0011jF\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002J/\u0005Q2m\u001c:sKN\u0004xN\u001c3j]\u001e\u0014VO\u001c;j[\u0016|\u0005\u000f^5p]V\tq\nE\u0002\u0017!bJ!!U\f\u0003\r=\u0003H/[8o\u0003M\u0001XO\u00197jG\u000e\u000bgN\\8u\u0007>l\u0007/\u001b7f)\t!C\u000bC\u0003V\r\u0001\u0007a+A\tpe&<\u0017N\\1m\u000bb\u001cW\r\u001d;j_:\u0004\"\u0001L,\n\u0005a3$!C#yG\u0016\u0004H/[8o\u0003M\u0019w.\u001c9jY\u0016$v.\u0012=fGV$\u0018M\u00197f)\rYfl\u0019\t\u00039qK!!\u0018\u0006\u0003\u001b\u0015CXmY;uS>t\u0007\u000b\\1o\u0011\u0015yv\u00011\u0001a\u00031awnZ5dC2\fV/\u001a:z!\ta\u0012-\u0003\u0002c\u0015\taAj\\4jG\u0006d\u0017+^3ss\")Am\u0002a\u0001?\u000591m\u001c8uKb$\u0018a\u0003:v]RLW.Z\"p]\u001a$\"!R4\t\u000b!D\u0001\u0019A\u000e\u0002\u000fI,h\u000e^5nK\u0002")
public class FallbackRuntime<CONTEXT extends RuntimeContext>
implements CypherRuntime<CONTEXT> {
    private final IndexedSeq<CypherRuntime<CONTEXT>> runtimes;
    private final CypherRuntimeOption requestedRuntime;

    @Override
    public String name() {
        return "fallback";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return this.runtimes.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends CypherRuntime<CONTEXT>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.correspondingRuntimeOption().isDefined()) {
                    return (B1)A1.correspondingRuntimeOption().get();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CypherRuntime<CONTEXT> x1) {
                CypherRuntime<CONTEXT> cypherRuntime = x1;
                return cypherRuntime.correspondingRuntimeOption().isDefined();
            }
        });
    }

    private Nothing$ publicCannotCompile(Exception originalException) {
        throw new RuntimeUnsupportedException(originalException.getMessage(), (Throwable)originalException);
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery logicalQuery, CONTEXT context) {
        RecordingNotificationLogger logger = new RecordingNotificationLogger();
        Tuple2 failedAttempt = null;
        Throwable lastException = null;
        for (int i = 0; i < this.runtimes.length(); ++i) {
            CypherRuntime runtime = (CypherRuntime)this.runtimes.apply(i);
            if (failedAttempt != null) {
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$)) {
                    Tuple2 tuple2 = failedAttempt;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    CypherRuntime failingRuntime = (CypherRuntime)tuple2._1();
                    String message = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)failingRuntime, (Object)message);
                    CypherRuntime failingRuntime2 = (CypherRuntime)tuple22._1();
                    String message2 = (String)tuple22._2();
                    logger.log((InternalNotification)new RuntimeUnsupportedNotification(this.runtimeConf(failingRuntime2), this.runtimeConf(runtime), message2));
                    failedAttempt = null;
                }
            }
            try {
                ExecutionPlan plan = runtime.compileToExecutable(logicalQuery, context);
                Set notifications = logger.notifications();
                ExecutionPlan notifiedPlan = notifications.isEmpty() ? plan : new ExecutionPlanWithNotifications(plan, (Set<InternalNotification>)notifications);
                return notifiedPlan;
            }
            catch (CantCompileQueryException e) {
                lastException = e;
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (!(cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$))) continue;
                CypherRuntimeOption cypherRuntimeOption = this.requestedRuntime;
                CypherRuntimeOption$default$ cypherRuntimeOption$default$ = CypherRuntimeOption$default$.MODULE$;
                if (!(cypherRuntimeOption == null ? cypherRuntimeOption$default$ != null : !cypherRuntimeOption.equals(cypherRuntimeOption$default$)) || i >= this.runtimes.length() - 1) continue;
                failedAttempt = new Tuple2((Object)runtime, (Object)e.getMessage());
                continue;
            }
            catch (RuntimeUnsupportedException e) {
                throw e;
            }
            catch (Exception e) {
                lastException = e;
                ((RuntimeContext)context).log().debug("Runtime " + runtime.getClass().getSimpleName() + " failed to compile query " + logicalQuery.queryText(), (Throwable)e);
            }
        }
        Throwable throwable = lastException;
        if (throwable instanceof CantCompileQueryException) {
            CantCompileQueryException cantCompileQueryException = (CantCompileQueryException)throwable;
            throw this.publicCannotCompile((Exception)((Object)cantCompileQueryException));
        }
        throw throwable;
    }

    private String runtimeConf(CypherRuntime<CONTEXT> runtime) {
        CypherRuntime cypherRuntime = runtime;
        if (cypherRuntime instanceof UnknownRuntime) {
            UnknownRuntime unknownRuntime = (UnknownRuntime)cypherRuntime;
            String requestedRuntime = unknownRuntime.requestedRuntime();
            return "runtime=" + requestedRuntime;
        }
        return (String)runtime.correspondingRuntimeOption().map((Function1 & Serializable)x$2 -> x$2.renderExplicit()).getOrElse((Function0 & Serializable)() -> "runtime=" + runtime.name());
    }

    public FallbackRuntime(IndexedSeq<CypherRuntime<CONTEXT>> runtimes, CypherRuntimeOption requestedRuntime) {
        this.runtimes = runtimes;
        this.requestedRuntime = requestedRuntime;
    }
}

