/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.values.virtual.MapValue;

public class MultiVersionExecutionEngine
extends ExecutionEngine {
    private final int maxQueryExecutionAttempts;

    public MultiVersionExecutionEngine(GraphDatabaseQueryService queryService, Config config, CypherQueryCaches queryCaches, InternalLogProvider logProvider, CompilerFactory compilerFactory) {
        super(queryService, queryCaches, logProvider, compilerFactory);
        this.maxQueryExecutionAttempts = (Integer)config.get(GraphDatabaseInternalSettings.snapshot_query_retries);
    }

    @Override
    public QueryExecution executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        return this.executeWithRetry(context, () -> super.executeQuery(query, parameters, context, prePopulate, subscriber));
    }

    @Override
    public QueryExecution executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) throws QueryExecutionKernelException {
        return this.executeWithRetry(context, () -> super.executeQuery(query, parameters, context, prePopulate, subscriber, monitor));
    }

    @Override
    public QueryExecution executeQuery(FullyParsedQuery query, MapValue parameters, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        return this.executeWithRetry(context, () -> super.executeQuery(query, parameters, context, prePopulate, input, queryMonitor, subscriber));
    }

    private QueryExecution executeWithRetry(TransactionalContext context, QueryExecutor executor) throws QueryExecutionKernelException {
        QueryExecution result;
        TxStateHolder txStateHolder;
        KernelTransaction kernelTransaction = context.kernelTransaction();
        if (kernelTransaction.aquireStatementCounter() > 1) {
            return executor.execute();
        }
        int attempts = 0;
        VersionContext versionContext = MultiVersionExecutionEngine.getCursorContext(context);
        do {
            if (attempts > 0) {
                kernelTransaction.releaseStorageEngineResources();
                ((TxStateHolder)kernelTransaction).txState().reset();
                context.executingQuery().onRetryAttempted();
                versionContext.initRead();
                versionContext.resetObsoleteHeadState();
            }
            result = executor.execute();
        } while (kernelTransaction instanceof TxStateHolder && (txStateHolder = (TxStateHolder)kernelTransaction).hasTxStateWithChanges() && !versionContext.initializedForWrite() && versionContext.invisibleHeadObserved() && attempts++ < this.maxQueryExecutionAttempts);
        return result;
    }

    private static VersionContext getCursorContext(TransactionalContext context) {
        return context.kernelTransaction().cursorContext().getVersionContext();
    }

    @FunctionalInterface
    private static interface QueryExecutor {
        public QueryExecution execute() throws QueryExecutionKernelException;
    }
}

