/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.UserFunctionSignature;
import org.neo4j.cypher.internal.logical.plans.CanGetValue$;
import org.neo4j.cypher.internal.logical.plans.DoNotGetValue$;
import org.neo4j.cypher.internal.logical.plans.GetValueFromIndexBehavior;
import org.neo4j.cypher.internal.planner.spi.EventuallyConsistent$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexOrderCapability;
import org.neo4j.cypher.internal.planner.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.TokenIndexDescriptor;
import org.neo4j.cypher.internal.runtime.QueryTransactionalContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionalContextWrapper;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundPlanContext$;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.PropertyKeyId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.logging.InternalLog;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r5s!B\u001f?\u0011\u0003Ie!B&?\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006\"B+\u0002\t\u00031\u0006b\u0002Bl\u0003\u0011\u00051q\u0006\u0005\b\u0005k\fA\u0011AB$\r\u0011Ye\b\u0001-\t\u0011-4!\u0011!Q\u0001\n1D\u0001b\u001c\u0004\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tm\u001a\u0011\t\u0011)A\u0005o\")1K\u0002C\u0001u\")aP\u0002C!\u007f\"9\u0011\u0011\u0006\u0004\u0005B\u0005-\u0002bBA\u0019\r\u0011\u0005\u00131\u0007\u0005\b\u0003o1A\u0011IA\u001d\u0011\u001d\tiD\u0002C!\u0003\u007fAq!a\u0011\u0007\t\u0003\n)\u0005C\u0004\u0002J\u0019!I!a\u0013\t\u000f\u0005\u001dd\u0001\"\u0003\u0002j!9\u0011q\u000e\u0004\u0005B\u0005E\u0004bBA:\r\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u007f2A\u0011IAA\u0011\u001d\t)I\u0002C!\u0003\u000fCq!!+\u0007\t\u0003\nY\u000bC\u0004\u00022\u001a!\t%a-\t\u000f\u0005ef\u0001\"\u0011\u0002<\"9\u00111\u0019\u0004\u0005B\u0005\u0015\u0007bBAf\r\u0011\u0005\u0013Q\u001a\u0005\b\u0003'4A\u0011BAk\u0011\u001d\tiN\u0002C\u0005\u0003?Dq!a:\u0007\t\u0013\tI\u000fC\u0004\u0002z\u001a!\t%a?\t\u000f\t\ra\u0001\"\u0011\u0003\u0006!9!1\u0002\u0004\u0005B\t5\u0001b\u0002B\n\r\u0011\u0005#Q\u0003\u0005\b\u000571A\u0011\tB\u000f\u0011\u001d\u0011\u0019C\u0002C!\u0005KAqAa\u000b\u0007\t\u0013\u0011i\u0003C\u0004\u00038\u0019!IA!\u000f\t\u000f\tMc\u0001\"\u0011\u0003V!9!q\u000b\u0004\u0005B\tU\u0003b\u0002B-\r\u0011\u0005#1\f\u0005\b\u0005C2A\u0011\tB2\u0011\u001d\u0011iG\u0002C\u0005\u0005_BqA! \u0007\t\u0003\u0012y\bC\u0004\u0003\u0006\u001a!\tEa\"\t\u000f\t-e\u0001\"\u0011\u0003\u000e\"9!q\u0012\u0004\u0005B\tE\u0005b\u0002BS\r\u0011\u0005#q\u0015\u0005\b\u0005g3A\u0011\tB[\u0011\u001d\u0011iL\u0002C!\u0005\u007fC\u0011Ba1\u0007\u0005\u0004%\tE!2\t\u000f\t\u001dg\u0001)A\u0005o\"I!\u0011\u001a\u0004C\u0002\u0013\u0005#1\u001a\u0005\t\u0005+4\u0001\u0015!\u0003\u0003N\"9!q\u001b\u0004\u0005B\te\u0007b\u0002B{\r\u0011\u0005#q\u001f\u0005\b\u0007\u00071A\u0011IB\u0003\u0011\u001d\u00199A\u0002C!\u0007\u0013Aqaa\u0003\u0007\t\u0003\u001ai\u0001C\u0004\u0004\u0016\u0019!\tea\u0006\u00027Q\u0013\u0018M\\:bGRLwN\u001c\"pk:$\u0007\u000b\\1o\u0007>tG/\u001a=u\u0015\ty\u0004)A\u0002ta&T!!\u0011\"\u0002\u0011%tG/\u001a:oC2T!a\u0011#\u0002\r\rL\b\u000f[3s\u0015\t)e)A\u0003oK>$$NC\u0001H\u0003\ry'oZ\u0002\u0001!\tQ\u0015!D\u0001?\u0005m!&/\u00198tC\u000e$\u0018n\u001c8C_VtG\r\u00157b]\u000e{g\u000e^3yiN\u0011\u0011!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0015!B1qa2LHcB,\u0004\u001c\ru1q\u0004\t\u0003\u0015\u001a\u0019BAB-bQB\u0011!lX\u0007\u00027*\u0011A,X\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002_\u0001\u00069!/\u001e8uS6,\u0017B\u00011\\\u0005\u0001\"&/\u00198tC\u000e$\u0018n\u001c8C_VtGMU3bIR{7.\u001a8D_:$X\r\u001f;\u0011\u0005\t4W\"A2\u000b\u0005}\"'BA3A\u0003\u001d\u0001H.\u00198oKJL!aZ2\u0003\u0017Ac\u0017M\\\"p]R,\u0007\u0010\u001e\t\u0003\u0015&L!A\u001b \u00039%sG-\u001a=EKN\u001c'/\u001b9u_J\u001cu.\u001c9bi&\u0014\u0017\u000e\\5us\u0006\u0011Ao\u0019\t\u000356L!A\\.\u00037Q\u0013\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u/J\f\u0007\u000f]3s\u0003\u0019awnZ4feB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fQ\u0001\u0005kRLG.\u0003\u0002ve\nQ\u0012J\u001c;fe:\fGNT8uS\u001aL7-\u0019;j_:dunZ4fe\u0006yqM]1qQN#\u0018\r^5ti&\u001c7\u000f\u0005\u0002cq&\u0011\u0011p\u0019\u0002\u001c\u0013:\u001cHO];nK:$X\rZ$sCBD7\u000b^1uSN$\u0018nY:\u0015\t][H0 \u0005\u0006W*\u0001\r\u0001\u001c\u0005\u0006_*\u0001\r\u0001\u001d\u0005\u0006m*\u0001\ra^\u0001\u0018e\u0006tw-Z%oI\u0016DXm]$fi\u001a{'\u000fT1cK2$B!!\u0001\u0002 A1\u00111AA\n\u00033qA!!\u0002\u0002\u00109!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f!\u000ba\u0001\u0010:p_Rt\u0014\"\u0001)\n\u0007\u0005Eq*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0011q\u0003\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011\u0011C(\u0011\u0007\t\fY\"C\u0002\u0002\u001e\r\u0014q\"\u00138eKb$Um]2sSB$xN\u001d\u0005\b\u0003CY\u0001\u0019AA\u0012\u0003\u001da\u0017MY3m\u0013\u0012\u00042ATA\u0013\u0013\r\t9c\u0014\u0002\u0004\u0013:$\u0018!\u0007:b]\u001e,\u0017J\u001c3fq\u0016\u001cx)\u001a;G_J\u0014V\r\u001c+za\u0016$B!!\u0001\u0002.!9\u0011q\u0006\u0007A\u0002\u0005\r\u0012!\u0003:fYRK\b/Z%e\u0003Y!X\r\u001f;J]\u0012,\u00070Z:HKR4uN\u001d'bE\u0016dG\u0003BA\u0001\u0003kAq!!\t\u000e\u0001\u0004\t\u0019#\u0001\ruKb$\u0018J\u001c3fq\u0016\u001cx)\u001a;G_J\u0014V\r\u001c+za\u0016$B!!\u0001\u0002<!9\u0011q\u0006\bA\u0002\u0005\r\u0012a\u00069pS:$\u0018J\u001c3fq\u0016\u001cx)\u001a;G_Jd\u0015MY3m)\u0011\t\t!!\u0011\t\u000f\u0005\u0005r\u00021\u0001\u0002$\u0005I\u0002o\\5oi&sG-\u001a=fg\u001e+GOR8s%\u0016dG+\u001f9f)\u0011\t\t!a\u0012\t\u000f\u0005=\u0002\u00031\u0001\u0002$\u0005\u0011\u0012N\u001c3fq\u0016\u001cx)\u001a;G_Jd\u0015MY3m)\u0019\t\t!!\u0014\u0002P!9\u0011\u0011E\tA\u0002\u0005\r\u0002bBA)#\u0001\u0007\u00111K\u0001\nS:$W\r\u001f+za\u0016\u0004RATA+\u00033J1!a\u0016P\u0005\u0019y\u0005\u000f^5p]B!\u00111LA2\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014AB:dQ\u0016l\u0017M\u0003\u0002B\t&!\u0011QMA/\u0005%Ie\u000eZ3y)f\u0004X-\u0001\u000bj]\u0012,\u00070Z:HKR4uN\u001d*fYRK\b/\u001a\u000b\u0007\u0003\u0003\tY'!\u001c\t\u000f\u0005=\"\u00031\u0001\u0002$!9\u0011\u0011\u000b\nA\u0002\u0005M\u0013!\u00069s_B,'\u000f^=J]\u0012,\u00070Z:HKR\fE\u000e\u001c\u000b\u0003\u0003\u0003\t1#\u001b8eKb,\u00050[:ug\u001a{'\u000fT1cK2$B!a\u001e\u0002~A\u0019a*!\u001f\n\u0007\u0005mtJA\u0004C_>dW-\u00198\t\u000f\u0005\u0005B\u00031\u0001\u0002$\u0005)\u0012N\u001c3fq\u0016C\u0018n\u001d;t\r>\u0014(+\u001a7UsB,G\u0003BA<\u0003\u0007Cq!a\f\u0016\u0001\u0004\t\u0019#A\u0011uKb$\u0018J\u001c3fq\u001e+GOR8s\u0019\u0006\u0014W\r\\!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\n\u0006-\u0015q\u0014\t\u0006\u001d\u0006U\u0013\u0011\u0004\u0005\b\u0003\u001b3\u0002\u0019AAH\u0003%a\u0017MY3m\u001d\u0006lW\r\u0005\u0003\u0002\u0012\u0006ee\u0002BAJ\u0003+\u00032!a\u0002P\u0013\r\t9jT\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0015Q\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]u\nC\u0004\u0002\"Z\u0001\r!a)\u0002\u0019A\u0014x\u000e]3sif\\U-_:\u0011\r\u0005\r\u0011QUAH\u0013\u0011\t9+a\u0006\u0003\u0007M+\u0017/\u0001\u0012sC:<W-\u00138eKb<U\r\u001e$pe2\u000b'-\u001a7B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u0003\u0013\u000bi+a,\t\u000f\u00055u\u00031\u0001\u0002\u0010\"9\u0011\u0011U\fA\u0002\u0005\r\u0016A\t9pS:$\u0018J\u001c3fq\u001e+GOR8s\u0019\u0006\u0014W\r\\!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\n\u0006U\u0016q\u0017\u0005\b\u0003\u001bC\u0002\u0019AAH\u0011\u001d\t\t\u000b\u0007a\u0001\u0003G\u000b1\u0005^3yi&sG-\u001a=HKR4uN\u001d*fYRK\b/Z!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\n\u0006u\u0016\u0011\u0019\u0005\b\u0003\u007fK\u0002\u0019AAH\u0003-\u0011X\r\u001c+za\u0016t\u0015-\\3\t\u000f\u0005\u0005\u0016\u00041\u0001\u0002$\u0006!#/\u00198hK&sG-\u001a=HKR4uN\u001d*fYRK\b/Z!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\n\u0006\u001d\u0017\u0011\u001a\u0005\b\u0003\u007fS\u0002\u0019AAH\u0011\u001d\t\tK\u0007a\u0001\u0003G\u000bA\u0005]8j]RLe\u000eZ3y\u000f\u0016$hi\u001c:SK2$\u0016\u0010]3B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u0003\u0013\u000by-!5\t\u000f\u0005}6\u00041\u0001\u0002\u0010\"9\u0011\u0011U\u000eA\u0002\u0005\r\u0016!H5oI\u0016Dx)\u001a;G_Jd\u0015MY3m\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\u0011\u0005%\u0015q[Am\u00037Dq!!\u0015\u001d\u0001\u0004\tI\u0006C\u0004\u0002\u000er\u0001\r!a$\t\u000f\u0005\u0005F\u00041\u0001\u0002$\u0006y\u0012N\u001c3fq\u001e+GOR8s%\u0016dG+\u001f9f\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\u0011\u0005%\u0015\u0011]Ar\u0003KDq!!\u0015\u001e\u0001\u0004\tI\u0006C\u0004\u0002@v\u0001\r!a$\t\u000f\u0005\u0005V\u00041\u0001\u0002$\u0006Y\u0012N\u001c3fq\u001e+GOR8s'\u000eDW-\\1EKN\u001c'/\u001b9u_J$B!a;\u0002xR!\u0011\u0011RAw\u0011\u001d\tyO\ba\u0001\u0003c\f!\u0002Z3tGJL\u0007\u000f^8s!\u0011\tY&a=\n\t\u0005U\u0018Q\f\u0002\u0011'\u000eDW-\\1EKN\u001c'/\u001b9u_JDq!!\u0015\u001f\u0001\u0004\tI&\u0001\u0013uKb$\u0018J\u001c3fq\u0016C\u0018n\u001d;t\r>\u0014H*\u00192fY\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\t9(!@\u0002\u0000\"9\u0011QR\u0010A\u0002\u0005=\u0005b\u0002B\u0001?\u0001\u0007\u00111U\u0001\faJ|\u0007/\u001a:us.+\u00170A\u0013sC:<W-\u00138eKb,\u00050[:ug\u001a{'\u000fT1cK2\fe\u000e\u001a)s_B,'\u000f^5fgR1\u0011q\u000fB\u0004\u0005\u0013Aq!!$!\u0001\u0004\ty\tC\u0004\u0003\u0002\u0001\u0002\r!a)\u0002KA|\u0017N\u001c;J]\u0012,\u00070\u0012=jgR\u001chi\u001c:MC\n,G.\u00118e!J|\u0007/\u001a:uS\u0016\u001cHCBA<\u0005\u001f\u0011\t\u0002C\u0004\u0002\u000e\u0006\u0002\r!a$\t\u000f\t\u0005\u0011\u00051\u0001\u0002$\u00061C/\u001a=u\u0013:$W\r_#ySN$8OR8s%\u0016dG+\u001f9f\u0003:$\u0007K]8qKJ$\u0018.Z:\u0015\r\u0005]$q\u0003B\r\u0011\u001d\tyL\ta\u0001\u0003\u001fCqA!\u0001#\u0001\u0004\t\u0019+A\u0014sC:<W-\u00138eKb,\u00050[:ug\u001a{'OU3m)f\u0004X-\u00118e!J|\u0007/\u001a:uS\u0016\u001cHCBA<\u0005?\u0011\t\u0003C\u0004\u0002@\u000e\u0002\r!a$\t\u000f\t\u00051\u00051\u0001\u0002$\u00069\u0003o\\5oi&sG-\u001a=Fq&\u001cHo\u001d$peJ+G\u000eV=qK\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\t9Ha\n\u0003*!9\u0011q\u0018\u0013A\u0002\u0005=\u0005b\u0002B\u0001I\u0001\u0007\u00111U\u0001\u000fO\u0016$xJ\u001c7j]\u0016Le\u000eZ3y)\u0011\tIIa\f\t\u000f\tER\u00051\u0001\u00034\u0005I!/\u001a4fe\u0016t7-\u001a\t\u0005\u00037\u0012)$\u0003\u0003\u0002\u001e\u0005u\u0013aF4fiR{7.\u001a8J]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s)\u0011\u0011YDa\u0011\u0011\u000b9\u000b)F!\u0010\u0011\u0007\t\u0014y$C\u0002\u0003B\r\u0014A\u0003V8lK:Le\u000eZ3y\t\u0016\u001c8M]5qi>\u0014\bb\u0002B#M\u0001\u0007!qI\u0001\bS:$W\r_3t!\u0019\u0011IE!\u0015\u000345\u0011!1\n\u0006\u0004g\n5#B\u0001B(\u0003\u0011Q\u0017M^1\n\t\u0005U!1J\u0001\u000f]>$W\rV8lK:Le\u000eZ3y+\t\u0011Y$\u0001\fsK2\fG/[8og\"L\u0007\u000fV8lK:Le\u000eZ3y\u0003\tB\u0017m\u001d(pI\u0016\u0004&o\u001c9feRLX\t_5ti\u0016t7-Z\"p]N$(/Y5oiR1\u0011q\u000fB/\u0005?Bq!!$*\u0001\u0004\ty\tC\u0004\u0003\u0002%\u0002\r!a$\u0002Q\u001d,GOT8eKB\u0013x\u000e]3si&,7oV5uQ\u0016C\u0018n\u001d;f]\u000e,7i\u001c8tiJ\f\u0017N\u001c;\u0015\t\t\u0015$1\u000e\t\u0007\u0003#\u00139'a$\n\t\t%\u0014Q\u0014\u0002\u0004'\u0016$\bbBAGU\u0001\u0007\u0011qR\u0001&O\u0016$\bK]8qKJ$\u0018.Z:Ge>lW\t_5ti\u0016t7-Z\"p]N$(/Y5oiN$BA!\u001a\u0003r!9!1O\u0016A\u0002\tU\u0014aC2p]N$(/Y5oiN\u0004b!a\u0001\u0002\u0014\t]\u0004\u0003BA.\u0005sJAAa\u001f\u0002^\t!2i\u001c8tiJ\f\u0017N\u001c;EKN\u001c'/\u001b9u_J\f!\u0006[1t%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d)s_B,'\u000f^=Fq&\u001cH/\u001a8dK\u000e{gn\u001d;sC&tG\u000f\u0006\u0004\u0002x\t\u0005%1\u0011\u0005\b\u0003\u007fc\u0003\u0019AAH\u0011\u001d\u0011\t\u0001\fa\u0001\u0003\u001f\u000b\u0001gZ3u%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d)s_B,'\u000f^5fg^KG\u000f[#ySN$XM\\2f\u0007>t7\u000f\u001e:bS:$H\u0003\u0002B3\u0005\u0013Cq!a0.\u0001\u0004\ty)\u0001\u0013hKR\u0004&o\u001c9feRLWm],ji\",\u00050[:uK:\u001cWmQ8ogR\u0014\u0018-\u001b8u+\t\u0011)'A\u000fiCNtu\u000eZ3Qe>\u0004XM\u001d;z)f\u0004XmQ8ogR\u0014\u0018-\u001b8u)!\t9Ha%\u0003\u0016\n]\u0005bBAG_\u0001\u0007\u0011q\u0012\u0005\b\u0005\u0003y\u0003\u0019AAH\u0011\u001d\u0011Ij\fa\u0001\u00057\u000b!bY=qQ\u0016\u0014H+\u001f9f!\u0011\u0011iJ!)\u000e\u0005\t}%\u0002\u0002B:\u0003;JAAa)\u0003 \ny1k\u00195f[\u00064\u0016\r\\;f)f\u0004X-A\u0012hKRtu\u000eZ3Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5UsB,7i\u001c8tiJ\f\u0017N\u001c;\u0015\t\t%&\u0011\u0017\t\t\u0003#\u0013Y+a$\u00030&!!QVAO\u0005\ri\u0015\r\u001d\t\u0007\u0003\u0007\t)Ka'\t\u000f\u00055\u0005\u00071\u0001\u0002\u0010\u0006)\u0003.Y:SK2\fG/[8og\"L\u0007\u000f\u0015:pa\u0016\u0014H/\u001f+za\u0016\u001cuN\\:ue\u0006Lg\u000e\u001e\u000b\t\u0003o\u00129L!/\u0003<\"9\u0011qX\u0019A\u0002\u0005=\u0005b\u0002B\u0001c\u0001\u0007\u0011q\u0012\u0005\b\u00053\u000b\u0004\u0019\u0001BN\u0003-:W\r\u001e*fY\u0006$\u0018n\u001c8tQ&\u0004\bK]8qKJ$\u0018.Z:XSRDG+\u001f9f\u0007>t7\u000f\u001e:bS:$H\u0003\u0002BU\u0005\u0003Dq!a03\u0001\u0004\ty)\u0001\u0006ti\u0006$\u0018n\u001d;jGN,\u0012a^\u0001\fgR\fG/[:uS\u000e\u001c\b%A\rmCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014XC\u0001Bg!\u0011\u0011yM!5\u000e\u0003\u0001K1Aa5A\u0005ea\u0015m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\u000251\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM\u001d\u0011\u0002%A\u0014xnY3ekJ,7+[4oCR,(/\u001a\u000b\u0005\u00057\u0014Y\u000f\u0005\u0003\u0003^\n\u001dXB\u0001Bp\u0015\u0011\u0011\tOa9\u0002\rAD\u0017m]3t\u0015\r\u0011)\u000fQ\u0001\tMJ|g\u000e^3oI&!!\u0011\u001eBp\u0005I\u0001&o\\2fIV\u0014XmU5h]\u0006$XO]3\t\u000f\t5x\u00071\u0001\u0003p\u0006!a.Y7f!\u0011\u0011iN!=\n\t\tM(q\u001c\u0002\u000e#V\fG.\u001b4jK\u0012t\u0015-\\3\u0002#\u0019,hn\u0019;j_:\u001c\u0016n\u001a8biV\u0014X\r\u0006\u0003\u0003z\u000e\u0005\u0001#\u0002(\u0002V\tm\b\u0003\u0002Bo\u0005{LAAa@\u0003`\n)Rk]3s\rVt7\r^5p]NKwM\\1ukJ,\u0007b\u0002Bwq\u0001\u0007!q^\u0001\u0013]>$\u0018NZ5dCRLwN\u001c'pO\u001e,'\u000fF\u0001q\u0003E!\bp\u0015;bi\u0016D\u0015m]\"iC:<Wm\u001d\u000b\u0003\u0003o\n\u0011\u0004\u001d:pG\u0016$WO]3TS\u001et\u0017\r^;sKZ+'o]5p]V\u00111q\u0002\t\u0004\u001d\u000eE\u0011bAB\n\u001f\n!Aj\u001c8h\u0003Y9\u0018\u000e\u001e5O_RLg-[2bi&|g\u000eT8hO\u0016\u0014HcA1\u0004\u001a!111\u0001\u001fA\u0002ADQa[\u0002A\u00021DQa\\\u0002A\u0002ADqa!\t\u0004\u0001\u0004\u0019\u0019#A\u0002m_\u001e\u0004Ba!\n\u0004,5\u00111q\u0005\u0006\u0004\u0007S!\u0015a\u00027pO\u001eLgnZ\u0005\u0005\u0007[\u00199CA\u0006J]R,'O\\1m\u0019><GC\u0002Bn\u0007c\u0019)\u0005C\u0004\u00044\u0011\u0001\ra!\u000e\u0002\u0005QD\b\u0003BB\u001c\u0007\u0003j!a!\u000f\u000b\t\rm2QH\u0001\u0004CBL'bAB \t\u000611.\u001a:oK2LAaa\u0011\u0004:\t\t2*\u001a:oK2$&/\u00198tC\u000e$\u0018n\u001c8\t\u000f\t5H\u00011\u0001\u0003pR1!\u0011`B%\u0007\u0017Bqaa\r\u0006\u0001\u0004\u0019)\u0004C\u0004\u0003n\u0016\u0001\rAa<")
public class TransactionBoundPlanContext
extends TransactionBoundReadTokenContext
implements PlanContext,
IndexDescriptorCompatibility {
    private final TransactionalContextWrapper tc;
    private final InternalNotificationLogger logger;
    private final InstrumentedGraphStatistics graphStatistics;
    private final InstrumentedGraphStatistics statistics;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;

    public static TransactionBoundPlanContext apply(TransactionalContextWrapper tc, InternalNotificationLogger logger, InternalLog log) {
        return TransactionBoundPlanContext$.MODULE$.apply(tc, logger, log);
    }

    @Override
    public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
    }

    @Override
    public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
    }

    @Override
    public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
        return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
    }

    @Override
    public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
        return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
    }

    @Override
    public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
    }

    @Override
    public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForLabel(int labelId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$1(it, x$2));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$2(x$3));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getLabelIndexesNonLocking(labelId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForRelType(int relTypeId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$1(it, x$4));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$2(x$5));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getRelTypeIndexesNonLocking(relTypeId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> propertyIndexesGetAll() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexesGetAllNonLocking()).asScala().flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public boolean indexExistsForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public boolean indexExistsForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.TEXT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.RANGE, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.POINT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.TEXT, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.RANGE, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.POINT, relTypeName, propertyKeys);
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForLabelAndProperties(IndexType indexType, String labelName, Seq<String> propertyKeys) {
        Option<LabelSchemaDescriptor> descriptor2 = this.toLabelSchemaDescriptor(this, labelName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForRelTypeAndProperties(IndexType indexType, String relTypeName, Seq<String> propertyKeys) {
        Option<RelationTypeSchemaDescriptor> descriptor2 = this.toRelTypeSchemaDescriptor(this, relTypeName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForSchemaDescriptor(IndexType indexType, SchemaDescriptor descriptor) {
        Iterator itr = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexForSchemaNonLocking(descriptor)).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexGetForSchemaDescriptor$1(indexType, x$6))).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
        if (itr.hasNext()) {
            return new Some(itr.next());
        }
        return None$.MODULE$;
    }

    public boolean textIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.textIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.rangeIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.pointIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean textIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.textIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.rangeIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.pointIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> getOnlineIndex(IndexDescriptor reference) {
        Object object;
        block7: {
            try {
                InternalIndexState internalIndexState = this.tc.schemaRead().indexGetStateNonLocking(reference);
                if (InternalIndexState.ONLINE.equals(internalIndexState) && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()))) {
                    CanGetValue$ valueCapability;
                    IndexDescriptor.EntityType$.Node node;
                    int tokenId = reference.schema().getEntityTokenIds()[0];
                    EntityType entityType = reference.schema().entityType();
                    if (EntityType.NODE.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Node(new LabelId(tokenId));
                    } else if (EntityType.RELATIONSHIP.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Relationship(new RelTypeId(tokenId));
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    IndexDescriptor.EntityType$.Node entityType2 = node;
                    PropertyKeyId[] properties = (PropertyKeyId[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()), (Function1)PropertyKeyId$.MODULE$, ClassTag$.MODULE$.apply(PropertyKeyId.class));
                    boolean isUnique = reference.isUnique();
                    Set behaviours = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])reference.getCapability().behaviours()), (Function1 & Serializable)behaviour -> this.kernelToCypher((IndexBehaviour)behaviour), ClassTag$.MODULE$.apply(org.neo4j.cypher.internal.planner.spi.IndexBehaviour.class))).toSet();
                    IndexOrderCapability.BOTH$ orderCapability = reference.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
                    Object object2 = valueCapability = reference.getCapability().supportsReturningValues() ? CanGetValue$.MODULE$ : DoNotGetValue$.MODULE$;
                    object = behaviours.contains((Object)EventuallyConsistent$.MODULE$) ? None$.MODULE$ : (isUnique && this.tc.schemaRead().indexGetOwningUniquenessConstraintIdNonLocking(reference) == null ? None$.MODULE$ : this.kernelToCypher(reference.getIndexType()).map(arg_0 -> TransactionBoundPlanContext.$anonfun$getOnlineIndex$2((Product)entityType2, properties, behaviours, (Product)orderCapability, (Product)valueCapability, reference, isUnique, arg_0)));
                    break block7;
                }
                object = None$.MODULE$;
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                object = None$.MODULE$;
            }
        }
        return object;
    }

    private Option<TokenIndexDescriptor> getTokenIndexDescriptor(java.util.Iterator<IndexDescriptor> indexes) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(indexes).asScala().nextOption().map((Function1 & Serializable)kernelIndexDescriptor -> {
            EntityType typ = kernelIndexDescriptor.schema().entityType();
            IndexOrderCapability.BOTH$ orderCapability = kernelIndexDescriptor.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
            return new TokenIndexDescriptor(typ, (IndexOrderCapability)orderCapability);
        });
    }

    public Option<TokenIndexDescriptor> nodeTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR));
    }

    public Option<TokenIndexDescriptor> relationshipTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR));
    }

    public boolean hasNodePropertyExistenceConstraint(String labelName, String propertyKey) {
        boolean bl;
        try {
            int labelId = this.getLabelId(labelName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getNodePropertiesWithExistenceConstraint(String labelName) {
        Set<String> set;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    private Set<String> getPropertiesFromExistenceConstraints(Iterator<ConstraintDescriptor> constraints) {
        Iterator existsConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence()));
        Set distinctPropertyIds = existsConstraints.flatMap((Function1 & Serializable)x$7 -> Predef$.MODULE$.wrapIntArray(x$7.schema().getPropertyIds())).toSet();
        return (Set)distinctPropertyIds.map((Function1 & Serializable)id -> TransactionBoundPlanContext.$anonfun$getPropertiesFromExistenceConstraints$3(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public boolean hasRelationshipPropertyExistenceConstraint(String relTypeName, String propertyKey) {
        boolean bl;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getRelationshipPropertiesWithExistenceConstraint(String relTypeName) {
        Set<String> set;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public Set<String> getPropertiesWithExistenceConstraint() {
        Set<String> set;
        try {
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetAllNonLocking()).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public boolean hasNodePropertyTypeConstraint(String labelName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getNodePropertiesWithTypeConstraint(labelName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getNodePropertiesWithTypeConstraint(String labelName) {
        Map map;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$8 -> x$8.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public boolean hasRelationshipPropertyTypeConstraint(String relTypeName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getRelationshipPropertiesWithTypeConstraint(relTypeName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getRelationshipPropertiesWithTypeConstraint(String relTypeName) {
        Map map;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$9 -> x$9.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public InstrumentedGraphStatistics statistics() {
        return this.statistics;
    }

    public LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ProcedureSignature procedureSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.procedureSignature(this.tc.kernelTransaction(), name);
    }

    public Option<UserFunctionSignature> functionSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.functionSignature(this.tc.kernelTransaction(), name);
    }

    public InternalNotificationLogger notificationLogger() {
        return this.logger;
    }

    public boolean txStateHasChanges() {
        return this.tc.dataRead().transactionStateHasChanges();
    }

    public long procedureSignatureVersion() {
        return this.tc.procedures().signatureVersion();
    }

    public PlanContext withNotificationLogger(InternalNotificationLogger notificationLogger) {
        return new TransactionBoundPlanContext(this.tc, notificationLogger, this.graphStatistics);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$1(IndexType it$1, IndexDescriptor x$2) {
        IndexType indexType = x$2.getIndexType();
        IndexType indexType2 = it$1;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$2(IndexDescriptor x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$1(IndexType it$2, IndexDescriptor x$4) {
        IndexType indexType = x$4.getIndexType();
        IndexType indexType2 = it$2;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$2(IndexDescriptor x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexGetForSchemaDescriptor$1(IndexType indexType$3, IndexDescriptor x$6) {
        IndexType indexType = x$6.getIndexType();
        IndexType indexType2 = indexType$3;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ org.neo4j.cypher.internal.planner.spi.IndexDescriptor $anonfun$getOnlineIndex$2(Product entityType$1, PropertyKeyId[] properties$1, Set behaviours$1, Product orderCapability$1, Product valueCapability$1, IndexDescriptor reference$1, boolean isUnique$1, IndexDescriptor.IndexType indexType) {
        return new org.neo4j.cypher.internal.planner.spi.IndexDescriptor(indexType, (IndexDescriptor.EntityType)entityType$1, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)properties$1), behaviours$1, (IndexOrderCapability)orderCapability$1, (GetValueFromIndexBehavior)valueCapability$1, (Option)new Some((Object)reference$1.getCapability()), isUnique$1);
    }

    public static final /* synthetic */ String $anonfun$getPropertiesFromExistenceConstraints$3(TransactionBoundPlanContext $this, int id) {
        return $this.tc.tokenRead().propertyKeyName(id);
    }

    public TransactionBoundPlanContext(TransactionalContextWrapper tc, InternalNotificationLogger logger, InstrumentedGraphStatistics graphStatistics) {
        this.tc = tc;
        this.logger = logger;
        this.graphStatistics = graphStatistics;
        super((QueryTransactionalContext)tc);
        IndexDescriptorCompatibility.$init$(this);
        this.statistics = graphStatistics;
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(tc.graph());
    }
}

