/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherQueryObfuscator$;
import org.neo4j.cypher.internal.util.LiteralOffset;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Y4AAD\b\u00011!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00033\u0001\u0011\u00051\u0007C\u00038\u0001\u0011\u0005\u0003\bC\u0003I\u0001\u0011\u0005\u0013\nC\u0003U\u0001\u0011%QkB\u0003^\u001f!\u0005aLB\u0003\u000f\u001f!\u0005q\fC\u00033\u000f\u0011\u00051\rC\u0004e\u000f\t\u0007I\u0011B3\t\r!<\u0001\u0015!\u0003g\u0011\u001dIwA1A\u0005\n)Da!]\u0004!\u0002\u0013Y\u0007\"\u0002:\b\t\u0003\u0019(!F\"za\",'/U;fef|%MZ;tG\u0006$xN\u001d\u0006\u0003!E\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003%M\taaY=qQ\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015qWm\u001c\u001bk\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001aCA\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0005Y\u0006twMC\u0001\u001f\u0003\u0011Q\u0017M^1\n\u0005\u0001Z\"AB(cU\u0016\u001cG\u000f\u0005\u0002#S5\t1E\u0003\u0002%K\u0005)\u0011/^3ss*\u0011aeJ\u0001\u0004CBL'B\u0001\u0015\u0014\u0003\u0019YWM\u001d8fY&\u0011!f\t\u0002\u0010#V,'/_(cMV\u001c8-\u0019;pe\u0006)1\u000f^1uKB\u0011Q\u0006M\u0007\u0002])\u0011qfD\u0001\u0005kRLG.\u0003\u00022]\t\u0019rJ\u00194vg\u000e\fG/[8o\u001b\u0016$\u0018\rZ1uC\u00061A(\u001b8jiz\"\"\u0001\u000e\u001c\u0011\u0005U\u0002Q\"A\b\t\u000b-\u0012\u0001\u0019\u0001\u0017\u0002\u001b=\u0014g-^:dCR,G+\u001a=u)\tId\t\u0005\u0002;\u0007:\u00111(\u0011\t\u0003y}j\u0011!\u0010\u0006\u0003}]\ta\u0001\u0010:p_Rt$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{\u0014A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!AQ \t\u000b\u001d\u001b\u0001\u0019A\u001d\u0002\u0019I\fw/U;fef$V\r\u001f;\u0002'=\u0014g-^:dCR,\u0007+\u0019:b[\u0016$XM]:\u0015\u0005)\u0013\u0006CA&Q\u001b\u0005a%BA'O\u0003\u001d1\u0018N\u001d;vC2T!aT\n\u0002\rY\fG.^3t\u0013\t\tFJ\u0001\u0005NCB4\u0016\r\\;f\u0011\u0015\u0019F\u00011\u0001K\u0003I\u0011\u0018m^)vKJL\b+\u0019:b[\u0016$XM]:\u0002'1LG/\u001a:bYN#(/\u001b8h\u0019\u0016tw\r\u001e5\u0015\u0007YS6\f\u0005\u0002X16\tq(\u0003\u0002Z\u007f\t\u0019\u0011J\u001c;\t\u000b\u001d+\u0001\u0019A\u001d\t\u000bq+\u0001\u0019\u0001,\u0002\u0013\u0019\u0014x.\\%oI\u0016D\u0018!F\"za\",'/U;fef|%MZ;tG\u0006$xN\u001d\t\u0003k\u001d\u0019\"a\u00021\u0011\u0005]\u000b\u0017B\u00012@\u0005\u0019\te.\u001f*fMR\ta,\u0001\nP\u0005\u001a+6kQ!U\u000b\u0012{F*\u0013+F%\u0006cU#\u00014\u0011\u0005i9\u0017B\u0001#\u001c\u0003My%IR+T\u0007\u0006#V\tR0M\u0013R+%+\u0011'!\u0003)y%IR+T\u0007\u0006#V\tR\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011aNT\u0001\tgR|'/\u00192mK&\u0011\u0001/\u001c\u0002\n)\u0016DHOV1mk\u0016\f1b\u0014\"G+N\u001b\u0015\tV#EA\u0005)\u0011\r\u001d9msR\u0011\u0011\u0005\u001e\u0005\u0006k6\u0001\r\u0001L\u0001\u0014_\n4Wo]2bi&|g.T3uC\u0012\fG/\u0019")
public class CypherQueryObfuscator
implements QueryObfuscator {
    private final ObfuscationMetadata state;

    public static QueryObfuscator apply(ObfuscationMetadata obfuscationMetadata) {
        return CypherQueryObfuscator$.MODULE$.apply(obfuscationMetadata);
    }

    public String obfuscateText(String rawQueryText) {
        if (this.state.sensitiveLiteralOffsets().isEmpty()) {
            return rawQueryText;
        }
        StringBuilder sb = new StringBuilder();
        IntRef i = IntRef.create((int)0);
        this.state.sensitiveLiteralOffsets().foreach((Function1 & Serializable)literalOffset -> {
            CypherQueryObfuscator.$anonfun$obfuscateText$1(this, rawQueryText, i, sb, literalOffset);
            return BoxedUnit.UNIT;
        });
        Object object = i.elem < rawQueryText.length() ? sb.append(rawQueryText.substring(i.elem)) : BoxedUnit.UNIT;
        return sb.toString();
    }

    public MapValue obfuscateParameters(MapValue rawQueryParameters) {
        if (this.state.sensitiveParameterNames().isEmpty()) {
            return rawQueryParameters;
        }
        ObjectRef params = ObjectRef.create((Object)rawQueryParameters);
        this.state.sensitiveParameterNames().foreach((Function1 & Serializable)p -> {
            params.elem = ((MapValue)params.elem).updatedWith(p, (AnyValue)CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED());
            return BoxedUnit.UNIT;
        });
        return (MapValue)params.elem;
    }

    private int literalStringLength(String rawQueryText, int fromIndex) {
        char first = rawQueryText.charAt(fromIndex);
        if (first == '\"' || first == '\'') {
            for (int lastCharacterIndex = fromIndex; lastCharacterIndex < rawQueryText.length() - 1; ++lastCharacterIndex) {
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), lastCharacterIndex) == '\\' || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), lastCharacterIndex + 1) != first) continue;
                return lastCharacterIndex - fromIndex + 2;
            }
            throw new IllegalStateException("Expected to find closing quote.");
        }
        return rawQueryText.length() - fromIndex;
    }

    public static final /* synthetic */ void $anonfun$obfuscateText$1(CypherQueryObfuscator $this, String rawQueryText$1, IntRef i$1, StringBuilder sb$1, LiteralOffset literalOffset) {
        int start = literalOffset.start();
        if (start >= rawQueryText$1.length() || start < i$1.elem) {
            throw new IllegalStateException("Literal offset out of bounds: " + literalOffset + ".");
        }
        sb$1.append(rawQueryText$1.substring(i$1.elem, start));
        sb$1.append(CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED_LITERAL());
        i$1.elem = start + BoxesRunTime.unboxToInt((Object)literalOffset.length().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.literalStringLength(rawQueryText$1, start)));
    }

    public CypherQueryObfuscator(ObfuscationMetadata state) {
        this.state = state;
    }
}

