/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.cypher.internal.CacheabilityInfo;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutingQueryTracer;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.cache.CacheSize;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.MissingLabelNotification;
import org.neo4j.cypher.internal.compiler.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.compiler.MissingRelTypeNotification;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.ParameterTypeInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0011%c\u0001B.]\u0001\u0015D\u0001\"\u001c\u0001\u0003\u0006\u0004%\tA\u001c\u0005\tk\u0002\u0011\t\u0011)A\u0005_\"Aa\u000f\u0001BC\u0002\u0013\u0005q\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003y\u0011!a\bA!b\u0001\n\u0003i\b\"CA\u000e\u0001\t\u0005\t\u0015!\u0003\u007f\u0011)\ti\u0002\u0001BC\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002BCA\u0019\u0001\t\u0015\r\u0011\"\u0001\u00024!Q\u00111\b\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!I\u0011Q\n\u0001C\u0002\u0013\u0005\u0011q\n\u0005\t\u0003\u0017\u0004\u0001\u0015!\u0003\u0002R!I\u0011Q\u001a\u0001C\u0002\u0013%\u0011q\u001a\u0005\t\u0003/\u0004\u0001\u0015!\u0003\u0002R\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005mgABA8\u0001\u0001\t\t\b\u0003\u0006\u0002tE\u0011)\u0019!C\u0001\u0003kB!\"a\u001e\u0012\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\tI(\u0005BC\u0002\u0013\u0005\u00111\u0010\u0005\u000b\u0003\u0007\u000b\"\u0011!Q\u0001\n\u0005u\u0004bBA\u001f#\u0011\u0005\u0011Q\u0011\u0005\n\u0003\u0017\u000b\u0002\u0019!C\u0005\u0003\u001bC\u0011\"!&\u0012\u0001\u0004%I!a&\t\u0011\u0005\r\u0016\u0003)Q\u0005\u0003\u001fCq!!,\u0012\t\u0003\ty\u000bC\u0004\u00022F!\t!!$\t\u000f\u0005M\u0016\u0003\"\u0001\u00026\"9\u0011\u0011Y\t\u0005B\u0005\r\u0007bBAd#\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003G\u0004A\u0011AAs\u0011%\u00119\u0004AI\u0001\n\u0003\u0011I\u0004C\u0004\u0003P\u0001!IA!\u0015\t\u000f\te\u0003\u0001\"\u0003\u0003\\!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002BG\u0001\u0011%!q\u0012\u0005\n\u0005;\u0003\u0011\u0013!C\u0005\u0005?CqAa)\u0001\t\u0013\u0011)\u000bC\u0005\u00032\u0002\t\n\u0011\"\u0003\u0003 \"9!1\u0017\u0001\u0005\n\tU\u0006b\u0002Be\u0001\u0011%!1\u001a\u0005\b\u0005/\u0004A\u0011\u0002Bm\u0011\u001d\u0011)\u000f\u0001C\u0001\u00037<qAa:]\u0011\u0003\u0011IO\u0002\u0004\\9\"\u0005!1\u001e\u0005\b\u0003{iC\u0011\u0001Bw\r\u0019\u0011y/\f\"\u0003r\"Q1QB\u0018\u0003\u0016\u0004%\taa\u0004\t\u0015\reqF!E!\u0002\u0013\u0019\t\u0002\u0003\u0006\u0004\u001c=\u0012)\u001a!C\u0001\u0007;A!b!\u00170\u0005#\u0005\u000b\u0011BB\u0010\u0011)\u0019Yf\fBK\u0002\u0013\u0005\u00111\u0010\u0005\u000b\u0007;z#\u0011#Q\u0001\n\u0005u\u0004bBA\u001f_\u0011\u00051q\f\u0005\n\u0007Sz\u0013\u0011!C\u0001\u0007WB\u0011ba\u001f0#\u0003%\ta! \t\u0013\r\u0015u&%A\u0005\u0002\r\u001d\u0005\"CBH_E\u0005I\u0011ABI\u0011%\u0019)jLA\u0001\n\u0003\u001a9\nC\u0005\u0004$>\n\t\u0011\"\u0001\u0002\u000e\"I1QU\u0018\u0002\u0002\u0013\u00051q\u0015\u0005\n\u0007W{\u0013\u0011!C!\u0007[C\u0011\"a-0\u0003\u0003%\taa/\t\u0013\r}v&!A\u0005B\r\u0005\u0007\"CAd_\u0005\u0005I\u0011IAe\u0011%\u0019)fLA\u0001\n\u0003\u001a)\rC\u0005\u0002B>\n\t\u0011\"\u0011\u0004H\u001eI11Z\u0017\u0002\u0002#\u00051Q\u001a\u0004\n\u0005_l\u0013\u0011!E\u0001\u0007\u001fDq!!\u0010F\t\u0003\u0019Y\u000eC\u0005\u0004V\u0015\u000b\t\u0011\"\u0012\u0004F\"I1Q\\#\u0002\u0002\u0013\u00055q\u001c\u0005\n\u0007_,\u0015\u0011!CA\u0007cD\u0011\u0002b\u0003F\u0003\u0003%I\u0001\"\u0004\t\u0013\u0011UQF1A\u0005\u0002\u0011]\u0001\u0002\u0003C\u0010[\u0001\u0006I\u0001\"\u0007\u0007\r\r\rR\u0006AB\u0013\u0011)\u00199#\u0014BC\u0002\u0013%1\u0011\u0006\u0005\u000b\u0007\u000bj%\u0011!Q\u0001\n\r-\u0002BCB$\u001b\n\u0005\t\u0015!\u0003\u0002\u0010\"A\u0011QH'\u0005\u00025\u001aI\u0005C\u0004\u0002H6#\t%!3\t\u000f\u0005\u0005W\n\"\u0011\u0004P!91QK'\u0005B\r]sa\u0002C\u0011[!\u0005A1\u0005\u0004\b\u0007Gi\u0003\u0012\u0001C\u0013\u0011\u001d\tiD\u0016C\u0001\tOA\u0011\u0002\"\u000bW\u0005\u0004%)a!\b\t\u0011\u0011-b\u000b)A\u0007\u0007?Aq\u0001\"\f.\t\u0003!yC\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016T!!\u00180\u0002\u0011%tG/\u001a:oC2T!a\u00181\u0002\r\rL\b\u000f[3s\u0015\t\t'-A\u0003oK>$$NC\u0001d\u0003\ry'oZ\u0002\u0001+\u00151\u0017\u0011FA\u0005'\t\u0001q\r\u0005\u0002iW6\t\u0011NC\u0001k\u0003\u0015\u00198-\u00197b\u0013\ta\u0017N\u0001\u0004B]f\u0014VMZ\u0001\rG\u0006\u001c\u0007.\u001a$bGR|'/_\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!\u000fX\u0001\u0006G\u0006\u001c\u0007.Z\u0005\u0003iF\u0014AcQ1gM\u0016Lg.Z\"bG\",g)Y2u_JL\u0018!D2bG\",g)Y2u_JL\b%A\u0006nCbLW.^7TSj,W#\u0001=\u0011\u0005AL\u0018B\u0001>r\u0005%\u0019\u0015m\u00195f'&TX-\u0001\u0007nCbLW.^7TSj,\u0007%A\bti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s+\u0005q\b#B@\u0002\u0002\u0005\u0015Q\"\u0001/\n\u0007\u0005\rALA\nQY\u0006t7\u000b^1mK:,7o]\"bY2,'\u000f\u0005\u0003\u0002\b\u0005%A\u0002\u0001\u0003\b\u0003\u0017\u0001!\u0019AA\u0007\u0005A)\u0005,R\"V)\u0006\u0013E*R0R+\u0016\u0013\u0016,\u0005\u0003\u0002\u0010\u0005U\u0001c\u00015\u0002\u0012%\u0019\u00111C5\u0003\u000f9{G\u000f[5oOB\u0019q0a\u0006\n\u0007\u0005eAL\u0001\tDC\u000eDW-\u00192jY&$\u00180\u00138g_\u0006\u00012\u000f^1mK:,7o]\"bY2,'\u000fI\u0001\u0007iJ\f7-\u001a:\u0016\u0005\u0005\u0005\u0002#\u00029\u0002$\u0005\u001d\u0012bAA\u0013c\nY1)Y2iKR\u0013\u0018mY3s!\u0011\t9!!\u000b\u0005\u000f\u0005-\u0002A1\u0001\u0002.\tI\u0011+V#S3~[U)W\t\u0004\u0003\u001f9\u0017a\u0002;sC\u000e,'\u000fI\u0001\u0015Kb,7-\u001e;j]\u001e\fV/\u001a:z)J\f7-\u001a:\u0016\u0005\u0005U\u0002cA@\u00028%\u0019\u0011\u0011\b/\u0003)\u0015CXmY;uS:<\u0017+^3ssR\u0013\u0018mY3s\u0003U)\u00070Z2vi&tw-U;fef$&/Y2fe\u0002\na\u0001P5oSRtD\u0003DA!\u0003\u0007\n)%a\u0012\u0002J\u0005-\u0003CB@\u0001\u0003O\t)\u0001C\u0003n\u0017\u0001\u0007q\u000eC\u0003w\u0017\u0001\u0007\u0001\u0010C\u0003}\u0017\u0001\u0007a\u0010C\u0004\u0002\u001e-\u0001\r!!\t\t\u000f\u0005E2\u00021\u0001\u00026\u0005y!/Z7pm\u0006dG*[:uK:,'/\u0006\u0002\u0002RAA\u00111KA4\u0003O\tY'\u0004\u0002\u0002V)\u0019!/a\u0016\u000b\t\u0005e\u00131L\u0001\tG\u00064g-Z5oK*!\u0011QLA0\u0003!\u0011WM\\7b]\u0016\u001c(\u0002BA1\u0003G\naaZ5uQV\u0014'BAA3\u0003\r\u0019w.\\\u0005\u0005\u0003S\n)FA\bSK6|g/\u00197MSN$XM\\3s!\r\ti'E\u0007\u0002\u0001\tY1)Y2iK\u00124\u0016\r\\;f'\t\tr-A\u0003wC2,X-\u0006\u0002\u0002\u0006\u00051a/\u00197vK\u0002\nqD]3d_6\u0004\u0018\u000e\\3e/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o+\t\ti\bE\u0002i\u0003\u007fJ1!!!j\u0005\u001d\u0011un\u001c7fC:\f\u0001E]3d_6\u0004\u0018\u000e\\3e/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3oAQ1\u00111NAD\u0003\u0013Cq!a\u001d\u0017\u0001\u0004\t)\u0001C\u0004\u0002zY\u0001\r!! \u0002\u001b}sW/\u001c2fe>3\u0007*\u001b;t+\t\ty\tE\u0002i\u0003#K1!a%j\u0005\rIe\u000e^\u0001\u0012?:,XNY3s\u001f\u001aD\u0015\u000e^:`I\u0015\fH\u0003BAM\u0003?\u00032\u0001[AN\u0013\r\ti*\u001b\u0002\u0005+:LG\u000fC\u0005\u0002\"b\t\t\u00111\u0001\u0002\u0010\u0006\u0019\u0001\u0010J\u0019\u0002\u001d}sW/\u001c2fe>3\u0007*\u001b;tA!\u001a\u0011$a*\u0011\u0007!\fI+C\u0002\u0002,&\u0014\u0001B^8mCRLG.Z\u0001\b[\u0006\u00148\u000eS5u)\t\tI*\u0001\u0007ok6\u0014WM](g\u0011&$8/\u0001\u0005dC:,\u0015/^1m)\u0011\ti(a.\t\u000f\u0005eF\u00041\u0001\u0002<\u0006)q\u000e\u001e5feB\u0019\u0001.!0\n\u0007\u0005}\u0016NA\u0002B]f\fa!Z9vC2\u001cH\u0003BA?\u0003\u000bDq!!/\u001e\u0001\u0004\tY,\u0001\u0005iCND7i\u001c3f)\t\ty)\u0001\tsK6|g/\u00197MSN$XM\\3sA\u0005)\u0011N\u001c8feV\u0011\u0011\u0011\u001b\t\t\u0003'\n\u0019.a\n\u0002l%!\u0011Q[A+\u0005\u0015\u0019\u0015m\u00195f\u0003\u0019IgN\\3sA\u0005iQm\u001d;j[\u0006$X\rZ*ju\u0016$\"!!8\u0011\u0007!\fy.C\u0002\u0002b&\u0014A\u0001T8oO\u000612m\\7qkR,\u0017JZ!cg\u0016tGo\u0014:Ti\u0006dW\r\u0006\u0007\u0002\u0006\u0005\u001d\u00181\u001eB\u0002\u0005\u001b\u0011i\u0002C\u0004\u0002j~\u0001\r!a\n\u0002\u0011E,XM]=LKfDq!!< \u0001\u0004\ty/\u0001\u0002uGB!\u0011\u0011_A\u0000\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018!B9vKJL(\u0002BA}\u0003w\fA![7qY*\u0019\u0011Q 1\u0002\r-,'O\\3m\u0013\u0011\u0011\t!a=\u0003)Q\u0013\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u\u0011\u001d\u0011)a\ba\u0001\u0005\u000f\t\u0001bY8na&dWM\u001d\t\u0006\u007f\n%\u0011QA\u0005\u0004\u0005\u0017a&aI\"p[BLG.\u001a:XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8PaRLwN\u001c\u0005\b\u0005\u001fy\u0002\u0019\u0001B\t\u00039\u0011X\r\u001d7b]N#(/\u0019;fOf\u0004BAa\u0005\u0003\u001a5\u0011!Q\u0003\u0006\u0004\u0005/a\u0016aB8qi&|gn]\u0005\u0005\u00057\u0011)B\u0001\nDsBDWM\u001d*fa2\fgn\u00149uS>t\u0007\"\u0003B\u0010?A\u0005\t\u0019\u0001B\u0011\u0003!iW\r^1ECR\f\u0007\u0003\u0002B\u0012\u0005cqAA!\n\u0003.A\u0019!qE5\u000e\u0005\t%\"b\u0001B\u0016I\u00061AH]8pizJ1Aa\fj\u0003\u0019\u0001&/\u001a3fM&!!1\u0007B\u001b\u0005\u0019\u0019FO]5oO*\u0019!qF5\u0002A\r|W\u000e];uK&3\u0017IY:f]R|%o\u0015;bY\u0016$C-\u001a4bk2$H%N\u000b\u0003\u0005wQCA!\t\u0003>-\u0012!q\b\t\u0005\u0005\u0003\u0012Y%\u0004\u0002\u0003D)!!Q\tB$\u0003%)hn\u00195fG.,GMC\u0002\u0003J%\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iEa\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000ej]Z\fG.\u001b3O_RLg-[2bi&|g.\u0012=jgRLgn\u001a\u000b\u0007\u0003{\u0012\u0019Fa\u0016\t\u000f\tU\u0013\u00051\u0001\u0002l\u0005Y1-Y2iK\u00124\u0016\r\\;f\u0011\u001d\ti/\ta\u0001\u0003_\fQ#[:J]Z\fG.\u001b3O_RLg-[2bi&|g\u000e\u0006\u0004\u0002~\tu#Q\u000e\u0005\b\u0005?\u0012\u0003\u0019\u0001B1\u00031qw\u000e^5gS\u000e\fG/[8o!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$b\u0001B49\u0006!Q\u000f^5m\u0013\u0011\u0011YG!\u001a\u0003)%sG/\u001a:oC2tu\u000e^5gS\u000e\fG/[8o\u0011\u001d\tiO\ta\u0001\u0003_\faB]3d_6\u0004\u0018\u000e\\3Pe\u001e+G\u000f\u0006\u0007\u0002\u0006\tM$Q\u0011BD\u0005\u0013\u0013Y\tC\u0004\u0003v\r\u0002\rAa\u001e\u0002\u001d\u0015DXmY;uS:<\u0017+^3ssB!!\u0011\u0010BA\u001b\t\u0011YH\u0003\u0003\u0002v\nu$\u0002\u0002B@\u0003w\f1!\u00199j\u0013\u0011\u0011\u0019Ia\u001f\u0003\u001d\u0015CXmY;uS:<\u0017+^3ss\"9!QK\u0012A\u0002\u0005-\u0004b\u0002B\u0003G\u0001\u0007!q\u0001\u0005\b\u0003S\u001c\u0003\u0019AA\u0014\u0011\u001d\u0011yb\ta\u0001\u0005C\tqbY8na&dW-\u00118e\u0007\u0006\u001c\u0007.\u001a\u000b\r\u0003\u000b\u0011\tJa%\u0003\u0016\n]%\u0011\u0014\u0005\b\u0005k\"\u0003\u0019\u0001B<\u0011\u001d\tI\u000f\na\u0001\u0003OAqA!\u0002%\u0001\u0004\u00119\u0001C\u0004\u0003 \u0011\u0002\rA!\t\t\u0013\tmE\u0005%AA\u0002\u0005u\u0014\u0001\u00035ji\u000e\u000b7\r[3\u00023\r|W\u000e]5mK\u0006sGmQ1dQ\u0016$C-\u001a4bk2$H%N\u000b\u0003\u0005CSC!! \u0003>\u0005!3m\\7qS2,w+\u001b;i\u000bb\u0004(/Z:tS>t7i\u001c3f\u000f\u0016t\u0017I\u001c3DC\u000eDW\r\u0006\u0007\u0002\u0006\t\u001d&\u0011\u0016BV\u0005[\u0013y\u000bC\u0004\u0003v\u0019\u0002\rAa\u001e\t\u000f\u0005%h\u00051\u0001\u0002(!9!Q\u0001\u0014A\u0002\t\u001d\u0001b\u0002B\u0010M\u0001\u0007!\u0011\u0005\u0005\n\u000573\u0003\u0013!a\u0001\u0003{\nafY8na&dWmV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+g.\u00118e\u0007\u0006\u001c\u0007.\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005i3m\\7qS2,wJ]\"p[BLG.Z,ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\!oI\u000e\u000b7\r[3\u0015\u0019\u0005\u0015!q\u0017B]\u0005w\u0013)Ma2\t\u000f\tU\u0004\u00061\u0001\u0003x!9\u0011\u0011\u001e\u0015A\u0002\u0005\u001d\u0002b\u0002B_Q\u0001\u0007!qX\u0001\bG>l\u0007/\u001b7f!\u0015A'\u0011YA\u0003\u0013\r\u0011\u0019-\u001b\u0002\n\rVt7\r^5p]BBqAa\b)\u0001\u0004\u0011\t\u0003C\u0004\u0003\u001c\"\u0002\r!! \u0002\u0007!LG\u000f\u0006\u0006\u0002\u0006\t5'q\u001aBi\u0005+DqA!\u001e*\u0001\u0004\u00119\bC\u0004\u0002j&\u0002\r!a\n\t\u000f\tM\u0017\u00061\u0001\u0002l\u0005yQ\r_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010C\u0004\u0003 %\u0002\rA!\t\u0002\t5L7o\u001d\u000b\u000b\u0003\u000b\u0011YN!8\u0003`\n\r\bb\u0002B;U\u0001\u0007!q\u000f\u0005\b\u0003ST\u0003\u0019AA\u0014\u0011\u001d\u0011\tO\u000ba\u0001\u0003\u000b\t!C\\3x\u000bb,7-\u001e;bE2,\u0017+^3ss\"9!q\u0004\u0016A\u0002\t\u0005\u0012!B2mK\u0006\u0014\u0018AC)vKJL8)Y2iKB\u0011q0L\n\u0003[\u001d$\"A!;\u0003\u0011\r\u000b7\r[3LKf,BAa=\u0004\u0014M1qf\u001aB{\u0005w\u00042\u0001\u001bB|\u0013\r\u0011I0\u001b\u0002\b!J|G-^2u!\u0011\u0011ipa\u0002\u000f\t\t}81\u0001\b\u0005\u0005O\u0019\t!C\u0001k\u0013\r\u0019)![\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019Iaa\u0003\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\r\u0015\u0011.\u0001\u0005rk\u0016\u0014\u0018PU3q+\t\u0019\t\u0002\u0005\u0003\u0002\b\rMAaBB\u000b_\t\u00071q\u0003\u0002\n#V+%+W0S\u000bB\u000bB!a\u0004\u0002<\u0006I\u0011/^3ssJ+\u0007\u000fI\u0001\u0011a\u0006\u0014\u0018-\\3uKJ$\u0016\u0010]3NCB,\"aa\b\u0011\u0007\r\u0005R*D\u0001.\u0005A\u0001\u0016M]1nKR,'\u000fV=qK6\u000b\u0007o\u0005\u0002NO\u0006I!/Z:vYRl\u0015\r]\u000b\u0003\u0007W\u0001\u0002b!\f\u00046\t\u00052\u0011H\u0007\u0003\u0007_QAAa\u001a\u00042)\u001111G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00048\r=\"aA'baB!11HB!\u001b\t\u0019iD\u0003\u0003\u0004@\t\u0015\u0014aB:z[\n|Gn]\u0005\u0005\u0007\u0007\u001aiDA\tQCJ\fW.\u001a;feRK\b/Z%oM>\f!B]3tk2$X*\u00199!\u0003%y\u0006.Y:i\u0007>$W\r\u0006\u0004\u0004 \r-3Q\n\u0005\b\u0007O\t\u0006\u0019AB\u0016\u0011\u001d\u00199%\u0015a\u0001\u0003\u001f#B!! \u0004R!911K*A\u0002\u0005m\u0016aA8cU\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\"\u0005\t\u0002/\u0019:b[\u0016$XM\u001d+za\u0016l\u0015\r\u001d\u0011\u0002#QD8\u000b^1uK\"\u000b7o\u00115b]\u001e,7/\u0001\nuqN#\u0018\r^3ICN\u001c\u0005.\u00198hKN\u0004C\u0003CB1\u0007G\u001a)ga\u001a\u0011\u000b\r\u0005rf!\u0005\t\u000f\r5a\u00071\u0001\u0004\u0012!911\u0004\u001cA\u0002\r}\u0001bBB.m\u0001\u0007\u0011QP\u0001\u0005G>\u0004\u00180\u0006\u0003\u0004n\rMD\u0003CB8\u0007k\u001a9h!\u001f\u0011\u000b\r\u0005rf!\u001d\u0011\t\u0005\u001d11\u000f\u0003\b\u0007+9$\u0019AB\f\u0011%\u0019ia\u000eI\u0001\u0002\u0004\u0019\t\bC\u0005\u0004\u001c]\u0002\n\u00111\u0001\u0004 !I11L\u001c\u0011\u0002\u0003\u0007\u0011QP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\u0019yha!\u0016\u0005\r\u0005%\u0006BB\t\u0005{!qa!\u00069\u0005\u0004\u00199\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\r%5QR\u000b\u0003\u0007\u0017SCaa\b\u0003>\u001191QC\u001dC\u0002\r]\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0005\u0005?\u001b\u0019\nB\u0004\u0004\u0016i\u0012\raa\u0006\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019I\n\u0005\u0003\u0004\u001c\u000e\u0005VBABO\u0015\u0011\u0019yj!\r\u0002\t1\fgnZ\u0005\u0005\u0005g\u0019i*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m6\u0011\u0016\u0005\n\u0003Ck\u0014\u0011!a\u0001\u0003\u001f\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007_\u0003ba!-\u00048\u0006mVBABZ\u0015\r\u0019),[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB]\u0007g\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u000b\u0005\u0003{\u001ai\fC\u0005\u0002\"~\n\t\u00111\u0001\u0002<\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0019Ija1\t\u0013\u0005\u0005\u0006)!AA\u0002\u0005=ECABM)\u0011\tih!3\t\u0013\u0005\u00056)!AA\u0002\u0005m\u0016\u0001C\"bG\",7*Z=\u0011\u0007\r\u0005Ri\u0005\u0003FO\u000eE\u0007\u0003BBj\u00073l!a!6\u000b\t\r]7\u0011G\u0001\u0003S>LAa!\u0003\u0004VR\u00111QZ\u0001\u0006CB\u0004H._\u000b\u0005\u0007C\u001c9\u000f\u0006\u0005\u0004d\u000e%81^Bw!\u0015\u0019\tcLBs!\u0011\t9aa:\u0005\u000f\rU\u0001J1\u0001\u0004\u0018!91Q\u0002%A\u0002\r\u0015\bbBB\u000e\u0011\u0002\u00071q\u0004\u0005\b\u00077B\u0005\u0019AA?\u0003\u001d)h.\u00199qYf,Baa=\u0005\u0004Q!1Q\u001fC\u0003!\u0015A7q_B~\u0013\r\u0019I0\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013!\u001ci\u0010\"\u0001\u0004 \u0005u\u0014bAB\u0000S\n1A+\u001e9mKN\u0002B!a\u0002\u0005\u0004\u001191QC%C\u0002\r]\u0001\"\u0003C\u0004\u0013\u0006\u0005\t\u0019\u0001C\u0005\u0003\rAH\u0005\r\t\u0006\u0007CyC\u0011A\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\t\u001f\u0001Baa'\u0005\u0012%!A1CBO\u0005\u0019y%M[3di\u0006Yaj\u0014+`!J+5+\u0012(U+\t!I\u0002E\u0002\u0000\t7I1\u0001\"\b]\u0005=)\u00050Z2vi\u0006\u0014G.Z)vKJL\u0018\u0001\u0004(P)~\u0003&+R*F\u001dR\u0003\u0013\u0001\u0005)be\u0006lW\r^3s)f\u0004X-T1q!\r\u0019\tCV\n\u0003-\u001e$\"\u0001b\t\u0002\u000b\u0015l\u0007\u000f^=\u0002\r\u0015l\u0007\u000f^=!\u0003])\u0007\u0010\u001e:bGR\u0004\u0016M]1nKR,'\u000fV=qK6\u000b\u0007\u000f\u0006\u0004\u0004 \u0011EBQ\t\u0005\b\tgQ\u0006\u0019\u0001C\u001b\u0003!i\u0017\r\u001d,bYV,\u0007\u0003\u0002C\u001c\t\u0003j!\u0001\"\u000f\u000b\t\u0011mBQH\u0001\bm&\u0014H/^1m\u0015\r!y\u0004Y\u0001\u0007m\u0006dW/Z:\n\t\u0011\rC\u0011\b\u0002\t\u001b\u0006\u0004h+\u00197vK\"9Aq\t.A\u0002\u0005u\u0014aC;tKNK'0\u001a%j]R\u0004")
public class QueryCache<QUERY_KEY, EXECUTABLE_QUERY extends CacheabilityInfo> {
    private final CaffeineCacheFactory cacheFactory;
    private final CacheSize maximumSize;
    private final PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller;
    private final CacheTracer<QUERY_KEY> tracer;
    private final ExecutingQueryTracer executingQueryTracer;
    private final RemovalListener<QUERY_KEY, CachedValue> removalListener;
    private final Cache<QUERY_KEY, CachedValue> inner;

    public static ParameterTypeMap extractParameterTypeMap(MapValue mapValue, boolean useSizeHint) {
        return QueryCache$.MODULE$.extractParameterTypeMap(mapValue, useSizeHint);
    }

    public static ExecutableQuery NOT_PRESENT() {
        return QueryCache$.MODULE$.NOT_PRESENT();
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public CacheSize maximumSize() {
        return this.maximumSize;
    }

    public PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller() {
        return this.stalenessCaller;
    }

    public CacheTracer<QUERY_KEY> tracer() {
        return this.tracer;
    }

    public ExecutingQueryTracer executingQueryTracer() {
        return this.executingQueryTracer;
    }

    public RemovalListener<QUERY_KEY, CachedValue> removalListener() {
        return this.removalListener;
    }

    private Cache<QUERY_KEY, CachedValue> inner() {
        return this.inner;
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public EXECUTABLE_QUERY computeIfAbsentOrStale(QUERY_KEY queryKey, TransactionalContext tc, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, CypherReplanOption replanStrategy, String metaData) {
        LazyRef executingQuery$lzy = new LazyRef();
        if (this.maximumSize().currentValue() == 0) {
            CacheabilityInfo result = (CacheabilityInfo)compiler.compile();
            this.tracer().compute(queryKey, metaData);
            return (EXECUTABLE_QUERY)result;
        }
        CachedValue cachedValue = (CachedValue)this.inner().getIfPresent(queryKey);
        ExecutableQuery executableQuery = QueryCache$.MODULE$.NOT_PRESENT();
        CachedValue cachedValue2 = cachedValue;
        if (!(executableQuery != null ? !executableQuery.equals(cachedValue2) : cachedValue2 != null)) {
            CypherReplanOption cypherReplanOption = replanStrategy;
            CypherReplanOption.force$ force$2 = CypherReplanOption.force$.MODULE$;
            if (!(cypherReplanOption != null ? !cypherReplanOption.equals(force$2) : force$2 != null)) {
                return this.compileWithExpressionCodeGenAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$5());
            }
            return this.compileAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, this.compileAndCache$default$5());
        }
        cachedValue.markHit();
        CypherReplanOption cypherReplanOption = replanStrategy;
        if (CypherReplanOption.force$.MODULE$.equals(cypherReplanOption)) {
            return this.compileWithExpressionCodeGenAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
        }
        if (CypherReplanOption.skip$.MODULE$.equals(cypherReplanOption)) {
            return this.hit(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, cachedValue, metaData);
        }
        if (CypherReplanOption.default$.MODULE$.equals(cypherReplanOption)) {
            Staleness staleness = this.stalenessCaller().staleness(tc, cachedValue.value());
            if (NotStale$.MODULE$.equals(staleness)) {
                if (this.invalidNotificationExisting(cachedValue, tc)) {
                    return this.compileAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
                }
                return this.recompileOrGet(QueryCache.executingQuery$1(executingQuery$lzy, tc), cachedValue, compiler, queryKey, metaData);
            }
            if (staleness instanceof Stale) {
                Stale stale = (Stale)staleness;
                int secondsSincePlan = stale.secondsSincePlan();
                Option<String> maybeReason = stale.maybeReason();
                this.tracer().cacheStale(queryKey, secondsSincePlan, metaData, maybeReason);
                if (cachedValue.recompiledWithExpressionCodeGen()) {
                    return this.compileWithExpressionCodeGenAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
                }
                return this.compileAndCache(QueryCache.executingQuery$1(executingQuery$lzy, tc), queryKey, compiler, metaData, true);
            }
            throw new MatchError((Object)staleness);
        }
        throw new MatchError((Object)cypherReplanOption);
    }

    public String computeIfAbsentOrStale$default$5() {
        return "";
    }

    private boolean invalidNotificationExisting(CachedValue cachedValue, TransactionalContext tc) {
        IndexedSeq<InternalNotification> notifications = cachedValue.value().notifications();
        for (int i = 0; i < notifications.length(); ++i) {
            if (!this.isInvalidNotification((InternalNotification)notifications.apply(i), tc)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidNotification(InternalNotification notification, TransactionalContext tc) {
        InternalNotification internalNotification = notification;
        if (internalNotification instanceof MissingLabelNotification) {
            MissingLabelNotification missingLabelNotification = (MissingLabelNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().nodeLabel(missingLabelNotification.label()) != -1;
        }
        if (internalNotification instanceof MissingRelTypeNotification) {
            MissingRelTypeNotification missingRelTypeNotification = (MissingRelTypeNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().relationshipType(missingRelTypeNotification.relType()) != -1;
        }
        if (internalNotification instanceof MissingPropertyNameNotification) {
            MissingPropertyNameNotification missingPropertyNameNotification = (MissingPropertyNameNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().propertyKey(missingPropertyNameNotification.name()) != -1;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EXECUTABLE_QUERY recompileOrGet(ExecutingQuery executingQuery, CachedValue cachedValue, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, QUERY_KEY queryKey, String metaData) {
        CachedValue cachedValue2;
        this.tracer().cacheHit(queryKey, metaData);
        this.executingQueryTracer().cacheHit(executingQuery);
        if (!cachedValue.recompiledWithExpressionCodeGen()) {
            Option<EXECUTABLE_QUERY> option = compiler.maybeCompileWithExpressionCodeGen(cachedValue.numberOfHits());
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheabilityInfo recompiledQuery = (CacheabilityInfo)some.value();
                this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
                CachedValue recompiled = new CachedValue(this, recompiledQuery, true);
                this.inner().put(queryKey, (Object)recompiled);
                cachedValue2 = recompiled;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                cachedValue2 = cachedValue;
            }
        } else {
            cachedValue2 = cachedValue;
        }
        CachedValue newCachedValue = cachedValue2;
        return newCachedValue.value();
    }

    private EXECUTABLE_QUERY compileAndCache(ExecutingQuery executingQuery, QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(executingQuery, queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compile(), metaData, hitCache);
        this.tracer().compute(queryKey, metaData);
        return result;
    }

    private boolean compileAndCache$default$5() {
        return false;
    }

    private EXECUTABLE_QUERY compileWithExpressionCodeGenAndCache(ExecutingQuery executingQuery, QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(executingQuery, queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compileWithExpressionCodeGen(), metaData, hitCache);
        this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
        return result;
    }

    private boolean compileWithExpressionCodeGenAndCache$default$5() {
        return false;
    }

    private EXECUTABLE_QUERY compileOrCompileWithExpressionCodeGenAndCache(ExecutingQuery executingQuery, QUERY_KEY queryKey, Function0<EXECUTABLE_QUERY> compile, String metaData, boolean hitCache) {
        CacheabilityInfo newExecutableQuery = (CacheabilityInfo)compile.apply();
        if (newExecutableQuery.shouldBeCached()) {
            CachedValue cachedValue = new CachedValue(this, newExecutableQuery, false);
            this.inner().put(queryKey, (Object)cachedValue);
            if (hitCache) {
                return this.hit(executingQuery, queryKey, cachedValue, metaData);
            }
            return (EXECUTABLE_QUERY)this.miss(executingQuery, queryKey, newExecutableQuery, metaData);
        }
        return (EXECUTABLE_QUERY)this.miss(executingQuery, queryKey, newExecutableQuery, metaData);
    }

    private EXECUTABLE_QUERY hit(ExecutingQuery executingQuery, QUERY_KEY queryKey, CachedValue executableQuery, String metaData) {
        this.tracer().cacheHit(queryKey, metaData);
        this.executingQueryTracer().cacheHit(executingQuery);
        return executableQuery.value();
    }

    private EXECUTABLE_QUERY miss(ExecutingQuery executingQuery, QUERY_KEY queryKey, EXECUTABLE_QUERY newExecutableQuery, String metaData) {
        this.tracer().cacheMiss(queryKey, metaData);
        this.executingQueryTracer().cacheMiss(executingQuery);
        return newExecutableQuery;
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer().cacheFlush(priorSize);
        return priorSize;
    }

    private static final /* synthetic */ ExecutingQuery executingQuery$lzycompute$1(LazyRef executingQuery$lzy$1, TransactionalContext tc$1) {
        ExecutingQuery executingQuery;
        LazyRef lazyRef = executingQuery$lzy$1;
        synchronized (lazyRef) {
            executingQuery = executingQuery$lzy$1.initialized() ? (ExecutingQuery)executingQuery$lzy$1.value() : (ExecutingQuery)executingQuery$lzy$1.initialize((Object)tc$1.executingQuery());
        }
        return executingQuery;
    }

    private static final ExecutingQuery executingQuery$1(LazyRef executingQuery$lzy$1, TransactionalContext tc$1) {
        if (executingQuery$lzy$1.initialized()) {
            return (ExecutingQuery)executingQuery$lzy$1.value();
        }
        return QueryCache.executingQuery$lzycompute$1(executingQuery$lzy$1, tc$1);
    }

    public QueryCache(CaffeineCacheFactory cacheFactory, CacheSize maximumSize, PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller, CacheTracer<QUERY_KEY> tracer, ExecutingQueryTracer executingQueryTracer) {
        this.cacheFactory = cacheFactory;
        this.maximumSize = maximumSize;
        this.stalenessCaller = stalenessCaller;
        this.tracer = tracer;
        this.executingQueryTracer = executingQueryTracer;
        this.removalListener = (key, value, cause) -> this.tracer().discard(key, "");
        this.inner = cacheFactory.createCache(maximumSize, this.removalListener());
    }

    public static final class CacheKey<QUERY_REP>
    implements Product,
    Serializable {
        private final QUERY_REP queryRep;
        private final ParameterTypeMap parameterTypeMap;
        private final boolean txStateHasChanges;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public QUERY_REP queryRep() {
            return this.queryRep;
        }

        public ParameterTypeMap parameterTypeMap() {
            return this.parameterTypeMap;
        }

        public boolean txStateHasChanges() {
            return this.txStateHasChanges;
        }

        public <QUERY_REP> CacheKey<QUERY_REP> copy(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            return new CacheKey<QUERY_REP>(queryRep, parameterTypeMap, txStateHasChanges);
        }

        public <QUERY_REP> QUERY_REP copy$default$1() {
            return this.queryRep();
        }

        public <QUERY_REP> ParameterTypeMap copy$default$2() {
            return this.parameterTypeMap();
        }

        public <QUERY_REP> boolean copy$default$3() {
            return this.txStateHasChanges();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.queryRep();
                }
                case 1: {
                    return this.parameterTypeMap();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.txStateHasChanges());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "queryRep";
                }
                case 1: {
                    return "parameterTypeMap";
                }
                case 2: {
                    return "txStateHasChanges";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryRep()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parameterTypeMap()));
            n = Statics.mix((int)n, (int)(this.txStateHasChanges() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            if (this.txStateHasChanges() != cacheKey.txStateHasChanges()) return false;
            if (!BoxesRunTime.equals(this.queryRep(), cacheKey.queryRep())) return false;
            ParameterTypeMap parameterTypeMap = this.parameterTypeMap();
            ParameterTypeMap parameterTypeMap2 = cacheKey.parameterTypeMap();
            if (parameterTypeMap != null) {
                if (!((Object)parameterTypeMap).equals(parameterTypeMap2)) return false;
                return true;
            }
            if (parameterTypeMap2 == null) return true;
            return false;
        }

        public CacheKey(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            this.queryRep = queryRep;
            this.parameterTypeMap = parameterTypeMap;
            this.txStateHasChanges = txStateHasChanges;
            Product.$init$((Product)this);
        }
    }

    public class CachedValue {
        private final EXECUTABLE_QUERY value;
        private final boolean recompiledWithExpressionCodeGen;
        private volatile int _numberOfHits;
        public final /* synthetic */ QueryCache $outer;

        public EXECUTABLE_QUERY value() {
            return this.value;
        }

        public boolean recompiledWithExpressionCodeGen() {
            return this.recompiledWithExpressionCodeGen;
        }

        private int _numberOfHits() {
            return this._numberOfHits;
        }

        private void _numberOfHits_$eq(int x$1) {
            this._numberOfHits = x$1;
        }

        public void markHit() {
            if (!this.recompiledWithExpressionCodeGen()) {
                this._numberOfHits_$eq(this._numberOfHits() + 1);
                return;
            }
        }

        public int numberOfHits() {
            return this._numberOfHits();
        }

        public boolean canEqual(Object other) {
            return other instanceof CachedValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CachedValue)) return false;
            if (((CachedValue)object).org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() != this.org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer()) return false;
            CachedValue cachedValue = (CachedValue)object;
            if (!cachedValue.canEqual(this)) return false;
            Object EXECUTABLE_QUERY = this.value();
            Object EXECUTABLE_QUERY2 = cachedValue.value();
            if (EXECUTABLE_QUERY != null) {
                if (!EXECUTABLE_QUERY.equals(EXECUTABLE_QUERY2)) return false;
                return true;
            }
            if (EXECUTABLE_QUERY2 == null) return true;
            return false;
        }

        public int hashCode() {
            .colon.colon state = new .colon.colon(this.value(), (List)Nil$.MODULE$);
            return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
        }

        public /* synthetic */ QueryCache org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public CachedValue(EXECUTABLE_QUERY value, boolean recompiledWithExpressionCodeGen) {
            this.value = value;
            this.recompiledWithExpressionCodeGen = recompiledWithExpressionCodeGen;
            if ($outer == null) {
                throw null;
            }
            this.$outer = (QueryCache)$outer;
            this._numberOfHits = 0;
        }
    }

    public static class ParameterTypeMap {
        private final Map<String, ParameterTypeInfo> resultMap;
        private final int _hashCode;

        private Map<String, ParameterTypeInfo> resultMap() {
            return this.resultMap;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof ParameterTypeMap) {
                ParameterTypeMap parameterTypeMap = (ParameterTypeMap)object;
                if (this.resultMap().size() == parameterTypeMap.resultMap().size()) {
                    Map<String, ParameterTypeInfo> otherMap = parameterTypeMap.resultMap();
                    java.util.Iterator<Map.Entry<String, ParameterTypeInfo>> entries = otherMap.entrySet().iterator();
                    boolean stillEqual = true;
                    while (entries.hasNext() && stillEqual) {
                        Map.Entry<String, ParameterTypeInfo> entry = entries.next();
                        String otherKey = entry.getKey();
                        ParameterTypeInfo otherValue = entry.getValue();
                        ParameterTypeInfo value = this.resultMap().get(otherKey);
                        stillEqual = otherValue.equals((Object)value);
                    }
                    return stillEqual;
                }
            }
            return false;
        }

        public String toString() {
            return CollectionConverters$.MODULE$.MapHasAsScala(this.resultMap()).asScala().toString();
        }

        public ParameterTypeMap(Map<String, ParameterTypeInfo> resultMap, int _hashCode) {
            this.resultMap = resultMap;
            this._hashCode = _hashCode;
        }
    }
}

