/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.MinimumGraphStatistics;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ur!\u0002\t\u0012\u0011\u0003ab!\u0002\u0010\u0012\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0015\u0002\t\u0003)e\u0001\u0002,\u0002\t]C\u0001bR\u0003\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t#\u0016\u0011\t\u0011)A\u0005%\"Aa(\u0002B\u0001B\u0003%q\bC\u0003'\u000b\u0011\u0005a\fC\u0003e\u000b\u0011\u0005S\rC\u0003u\u000b\u0011\u0005S\u000fC\u0003x\u000b\u0011\u0005\u0003\u0010C\u0003}\u000b\u0011\u0005S\u0010C\u0004\u0002\n\u0015!\t%a\u0003\t\u000f\u0005\u0005R\u0001\"\u0003\u0002$\u0005yBK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u000b\u0005I\u0019\u0012aA:qS*\u0011A#F\u0001\tS:$XM\u001d8bY*\u0011acF\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005aI\u0012!\u00028f_RR'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005u\tQ\"A\t\u0003?Q\u0013\u0018M\\:bGRLwN\u001c\"pk:$wI]1qQN#\u0018\r^5ti&\u001c7o\u0005\u0002\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007)\nT\b\u0005\u0002,_5\tAF\u0003\u0002\u0013[)\u0011afE\u0001\ba2\fgN\\3s\u0013\t\u0001DF\u0001\fNS:LW.^7He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0011\u0015\u00114\u00011\u00014\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yiB\u0011AgO\u0007\u0002k)\u0011agN\u0001\u0006cV,'/\u001f\u0006\u0003qe\nA![7qY*\u0011!hF\u0001\u0007W\u0016\u0014h.\u001a7\n\u0005q*$\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0003?\u0007\u0001\u0007q(A\u0002m_\u001e\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\f\u0002\u000f1|wmZ5oO&\u0011A)\u0011\u0002\f\u0013:$XM\u001d8bY2{w\r\u0006\u0003+\rB+\u0006\"B$\u0005\u0001\u0004A\u0015\u0001\u0002:fC\u0012\u0004\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\u0007\u0005\u0004\u0018N\u0003\u0002;\u001b*\u0011AcF\u0005\u0003\u001f*\u0013AAU3bI\")\u0011\u000b\u0002a\u0001%\u0006Q1o\u00195f[\u0006\u0014V-\u00193\u0011\u0005%\u001b\u0016B\u0001+K\u0005)\u00196\r[3nCJ+\u0017\r\u001a\u0005\u0006}\u0011\u0001\ra\u0010\u0002$\u0005\u0006\u001cX\r\u0016:b]N\f7\r^5p]\n{WO\u001c3He\u0006\u0004\bn\u0015;bi&\u001cH/[2t'\u0011)\u0001\u0005W.\u0011\u0005-J\u0016B\u0001.-\u0005=9%/\u00199i'R\fG/[:uS\u000e\u001c\bCA\u000f]\u0013\ti\u0016C\u0001\u000fJ]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=\u0015\t}\u000b'm\u0019\t\u0003A\u0016i\u0011!\u0001\u0005\u0006\u000f&\u0001\r\u0001\u0013\u0005\u0006#&\u0001\rA\u0015\u0005\u0006}%\u0001\raP\u0001\u0017k:L\u0017/^3WC2,XmU3mK\u000e$\u0018N^5usR\u0011am\u001c\t\u0004C\u001dL\u0017B\u00015#\u0005\u0019y\u0005\u000f^5p]B\u0011!.\\\u0007\u0002W*\u0011AnE\u0001\u0005kRLG.\u0003\u0002oW\nY1+\u001a7fGRLg/\u001b;z\u0011\u0015\u0001(\u00021\u0001r\u0003\u0015Ig\u000eZ3y!\tY#/\u0003\u0002tY\ty\u0011J\u001c3fq\u0012+7o\u0019:jaR|'/A\u0011j]\u0012,\u0007\u0010\u0015:pa\u0016\u0014H/_%t\u001d>$h*\u001e7m'\u0016dWm\u0019;jm&$\u0018\u0010\u0006\u0002gm\")\u0001o\u0003a\u0001c\u0006\u0019bn\u001c3fg\u0006cGnQ1sI&t\u0017\r\\5usR\t\u0011\u0010\u0005\u0002ku&\u00111p\u001b\u0002\f\u0007\u0006\u0014H-\u001b8bY&$\u00180A\ro_\u0012,7oV5uQ2\u000b'-\u001a7DCJ$\u0017N\\1mSRLHCA=\u007f\u0011\u0019yX\u00021\u0001\u0002\u0002\u0005aQ.Y=cK2\u000b'-\u001a7JIB!\u0011eZA\u0002!\rQ\u0017QA\u0005\u0004\u0003\u000fY'a\u0002'bE\u0016d\u0017\nZ\u0001\u0017a\u0006$H/\u001a:o'R,\u0007oQ1sI&t\u0017\r\\5usR9\u00110!\u0004\u0002\u0012\u0005u\u0001bBA\b\u001d\u0001\u0007\u0011\u0011A\u0001\nMJ|W\u000eT1cK2Dq!a\u0005\u000f\u0001\u0004\t)\"A\u0005sK2$\u0016\u0010]3JIB!\u0011eZA\f!\rQ\u0017\u0011D\u0005\u0004\u00037Y'!\u0003*fYRK\b/Z%e\u0011\u001d\tyB\u0004a\u0001\u0003\u0003\tq\u0001^8MC\n,G.\u0001\u000enCf\u0014WmS3s]\u0016d\u0017J\u001c3fq\u0012+7o\u0019:jaR|'\u000f\u0006\u0003\u0002&\u0005E\u0002\u0003B\u0011h\u0003O\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[i\u0015AB:dQ\u0016l\u0017-C\u0002t\u0003WAa!a\r\u0010\u0001\u0004\t\u0018aD5oI\u0016DH)Z:de&\u0004Ho\u001c:")
public final class TransactionBoundGraphStatistics {
    public static MinimumGraphStatistics apply(Read read, SchemaRead schemaRead, InternalLog log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(read, schemaRead, log);
    }

    public static MinimumGraphStatistics apply(TransactionalContext transactionalContext, InternalLog log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(transactionalContext, log);
    }

    private static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics,
    IndexDescriptorCompatibility {
        private final Read read;
        private final SchemaRead schemaRead;
        private final InternalLog log;

        @Override
        public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
            return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
        }

        @Override
        public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
            return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
        }

        @Override
        public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
        }

        @Override
        public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
            return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
        }

        @Override
        public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
        }

        @Override
        public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
        }

        public Option<Selectivity> uniqueValueSelectivity(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            Option option;
            try {
                Option<IndexDescriptor> maybeIndexDescriptor = this.maybeKernelIndexDescriptor(index);
                option = maybeIndexDescriptor.map((Function1 & Serializable)indexDescriptor -> {
                    Selectivity selectivity;
                    long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                    if (indexSize == 0L) {
                        selectivity = Selectivity$.MODULE$.ZERO();
                    } else {
                        double indexEntrySelectivity = $this.schemaRead.indexUniqueValuesSelectivity(indexDescriptor);
                        if (indexEntrySelectivity == 0.0) {
                            selectivity = Selectivity$.MODULE$.ZERO();
                        } else {
                            double frequencyOfEntitiesWithSameValue = 1.0 / indexEntrySelectivity;
                            double indexSelectivity = frequencyOfEntitiesWithSameValue / (double)indexSize;
                            selectivity = Selectivity$.MODULE$.apply(Math.min(indexSelectivity, 1.0));
                        }
                    }
                    return selectivity;
                });
            }
            catch (IndexNotFoundKernelException e) {
                this.log.debug("Index not found for uniqueValueSelectivity", (Throwable)e);
                option = None$.MODULE$;
            }
            return option;
        }

        public Option<Selectivity> indexPropertyIsNotNullSelectivity(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            None$ none$;
            block7: {
                try {
                    double d;
                    IndexDescriptor.EntityType entityType = index.entityType();
                    if (entityType instanceof IndexDescriptor.EntityType$.Node) {
                        IndexDescriptor.EntityType$.Node node = (IndexDescriptor.EntityType$.Node)entityType;
                        LabelId label = node.label();
                        d = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                    } else if (entityType instanceof IndexDescriptor.EntityType$.Relationship) {
                        IndexDescriptor.EntityType$.Relationship relationship = (IndexDescriptor.EntityType$.Relationship)entityType;
                        RelTypeId relType = relationship.relType();
                        d = this.read.countsForRelationshipWithoutTxState(-1, NameId$.MODULE$.toKernelEncode((NameId)relType), -1);
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    double entitiesCount = d;
                    if (entitiesCount == 0.0) {
                        none$ = new Some((Object)Selectivity$.MODULE$.ZERO());
                        break block7;
                    }
                    Option<IndexDescriptor> maybeIndexDescriptor = this.maybeKernelIndexDescriptor(index);
                    none$ = maybeIndexDescriptor.map((Function1 & Serializable)indexDescriptor -> {
                        long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                        double indexSelectivity = (double)indexSize / entitiesCount;
                        return Selectivity$.MODULE$.apply(Math.min(indexSelectivity, 1.0));
                    });
                }
                catch (IndexNotFoundKernelException e) {
                    this.log.debug("Index not found for indexPropertyExistsSelectivity", (Throwable)e);
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }

        public Cardinality nodesAllCardinality() {
            return new Cardinality((double)this.read.countsForNodeWithoutTxState(-1));
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> maybeLabelId) {
            long count = BoxesRunTime.unboxToLong((Object)maybeLabelId.map((Function1 & Serializable)labelId -> BoxesRunTime.boxToLong((long)this.read.countsForNodeWithoutTxState(labelId.id()))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            return new Cardinality((double)count);
        }

        public Cardinality patternStepCardinality(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return new Cardinality((double)this.read.countsForRelationshipWithoutTxState(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        private Option<IndexDescriptor> maybeKernelIndexDescriptor(org.neo4j.cypher.internal.planner.spi.IndexDescriptor indexDescriptor) {
            return Option$.MODULE$.apply((Object)this.schemaRead.index(this.cypherToKernelSchema(indexDescriptor), this.cypherToKernel(indexDescriptor.indexType()))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BaseTransactionBoundGraphStatistics.$anonfun$maybeKernelIndexDescriptor$1(x$1)));
        }

        public static final /* synthetic */ boolean $anonfun$maybeKernelIndexDescriptor$1(IndexDescriptor x$1) {
            IndexDescriptor indexDescriptor = x$1;
            IndexDescriptor indexDescriptor2 = IndexDescriptor.NO_INDEX;
            return indexDescriptor == null ? indexDescriptor2 != null : !indexDescriptor.equals(indexDescriptor2);
        }

        public BaseTransactionBoundGraphStatistics(Read read, SchemaRead schemaRead, InternalLog log) {
            this.read = read;
            this.schemaRead = schemaRead;
            this.log = log;
            IndexDescriptorCompatibility.$init$(this);
        }
    }
}

