/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CacheabilityInfo;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.MissingLabelNotification;
import org.neo4j.cypher.internal.compiler.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.compiler.MissingRelTypeNotification;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r}h\u0001B,Y\u0001\u0005D\u0001\"\u001b\u0001\u0003\u0006\u0004%\tA\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005W\"A!\u000f\u0001BC\u0002\u0013\u00051\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003u\u0011!A\bA!b\u0001\n\u0003I\b\"CA\n\u0001\t\u0005\t\u0015!\u0003{\u0011)\t)\u0002\u0001BC\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003O\u0001!\u0011!Q\u0001\n\u0005e\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003sA\u0001\"!,\u0001A\u0003%\u00111\b\u0005\b\u0003_\u0003A\u0011AAY\r\u0019\tI\u0006\u0001\u0003\u0002\\!Q\u0011QL\u0007\u0003\u0006\u0004%\t!a\u0018\t\u0013\u0005\u0005TB!A!\u0002\u0013q\bBCA2\u001b\t\u0015\r\u0011\"\u0001\u0002f!Q\u0011QN\u0007\u0003\u0002\u0003\u0006I!a\u001a\t\u000f\u0005%R\u0002\"\u0001\u0002p!A\u0011QO\u0007A\u0002\u0013%1\u000fC\u0005\u0002x5\u0001\r\u0011\"\u0003\u0002z!9\u0011QQ\u0007!B\u0013!\bbBAH\u001b\u0011\u0005\u0011\u0011\u0013\u0005\u0007\u0003'kA\u0011A:\t\u000f\u0005UU\u0002\"\u0001\u0002\u0018\"9\u00111U\u0007\u0005B\u0005\u0015\u0006bBAU\u001b\u0011\u0005\u00131\u0016\u0005\b\u0003s\u0003A\u0011AA^\u0011%\u0011i\u0001AI\u0001\n\u0003\u0011y\u0001C\u0004\u0003&\u0001!IAa\n\t\u000f\t=\u0002\u0001\"\u0003\u00032!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B)\u0001\u0011%!1\u000b\u0005\n\u0005?\u0002\u0011\u0013!C\u0005\u0005CBqA!\u001a\u0001\t\u0013\u00119\u0007C\u0005\u0003r\u0001\t\n\u0011\"\u0003\u0003b!9!1\u000f\u0001\u0005\n\tU\u0004b\u0002BD\u0001\u0011%!\u0011\u0012\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u0011y\n\u0001C\u0001\u0003c;qA!)Y\u0011\u0003\u0011\u0019K\u0002\u0004X1\"\u0005!Q\u0015\u0005\b\u0003SIC\u0011\u0001BT\r\u0019\u0011I+\u000b\"\u0003,\"Q!qY\u0016\u0003\u0016\u0004%\tA!3\t\u0015\tM7F!E!\u0002\u0013\u0011Y\r\u0003\u0006\u0003V.\u0012)\u001a!C\u0001\u0005/D!ba\u0005,\u0005#\u0005\u000b\u0011\u0002Bm\u0011)\u0019)b\u000bBK\u0002\u0013\u0005\u0011Q\r\u0005\u000b\u0007/Y#\u0011#Q\u0001\n\u0005\u001d\u0004bBA\u0015W\u0011\u00051\u0011\u0004\u0005\n\u0007GY\u0013\u0011!C\u0001\u0007KA\u0011b!\u000e,#\u0003%\taa\u000e\t\u0013\r}2&%A\u0005\u0002\r\u0005\u0003\"CB%WE\u0005I\u0011AB&\u0011%\u0019yeKA\u0001\n\u0003\u001a\t\u0006\u0003\u0005\u0004^-\n\t\u0011\"\u0001t\u0011%\u0019yfKA\u0001\n\u0003\u0019\t\u0007C\u0005\u0004f-\n\t\u0011\"\u0011\u0004h!I\u0011QS\u0016\u0002\u0002\u0013\u00051Q\u000f\u0005\n\u0007sZ\u0013\u0011!C!\u0007wB\u0011\"!+,\u0003\u0003%\t%a+\t\u0013\r=1&!A\u0005B\r}\u0004\"CARW\u0005\u0005I\u0011IBA\u000f%\u0019))KA\u0001\u0012\u0003\u00199IB\u0005\u0003*&\n\t\u0011#\u0001\u0004\n\"9\u0011\u0011F!\u0005\u0002\rU\u0005\"CB\b\u0003\u0006\u0005IQIB@\u0011%\u00199*QA\u0001\n\u0003\u001bI\nC\u0005\u0004*\u0006\u000b\t\u0011\"!\u0004,\"I1QY!\u0002\u0002\u0013%1q\u0019\u0005\n\u0007\u001fL#\u0019!C\u0001\u0007#D\u0001b!7*A\u0003%11\u001b\u0004\u0007\u0005;L\u0003Aa8\t\u0015\t\u0005\u0018J!b\u0001\n\u0013\u0011\u0019\u000f\u0003\u0006\u0003\u0000&\u0013\t\u0011)A\u0005\u0005KD\u0011b!\u0001J\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011\u0005%\u0012\n\"\u0001*\u0007\u0007Aq!!+J\t\u0003\nY\u000bC\u0004\u0002$&#\te!\u0003\t\u000f\r=\u0011\n\"\u0011\u0004\u0012\u001d911\\\u0015\t\u0002\ruga\u0002BoS!\u00051q\u001c\u0005\b\u0003S\u0011F\u0011ABq\u0011%\u0019\u0019O\u0015b\u0001\n\u000b\u00119\u000e\u0003\u0005\u0004fJ\u0003\u000bQ\u0002Bm\u0011\u001d\u00199/\u000bC\u0001\u0007S\u0014!\"U;fef\u001c\u0015m\u00195f\u0015\tI&,\u0001\u0005j]R,'O\\1m\u0015\tYF,\u0001\u0004dsBDWM\u001d\u0006\u0003;z\u000bQA\\3pi)T\u0011aX\u0001\u0004_J<7\u0001A\u000b\u0006E\u0006\u0005\u0012\u0011A\n\u0003\u0001\r\u0004\"\u0001Z4\u000e\u0003\u0015T\u0011AZ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0016\u0014a!\u00118z%\u00164\u0017\u0001D2bG\",g)Y2u_JLX#A6\u0011\u00051|W\"A7\u000b\u00059D\u0016!B2bG\",\u0017B\u00019n\u0005Q\u0019\u0015M\u001a4fS:,7)Y2iK\u001a\u000b7\r^8ss\u0006i1-Y2iK\u001a\u000b7\r^8ss\u0002\n1\"\\1yS6,XnU5{KV\tA\u000f\u0005\u0002ek&\u0011a/\u001a\u0002\u0004\u0013:$\u0018\u0001D7bq&lW/\\*ju\u0016\u0004\u0013aD:uC2,g.Z:t\u0007\u0006dG.\u001a:\u0016\u0003i\u00042a\u001f?\u007f\u001b\u0005A\u0016BA?Y\u0005M\u0001F.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s!\ry\u0018\u0011\u0001\u0007\u0001\t\u001d\t\u0019\u0001\u0001b\u0001\u0003\u000b\u0011\u0001#\u0012-F\u0007V#\u0016I\u0011'F?F+VIU-\u0012\t\u0005\u001d\u0011Q\u0002\t\u0004I\u0006%\u0011bAA\u0006K\n9aj\u001c;iS:<\u0007cA>\u0002\u0010%\u0019\u0011\u0011\u0003-\u0003!\r\u000b7\r[3bE&d\u0017\u000e^=J]\u001a|\u0017\u0001E:uC2,g.Z:t\u0007\u0006dG.\u001a:!\u0003\u0019!(/Y2feV\u0011\u0011\u0011\u0004\t\u0006w\u0006m\u0011qD\u0005\u0004\u0003;A&aC\"bG\",GK]1dKJ\u00042a`A\u0011\t\u001d\t\u0019\u0003\u0001b\u0001\u0003K\u0011\u0011\"U+F%f{6*R-\u0012\u0007\u0005\u001d1-A\u0004ue\u0006\u001cWM\u001d\u0011\u0002\rqJg.\u001b;?))\ti#a\f\u00022\u0005M\u0012Q\u0007\t\u0006w\u0002\tyB \u0005\u0006S&\u0001\ra\u001b\u0005\u0006e&\u0001\r\u0001\u001e\u0005\u0006q&\u0001\rA\u001f\u0005\b\u0003+I\u0001\u0019AA\r\u0003\u0015IgN\\3s+\t\tY\u0004\u0005\u0005\u0002>\u0005E\u0013qDA+\u001b\t\tyDC\u0002o\u0003\u0003RA!a\u0011\u0002F\u0005A1-\u00194gK&tWM\u0003\u0003\u0002H\u0005%\u0013\u0001\u00032f]6\fg.Z:\u000b\t\u0005-\u0013QJ\u0001\u0007O&$\b.\u001e2\u000b\u0005\u0005=\u0013aA2p[&!\u00111KA \u0005\u0015\u0019\u0015m\u00195f!\r\t9&D\u0007\u0002\u0001\tY1)Y2iK\u00124\u0016\r\\;f'\ti1-A\u0003wC2,X-F\u0001\u007f\u0003\u00191\u0018\r\\;fA\u0005y\"/Z2p[BLG.\u001a3XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8\u0016\u0005\u0005\u001d\u0004c\u00013\u0002j%\u0019\u00111N3\u0003\u000f\t{w\u000e\\3b]\u0006\u0001#/Z2p[BLG.\u001a3XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8!)\u0019\t)&!\u001d\u0002t!1\u0011Q\f\nA\u0002yDq!a\u0019\u0013\u0001\u0004\t9'A\u0007`]Vl'-\u001a:PM\"KGo]\u0001\u0012?:,XNY3s\u001f\u001aD\u0015\u000e^:`I\u0015\fH\u0003BA>\u0003\u0003\u00032\u0001ZA?\u0013\r\ty(\u001a\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0004R\t\t\u00111\u0001u\u0003\rAH%M\u0001\u000f?:,XNY3s\u001f\u001aD\u0015\u000e^:!Q\r)\u0012\u0011\u0012\t\u0004I\u0006-\u0015bAAGK\nAao\u001c7bi&dW-A\u0004nCJ\\\u0007*\u001b;\u0015\u0005\u0005m\u0014\u0001\u00048v[\n,'o\u00144ISR\u001c\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0014\u0011\u0014\u0005\b\u00037C\u0002\u0019AAO\u0003\u0015yG\u000f[3s!\r!\u0017qT\u0005\u0004\u0003C+'aA!os\u00061Q-];bYN$B!a\u001a\u0002(\"9\u00111T\rA\u0002\u0005u\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003Q\fa!\u001b8oKJ\u0004\u0013!D3ti&l\u0017\r^3e'&TX\r\u0006\u0002\u00024B\u0019A-!.\n\u0007\u0005]VM\u0001\u0003M_:<\u0017AF2p[B,H/Z%g\u0003\n\u001cXM\u001c;PeN#\u0018\r\\3\u0015\u0017y\fi,!1\u0002Z\u0006\r\u00181\u001f\u0005\b\u0003\u007f[\u0002\u0019AA\u0010\u0003!\tX/\u001a:z\u0017\u0016L\bbBAb7\u0001\u0007\u0011QY\u0001\u0003i\u000e\u0004B!a2\u0002V6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\fi-A\u0003rk\u0016\u0014\u0018P\u0003\u0003\u0002P\u0006E\u0017\u0001B5na2T1!a5]\u0003\u0019YWM\u001d8fY&!\u0011q[Ae\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yi\"9\u00111\\\u000eA\u0002\u0005u\u0017\u0001C2p[BLG.\u001a:\u0011\tm\fyN`\u0005\u0004\u0003CD&aI\"p[BLG.\u001a:XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8PaRLwN\u001c\u0005\b\u0003K\\\u0002\u0019AAt\u00039\u0011X\r\u001d7b]N#(/\u0019;fOf\u0004B!!;\u0002p6\u0011\u00111\u001e\u0006\u0004\u0003[D\u0016aB8qi&|gn]\u0005\u0005\u0003c\fYO\u0001\nDsBDWM\u001d*fa2\fgn\u00149uS>t\u0007\"CA{7A\u0005\t\u0019AA|\u0003!iW\r^1ECR\f\u0007\u0003BA}\u0005\u000fqA!a?\u0003\u0004A\u0019\u0011Q`3\u000e\u0005\u0005}(b\u0001B\u0001A\u00061AH]8pizJ1A!\u0002f\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0002B\u0006\u0005\u0019\u0019FO]5oO*\u0019!QA3\u0002A\r|W\u000e];uK&3\u0017IY:f]R|%o\u0015;bY\u0016$C-\u001a4bk2$H%N\u000b\u0003\u0005#QC!a>\u0003\u0014-\u0012!Q\u0003\t\u0005\u0005/\u0011\t#\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003%)hn\u00195fG.,GMC\u0002\u0003 \u0015\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019C!\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000ej]Z\fG.\u001b3O_RLg-[2bi&|g.\u0012=jgRLgn\u001a\u000b\u0007\u0003O\u0012IC!\f\t\u000f\t-R\u00041\u0001\u0002V\u0005Y1-Y2iK\u00124\u0016\r\\;f\u0011\u001d\t\u0019-\ba\u0001\u0003\u000b\fQ#[:J]Z\fG.\u001b3O_RLg-[2bi&|g\u000e\u0006\u0004\u0002h\tM\"1\t\u0005\b\u0005kq\u0002\u0019\u0001B\u001c\u00031qw\u000e^5gS\u000e\fG/[8o!\u0011\u0011IDa\u0010\u000e\u0005\tm\"b\u0001B\u001f1\u0006!Q\u000f^5m\u0013\u0011\u0011\tEa\u000f\u0003)%sG/\u001a:oC2tu\u000e^5gS\u000e\fG/[8o\u0011\u001d\t\u0019M\ba\u0001\u0003\u000b\faB]3d_6\u0004\u0018\u000e\\3Pe\u001e+G\u000fF\u0005\u007f\u0005\u0013\u0012YE!\u0014\u0003P!9!1F\u0010A\u0002\u0005U\u0003bBAn?\u0001\u0007\u0011Q\u001c\u0005\b\u0003\u007f{\u0002\u0019AA\u0010\u0011\u001d\t)p\ba\u0001\u0003o\fqbY8na&dW-\u00118e\u0007\u0006\u001c\u0007.\u001a\u000b\n}\nU#q\u000bB-\u00057Bq!a0!\u0001\u0004\ty\u0002C\u0004\u0002\\\u0002\u0002\r!!8\t\u000f\u0005U\b\u00051\u0001\u0002x\"I!Q\f\u0011\u0011\u0002\u0003\u0007\u0011qM\u0001\tQ&$8)Y2iK\u0006I2m\\7qS2,\u0017I\u001c3DC\u000eDW\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019G\u000b\u0003\u0002h\tM\u0011\u0001J2p[BLG.Z,ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\!oI\u000e\u000b7\r[3\u0015\u0013y\u0014IGa\u001b\u0003n\t=\u0004bBA`E\u0001\u0007\u0011q\u0004\u0005\b\u00037\u0014\u0003\u0019AAo\u0011\u001d\t)P\ta\u0001\u0003oD\u0011B!\u0018#!\u0003\u0005\r!a\u001a\u0002]\r|W\u000e]5mK^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]\u0006sGmQ1dQ\u0016$C-\u001a4bk2$H\u0005N\u0001.G>l\u0007/\u001b7f\u001fJ\u001cu.\u001c9jY\u0016<\u0016\u000e\u001e5FqB\u0014Xm]:j_:\u001cu\u000eZ3HK:\fe\u000eZ\"bG\",G#\u0003@\u0003x\te$1\u0011BC\u0011\u001d\ty\f\na\u0001\u0003?AqAa\u001f%\u0001\u0004\u0011i(A\u0004d_6\u0004\u0018\u000e\\3\u0011\t\u0011\u0014yH`\u0005\u0004\u0005\u0003+'!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\t)\u0010\na\u0001\u0003oDqA!\u0018%\u0001\u0004\t9'A\u0002iSR$rA BF\u0005\u001b\u0013\t\nC\u0004\u0002@\u0016\u0002\r!a\b\t\u000f\t=U\u00051\u0001\u0002V\u0005yQ\r_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010C\u0004\u0002v\u0016\u0002\r!a>\u0002\t5L7o\u001d\u000b\b}\n]%\u0011\u0014BO\u0011\u001d\tyL\na\u0001\u0003?AaAa''\u0001\u0004q\u0018A\u00058fo\u0016CXmY;uC\ndW-U;fefDq!!>'\u0001\u0004\t90A\u0003dY\u0016\f'/\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016\u0004\"a_\u0015\u0014\u0005%\u001aGC\u0001BR\u0005!\u0019\u0015m\u00195f\u0017\u0016LX\u0003\u0002BW\u0005\u001b\u001cbaK2\u00030\nU\u0006c\u00013\u00032&\u0019!1W3\u0003\u000fA\u0013x\u000eZ;diB!!q\u0017Ba\u001d\u0011\u0011IL!0\u000f\t\u0005u(1X\u0005\u0002M&\u0019!qX3\u0002\u000fA\f7m[1hK&!!1\u0019Bc\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\u0011y,Z\u0001\tcV,'/\u001f*faV\u0011!1\u001a\t\u0004\u007f\n5Ga\u0002BhW\t\u0007!\u0011\u001b\u0002\n#V+%+W0S\u000bB\u000bB!a\u0002\u0002\u001e\u0006I\u0011/^3ssJ+\u0007\u000fI\u0001\u0011a\u0006\u0014\u0018-\\3uKJ$\u0016\u0010]3NCB,\"A!7\u0011\u0007\tm\u0017*D\u0001*\u0005A\u0001\u0016M]1nKR,'\u000fV=qK6\u000b\u0007o\u0005\u0002JG\u0006I!/Z:vYRl\u0015\r]\u000b\u0003\u0005K\u0004\u0002Ba:\u0003p\u0006](1_\u0007\u0003\u0005STAA!\u0010\u0003l*\u0011!Q^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003r\n%(aA'baB!!Q\u001fB~\u001b\t\u00119P\u0003\u0003\u0003z\nm\u0012aB:z[\n|Gn]\u0005\u0005\u0005{\u00149P\u0001\u0006DsBDWM\u001d+za\u0016\f!B]3tk2$X*\u00199!\u0003%y\u0006.Y:i\u0007>$W\r\u0006\u0004\u0003Z\u000e\u00151q\u0001\u0005\b\u0005Cl\u0005\u0019\u0001Bs\u0011\u0019\u0019\t!\u0014a\u0001iR!\u0011qMB\u0006\u0011\u001d\u0019ia\u0014a\u0001\u0003;\u000b1a\u001c2k\u0003!!xn\u0015;sS:<GCAA|\u0003E\u0001\u0018M]1nKR,'\u000fV=qK6\u000b\u0007\u000fI\u0001\u0012ib\u001cF/\u0019;f\u0011\u0006\u001c8\t[1oO\u0016\u001c\u0018A\u0005;y'R\fG/\u001a%bg\u000eC\u0017M\\4fg\u0002\"\u0002ba\u0007\u0004\u001e\r}1\u0011\u0005\t\u0006\u00057\\#1\u001a\u0005\b\u0005\u000f\u0014\u0004\u0019\u0001Bf\u0011\u001d\u0011)N\ra\u0001\u00053Dqa!\u00063\u0001\u0004\t9'\u0001\u0003d_BLX\u0003BB\u0014\u0007[!\u0002b!\u000b\u00040\rE21\u0007\t\u0006\u00057\\31\u0006\t\u0004\u007f\u000e5Ba\u0002Bhg\t\u0007!\u0011\u001b\u0005\n\u0005\u000f\u001c\u0004\u0013!a\u0001\u0007WA\u0011B!64!\u0003\u0005\rA!7\t\u0013\rU1\u0007%AA\u0002\u0005\u001d\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0007s\u0019i$\u0006\u0002\u0004<)\"!1\u001aB\n\t\u001d\u0011y\r\u000eb\u0001\u0005#\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u0004D\r\u001dSCAB#U\u0011\u0011INa\u0005\u0005\u000f\t=WG1\u0001\u0003R\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aT\u0003\u0002B1\u0007\u001b\"qAa47\u0005\u0004\u0011\t.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007'\u0002Ba!\u0016\u0004\\5\u00111q\u000b\u0006\u0005\u00073\u0012Y/\u0001\u0003mC:<\u0017\u0002\u0002B\u0005\u0007/\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001e\u000e\r\u0004\u0002CABs\u0005\u0005\t\u0019\u0001;\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u001b\u0011\r\r-4\u0011OAO\u001b\t\u0019iGC\u0002\u0004p\u0015\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019h!\u001c\u0003\u0011%#XM]1u_J$B!a\u001a\u0004x!I\u00111Q\u001e\u0002\u0002\u0003\u0007\u0011QT\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0004T\ru\u0004\u0002CABy\u0005\u0005\t\u0019\u0001;\u0015\u0005\rMC\u0003BA4\u0007\u0007C\u0011\"a!@\u0003\u0003\u0005\r!!(\u0002\u0011\r\u000b7\r[3LKf\u00042Aa7B'\u0011\t5ma#\u0011\t\r551S\u0007\u0003\u0007\u001fSAa!%\u0003l\u0006\u0011\u0011n\\\u0005\u0005\u0005\u0007\u001cy\t\u0006\u0002\u0004\b\u0006)\u0011\r\u001d9msV!11TBQ)!\u0019ija)\u0004&\u000e\u001d\u0006#\u0002BnW\r}\u0005cA@\u0004\"\u00129!q\u001a#C\u0002\tE\u0007b\u0002Bd\t\u0002\u00071q\u0014\u0005\b\u0005+$\u0005\u0019\u0001Bm\u0011\u001d\u0019)\u0002\u0012a\u0001\u0003O\nq!\u001e8baBd\u00170\u0006\u0003\u0004.\u000euF\u0003BBX\u0007\u007f\u0003R\u0001ZBY\u0007kK1aa-f\u0005\u0019y\u0005\u000f^5p]BIAma.\u0004<\ne\u0017qM\u0005\u0004\u0007s+'A\u0002+va2,7\u0007E\u0002\u0000\u0007{#qAa4F\u0005\u0004\u0011\t\u000eC\u0005\u0004B\u0016\u000b\t\u00111\u0001\u0004D\u0006\u0019\u0001\u0010\n\u0019\u0011\u000b\tm7fa/\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r%\u0007\u0003BB+\u0007\u0017LAa!4\u0004X\t1qJ\u00196fGR\f1BT(U?B\u0013ViU#O)V\u001111\u001b\t\u0004w\u000eU\u0017bABl1\nyQ\t_3dkR\f'\r\\3Rk\u0016\u0014\u00180\u0001\u0007O\u001fR{\u0006KU#T\u000b:#\u0006%\u0001\tQCJ\fW.\u001a;feRK\b/Z'baB\u0019!1\u001c*\u0014\u0005I\u001bGCABo\u0003\u0015)W\u000e\u001d;z\u0003\u0019)W\u000e\u001d;zA\u00059R\r\u001f;sC\u000e$\b+\u0019:b[\u0016$XM\u001d+za\u0016l\u0015\r\u001d\u000b\u0005\u00053\u001cY\u000fC\u0004\u0004nZ\u0003\raa<\u0002\u00115\f\u0007OV1mk\u0016\u0004Ba!=\u0004|6\u001111\u001f\u0006\u0005\u0007k\u001c90A\u0004wSJ$X/\u00197\u000b\u0007\reH,\u0001\u0004wC2,Xm]\u0005\u0005\u0007{\u001c\u0019P\u0001\u0005NCB4\u0016\r\\;f\u0001")
public class QueryCache<QUERY_KEY, EXECUTABLE_QUERY extends CacheabilityInfo> {
    private final CaffeineCacheFactory cacheFactory;
    private final int maximumSize;
    private final PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller;
    private final CacheTracer<QUERY_KEY> tracer;
    private final Cache<QUERY_KEY, CachedValue> inner;

    public static ParameterTypeMap extractParameterTypeMap(MapValue mapValue) {
        return QueryCache$.MODULE$.extractParameterTypeMap(mapValue);
    }

    public static ExecutableQuery NOT_PRESENT() {
        return QueryCache$.MODULE$.NOT_PRESENT();
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public int maximumSize() {
        return this.maximumSize;
    }

    public PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller() {
        return this.stalenessCaller;
    }

    public CacheTracer<QUERY_KEY> tracer() {
        return this.tracer;
    }

    private Cache<QUERY_KEY, CachedValue> inner() {
        return this.inner;
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public EXECUTABLE_QUERY computeIfAbsentOrStale(QUERY_KEY queryKey, TransactionalContext tc, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, CypherReplanOption replanStrategy, String metaData) {
        CacheabilityInfo cacheabilityInfo;
        if (this.maximumSize() == 0) {
            CacheabilityInfo result = (CacheabilityInfo)compiler.compile();
            this.tracer().queryCompile(queryKey, metaData);
            cacheabilityInfo = result;
        } else {
            EXECUTABLE_QUERY EXECUTABLE_QUERY;
            CachedValue cachedValue = (CachedValue)this.inner().getIfPresent(queryKey);
            ExecutableQuery executableQuery = QueryCache$.MODULE$.NOT_PRESENT();
            CachedValue cachedValue2 = cachedValue;
            if (!(executableQuery != null ? !executableQuery.equals(cachedValue2) : cachedValue2 != null)) {
                CypherReplanOption cypherReplanOption = replanStrategy;
                CypherReplanOption.force$ force$2 = CypherReplanOption.force$.MODULE$;
                EXECUTABLE_QUERY = !(cypherReplanOption != null ? !cypherReplanOption.equals(force$2) : force$2 != null) ? this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4()) : this.compileAndCache(queryKey, compiler, metaData, this.compileAndCache$default$4());
            } else {
                EXECUTABLE_QUERY EXECUTABLE_QUERY2;
                cachedValue.markHit();
                CypherReplanOption cypherReplanOption = replanStrategy;
                if (CypherReplanOption.force$.MODULE$.equals(cypherReplanOption)) {
                    EXECUTABLE_QUERY2 = this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4());
                } else if (CypherReplanOption.skip$.MODULE$.equals(cypherReplanOption)) {
                    EXECUTABLE_QUERY2 = this.hit(queryKey, cachedValue, metaData);
                } else if (CypherReplanOption.default$.MODULE$.equals(cypherReplanOption)) {
                    EXECUTABLE_QUERY EXECUTABLE_QUERY3;
                    Staleness staleness = this.stalenessCaller().staleness(tc, cachedValue.value());
                    if (NotStale$.MODULE$.equals(staleness)) {
                        EXECUTABLE_QUERY3 = this.invalidNotificationExisting(cachedValue, tc) ? this.compileAndCache(queryKey, compiler, metaData, true) : this.recompileOrGet(cachedValue, compiler, queryKey, metaData);
                    } else if (staleness instanceof Stale) {
                        Stale stale = (Stale)staleness;
                        int secondsSincePlan = stale.secondsSincePlan();
                        Option<String> maybeReason = stale.maybeReason();
                        this.tracer().queryCacheStale(queryKey, secondsSincePlan, metaData, maybeReason);
                        EXECUTABLE_QUERY3 = cachedValue.recompiledWithExpressionCodeGen() ? this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4()) : this.compileAndCache(queryKey, compiler, metaData, this.compileAndCache$default$4());
                    } else {
                        throw new MatchError((Object)staleness);
                    }
                    EXECUTABLE_QUERY2 = EXECUTABLE_QUERY3;
                } else {
                    throw new MatchError((Object)cypherReplanOption);
                }
                EXECUTABLE_QUERY = EXECUTABLE_QUERY2;
            }
            cacheabilityInfo = EXECUTABLE_QUERY;
        }
        return (EXECUTABLE_QUERY)cacheabilityInfo;
    }

    public String computeIfAbsentOrStale$default$5() {
        return "";
    }

    private boolean invalidNotificationExisting(CachedValue cachedValue, TransactionalContext tc) {
        IndexedSeq<InternalNotification> notifications = cachedValue.value().notifications();
        for (int i = 0; i < notifications.length(); ++i) {
            if (!this.isInvalidNotification((InternalNotification)notifications.apply(i), tc)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidNotification(InternalNotification notification, TransactionalContext tc) {
        boolean bl;
        InternalNotification internalNotification = notification;
        if (internalNotification instanceof MissingLabelNotification) {
            MissingLabelNotification missingLabelNotification = (MissingLabelNotification)internalNotification;
            bl = tc.kernelTransaction().tokenRead().nodeLabel(missingLabelNotification.label()) != -1;
        } else if (internalNotification instanceof MissingRelTypeNotification) {
            MissingRelTypeNotification missingRelTypeNotification = (MissingRelTypeNotification)internalNotification;
            bl = tc.kernelTransaction().tokenRead().relationshipType(missingRelTypeNotification.relType()) != -1;
        } else if (internalNotification instanceof MissingPropertyNameNotification) {
            MissingPropertyNameNotification missingPropertyNameNotification = (MissingPropertyNameNotification)internalNotification;
            bl = tc.kernelTransaction().tokenRead().propertyKey(missingPropertyNameNotification.name()) != -1;
        } else {
            bl = false;
        }
        return bl;
    }

    private EXECUTABLE_QUERY recompileOrGet(CachedValue cachedValue, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, QUERY_KEY queryKey, String metaData) {
        CachedValue cachedValue2;
        this.tracer().queryCacheHit(queryKey, metaData);
        if (!cachedValue.recompiledWithExpressionCodeGen()) {
            CachedValue cachedValue3;
            Option<EXECUTABLE_QUERY> option = compiler.maybeCompileWithExpressionCodeGen(cachedValue.numberOfHits());
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheabilityInfo recompiledQuery = (CacheabilityInfo)some.value();
                this.tracer().queryCompileWithExpressionCodeGen(queryKey, metaData);
                CachedValue recompiled = new CachedValue(this, recompiledQuery, true);
                this.inner().put(queryKey, (Object)recompiled);
                cachedValue3 = recompiled;
            } else if (None$.MODULE$.equals(option)) {
                cachedValue3 = cachedValue;
            } else {
                throw new MatchError(option);
            }
            cachedValue2 = cachedValue3;
        } else {
            cachedValue2 = cachedValue;
        }
        CachedValue newCachedValue = cachedValue2;
        return newCachedValue.value();
    }

    private EXECUTABLE_QUERY compileAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compile(), metaData, hitCache);
        this.tracer().queryCompile(queryKey, metaData);
        return result;
    }

    private boolean compileAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compileWithExpressionCodeGen(), metaData, hitCache);
        this.tracer().queryCompileWithExpressionCodeGen(queryKey, metaData);
        return result;
    }

    private boolean compileWithExpressionCodeGenAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileOrCompileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, Function0<EXECUTABLE_QUERY> compile, String metaData, boolean hitCache) {
        CacheabilityInfo cacheabilityInfo;
        CacheabilityInfo newExecutableQuery = (CacheabilityInfo)compile.apply();
        if (newExecutableQuery.shouldBeCached()) {
            CachedValue cachedValue = new CachedValue(this, newExecutableQuery, false);
            this.inner().put(queryKey, (Object)cachedValue);
            cacheabilityInfo = hitCache ? this.hit(queryKey, cachedValue, metaData) : this.miss(queryKey, newExecutableQuery, metaData);
        } else {
            cacheabilityInfo = this.miss(queryKey, newExecutableQuery, metaData);
        }
        return (EXECUTABLE_QUERY)cacheabilityInfo;
    }

    private EXECUTABLE_QUERY hit(QUERY_KEY queryKey, CachedValue executableQuery, String metaData) {
        this.tracer().queryCacheHit(queryKey, metaData);
        return executableQuery.value();
    }

    private EXECUTABLE_QUERY miss(QUERY_KEY queryKey, EXECUTABLE_QUERY newExecutableQuery, String metaData) {
        this.tracer().queryCacheMiss(queryKey, metaData);
        return newExecutableQuery;
    }

    /*
     * WARNING - void declaration
     */
    public long clear() {
        void var1_1;
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer().queryCacheFlush(priorSize);
        return (long)var1_1;
    }

    public QueryCache(CaffeineCacheFactory cacheFactory, int maximumSize, PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller, CacheTracer<QUERY_KEY> tracer) {
        this.cacheFactory = cacheFactory;
        this.maximumSize = maximumSize;
        this.stalenessCaller = stalenessCaller;
        this.tracer = tracer;
        this.inner = cacheFactory.createCache(maximumSize);
    }

    public static final class CacheKey<QUERY_REP>
    implements Product,
    Serializable {
        private final QUERY_REP queryRep;
        private final ParameterTypeMap parameterTypeMap;
        private final boolean txStateHasChanges;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public QUERY_REP queryRep() {
            return this.queryRep;
        }

        public ParameterTypeMap parameterTypeMap() {
            return this.parameterTypeMap;
        }

        public boolean txStateHasChanges() {
            return this.txStateHasChanges;
        }

        public <QUERY_REP> CacheKey<QUERY_REP> copy(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            return new CacheKey<QUERY_REP>(queryRep, parameterTypeMap, txStateHasChanges);
        }

        public <QUERY_REP> QUERY_REP copy$default$1() {
            return this.queryRep();
        }

        public <QUERY_REP> ParameterTypeMap copy$default$2() {
            return this.parameterTypeMap();
        }

        public <QUERY_REP> boolean copy$default$3() {
            return this.txStateHasChanges();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            return switch (n) {
                case 0 -> this.queryRep();
                case 1 -> this.parameterTypeMap();
                case 2 -> BoxesRunTime.boxToBoolean((boolean)this.txStateHasChanges());
                default -> Statics.ioobe((int)x$1);
            };
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            return switch (n) {
                case 0 -> "queryRep";
                case 1 -> "parameterTypeMap";
                case 2 -> "txStateHasChanges";
                default -> (String)Statics.ioobe((int)x$1);
            };
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryRep()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parameterTypeMap()));
            n = Statics.mix((int)n, (int)(this.txStateHasChanges() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            if (this.txStateHasChanges() != cacheKey.txStateHasChanges()) return false;
            if (!BoxesRunTime.equals(this.queryRep(), cacheKey.queryRep())) return false;
            ParameterTypeMap parameterTypeMap = this.parameterTypeMap();
            ParameterTypeMap parameterTypeMap2 = cacheKey.parameterTypeMap();
            if (parameterTypeMap != null) {
                if (!((Object)parameterTypeMap).equals(parameterTypeMap2)) return false;
                return true;
            }
            if (parameterTypeMap2 == null) return true;
            return false;
        }

        public CacheKey(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            this.queryRep = queryRep;
            this.parameterTypeMap = parameterTypeMap;
            this.txStateHasChanges = txStateHasChanges;
            Product.$init$((Product)this);
        }
    }

    private class CachedValue {
        private final EXECUTABLE_QUERY value;
        private final boolean recompiledWithExpressionCodeGen;
        private volatile int _numberOfHits;
        public final /* synthetic */ QueryCache $outer;

        public EXECUTABLE_QUERY value() {
            return this.value;
        }

        public boolean recompiledWithExpressionCodeGen() {
            return this.recompiledWithExpressionCodeGen;
        }

        private int _numberOfHits() {
            return this._numberOfHits;
        }

        private void _numberOfHits_$eq(int x$1) {
            this._numberOfHits = x$1;
        }

        public void markHit() {
            block0: {
                if (this.recompiledWithExpressionCodeGen()) break block0;
                this._numberOfHits_$eq(this._numberOfHits() + 1);
            }
        }

        public int numberOfHits() {
            return this._numberOfHits();
        }

        public boolean canEqual(Object other) {
            return other instanceof CachedValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CachedValue)) return false;
            if (((CachedValue)object).org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() != this.org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer()) return false;
            CachedValue cachedValue = (CachedValue)object;
            if (!cachedValue.canEqual(this)) return false;
            Object EXECUTABLE_QUERY = this.value();
            Object EXECUTABLE_QUERY2 = cachedValue.value();
            if (EXECUTABLE_QUERY != null) {
                if (!EXECUTABLE_QUERY.equals(EXECUTABLE_QUERY2)) return false;
                return true;
            }
            if (EXECUTABLE_QUERY2 == null) return true;
            return false;
        }

        public int hashCode() {
            Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CacheabilityInfo[]{this.value()}));
            return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
        }

        public /* synthetic */ QueryCache org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public CachedValue(EXECUTABLE_QUERY value, boolean recompiledWithExpressionCodeGen) {
            this.value = value;
            this.recompiledWithExpressionCodeGen = recompiledWithExpressionCodeGen;
            if ($outer == null) {
                throw null;
            }
            this.$outer = (QueryCache)$outer;
            this._numberOfHits = 0;
        }
    }

    public static class ParameterTypeMap {
        private final Map<String, CypherType> resultMap;
        private final int _hashCode;

        private Map<String, CypherType> resultMap() {
            return this.resultMap;
        }

        public int hashCode() {
            return this._hashCode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            Object object = obj;
            if (!(object instanceof ParameterTypeMap)) return false;
            ParameterTypeMap parameterTypeMap = (ParameterTypeMap)object;
            if (this.resultMap().size() != parameterTypeMap.resultMap().size()) return false;
            Map<String, CypherType> otherMap = parameterTypeMap.resultMap();
            java.util.Iterator<Map.Entry<String, CypherType>> entries = otherMap.entrySet().iterator();
            boolean stillEqual = true;
            while (entries.hasNext()) {
                if (!stillEqual) return stillEqual;
                Map.Entry<String, CypherType> entry = entries.next();
                String otherKey = entry.getKey();
                CypherType otherValue = entry.getValue();
                CypherType value = this.resultMap().get(otherKey);
                stillEqual = otherValue.equals((Object)value);
            }
            return stillEqual;
        }

        public String toString() {
            return CollectionConverters$.MODULE$.MapHasAsScala(this.resultMap()).asScala().toString();
        }

        public ParameterTypeMap(Map<String, CypherType> resultMap, int _hashCode) {
            this.resultMap = resultMap;
            this._hashCode = _hashCode;
        }
    }
}

