/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.CreateDatabaseOptions;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.cypher.internal.OptionsConverter;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class CreateDatabaseOptionsConverter$
implements OptionsConverter<CreateDatabaseOptions>,
Product,
Serializable {
    public static final CreateDatabaseOptionsConverter$ MODULE$ = new CreateDatabaseOptionsConverter$();
    private static final String EXISTING_DATA;
    private static final String EXISTING_SEED_INSTANCE;
    private static final String NUM_PRIMARIES;
    private static final String NUM_SECONDARIES;
    private static final String STORE_FORMAT;
    private static final String SEED_URI;
    private static final String SEED_CREDENTIALS;
    private static final String SEED_CONFIG;
    private static final String VISIBLE_PERMITTED_OPTIONS;
    private static final String USE_EXISTING_DATA;
    private static ExpressionEvaluator evaluator;

    static {
        OptionsConverter.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
        EXISTING_DATA = "existingData";
        EXISTING_SEED_INSTANCE = "existingDataSeedInstance";
        NUM_PRIMARIES = "primaries";
        NUM_SECONDARIES = "secondaries";
        STORE_FORMAT = "storeFormat";
        SEED_URI = "seedURI";
        SEED_CREDENTIALS = "seedCredentials";
        SEED_CONFIG = "seedConfig";
        VISIBLE_PERMITTED_OPTIONS = "'" + MODULE$.EXISTING_DATA() + "', '" + MODULE$.EXISTING_SEED_INSTANCE() + "', '" + MODULE$.STORE_FORMAT() + "'";
        USE_EXISTING_DATA = "use";
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public AnyValue evaluate(Expression expression, MapValue params) {
        return OptionsConverter.evaluate$(this, expression, params);
    }

    @Override
    public Option<CreateDatabaseOptions> convert(Options options, MapValue params) {
        return OptionsConverter.convert$(this, options, params);
    }

    @Override
    public ExpressionEvaluator evaluator() {
        return evaluator;
    }

    @Override
    public void org$neo4j$cypher$internal$OptionsConverter$_setter_$evaluator_$eq(ExpressionEvaluator x$1) {
        evaluator = x$1;
    }

    public String EXISTING_DATA() {
        return EXISTING_DATA;
    }

    public String EXISTING_SEED_INSTANCE() {
        return EXISTING_SEED_INSTANCE;
    }

    public String NUM_PRIMARIES() {
        return NUM_PRIMARIES;
    }

    public String NUM_SECONDARIES() {
        return NUM_SECONDARIES;
    }

    public String STORE_FORMAT() {
        return STORE_FORMAT;
    }

    public String SEED_URI() {
        return SEED_URI;
    }

    public String SEED_CREDENTIALS() {
        return SEED_CREDENTIALS;
    }

    public String SEED_CONFIG() {
        return SEED_CONFIG;
    }

    public String VISIBLE_PERMITTED_OPTIONS() {
        return VISIBLE_PERMITTED_OPTIONS;
    }

    public String USE_EXISTING_DATA() {
        return USE_EXISTING_DATA;
    }

    @Override
    public CreateDatabaseOptions convert(MapValue map) {
        return MapValueOps$.MODULE$.Ops(map).foldLeft(new CreateDatabaseOptions((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            CreateDatabaseOptions createDatabaseOptions;
            AnyValue value;
            String key;
            CreateDatabaseOptions ops;
            block15: {
                block17: {
                    AnyValue anyValue;
                    TextValue textValue;
                    boolean bl;
                    block16: {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        ops = (CreateDatabaseOptions)tuple2._1();
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        if (tuple22 == null) throw new MatchError((Object)tuple2);
                        key = (String)tuple22._1();
                        value = (AnyValue)tuple22._2();
                        if (!key.equalsIgnoreCase(MODULE$.EXISTING_DATA())) break block15;
                        bl = false;
                        textValue = null;
                        anyValue = value;
                        if (!(anyValue instanceof TextValue)) break block16;
                        bl = true;
                        textValue = (TextValue)anyValue;
                        if (MODULE$.USE_EXISTING_DATA().equalsIgnoreCase(textValue.stringValue())) break block17;
                    }
                    if (bl) {
                        throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.EXISTING_DATA() + " '" + textValue.stringValue() + "'. Expected '" + MODULE$.USE_EXISTING_DATA() + "'.");
                    }
                    if (anyValue == null) throw new MatchError((Object)anyValue);
                    AnyValue anyValue2 = anyValue;
                    throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.EXISTING_DATA() + " '" + anyValue2 + "'. Expected '" + MODULE$.USE_EXISTING_DATA() + "'.");
                }
                CreateDatabaseOptions createDatabaseOptions2 = ops.copy((Option<String>)new Some((Object)MODULE$.USE_EXISTING_DATA()), ops.copy$default$2(), ops.copy$default$3(), ops.copy$default$4(), ops.copy$default$5(), ops.copy$default$6(), ops.copy$default$7(), ops.copy$default$8());
                createDatabaseOptions = createDatabaseOptions2;
                return createDatabaseOptions;
            }
            if (key.equalsIgnoreCase(MODULE$.EXISTING_SEED_INSTANCE())) {
                AnyValue anyValue = value;
                if (!(anyValue instanceof TextValue)) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.EXISTING_SEED_INSTANCE() + " '" + value + "'. Expected server uuid string.");
                TextValue textValue = (TextValue)anyValue;
                Some x$1 = new Some((Object)textValue.stringValue());
                Option<String> x$2 = ops.copy$default$1();
                Option<Integer> x$3 = ops.copy$default$3();
                Option<Integer> x$4 = ops.copy$default$4();
                Option<String> x$5 = ops.copy$default$5();
                Option<String> x$6 = ops.copy$default$6();
                Option<String> x$7 = ops.copy$default$7();
                Option<String> x$8 = ops.copy$default$8();
                CreateDatabaseOptions createDatabaseOptions3 = ops.copy(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                createDatabaseOptions = createDatabaseOptions3;
                return createDatabaseOptions;
            }
            if (key.equalsIgnoreCase(MODULE$.NUM_PRIMARIES())) {
                AnyValue anyValue = value;
                if (!(anyValue instanceof IntegralValue)) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.NUM_PRIMARIES() + " '" + value + "'. Expected positive integer number of primaries.");
                IntegralValue integralValue = (IntegralValue)anyValue;
                if (integralValue.longValue() < 1L) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.NUM_PRIMARIES() + " '" + value + "'. Expected positive integer number of primaries.");
                Some x$9 = new Some((Object)Predef$.MODULE$.int2Integer((int)integralValue.longValue()));
                Option<String> x$10 = ops.copy$default$1();
                Option<String> x$11 = ops.copy$default$2();
                Option<Integer> x$12 = ops.copy$default$4();
                Option<String> x$13 = ops.copy$default$5();
                Option<String> x$14 = ops.copy$default$6();
                Option<String> x$15 = ops.copy$default$7();
                Option<String> x$16 = ops.copy$default$8();
                CreateDatabaseOptions createDatabaseOptions4 = ops.copy(x$10, x$11, (Option<Integer>)x$9, x$12, x$13, x$14, x$15, x$16);
                createDatabaseOptions = createDatabaseOptions4;
                return createDatabaseOptions;
            }
            if (key.equalsIgnoreCase(MODULE$.NUM_SECONDARIES())) {
                AnyValue anyValue = value;
                if (!(anyValue instanceof IntegralValue)) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.NUM_SECONDARIES() + " '" + value + "'. Expected non-negative integer number of secondaries.");
                IntegralValue integralValue = (IntegralValue)anyValue;
                if (integralValue.longValue() < 0L) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.NUM_SECONDARIES() + " '" + value + "'. Expected non-negative integer number of secondaries.");
                Some x$17 = new Some((Object)Predef$.MODULE$.int2Integer((int)integralValue.longValue()));
                Option<String> x$18 = ops.copy$default$1();
                Option<String> x$19 = ops.copy$default$2();
                Option<Integer> x$20 = ops.copy$default$3();
                Option<String> x$21 = ops.copy$default$5();
                Option<String> x$22 = ops.copy$default$6();
                Option<String> x$23 = ops.copy$default$7();
                Option<String> x$24 = ops.copy$default$8();
                CreateDatabaseOptions createDatabaseOptions5 = ops.copy(x$18, x$19, x$20, (Option<Integer>)x$17, x$21, x$22, x$23, x$24);
                createDatabaseOptions = createDatabaseOptions5;
                return createDatabaseOptions;
            }
            if (key.equalsIgnoreCase(MODULE$.STORE_FORMAT())) {
                CreateDatabaseOptions createDatabaseOptions6;
                AnyValue anyValue = value;
                if (!(anyValue instanceof TextValue)) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.STORE_FORMAT() + " '" + value + "', String expected.");
                TextValue textValue = (TextValue)anyValue;
                try {
                    StorageEngineFactory.selectStorageEngine((Configuration)Config.defaults((Setting)GraphDatabaseSettings.db_format, (Object)textValue.stringValue()));
                    Some x$25 = new Some((Object)textValue.stringValue());
                    Option<String> x$26 = ops.copy$default$1();
                    Option<String> x$27 = ops.copy$default$2();
                    Option<Integer> x$28 = ops.copy$default$3();
                    Option<Integer> x$29 = ops.copy$default$4();
                    Option<String> x$30 = ops.copy$default$6();
                    Option<String> x$31 = ops.copy$default$7();
                    Option<String> x$32 = ops.copy$default$8();
                    createDatabaseOptions6 = ops.copy(x$26, x$27, x$28, x$29, (Option<String>)x$25, x$30, x$31, x$32);
                }
                catch (Exception exception) {
                    throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.STORE_FORMAT() + " '" + textValue.stringValue() + "'. Unknown format, supported formats are " + "'aligned', 'standard' or 'high_limit'");
                }
                CreateDatabaseOptions createDatabaseOptions7 = createDatabaseOptions6;
                createDatabaseOptions = createDatabaseOptions7;
                return createDatabaseOptions;
            }
            if (key.equalsIgnoreCase(MODULE$.SEED_URI())) {
                AnyValue anyValue = value;
                if (!(anyValue instanceof TextValue)) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.SEED_URI() + " '" + value + "', String expected.");
                TextValue textValue = (TextValue)anyValue;
                Some x$33 = new Some((Object)textValue.stringValue());
                Option<String> x$34 = ops.copy$default$1();
                Option<String> x$35 = ops.copy$default$2();
                Option<Integer> x$36 = ops.copy$default$3();
                Option<Integer> x$37 = ops.copy$default$4();
                Option<String> x$38 = ops.copy$default$5();
                Option<String> x$39 = ops.copy$default$7();
                Option<String> x$40 = ops.copy$default$8();
                CreateDatabaseOptions createDatabaseOptions8 = ops.copy(x$34, x$35, x$36, x$37, x$38, (Option<String>)x$33, x$39, x$40);
                createDatabaseOptions = createDatabaseOptions8;
                return createDatabaseOptions;
            } else if (key.equalsIgnoreCase(MODULE$.SEED_CREDENTIALS())) {
                AnyValue anyValue = value;
                if (!(anyValue instanceof TextValue)) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.SEED_CREDENTIALS() + " '" + value + "', String expected.");
                TextValue textValue = (TextValue)anyValue;
                Some x$41 = new Some((Object)textValue.stringValue());
                Option<String> x$42 = ops.copy$default$1();
                Option<String> x$43 = ops.copy$default$2();
                Option<Integer> x$44 = ops.copy$default$3();
                Option<Integer> x$45 = ops.copy$default$4();
                Option<String> x$46 = ops.copy$default$5();
                Option<String> x$47 = ops.copy$default$6();
                Option<String> x$48 = ops.copy$default$8();
                CreateDatabaseOptions createDatabaseOptions9 = ops.copy(x$42, x$43, x$44, x$45, x$46, x$47, (Option<String>)x$41, x$48);
                createDatabaseOptions = createDatabaseOptions9;
                return createDatabaseOptions;
            } else {
                if (!key.equalsIgnoreCase(MODULE$.SEED_CONFIG())) throw new InvalidArgumentsException("Could not create database with unrecognised option: '" + key + "'. Expected " + MODULE$.VISIBLE_PERMITTED_OPTIONS() + ".");
                AnyValue anyValue = value;
                if (!(anyValue instanceof TextValue)) throw new InvalidArgumentsException("Could not create database with specified " + MODULE$.SEED_CONFIG() + " '" + value + "', String expected.");
                TextValue textValue = (TextValue)anyValue;
                Some x$49 = new Some((Object)textValue.stringValue());
                Option<String> x$50 = ops.copy$default$1();
                Option<String> x$51 = ops.copy$default$2();
                Option<Integer> x$52 = ops.copy$default$3();
                Option<Integer> x$53 = ops.copy$default$4();
                Option<String> x$54 = ops.copy$default$5();
                Option<String> x$55 = ops.copy$default$6();
                Option<String> x$56 = ops.copy$default$7();
                CreateDatabaseOptions createDatabaseOptions10 = ops.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$56, (Option<String>)x$49);
                createDatabaseOptions = createDatabaseOptions10;
            }
            return createDatabaseOptions;
        });
    }

    @Override
    public String operation() {
        return "create database";
    }

    public String productPrefix() {
        return "CreateDatabaseOptionsConverter";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateDatabaseOptionsConverter$;
    }

    public int hashCode() {
        return 1416679801;
    }

    public String toString() {
        return "CreateDatabaseOptionsConverter";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CreateDatabaseOptionsConverter$.class);
    }

    private CreateDatabaseOptionsConverter$() {
    }
}

