/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime;
import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime$;
import org.neo4j.cypher.internal.CommunityRuntimeContext;
import org.neo4j.cypher.internal.CommunityRuntimeContextManager;
import org.neo4j.cypher.internal.CommunityRuntimeFactory$;
import org.neo4j.cypher.internal.Compiler;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CypherCurrentCompiler;
import org.neo4j.cypher.internal.CypherRuntimeConfiguration;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler$;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.compiler.phases.Compatibility3_5$;
import org.neo4j.cypher.internal.compiler.phases.Compatibility4_2$;
import org.neo4j.cypher.internal.compiler.phases.Compatibility4_3$;
import org.neo4j.cypher.internal.compiler.phases.CypherCompatibilityVersion;
import org.neo4j.cypher.internal.options.CypherPlannerOption;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.options.CypherUpdateStrategy;
import org.neo4j.cypher.internal.options.CypherVersion;
import org.neo4j.cypher.internal.planning.CypherPlanner;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\u0007\u000e\u0001YA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!i\u0004A!A!\u0002\u0013q\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b!\u0003A\u0011A%\t\u000fE\u0003!\u0019!C\u0005%\"1a\u000b\u0001Q\u0001\nMCQa\u0016\u0001\u0005BaCQ\u0001\u0018\u0001\u0005Bu\u0013\u0001dQ8n[Vt\u0017\u000e^=D_6\u0004\u0018\u000e\\3s\r\u0006\u001cGo\u001c:z\u0015\tqq\"\u0001\u0005j]R,'O\\1m\u0015\t\u0001\u0012#\u0001\u0004dsBDWM\u001d\u0006\u0003%M\tQA\\3pi)T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001f?5\tQ\"\u0003\u0002!\u001b\ty1i\\7qS2,'OR1di>\u0014\u00180A\u0003he\u0006\u0004\b\u000e\u0005\u0002$M5\tAE\u0003\u0002&#\u000511.\u001a:oK2L!a\n\u0013\u00033\u001d\u0013\u0018\r\u001d5ECR\f'-Y:f#V,'/_*feZL7-Z\u0001\u000fW\u0016\u0014h.\u001a7N_:LGo\u001c:t!\tQS&D\u0001,\u0015\ta\u0013#\u0001\u0006n_:LGo\u001c:j]\u001eL!AL\u0016\u0003\u00115{g.\u001b;peN\fAbY1dQ\u00164\u0015m\u0019;pef\u0004\"!\r\u001b\u000e\u0003IR!aM\u0007\u0002\u000b\r\f7\r[3\n\u0005U\u0012$\u0001F\"bM\u001a,\u0017N\\3DC\u000eDWMR1di>\u0014\u00180A\u0006m_\u001e\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0012\u0003\u001dawnZ4j]\u001eL!\u0001P\u001d\u0003\u00171{w\r\u0015:pm&$WM]\u0001\u000ea2\fgN\\3s\u0007>tg-[4\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005k\u0011\u0001C2p[BLG.\u001a:\n\u0005\r\u0003%AG\"za\",'\u000f\u00157b]:,'oQ8oM&<WO]1uS>t\u0017!\u0004:v]RLW.Z\"p]\u001aLw\r\u0005\u0002\u001f\r&\u0011q)\u0004\u0002\u001b\u0007f\u0004\b.\u001a:Sk:$\u0018.\\3D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f)[E*\u0014(P!B\u0011a\u0004\u0001\u0005\u0006C\u001d\u0001\rA\t\u0005\u0006Q\u001d\u0001\r!\u000b\u0005\u0006_\u001d\u0001\r\u0001\r\u0005\u0006m\u001d\u0001\ra\u000e\u0005\u0006{\u001d\u0001\rA\u0010\u0005\u0006\t\u001e\u0001\r!R\u0001\u0004Y><W#A*\u0011\u0005a\"\u0016BA+:\u0005\raunZ\u0001\u0005Y><\u0007%\u0001\u0010tkB\u0004xN\u001d;t\u0003\u0012l\u0017N\\5tiJ\fG/\u001b<f\u0007>lW.\u00198egR\t\u0011\f\u0005\u0002\u00195&\u00111,\u0007\u0002\b\u0005>|G.Z1o\u00039\u0019'/Z1uK\u000e{W\u000e]5mKJ$bAX1j]ND\bC\u0001\u0010`\u0013\t\u0001WB\u0001\u0005D_6\u0004\u0018\u000e\\3s\u0011\u0015\u00117\u00021\u0001d\u00035\u0019\u0017\u0010\u001d5feZ+'o]5p]B\u0011AmZ\u0007\u0002K*\u0011a-D\u0001\b_B$\u0018n\u001c8t\u0013\tAWMA\u0007DsBDWM\u001d,feNLwN\u001c\u0005\u0006U.\u0001\ra[\u0001\u000eGf\u0004\b.\u001a:QY\u0006tg.\u001a:\u0011\u0005\u0011d\u0017BA7f\u0005M\u0019\u0015\u0010\u001d5feBc\u0017M\u001c8fe>\u0003H/[8o\u0011\u0015y7\u00021\u0001q\u00035\u0019\u0017\u0010\u001d5feJ+h\u000e^5nKB\u0011A-]\u0005\u0003e\u0016\u00141cQ=qQ\u0016\u0014(+\u001e8uS6,w\n\u001d;j_:DQ\u0001^\u0006A\u0002U\fAcY=qQ\u0016\u0014X\u000b\u001d3bi\u0016\u001cFO]1uK\u001eL\bC\u00013w\u0013\t9XM\u0001\u000bDsBDWM]+qI\u0006$Xm\u0015;sCR,w-\u001f\u0005\u0006s.\u0001\rA_\u0001\u0018Kb,7-\u001e;j_:,enZ5oKB\u0013xN^5eKJ\u00042\u0001G>~\u0013\ta\u0018DA\u0005Gk:\u001cG/[8oaA\u0011aD`\u0005\u0003\u007f6\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a")
public class CommunityCompilerFactory
implements CompilerFactory {
    private final GraphDatabaseQueryService graph;
    private final Monitors kernelMonitors;
    private final CaffeineCacheFactory cacheFactory;
    private final CypherPlannerConfiguration plannerConfig;
    private final CypherRuntimeConfiguration runtimeConfig;
    private final Log log;

    private Log log() {
        return this.log;
    }

    @Override
    public boolean supportsAdministrativeCommands() {
        return this.plannerConfig.planSystemCommands();
    }

    @Override
    public Compiler createCompiler(CypherVersion cypherVersion, CypherPlannerOption cypherPlanner, CypherRuntimeOption cypherRuntime, CypherUpdateStrategy cypherUpdateStrategy, Function0<ExecutionEngine> executionEngineProvider) {
        CommunityAdministrationCommandRuntime communityAdministrationCommandRuntime;
        Compatibility3_5$ compatibility3_5$;
        CypherVersion cypherVersion2 = cypherVersion;
        if (CypherVersion.v3_5$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility3_5$.MODULE$;
        } else if (CypherVersion.v4_2$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility4_2$.MODULE$;
        } else if (CypherVersion.v4_3$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility4_3$.MODULE$;
        } else {
            throw new MatchError((Object)cypherVersion2);
        }
        Compatibility3_5$ compatibilityMode = compatibility3_5$;
        CypherPlanner planner = new CypherPlanner(this.plannerConfig, MasterCompiler$.MODULE$.CLOCK(), this.kernelMonitors, this.log(), this.cacheFactory, cypherPlanner, cypherUpdateStrategy, (Function0<Object>)new LastCommittedTxIdProvider(this.graph), (CypherCompatibilityVersion)compatibilityMode);
        if (this.plannerConfig.planSystemCommands()) {
            CommunityAdministrationCommandRuntime communityAdministrationCommandRuntime2;
            CypherVersion cypherVersion3 = cypherVersion;
            if (CypherVersion.v3_5$.MODULE$.equals(cypherVersion3)) {
                throw new SyntaxException("Commands towards system database are not supported in this Cypher version.");
            }
            communityAdministrationCommandRuntime = communityAdministrationCommandRuntime2 = new CommunityAdministrationCommandRuntime((ExecutionEngine)executionEngineProvider.apply(), this.graph.getDependencyResolver(), CommunityAdministrationCommandRuntime$.MODULE$.apply$default$3());
        } else {
            communityAdministrationCommandRuntime = CommunityRuntimeFactory$.MODULE$.getRuntime(cypherRuntime, this.plannerConfig.useErrorsOverWarnings());
        }
        CommunityAdministrationCommandRuntime runtime = communityAdministrationCommandRuntime;
        return new CypherCurrentCompiler<CommunityRuntimeContext>(planner, runtime, new CommunityRuntimeContextManager(this.log(), this.runtimeConfig), this.kernelMonitors);
    }

    public CommunityCompilerFactory(GraphDatabaseQueryService graph, Monitors kernelMonitors, CaffeineCacheFactory cacheFactory, LogProvider logProvider, CypherPlannerConfiguration plannerConfig, CypherRuntimeConfiguration runtimeConfig) {
        this.graph = graph;
        this.kernelMonitors = kernelMonitors;
        this.cacheFactory = cacheFactory;
        this.plannerConfig = plannerConfig;
        this.runtimeConfig = runtimeConfig;
        this.log = logProvider.getLog(this.getClass());
    }
}

