/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.DefaultPlanStalenessCaller;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator$;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.options.CypherExecutionMode;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\rUd\u0001\u0002\u001c8\u0001\u0001C\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003S\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0011\"!\u0002\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0015\u0005\u001d\u0001A!b\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0016\u0001\u0011\t\u0011)A\u0005\u0003\u0017A!\"a\u0006\u0001\u0005\u000b\u0007I\u0011AA\r\u0011)\t\t\u0003\u0001B\u0001B\u0003%\u00111\u0004\u0005\u000b\u0003G\u0001!Q1A\u0005\u0002\u0005\u0015\u0002BCA\u001a\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u0011Q\u0007\u0001\u0003\u0006\u0004%\t!a\u000e\t\u0015\u0005\u0015\u0003A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002H\u0001\u0011)\u0019!C\u0001\u0003\u0013B!\"a\u0017\u0001\u0005\u0003\u0005\u000b\u0011BA&\u0011\u001d\ti\u0006\u0001C\u0001\u0003?B\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\t\u0011\u0005%\u0005\u0001)A\u0005\u0003sB\u0011\"a#\u0001\u0005\u0004%I!!$\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001fC\u0011\"a&\u0001\u0005\u0004%I!!'\t\u0011\u0005\u0005\u0006\u0001)A\u0005\u00037Cq!a)\u0001\t\u0013\t)\u000bC\u0005\u0002B\u0002\u0011\r\u0011\"\u0003\u0002D\"A\u00111\u001a\u0001!\u0002\u0013\t)\rC\u0005\u0002N\u0002\u0011\r\u0011\"\u0003\u0002P\"A\u0011q\u001b\u0001!\u0002\u0013\t\t\u000eC\u0005\u0002Z\u0002\u0011\r\u0011\"\u0003\u0002\\\"A\u00111\u001d\u0001!\u0002\u0013\ti\u000eC\u0005\u0002f\u0002\u0011\r\u0011\"\u0003\u0002h\"A\u0011q\u001e\u0001!\u0002\u0013\tI\u000fC\u0005\u0002r\u0002\u0011\r\u0011\"\u0003\u0002t\"A\u00111 \u0001!\u0002\u0013\t)\u0010C\u0004\u0002~\u0002!\t!a@\t\u000f\u0005u\b\u0001\"\u0001\u0003:!9!q\f\u0001\u0005\u0002\t\u0005\u0004b\u0002B:\u0001\u0011%!Q\u000f\u0005\b\u0005g\u0003A\u0011\u0002B[\u0011\u001d\u0011y\r\u0001C\u0005\u0005#DqAa9\u0001\t\u0013\u0011)\u000fC\u0004\u0003r\u0002!\tAa=\t\u000f\tm\b\u0001\"\u0001\u0003~\"91\u0011\u0001\u0001\u0005\u0002\r\r\u0001bBB\f\u0001\u0011%1\u0011D\u0004\b\u0007\u0013:\u0004\u0012AB&\r\u00191t\u0007#\u0001\u0004N!9\u0011QL\u0019\u0005\u0002\r=\u0003\"CB)c\t\u0007I\u0011AB*\u0011!\u0019Y&\rQ\u0001\n\rU\u0003\"CB/cE\u0005I\u0011AB0\u0005=)\u00050Z2vi&|g.\u00128hS:,'B\u0001\u001d:\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001e<\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A(P\u0001\u0006]\u0016|GG\u001b\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\u0019E,XM]=TKJ4\u0018nY3\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001T\u001e\u0002\r-,'O\\3m\u0013\tq5JA\rHe\u0006\u0004\b\u000eR1uC\n\f7/Z)vKJL8+\u001a:wS\u000e,\u0017!D9vKJL8+\u001a:wS\u000e,\u0007%\u0001\blKJtW\r\\'p]&$xN]:\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!V\u001e\u0002\u00155|g.\u001b;pe&tw-\u0003\u0002X)\nAQj\u001c8ji>\u00148/A\blKJtW\r\\'p]&$xN]:!\u0003\u0019!(/Y2feV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_o\u00059AO]1dS:<\u0017B\u00011^\u0005E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0001\biJ\f7-\u001a:!\u0003-\u0019\u0017m\u00195f)J\f7-\u001a:\u0016\u0003\u0011\u00042!\u001a4i\u001b\u00059\u0014BA48\u0005-\u0019\u0015m\u00195f)J\f7-\u001a:\u0011\u0007%<(P\u0004\u0002kk:\u00111\u000e\u001e\b\u0003YNt!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005A|\u0014A\u0002\u001fs_>$h(C\u0001?\u0013\taT(\u0003\u0002;w%\u0011\u0001(O\u0005\u0003m^\n!\"U;fef\u001c\u0015m\u00195f\u0013\tA\u0018P\u0001\u0005DC\u000eDWmS3z\u0015\t1x\u0007\u0005\u0002|\u007f:\u0011A0 \t\u0003]\u000eK!A`\"\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\rM#(/\u001b8h\u0015\tq8)\u0001\u0007dC\u000eDW\r\u0016:bG\u0016\u0014\b%\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00125\u0011\u0011q\u0002\u0006\u0004\u0003\u000f9\u0014\u0002BA\n\u0003\u001f\u00111cQ=qQ\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\fqaY8oM&<\u0007%A\bd_6\u0004\u0018\u000e\\3s\u0019&\u0014'/\u0019:z+\t\tY\u0002E\u0002f\u0003;I1!a\b8\u0005=\u0019u.\u001c9jY\u0016\u0014H*\u001b2sCJL\u0018\u0001E2p[BLG.\u001a:MS\n\u0014\u0018M]=!\u00031\u0019\u0017m\u00195f\r\u0006\u001cGo\u001c:z+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ticN\u0001\u0006G\u0006\u001c\u0007.Z\u0005\u0005\u0003c\tYC\u0001\u000bDC\u001a4W-\u001b8f\u0007\u0006\u001c\u0007.\u001a$bGR|'/_\u0001\u000eG\u0006\u001c\u0007.\u001a$bGR|'/\u001f\u0011\u0002\u00171|w\r\u0015:pm&$WM]\u000b\u0003\u0003s\u0001B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fY\u0014a\u00027pO\u001eLgnZ\u0005\u0005\u0003\u0007\niDA\u0006M_\u001e\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u00047pOB\u0013xN^5eKJ\u0004\u0013!B2m_\u000e\\WCAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\nA\u0001^5nK*\u0011\u0011QK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\u0005=#!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003C\n\u0019'!\u001a\u0002h\u0005%\u00141NA7\u0003_\n\t(a\u001d\u0011\u0005\u0015\u0004\u0001\"B$\u0014\u0001\u0004I\u0005\"\u0002)\u0014\u0001\u0004\u0011\u0006\"B-\u0014\u0001\u0004Y\u0006\"\u00022\u0014\u0001\u0004!\u0007bBA\u0004'\u0001\u0007\u00111\u0002\u0005\b\u0003/\u0019\u0002\u0019AA\u000e\u0011\u001d\t\u0019c\u0005a\u0001\u0003OAq!!\u000e\u0014\u0001\u0004\tI\u0004C\u0005\u0002HM\u0001\n\u00111\u0001\u0002L\u0005aB-\u001a4bk2$\u0018+^3ss\u0016CXmY;uS>tWj\u001c8ji>\u0014XCAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000bQ!];fefT1!a!L\u0003\u0011IW\u000e\u001d7\n\t\u0005\u001d\u0015Q\u0010\u0002\u0016#V,'/_#yK\u000e,H/[8o\u001b>t\u0017\u000e^8s\u0003u!WMZ1vYR\fV/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J\u0004\u0013!\u00039sKB\u000b'o]3s+\t\ty\tE\u0002f\u0003#K1!a%8\u0005%\u0001&/\u001a)beN,'/\u0001\u0006qe\u0016\u0004\u0016M]:fe\u0002\n\u0011\u0004\\1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3feV\u0011\u00111\u0014\t\u0004K\u0006u\u0015bAAPo\tIB*Y:u\u0007>lW.\u001b;uK\u0012$\u00060\u00133Qe>4\u0018\u000eZ3s\u0003ia\u0017m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:!\u0003A\u0001H.\u00198SKV\u001c\u0018MY5mSRL\u0017\u0010\u0006\u0004\u0002(\u00065\u0016q\u0017\t\u0004K\u0006%\u0016bAAVo\t\u0001\"+Z;tC\nLG.\u001b;z'R\fG/\u001a\u0005\b\u0003_S\u0002\u0019AAY\u0003=)\u00070Z2vi\u0006\u0014G.Z)vKJL\bcA3\u00024&\u0019\u0011QW\u001c\u0003\u001f\u0015CXmY;uC\ndW-U;fefDq!!/\u001b\u0001\u0004\tY,\u0001\u000bue\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010\u001e\t\u0005\u0003w\ni,\u0003\u0003\u0002@\u0006u$\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH/A\u0002m_\u001e,\"!!2\u0011\t\u0005m\u0012qY\u0005\u0005\u0003\u0013\fiDA\u0002M_\u001e\fA\u0001\\8hA\u0005\u0019\u0002\u000f\\1o'R\fG.\u001a8fgN\u001c\u0015\r\u001c7feV\u0011\u0011\u0011\u001b\t\u0006K\u0006M\u0017\u0011W\u0005\u0004\u0003+<$A\u0007#fM\u0006,H\u000e\u001e)mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014\u0018\u0001\u00069mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014\b%\u0001\u0006rk\u0016\u0014\u0018pQ1dQ\u0016,\"!!8\u0011\r\u0015\fy\u000e[AY\u0013\r\t\to\u000e\u0002\u000b#V,'/_\"bG\",\u0017aC9vKJL8)Y2iK\u0002\na\"\\1ti\u0016\u00148i\\7qS2,'/\u0006\u0002\u0002jB\u0019Q-a;\n\u0007\u00055xG\u0001\bNCN$XM]\"p[BLG.\u001a:\u0002\u001f5\f7\u000f^3s\u0007>l\u0007/\u001b7fe\u0002\nAb]2iK6\f\u0007*\u001a7qKJ,\"!!>\u0011\u0007\u0015\f90C\u0002\u0002z^\u0012AbU2iK6\f\u0007*\u001a7qKJ\fQb]2iK6\f\u0007*\u001a7qKJ\u0004\u0013aB3yK\u000e,H/\u001a\u000b\u000f\u0005\u0003\u00119A!\u0003\u0003\u001e\t\u0005\"1\u0006B\u0018!\u0011\tYHa\u0001\n\t\t\u0015\u0011Q\u0010\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u0019\ty(\na\u0001u\"9!1B\u0013A\u0002\t5\u0011A\u00029be\u0006l7\u000f\u0005\u0003\u0003\u0010\teQB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u000fYL'\u000f^;bY*\u0019!qC\u001e\u0002\rY\fG.^3t\u0013\u0011\u0011YB!\u0005\u0003\u00115\u000b\u0007OV1mk\u0016DqAa\b&\u0001\u0004\tY,A\u0004d_:$X\r\u001f;\t\u000f\t\rR\u00051\u0001\u0003&\u00059\u0001O]8gS2,\u0007c\u0001\"\u0003(%\u0019!\u0011F\"\u0003\u000f\t{w\u000e\\3b]\"9!QF\u0013A\u0002\t\u0015\u0012a\u00039sKB{\u0007/\u001e7bi\u0016DqA!\r&\u0001\u0004\u0011\u0019$\u0001\u0006tk\n\u001c8M]5cKJ\u0004B!a\u001f\u00036%!!qGA?\u0005=\tV/\u001a:z'V\u00147o\u0019:jE\u0016\u0014H\u0003\u0005B\u0001\u0005w\u0011\u0019E!\u0012\u0003H\t%#\u0011\fB/\u0011\u001d\tyH\na\u0001\u0005{\u00012!\u001aB \u0013\r\u0011\te\u000e\u0002\u0011\rVdG.\u001f)beN,G-U;fefDqAa\u0003'\u0001\u0004\u0011i\u0001C\u0004\u0003 \u0019\u0002\r!a/\t\u000f\t5b\u00051\u0001\u0003&!9!1\n\u0014A\u0002\t5\u0013!B5oaV$\b\u0003\u0002B(\u0005+j!A!\u0015\u000b\u0007\tMs'A\u0004sk:$\u0018.\\3\n\t\t]#\u0011\u000b\u0002\u0010\u0013:\u0004X\u000f\u001e#bi\u0006\u001cFO]3b[\"9!1\f\u0014A\u0002\u0005e\u0014\u0001D9vKJLXj\u001c8ji>\u0014\bb\u0002B\u0019M\u0001\u0007!1G\u0001\u0010Kb,7-\u001e;f'V\u0014\u0017+^3ssR\u0001\"\u0011\u0001B2\u0005K\u00129G!\u001b\u0003n\t=$\u0011\u000f\u0005\u0007\u0003\u007f:\u0003\u0019\u0001>\t\u000f\t-q\u00051\u0001\u0003\u000e!9!qD\u0014A\u0002\u0005m\u0006b\u0002B6O\u0001\u0007!QE\u0001\u0011SN|U\u000f^3s[>\u001cH/U;fefDqAa\t(\u0001\u0004\u0011)\u0003C\u0004\u0003.\u001d\u0002\rA!\n\t\u000f\tEr\u00051\u0001\u00034\u000591\r\\8tS:<W\u0003\u0002B<\u0005\u007f\"bA!\u001f\u0003\u001c\nuE\u0003\u0002B>\u0005#\u0003BA! \u0003\u00001\u0001Aa\u0002BAQ\t\u0007!1\u0011\u0002\u0002)F!!Q\u0011BF!\r\u0011%qQ\u0005\u0004\u0005\u0013\u001b%a\u0002(pi\"Lgn\u001a\t\u0004\u0005\n5\u0015b\u0001BH\u0007\n\u0019\u0011I\\=\t\u0011\tM\u0005\u0006\"a\u0001\u0005+\u000bAaY8eKB)!Ia&\u0003|%\u0019!\u0011T\"\u0003\u0011q\u0012\u0017P\\1nKzBqAa\b)\u0001\u0004\tY\fC\u0004\u0003 \"\u0002\rA!)\u0002\u0015Q\u0014\u0018mY3Fm\u0016tG\u000f\u0005\u0003\u0003$\n5f\u0002\u0002BS\u0005Ss1A\u001bBT\u0013\tqv'C\u0002\u0003,v\u000b\u0011cQ8na&d\u0017\r^5p]R\u0013\u0018mY3s\u0013\u0011\u0011yK!-\u0003+E+XM]=D_6\u0004\u0018\u000e\\1uS>tWI^3oi*\u0019!1V/\u0002\u0013\u0011|W\t_3dkR,G\u0003\u0006B\u0001\u0005o\u0013yL!1\u0003D\n\u0015'q\u0019Be\u0005\u0017\u0014i\rC\u0004\u0002\u0000%\u0002\rA!/\u0011\u0007\u0015\u0014Y,C\u0002\u0003>^\u0012!\"\u00138qkR\fV/\u001a:z\u0011\u001d\u0011Y!\u000ba\u0001\u0005\u001bAqAa\b*\u0001\u0004\tY\fC\u0004\u0003l%\u0002\rA!\n\t\u000f\t5\u0012\u00061\u0001\u0003&!9!1J\u0015A\u0002\t5\u0003b\u0002B.S\u0001\u0007\u0011\u0011\u0010\u0005\u00073&\u0002\rA!)\t\u000f\tE\u0012\u00061\u0001\u00034\u0005\u00193m\\7qS2,'oV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+gn\u00149uS>tGC\u0003Bj\u00053\u0014iNa8\u0003bB)QM!6\u00022&\u0019!q[\u001c\u0003G\r{W\u000e]5mKJ<\u0016\u000e\u001e5FqB\u0014Xm]:j_:\u001cu\u000eZ3HK:|\u0005\u000f^5p]\"9!1\u001c\u0016A\u0002\te\u0016AC5oaV$\u0018+^3ss\"1\u0011L\u000ba\u0001\u0005CCq!!/+\u0001\u0004\tY\fC\u0004\u0003\f)\u0002\rA!\u0004\u0002\u0019\u001d,Go\u0014:D_6\u0004\u0018\u000e\\3\u0015\u0015\u0005E&q\u001dBu\u0005[\u0014y\u000fC\u0004\u0003 -\u0002\r!a/\t\u000f\t-8\u00061\u0001\u0003:\u0006\t\u0012N\\5uS\u0006d\u0017J\u001c9viF+XM]=\t\re[\u0003\u0019\u0001BQ\u0011\u001d\u0011Ya\u000ba\u0001\u0005\u001b\t\u0001c\u00197fCJ\fV/\u001a:z\u0007\u0006\u001c\u0007.Z:\u0015\u0005\tU\bc\u0001\"\u0003x&\u0019!\u0011`\"\u0003\t1{gnZ\u0001\u0011SN\u0004VM]5pI&\u001c7i\\7nSR$BA!\n\u0003\u0000\"1\u0011qP\u0017A\u0002i\f!cZ3u\u0007f\u0004\b.\u001a:Gk:\u001cG/[8ogV\u00111Q\u0001\t\u0007\u0007\u000f\u0019ia!\u0005\u000e\u0005\r%!\u0002BB\u0006\u0003'\nA!\u001e;jY&!1qBB\u0005\u0005\u0011a\u0015n\u001d;\u0011\t\u0005m41C\u0005\u0005\u0007+\tiHA\nGk:\u001cG/[8o\u0013:4wN]7bi&|g.A\bdQ\u0016\u001c7\u000eU1sC6,G/\u001a:t)!\u0019Yb!\t\u0004,\r=\u0002c\u0001\"\u0004\u001e%\u00191qD\"\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007Gy\u0003\u0019AB\u0013\u0003-\tX/\u001a:z!\u0006\u0014\u0018-\\:\u0011\t\t\u001b9C_\u0005\u0004\u0007S\u0019%!B!se\u0006L\bbBB\u0017_\u0001\u0007!QB\u0001\fO&4XM\u001c)be\u0006l7\u000fC\u0004\u00042=\u0002\rA!\u0004\u0002\u001f\u0015DHO]1di\u0016$\u0007+\u0019:b[NDSaLB\u001b\u0007\u000f\u0002RAQB\u001c\u0007wI1a!\u000fD\u0005\u0019!\bN]8xgB!1QHB\"\u001b\t\u0019yDC\u0002\u0004Bm\n!\"\u001a=dKB$\u0018n\u001c8t\u0013\u0011\u0019)ea\u0010\u00035A\u000b'/Y7fi\u0016\u0014hj\u001c;G_VtG-\u0012=dKB$\u0018n\u001c8$\u0005\rm\u0012aD#yK\u000e,H/[8o\u000b:<\u0017N\\3\u0011\u0005\u0015\f4CA\u0019B)\t\u0019Y%A\nQ\u0019\u0006suLQ+J\u0019\u0012KejR0U%&+5+\u0006\u0002\u0004VA\u0019!ia\u0016\n\u0007\re3IA\u0002J]R\fA\u0003\u0015'B\u001d~\u0013U+\u0013'E\u0013:;u\f\u0016*J\u000bN\u0003\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0004b)\"\u00111JB2W\t\u0019)\u0007\u0005\u0003\u0004h\rETBAB5\u0015\u0011\u0019Yg!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAB8\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rM4\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<QueryCache.CacheKey<String>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final CaffeineCacheFactory cacheFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<QueryCache.CacheKey<String>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$9() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$9();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<QueryCache.CacheKey<String>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<QueryCache.CacheKey<String>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.defaultQueryExecutionMonitor().startProcessing(context.executingQuery());
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.compilerLibrary().supportsAdministrativeCommands();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, this.defaultQueryExecutionMonitor(), queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().queryOptions().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), executableQuery.planDescriptionSupplier());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0 ? (ExecutableQuery)this.compiledExpressionCompiler$1.apply() : (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() ? new Some(this.compiledExpressionCompiler$1.apply()) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<String> cacheKey = new QueryCache.CacheKey<String>(initialInputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params), tc.kernelTransaction().dataRead().transactionStateHasChanges());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2(), this.preParser().preParseQuery$default$3());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().queryOptions().executionMode();
        CypherExecutionMode.explain$ explain$2 = CypherExecutionMode.explain$.MODULE$;
        return (cypherExecutionMode == null ? explain$2 != null : !cypherExecutionMode.equals(explain$2)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        Seq predicateInformations = (Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, Seq$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)informations.$plus$plus((GenTraversableOnce)predicateInformations, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<QueryCache.CacheKey<String>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, CaffeineCacheFactory cacheFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.cacheFactory = cacheFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config, cacheFactory);
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new ExecutionEngineQueryCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheCompile(Object key) {
                CypherCacheHitMonitor.cacheCompile$(this, key);
            }

            public void cacheCompileWithExpressionCodeGen(Object key) {
                CypherCacheHitMonitor.cacheCompileWithExpressionCodeGen$(this, key);
            }

            public void cacheDiscard(QueryCache.CacheKey<String> ignored, String queryId, int secondsSinceReplan, Option<String> maybeReason) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(69).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds").append(maybeReason.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)r -> new StringBuilder(10).append(". Reason: ").append((String)r).toString())).append(". Query id: ").append(queryId).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheDiscard$1(), $anonfun$cacheDiscard$2(java.lang.String )}, serializedLambda);
            }
        }, new String[0]);
        this.planStalenessCaller = new DefaultPlanStalenessCaller(clock, StatsDivergenceCalculator$.MODULE$.divergenceCalculatorFor(config.statsDivergenceCalculator()), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext), this.org$neo4j$cypher$internal$ExecutionEngine$$log());
        this.queryCache = new QueryCache<QueryCache.CacheKey<String>, ExecutableQuery>(cacheFactory, config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.masterCompiler = new MasterCompiler(compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache(), this.masterCompiler());
    }
}

