/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.CommunityCompilerFactory;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CypherRuntimeConfiguration;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.ExecutorBasedCaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.GraphDatabaseCypherService;
import org.neo4j.cypher.internal.javacompat.SnapshotExecutionEngine;
import org.neo4j.cypher.internal.javacompat.SystemExecutionEngine;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.MonitoredJobExecutor;

public class CommunityCypherEngineProvider
extends QueryEngineProvider {
    protected int enginePriority() {
        return 42;
    }

    protected CompilerFactory makeCompilerFactory(GraphDatabaseCypherService queryService, QueryEngineProvider.SPI spi, CypherPlannerConfiguration plannerConfig, CypherRuntimeConfiguration runtimeConfig) {
        return new CommunityCompilerFactory((GraphDatabaseQueryService)queryService, spi.monitors(), CommunityCypherEngineProvider.makeCacheFactory(spi), spi.logProvider(), plannerConfig, runtimeConfig);
    }

    protected QueryExecutionEngine createEngine(Dependencies deps, GraphDatabaseAPI graphAPI, boolean isSystemDatabase, QueryEngineProvider.SPI spi) {
        GraphDatabaseCypherService queryService = new GraphDatabaseCypherService((GraphDatabaseService)graphAPI);
        deps.satisfyDependency((Object)queryService);
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig((Config)spi.config());
        CypherPlannerConfiguration plannerConfig = CypherPlannerConfiguration.fromCypherConfiguration((CypherConfiguration)cypherConfig, (Config)spi.config(), (boolean)isSystemDatabase);
        CypherRuntimeConfiguration runtimeConfig = CypherRuntimeConfiguration.fromCypherConfiguration(cypherConfig);
        CompilerFactory compilerFactory = this.makeCompilerFactory(queryService, spi, plannerConfig, runtimeConfig);
        CaffeineCacheFactory cacheFactory = CommunityCypherEngineProvider.makeCacheFactory(spi);
        if (isSystemDatabase) {
            CypherPlannerConfiguration innerPlannerConfig = CypherPlannerConfiguration.fromCypherConfiguration((CypherConfiguration)cypherConfig, (Config)spi.config(), (boolean)false);
            CompilerFactory innerCompilerFactory = this.makeCompilerFactory(queryService, spi, innerPlannerConfig, runtimeConfig);
            return new SystemExecutionEngine((GraphDatabaseQueryService)queryService, cacheFactory, spi.logProvider(), compilerFactory, innerCompilerFactory);
        }
        if (((Boolean)spi.config().get(GraphDatabaseInternalSettings.snapshot_query)).booleanValue()) {
            return new SnapshotExecutionEngine((GraphDatabaseQueryService)queryService, spi.config(), cacheFactory, spi.logProvider(), compilerFactory);
        }
        return new ExecutionEngine((GraphDatabaseQueryService)queryService, cacheFactory, spi.logProvider(), compilerFactory);
    }

    private static CaffeineCacheFactory makeCacheFactory(QueryEngineProvider.SPI spi) {
        MonitoredJobExecutor monitoredExecutor = spi.jobScheduler().monitoredJobExecutor(Group.CYPHER_CACHE);
        return new ExecutorBasedCaffeineCacheFactory(job -> monitoredExecutor.execute(JobMonitoringParams.systemJob((String)"Query plan cache maintenance"), job));
    }
}

