/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import org.neo4j.cypher.internal.FineToReuse$;
import org.neo4j.cypher.internal.MaybeReusable;
import org.neo4j.cypher.internal.NeedsReplan;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanFingerprint;
import org.neo4j.cypher.internal.PlanFingerprintReference;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.planner.spi.DivergenceState;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.GraphStatisticsSnapshot;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics$;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.reflect.ScalaSignature;
import scala.runtime.LazyLong;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0003\u0006\u0001'!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011I\u0003!\u0011!Q\u0001\nMCQ!\u0017\u0001\u0005\u0002iCQ!\u0019\u0001\u0005B\tDa!\u0019\u0001\u0005\u0002)Q'A\u0007#fM\u0006,H\u000e\u001e)mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001U\u0011A#I\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\rE\u0002\u001d;}i\u0011AC\u0005\u0003=)\u00111\u0003\u00157b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ\u0004\"\u0001I\u0011\r\u0001\u0011)!\u0005\u0001b\u0001G\t\u0001R\tW#D+R\u000b%\tT#`#V+%+W\t\u0003I\u001d\u0002\"AF\u0013\n\u0005\u0019:\"a\u0002(pi\"Lgn\u001a\t\u0003-!J!!K\f\u0003\u0007\u0005s\u00170A\u0003dY>\u001c7\u000e\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A/[7f\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\u000b\rcwnY6\u0002)\u0011Lg/\u001a:hK:\u001cWmQ1mGVd\u0017\r^8s!\t)\u0004(D\u00017\u0015\t9$\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0013\tIdGA\rTi\u0006$8\u000fR5wKJ<WM\\2f\u0007\u0006d7-\u001e7bi>\u0014\u0018!\u00077bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\u00042A\u0006\u001f?\u0013\titCA\u0005Gk:\u001cG/[8oaA\u0011acP\u0005\u0003\u0001^\u0011A\u0001T8oO\u0006y!/Z;tC\nLG.\u001b;z\u0013:4w\u000eE\u0003\u0017\u0007~)u*\u0003\u0002E/\tIa)\u001e8di&|gN\r\t\u0003\r6k\u0011a\u0012\u0006\u0003\u0011&\u000bQ!];fefT!AS&\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u0019:\taa[3s]\u0016d\u0017B\u0001(H\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yiB\u0011A\u0004U\u0005\u0003#*\u0011\u0001CU3vg\u0006\u0014\u0017\u000e\\5usN#\u0018\r^3\u0002\u00071|w\r\u0005\u0002U/6\tQK\u0003\u0002W\u001d\u00059An\\4hS:<\u0017B\u0001-V\u0005\raunZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\rmcVLX0a!\ra\u0002a\b\u0005\u0006U\u0019\u0001\ra\u000b\u0005\u0006g\u0019\u0001\r\u0001\u000e\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006\u0003\u001a\u0001\rA\u0011\u0005\u0006%\u001a\u0001\raU\u0001\ngR\fG.\u001a8fgN$2a\u00194i!\taB-\u0003\u0002f\u0015\tI1\u000b^1mK:,7o\u001d\u0005\u0006O\u001e\u0001\r!R\u0001\u0015iJ\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\u000b%<\u0001\u0019A\u0010\u0002+\r\f7\r[3e\u000bb,7-\u001e;bE2,\u0017+^3ssR\u00191m\u001b9\t\u000b1D\u0001\u0019A7\u0002\u0007I,g\r\u0005\u0002\u001d]&\u0011qN\u0003\u0002\u0019!2\fgNR5oO\u0016\u0014\bO]5oiJ+g-\u001a:f]\u000e,\u0007BB9\t\t\u0003\u0007!/\u0001\u0006ti\u0006$\u0018n\u001d;jGN\u00042AF:v\u0013\t!xC\u0001\u0005=Eft\u0017-\\3?!\t180D\u0001x\u0015\tA\u00180A\u0002ta&T!A\u001f\u0006\u0002\u000fAd\u0017M\u001c8fe&\u0011Ap\u001e\u0002\u0010\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\u0002")
public class DefaultPlanStalenessCaller<EXECUTABLE_QUERY>
implements PlanStalenessCaller<EXECUTABLE_QUERY> {
    private final Clock clock;
    private final StatsDivergenceCalculator divergenceCalculator;
    private final Function0<Object> lastCommittedTxIdProvider;
    private final Function2<EXECUTABLE_QUERY, TransactionalContext, ReusabilityState> reusabilityInfo;
    private final Log log;

    @Override
    public Staleness staleness(TransactionalContext transactionalContext, EXECUTABLE_QUERY cachedExecutableQuery) {
        Staleness staleness;
        ReusabilityState reusability = (ReusabilityState)this.reusabilityInfo.apply(cachedExecutableQuery, (Object)transactionalContext);
        ReusabilityState reusabilityState = reusability;
        if (reusabilityState instanceof MaybeReusable) {
            MaybeReusable maybeReusable = (MaybeReusable)reusabilityState;
            PlanFingerprintReference ref = maybeReusable.fingerprint();
            KernelTransaction ktx = transactionalContext.kernelTransaction();
            staleness = this.staleness(ref, (Function0<GraphStatistics>)(Function0 & Serializable & scala.Serializable)() -> TransactionBoundGraphStatistics$.MODULE$.apply(ktx.dataRead(), ktx.schemaRead(), $this.log));
        } else if (FineToReuse$.MODULE$.equals(reusabilityState)) {
            staleness = NotStale$.MODULE$;
        } else if (reusabilityState instanceof NeedsReplan) {
            NeedsReplan needsReplan = (NeedsReplan)reusabilityState;
            int x = needsReplan.secondsSincePlan();
            staleness = new Stale(x, (Option<String>)None$.MODULE$);
        } else {
            throw new MatchError((Object)reusabilityState);
        }
        return staleness;
    }

    public Staleness staleness(PlanFingerprintReference ref, Function0<GraphStatistics> statistics) {
        Product product;
        LazyLong currentTimeMillis$lzy = new LazyLong();
        LazyLong currentTxId$lzy = new LazyLong();
        PlanFingerprint f = ref.fingerprint();
        if (this.divergenceCalculator.shouldCheck(this.currentTimeMillis$1(currentTimeMillis$lzy), f.lastCheckTimeMillis()) && this.currentTxId$1(currentTxId$lzy) != f.txId()) {
            double threshold = this.divergenceCalculator.decay(this.currentTimeMillis$1(currentTimeMillis$lzy) - f.creationTimeMillis());
            DivergenceState divergence = f.snapshot().diverges(f.snapshot().recompute((GraphStatistics)statistics.apply()));
            if (divergence.divergence() > threshold) {
                product = new Stale((int)((this.currentTimeMillis$1(currentTimeMillis$lzy) - f.creationTimeMillis()) / 1000L), (Option<String>)Option$.MODULE$.apply((Object)new StringBuilder(78).append(divergence.key()).append(" changed from ").append(divergence.before()).append(" to ").append(divergence.after()).append(", ").append("which is a divergence of ").append(divergence.divergence()).append(" which is greater than ").append("threshold ").append(threshold).toString()));
            } else {
                long x$1 = this.currentTimeMillis$1(currentTimeMillis$lzy);
                long x$2 = this.currentTxId$1(currentTxId$lzy);
                long x$3 = f.copy$default$1();
                GraphStatisticsSnapshot x$4 = f.copy$default$4();
                ref.fingerprint_$eq(f.copy(x$3, x$1, x$2, x$4));
                product = NotStale$.MODULE$;
            }
        } else {
            long x$5 = this.currentTimeMillis$1(currentTimeMillis$lzy);
            long x$6 = f.copy$default$1();
            long x$7 = f.copy$default$3();
            GraphStatisticsSnapshot x$8 = f.copy$default$4();
            ref.fingerprint_$eq(f.copy(x$6, x$5, x$7, x$8));
            product = NotStale$.MODULE$;
        }
        return product;
    }

    private final /* synthetic */ long currentTimeMillis$lzycompute$1(LazyLong currentTimeMillis$lzy$1) {
        long l;
        LazyLong lazyLong = currentTimeMillis$lzy$1;
        synchronized (lazyLong) {
            l = currentTimeMillis$lzy$1.initialized() ? currentTimeMillis$lzy$1.value() : currentTimeMillis$lzy$1.initialize(this.clock.millis());
        }
        return l;
    }

    private final long currentTimeMillis$1(LazyLong currentTimeMillis$lzy$1) {
        return currentTimeMillis$lzy$1.initialized() ? currentTimeMillis$lzy$1.value() : this.currentTimeMillis$lzycompute$1(currentTimeMillis$lzy$1);
    }

    private final /* synthetic */ long currentTxId$lzycompute$1(LazyLong currentTxId$lzy$1) {
        long l;
        LazyLong lazyLong = currentTxId$lzy$1;
        synchronized (lazyLong) {
            l = currentTxId$lzy$1.initialized() ? currentTxId$lzy$1.value() : currentTxId$lzy$1.initialize(this.lastCommittedTxIdProvider.apply$mcJ$sp());
        }
        return l;
    }

    private final long currentTxId$1(LazyLong currentTxId$lzy$1) {
        return currentTxId$lzy$1.initialized() ? currentTxId$lzy$1.value() : this.currentTxId$lzycompute$1(currentTxId$lzy$1);
    }

    public DefaultPlanStalenessCaller(Clock clock, StatsDivergenceCalculator divergenceCalculator, Function0<Object> lastCommittedTxIdProvider, Function2<EXECUTABLE_QUERY, TransactionalContext, ReusabilityState> reusabilityInfo, Log log) {
        this.clock = clock;
        this.divergenceCalculator = divergenceCalculator;
        this.lastCommittedTxIdProvider = lastCommittedTxIdProvider;
        this.reusabilityInfo = reusabilityInfo;
        this.log = log;
    }
}

