/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.DefaultPlanStalenessCaller;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r=d\u0001\u0002\u001c8\u0001\u0001C\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003S\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0011\"!\u0002\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0015\u0005\u001d\u0001A!b\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011\t\u0011)A\u0005\u0003\u0017A!\"a\u0005\u0001\u0005\u000b\u0007I\u0011AA\u000b\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003?\u0001!Q1A\u0005\u0002\u0005\u0005\u0002BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002$!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t!a\r\t\u0015\u0005\u0005\u0003A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002D\u0001\u0011)\u0019!C\u0001\u0003\u000bB!\"a\u0016\u0001\u0005\u0003\u0005\u000b\u0011BA$\u0011\u001d\tI\u0006\u0001C\u0001\u00037B\u0011\"!\u001d\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003kB\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u0017C\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005u\u0005\u0001)A\u0005\u0003/Cq!a(\u0001\t\u0013\t\t\u000bC\u0005\u0002>\u0002\u0011\r\u0011\"\u0003\u0002@\"A\u0011q\u0019\u0001!\u0002\u0013\t\t\rC\u0005\u0002J\u0002\u0011\r\u0011\"\u0003\u0002L\"A\u00111\u001b\u0001!\u0002\u0013\ti\rC\u0005\u0002V\u0002\u0011\r\u0011\"\u0003\u0002X\"A\u0011q\u001c\u0001!\u0002\u0013\tI\u000eC\u0005\u0002b\u0002\u0011\r\u0011\"\u0003\u0002d\"A\u00111\u001e\u0001!\u0002\u0013\t)\u000fC\u0005\u0002n\u0002\u0011\r\u0011\"\u0003\u0002p\"A\u0011q\u001f\u0001!\u0002\u0013\t\t\u0010C\u0004\u0002z\u0002!\t!a?\t\u000f\u0005e\b\u0001\"\u0001\u00036!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011Y\r\u0001C\u0005\u0005\u001bDqAa8\u0001\t\u0013\u0011\t\u000fC\u0004\u0003l\u0002!\tA!<\t\u000f\tU\b\u0001\"\u0001\u0003x\"9!1 \u0001\u0005\u0002\tu\bbBB\t\u0001\u0011%11C\u0004\b\u0007\u0007:\u0004\u0012AB#\r\u00191t\u0007#\u0001\u0004H!9\u0011\u0011L\u0019\u0005\u0002\r%\u0003\"CB&c\t\u0007I\u0011AB'\u0011!\u0019)&\rQ\u0001\n\r=\u0003\"CB,cE\u0005I\u0011AB-\u0005=)\u00050Z2vi&|g.\u00128hS:,'B\u0001\u001d:\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001e<\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A(P\u0001\u0006]\u0016|GG\u001b\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\u0019E,XM]=TKJ4\u0018nY3\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001T\u001e\u0002\r-,'O\\3m\u0013\tq5JA\rHe\u0006\u0004\b\u000eR1uC\n\f7/Z)vKJL8+\u001a:wS\u000e,\u0017!D9vKJL8+\u001a:wS\u000e,\u0007%\u0001\blKJtW\r\\'p]&$xN]:\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!V\u001e\u0002\u00155|g.\u001b;pe&tw-\u0003\u0002X)\nAQj\u001c8ji>\u00148/A\blKJtW\r\\'p]&$xN]:!\u0003\u0019!(/Y2feV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_o\u00059AO]1dS:<\u0017B\u00011^\u0005E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0001\biJ\f7-\u001a:!\u0003-\u0019\u0017m\u00195f)J\f7-\u001a:\u0016\u0003\u0011\u00042!\u001a4i\u001b\u00059\u0014BA48\u0005-\u0019\u0015m\u00195f)J\f7-\u001a:\u0011\u0007%<(P\u0004\u0002kk:\u00111\u000e\u001e\b\u0003YNt!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005A|\u0014A\u0002\u001fs_>$h(C\u0001?\u0013\taT(\u0003\u0002;w%\u0011\u0001(O\u0005\u0003m^\n!\"U;fef\u001c\u0015m\u00195f\u0013\tA\u0018P\u0001\u0005DC\u000eDWmS3z\u0015\t1x\u0007\u0005\u0002|\u007f:\u0011A0 \t\u0003]\u000eK!A`\"\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t!a\u0001\u0003\rM#(/\u001b8h\u0015\tq8)\u0001\u0007dC\u000eDW\r\u0016:bG\u0016\u0014\b%\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003\u0017\u00012!ZA\u0007\u0013\r\tya\u000e\u0002\u0014\u0007f\u0004\b.\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u0003=\u0019w.\u001c9jY\u0016\u0014H*\u001b2sCJLXCAA\f!\r)\u0017\u0011D\u0005\u0004\u000379$aD\"p[BLG.\u001a:MS\n\u0014\u0018M]=\u0002!\r|W\u000e]5mKJd\u0015N\u0019:bef\u0004\u0013\u0001D2bG\",g)Y2u_JLXCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015o\u0005)1-Y2iK&!\u0011QFA\u0014\u0005Q\u0019\u0015M\u001a4fS:,7)Y2iK\u001a\u000b7\r^8ss\u0006i1-Y2iK\u001a\u000b7\r^8ss\u0002\n1\u0002\\8h!J|g/\u001b3feV\u0011\u0011Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H\u001e\u0002\u000f1|wmZ5oO&!\u0011qHA\u001d\u0005-aun\u001a)s_ZLG-\u001a:\u0002\u00191|w\r\u0015:pm&$WM\u001d\u0011\u0002\u000b\rdwnY6\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0005i&lWM\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\u0011\t)&a\u0013\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003\u0019a\u0014N\\5u}Q!\u0012QLA0\u0003C\n\u0019'!\u001a\u0002h\u0005%\u00141NA7\u0003_\u0002\"!\u001a\u0001\t\u000b\u001d\u001b\u0002\u0019A%\t\u000bA\u001b\u0002\u0019\u0001*\t\u000be\u001b\u0002\u0019A.\t\u000b\t\u001c\u0002\u0019\u00013\t\u000f\u0005\u001d1\u00031\u0001\u0002\f!9\u00111C\nA\u0002\u0005]\u0001bBA\u0010'\u0001\u0007\u00111\u0005\u0005\b\u0003c\u0019\u0002\u0019AA\u001b\u0011%\t\u0019e\u0005I\u0001\u0002\u0004\t9%\u0001\u000feK\u001a\fW\u000f\u001c;Rk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u0006cV,'/\u001f\u0006\u0004\u0003\u007fZ\u0015\u0001B5na2LA!a!\u0002z\t)\u0012+^3ss\u0016CXmY;uS>tWj\u001c8ji>\u0014\u0018!\b3fM\u0006,H\u000e^)vKJLX\t_3dkRLwN\\'p]&$xN\u001d\u0011\u0002\u0013A\u0014X\rU1sg\u0016\u0014XCAAF!\r)\u0017QR\u0005\u0004\u0003\u001f;$!\u0003)sKB\u000b'o]3s\u0003)\u0001(/\u001a)beN,'\u000fI\u0001\u001aY\u0006\u001cHoQ8n[&$H/\u001a3Uq&#\u0007K]8wS\u0012,'/\u0006\u0002\u0002\u0018B\u0019Q-!'\n\u0007\u0005muGA\rMCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\u0018A\u00077bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\u0004\u0013\u0001\u00059mC:\u0014V-^:bE&d\u0017\u000e^5z)\u0019\t\u0019+!+\u00024B\u0019Q-!*\n\u0007\u0005\u001dvG\u0001\tSKV\u001c\u0018MY5mSRL8\u000b^1uK\"9\u00111\u0016\u000eA\u0002\u00055\u0016aD3yK\u000e,H/\u00192mKF+XM]=\u0011\u0007\u0015\fy+C\u0002\u00022^\u0012q\"\u0012=fGV$\u0018M\u00197f#V,'/\u001f\u0005\b\u0003kS\u0002\u0019AA\\\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yiB!\u0011qOA]\u0013\u0011\tY,!\u001f\u0003)Q\u0013\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u\u0003\rawnZ\u000b\u0003\u0003\u0003\u0004B!a\u000e\u0002D&!\u0011QYA\u001d\u0005\raunZ\u0001\u0005Y><\u0007%A\nqY\u0006t7\u000b^1mK:,7o]\"bY2,'/\u0006\u0002\u0002NB)Q-a4\u0002.&\u0019\u0011\u0011[\u001c\u00035\u0011+g-Y;miBc\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:\u0002)Ad\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:!\u0003)\tX/\u001a:z\u0007\u0006\u001c\u0007.Z\u000b\u0003\u00033\u0004b!ZAnQ\u00065\u0016bAAoo\tQ\u0011+^3ss\u000e\u000b7\r[3\u0002\u0017E,XM]=DC\u000eDW\rI\u0001\u000f[\u0006\u001cH/\u001a:D_6\u0004\u0018\u000e\\3s+\t\t)\u000fE\u0002f\u0003OL1!!;8\u00059i\u0015m\u001d;fe\u000e{W\u000e]5mKJ\fq\"\\1ti\u0016\u00148i\\7qS2,'\u000fI\u0001\rg\u000eDW-\\1IK2\u0004XM]\u000b\u0003\u0003c\u00042!ZAz\u0013\r\t)p\u000e\u0002\r'\u000eDW-\\1IK2\u0004XM]\u0001\u000eg\u000eDW-\\1IK2\u0004XM\u001d\u0011\u0002\u000f\u0015DXmY;uKRq\u0011Q B\u0002\u0005\u000b\u0011IB!\b\u0003(\t-\u0002\u0003BA<\u0003\u007fLAA!\u0001\u0002z\tq\u0011+^3ss\u0016CXmY;uS>t\u0007BBA>K\u0001\u0007!\u0010C\u0004\u0003\b\u0015\u0002\rA!\u0003\u0002\rA\f'/Y7t!\u0011\u0011YA!\u0006\u000e\u0005\t5!\u0002\u0002B\b\u0005#\tqA^5siV\fGNC\u0002\u0003\u0014m\naA^1mk\u0016\u001c\u0018\u0002\u0002B\f\u0005\u001b\u0011\u0001\"T1q-\u0006dW/\u001a\u0005\b\u00057)\u0003\u0019AA\\\u0003\u001d\u0019wN\u001c;fqRDqAa\b&\u0001\u0004\u0011\t#A\u0004qe>4\u0017\u000e\\3\u0011\u0007\t\u0013\u0019#C\u0002\u0003&\r\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003*\u0015\u0002\rA!\t\u0002\u0017A\u0014X\rU8qk2\fG/\u001a\u0005\b\u0005[)\u0003\u0019\u0001B\u0018\u0003)\u0019XOY:de&\u0014WM\u001d\t\u0005\u0003o\u0012\t$\u0003\u0003\u00034\u0005e$aD)vKJL8+\u001e2tGJL'-\u001a:\u0015!\u0005u(q\u0007B \u0005\u0003\u0012\u0019E!\u0012\u0003V\te\u0003bBA>M\u0001\u0007!\u0011\b\t\u0004K\nm\u0012b\u0001B\u001fo\t\u0001b)\u001e7msB\u000b'o]3e#V,'/\u001f\u0005\b\u0005\u000f1\u0003\u0019\u0001B\u0005\u0011\u001d\u0011YB\na\u0001\u0003oCqA!\u000b'\u0001\u0004\u0011\t\u0003C\u0004\u0003H\u0019\u0002\rA!\u0013\u0002\u000b%t\u0007/\u001e;\u0011\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u00148\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0015\u0003N\ty\u0011J\u001c9vi\u0012\u000bG/Y*ue\u0016\fW\u000eC\u0004\u0003X\u0019\u0002\r!!\u001e\u0002\u0019E,XM]=N_:LGo\u001c:\t\u000f\t5b\u00051\u0001\u00030\u0005yQ\r_3dkR,7+\u001e2Rk\u0016\u0014\u0018\u0010\u0006\t\u0002~\n}#\u0011\rB2\u0005K\u0012IGa\u001b\u0003n!1\u00111P\u0014A\u0002iDqAa\u0002(\u0001\u0004\u0011I\u0001C\u0004\u0003\u001c\u001d\u0002\r!a.\t\u000f\t\u001dt\u00051\u0001\u0003\"\u0005\u0001\u0012n](vi\u0016\u0014Xn\\:u#V,'/\u001f\u0005\b\u0005?9\u0003\u0019\u0001B\u0011\u0011\u001d\u0011Ic\na\u0001\u0005CAqA!\f(\u0001\u0004\u0011y#A\u0004dY>\u001c\u0018N\\4\u0016\t\tM$1\u0010\u000b\u0007\u0005k\u00129J!'\u0015\t\t]$Q\u0012\t\u0005\u0005s\u0012Y\b\u0004\u0001\u0005\u000f\tu\u0004F1\u0001\u0003\u0000\t\tA+\u0005\u0003\u0003\u0002\n\u001d\u0005c\u0001\"\u0003\u0004&\u0019!QQ\"\u0003\u000f9{G\u000f[5oOB\u0019!I!#\n\u0007\t-5IA\u0002B]fD\u0001Ba$)\t\u0003\u0007!\u0011S\u0001\u0005G>$W\rE\u0003C\u0005'\u00139(C\u0002\u0003\u0016\u000e\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u00057A\u0003\u0019AA\\\u0011\u001d\u0011Y\n\u000ba\u0001\u0005;\u000b!\u0002\u001e:bG\u0016,e/\u001a8u!\u0011\u0011yJ!+\u000f\t\t\u0005&Q\u0015\b\u0004U\n\r\u0016B\u000108\u0013\r\u00119+X\u0001\u0012\u0007>l\u0007/\u001b7bi&|g\u000e\u0016:bG\u0016\u0014\u0018\u0002\u0002BV\u0005[\u0013Q#U;fef\u001cu.\u001c9jY\u0006$\u0018n\u001c8Fm\u0016tGOC\u0002\u0003(v\u000b\u0011\u0002Z8Fq\u0016\u001cW\u000f^3\u0015)\u0005u(1\u0017B^\u0005{\u0013yL!1\u0003D\n\u0015'q\u0019Be\u0011\u001d\tY(\u000ba\u0001\u0005k\u00032!\u001aB\\\u0013\r\u0011Il\u000e\u0002\u000b\u0013:\u0004X\u000f^)vKJL\bb\u0002B\u0004S\u0001\u0007!\u0011\u0002\u0005\b\u00057I\u0003\u0019AA\\\u0011\u001d\u00119'\u000ba\u0001\u0005CAqA!\u000b*\u0001\u0004\u0011\t\u0003C\u0004\u0003H%\u0002\rA!\u0013\t\u000f\t]\u0013\u00061\u0001\u0002v!1\u0011,\u000ba\u0001\u0005;CqA!\f*\u0001\u0004\u0011y#A\u0012d_6\u0004\u0018\u000e\\3s/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o\u001fB$\u0018n\u001c8\u0015\u0015\t='Q\u001bBm\u00057\u0014i\u000eE\u0003f\u0005#\fi+C\u0002\u0003T^\u00121eQ8na&dWM],ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\(qi&|g\u000eC\u0004\u0003X*\u0002\rA!.\u0002\u0015%t\u0007/\u001e;Rk\u0016\u0014\u0018\u0010\u0003\u0004ZU\u0001\u0007!Q\u0014\u0005\b\u0003kS\u0003\u0019AA\\\u0011\u001d\u00119A\u000ba\u0001\u0005\u0013\tAbZ3u\u001fJ\u001cu.\u001c9jY\u0016$\"\"!,\u0003d\n\u0015(q\u001dBu\u0011\u001d\u0011Yb\u000ba\u0001\u0003oCqAa6,\u0001\u0004\u0011)\f\u0003\u0004ZW\u0001\u0007!Q\u0014\u0005\b\u0005\u000fY\u0003\u0019\u0001B\u0005\u0003A\u0019G.Z1s#V,'/_\"bG\",7\u000f\u0006\u0002\u0003pB\u0019!I!=\n\u0007\tM8I\u0001\u0003M_:<\u0017\u0001E5t!\u0016\u0014\u0018n\u001c3jG\u000e{W.\\5u)\u0011\u0011\tC!?\t\r\u0005mT\u00061\u0001{\u0003I9W\r^\"za\",'OR;oGRLwN\\:\u0016\u0005\t}\bCBB\u0001\u0007\u000f\u0019Y!\u0004\u0002\u0004\u0004)!1QAA(\u0003\u0011)H/\u001b7\n\t\r%11\u0001\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002x\r5\u0011\u0002BB\b\u0003s\u00121CR;oGRLwN\\%oM>\u0014X.\u0019;j_:\fqb\u00195fG.\u0004\u0016M]1nKR,'o\u001d\u000b\t\u0007+\u0019Yb!\n\u0004*A\u0019!ia\u0006\n\u0007\re1I\u0001\u0003V]&$\bbBB\u000f_\u0001\u00071qD\u0001\fcV,'/\u001f)be\u0006l7\u000f\u0005\u0003C\u0007CQ\u0018bAB\u0012\u0007\n)\u0011I\u001d:bs\"91qE\u0018A\u0002\t%\u0011aC4jm\u0016t\u0007+\u0019:b[NDqaa\u000b0\u0001\u0004\u0011I!A\bfqR\u0014\u0018m\u0019;fIB\u000b'/Y7tQ\u0015y3qFB!!\u0015\u00115\u0011GB\u001b\u0013\r\u0019\u0019d\u0011\u0002\u0007i\"\u0014xn^:\u0011\t\r]2QH\u0007\u0003\u0007sQ1aa\u000f<\u0003))\u0007pY3qi&|gn]\u0005\u0005\u0007\u007f\u0019ID\u0001\u000eQCJ\fW.\u001a;fe:{GOR8v]\u0012,\u0005pY3qi&|gn\t\u0002\u00046\u0005yQ\t_3dkRLwN\\#oO&tW\r\u0005\u0002fcM\u0011\u0011'\u0011\u000b\u0003\u0007\u000b\n1\u0003\u0015'B\u001d~\u0013U+\u0013'E\u0013:;u\f\u0016*J\u000bN+\"aa\u0014\u0011\u0007\t\u001b\t&C\u0002\u0004T\r\u00131!\u00138u\u0003Q\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#TA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe*\"aa\u0017+\t\u0005\u001d3QL\u0016\u0003\u0007?\u0002Ba!\u0019\u0004l5\u001111\r\u0006\u0005\u0007K\u001a9'A\u0005v]\u000eDWmY6fI*\u00191\u0011N\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004n\r\r$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<QueryCache.CacheKey<String>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final CaffeineCacheFactory cacheFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<QueryCache.CacheKey<String>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$9() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$9();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<QueryCache.CacheKey<String>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<QueryCache.CacheKey<String>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.defaultQueryExecutionMonitor().startProcessing(context.executingQuery());
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.compilerLibrary().supportsAdministrativeCommands();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, this.defaultQueryExecutionMonitor(), queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), () -> executableQuery.planDescription());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0 ? (ExecutableQuery)this.compiledExpressionCompiler$1.apply() : (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() ? new Some(this.compiledExpressionCompiler$1.apply()) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block5: {
            ExecutableQuery executableQuery;
            block4: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                QueryCache.CacheKey<String> cacheKey = new QueryCache.CacheKey<String>(inputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params), tc.kernelTransaction().dataRead().transactionStateHasChanges());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().replan(), inputQuery.description());
                        if (!this.schemaHelper().lockLabels(schemaToken, executableQuery2, inputQuery.options().version(), tc)) continue;
                        executableQuery = executableQuery2;
                        break block4;
                    }
                    break block5;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2(), this.preParser().preParseQuery$default$3());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().executionMode();
        CypherExecutionMode$explain$ cypherExecutionMode$explain$ = CypherExecutionMode$explain$.MODULE$;
        return (cypherExecutionMode == null ? cypherExecutionMode$explain$ != null : !cypherExecutionMode.equals(cypherExecutionMode$explain$)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        Seq predicateInformations = (Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, Seq$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)informations.$plus$plus((GenTraversableOnce)predicateInformations, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<QueryCache.CacheKey<String>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, CaffeineCacheFactory cacheFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.cacheFactory = cacheFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.operatorEngine(), config.interpretedPipesFallback(), config.queryCacheSize(), cacheFactory);
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new ExecutionEngineQueryCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheCompile(Object key) {
                CypherCacheHitMonitor.cacheCompile$(this, key);
            }

            public void cacheCompileWithExpressionCodeGen(Object key) {
                CypherCacheHitMonitor.cacheCompileWithExpressionCodeGen$(this, key);
            }

            public void cacheDiscard(QueryCache.CacheKey<String> ignored, String query, int secondsSinceReplan, Option<String> maybeReason) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(66).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds").append(maybeReason.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)r -> new StringBuilder(10).append(". Reason: ").append((String)r).toString())).append(". Query: ").append(query).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheDiscard$1(), $anonfun$cacheDiscard$2(java.lang.String )}, serializedLambda);
            }
        }, new String[0]);
        this.planStalenessCaller = new DefaultPlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext), this.org$neo4j$cypher$internal$ExecutionEngine$$log());
        this.queryCache = new QueryCache<QueryCache.CacheKey<String>, ExecutableQuery>(cacheFactory, config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.masterCompiler = new MasterCompiler(compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

