/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.logical.plans.ConstraintType;
import org.neo4j.cypher.internal.logical.plans.CreateIndex;
import org.neo4j.cypher.internal.logical.plans.CreateNodeKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateUniquePropertyConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex;
import org.neo4j.cypher.internal.logical.plans.DropConstraintOnName;
import org.neo4j.cypher.internal.logical.plans.DropIndex;
import org.neo4j.cypher.internal.logical.plans.DropIndexOnName;
import org.neo4j.cypher.internal.logical.plans.DropNodeKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.DropNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.DropRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.DropUniquePropertyConstraint;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeKey$;
import org.neo4j.cypher.internal.logical.plans.NodePropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.Uniqueness$;
import org.neo4j.cypher.internal.procs.IgnoredResult$;
import org.neo4j.cypher.internal.procs.SchemaWriteExecutionPlan;
import org.neo4j.cypher.internal.procs.SchemaWriteExecutionPlan$;
import org.neo4j.cypher.internal.procs.SchemaWriteExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult$;
import org.neo4j.cypher.internal.runtime.InternalQueryType;
import org.neo4j.cypher.internal.runtime.ParameterMapping;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.SCHEMA_WRITE$;
import org.neo4j.cypher.internal.runtime.slottedParameters$;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class SchemaCommandRuntime$
implements CypherRuntime<RuntimeContext> {
    public static SchemaCommandRuntime$ MODULE$;
    private final PartialFunction<LogicalPlan, Function2<RuntimeContext, ParameterMapping, ExecutionPlan>> logicalToExecutable;

    static {
        new SchemaCommandRuntime$();
    }

    @Override
    public String name() {
        return "schema";
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery state, RuntimeContext context) {
        Tuple2 tuple2 = slottedParameters$.MODULE$.apply(state.logicalPlan());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan withSlottedParameters = (LogicalPlan)tuple2._1();
        ParameterMapping parameterMapping = (ParameterMapping)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)withSlottedParameters, (Object)parameterMapping);
        Tuple2 tuple23 = tuple22;
        LogicalPlan withSlottedParameters2 = (LogicalPlan)tuple23._1();
        ParameterMapping parameterMapping2 = (ParameterMapping)tuple23._2();
        return (ExecutionPlan)((Function2)this.logicalToExecutable().applyOrElse((Object)withSlottedParameters2, (Function1 & Serializable & scala.Serializable)unknownPlan -> MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply((Object)context, (Object)parameterMapping2);
    }

    public Nothing$ throwCantCompile(LogicalPlan unknownPlan) {
        throw new CantCompileQueryException(new StringBuilder(30).append("Plan is not a schema command: ").append(unknownPlan.getClass().getSimpleName()).toString());
    }

    public Option<InternalQueryType> queryType(LogicalPlan logicalPlan) {
        return this.logicalToExecutable().isDefinedAt((Object)logicalPlan) ? new Some((Object)SCHEMA_WRITE$.MODULE$) : None$.MODULE$;
    }

    public PartialFunction<LogicalPlan, Function2<RuntimeContext, ParameterMapping, ExecutionPlan>> logicalToExecutable() {
        return this.logicalToExecutable;
    }

    public boolean isApplicable(LogicalPlanState logicalPlanState) {
        return this.logicalToExecutable().isDefinedAt(logicalPlanState.maybeLogicalPlan().get());
    }

    public Function1<ConstraintDescriptor, Object> convertConstraintTypeToConstraintMatcher(ConstraintType assertion) {
        Function1 & Serializable & scala.Serializable intersect;
        ConstraintType constraintType = assertion;
        if (NodePropertyExistence$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodePropertyExistenceConstraint());
        } else if (RelationshipPropertyExistence$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipPropertyExistenceConstraint());
        } else if (Uniqueness$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isUniquenessConstraint());
        } else if (NodeKey$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeKeyConstraint());
        } else {
            throw new MatchError((Object)constraintType);
        }
        return intersect;
    }

    public LabelId org$neo4j$cypher$internal$SchemaCommandRuntime$$labelToId(QueryContext ctx, LabelName label) {
        return new LabelId(ctx.getOrCreateLabelId(label.name()));
    }

    public PropertyKeyId org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(QueryContext ctx, PropertyKeyName property) {
        return new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name()));
    }

    private List<PropertyKeyId> propertiesToIds(QueryContext ctx, List<PropertyKeyName> properties) {
        return (List)properties.map((Function1 & Serializable & scala.Serializable)property -> new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name())), List$.MODULE$.canBuildFrom());
    }

    public Tuple2<Object, Object> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelProp(QueryContext ctx, LabelName label, PropertyKeyName prop) {
        return new Tuple2.mcII.sp(ctx.getOrCreateLabelId(label.name()), ctx.getOrCreatePropertyKeyId(prop.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName(QueryContext ctx, LabelName label, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public Tuple2<Object, Object> org$neo4j$cypher$internal$SchemaCommandRuntime$$typeProp(QueryContext ctx, RelTypeName relType, PropertyKeyName prop) {
        return new Tuple2.mcII.sp(ctx.getOrCreateRelTypeId(relType.name()), ctx.getOrCreatePropertyKeyId(prop.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName(QueryContext ctx, RelTypeName relType, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    private SchemaCommandRuntime$() {
        MODULE$ = this;
        this.logicalToExecutable = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function2 & Serializable & scala.Serializable intersect;
                A1 A1 = x1;
                if (A1 instanceof CreateNodeKeyConstraint) {
                    CreateNodeKeyConstraint createNodeKeyConstraint = (CreateNodeKeyConstraint)A1;
                    Option source = createNodeKeyConstraint.source();
                    LabelName label = createNodeKeyConstraint.label();
                    Seq props = createNodeKeyConstraint.props();
                    Option name = createNodeKeyConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateNodeKeyConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$3(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.createNodeKeyConstraint(labelId, propertyKeyIds, name);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$2 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$2, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropNodeKeyConstraint) {
                    DropNodeKeyConstraint dropNodeKeyConstraint = (DropNodeKeyConstraint)A1;
                    LabelName label = dropNodeKeyConstraint.label();
                    Seq props = dropNodeKeyConstraint.props();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> new SchemaWriteExecutionPlan("DropNodeKeyConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$8(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.dropNodeKeyConstraint(labelId, propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateUniquePropertyConstraint) {
                    CreateUniquePropertyConstraint createUniquePropertyConstraint = (CreateUniquePropertyConstraint)A1;
                    Option source = createUniquePropertyConstraint.source();
                    LabelName label = createUniquePropertyConstraint.label();
                    Seq props = createUniquePropertyConstraint.props();
                    Option name = createUniquePropertyConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateUniqueConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$11(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.createUniqueConstraint(labelId, propertyKeyIds, name);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$5 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$5, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropUniquePropertyConstraint) {
                    DropUniquePropertyConstraint dropUniquePropertyConstraint = (DropUniquePropertyConstraint)A1;
                    LabelName label = dropUniquePropertyConstraint.label();
                    Seq props = dropUniquePropertyConstraint.props();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> new SchemaWriteExecutionPlan("DropUniqueConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$16(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.dropUniqueConstraint(labelId, propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateNodePropertyExistenceConstraint) {
                    CreateNodePropertyExistenceConstraint createNodePropertyExistenceConstraint = (CreateNodePropertyExistenceConstraint)A1;
                    Option source = createNodePropertyExistenceConstraint.source();
                    LabelName label = createNodePropertyExistenceConstraint.label();
                    Property prop = createNodePropertyExistenceConstraint.prop();
                    Option name = createNodePropertyExistenceConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateNodePropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((Function3 & Serializable & scala.Serializable)(Function3 & Serializable & scala.Serializable)(labelId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$19(ctx, BoxesRunTime.unboxToInt((Object)labelId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName((QueryContext)ctx, label, prop.propertyKey(), (Option<String>)name));
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$8 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$8, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropNodePropertyExistenceConstraint) {
                    DropNodePropertyExistenceConstraint dropNodePropertyExistenceConstraint = (DropNodePropertyExistenceConstraint)A1;
                    LabelName label = dropNodePropertyExistenceConstraint.label();
                    Property prop = dropNodePropertyExistenceConstraint.prop();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> new SchemaWriteExecutionPlan("DropNodePropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((JFunction2.mcVII.sp & Serializable & scala.Serializable)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(labelId, propertyKeyId) -> ctx.dropNodePropertyExistenceConstraint(labelId, propertyKeyId)).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelProp((QueryContext)ctx, label, prop.propertyKey()));
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateRelationshipPropertyExistenceConstraint) {
                    CreateRelationshipPropertyExistenceConstraint createRelationshipPropertyExistenceConstraint = (CreateRelationshipPropertyExistenceConstraint)A1;
                    Option source = createRelationshipPropertyExistenceConstraint.source();
                    RelTypeName relType = createRelationshipPropertyExistenceConstraint.typeName();
                    Property prop = createRelationshipPropertyExistenceConstraint.prop();
                    Option name = createRelationshipPropertyExistenceConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateRelationshipPropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((Function3 & Serializable & scala.Serializable)(Function3 & Serializable & scala.Serializable)(relTypeId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$27(ctx, BoxesRunTime.unboxToInt((Object)relTypeId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName((QueryContext)ctx, relType, prop.propertyKey(), (Option<String>)name));
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$11 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$11, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropRelationshipPropertyExistenceConstraint) {
                    DropRelationshipPropertyExistenceConstraint dropRelationshipPropertyExistenceConstraint = (DropRelationshipPropertyExistenceConstraint)A1;
                    RelTypeName relType = dropRelationshipPropertyExistenceConstraint.typeName();
                    Property prop = dropRelationshipPropertyExistenceConstraint.prop();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$12, x$13) -> new SchemaWriteExecutionPlan("DropRelationshipPropertyExistenceConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        ((JFunction2.mcVII.sp & Serializable & scala.Serializable)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(relTypeId, propertyKeyId) -> ctx.dropRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId)).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typeProp((QueryContext)ctx, relType, prop.propertyKey()));
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DropConstraintOnName) {
                    DropConstraintOnName dropConstraintOnName = (DropConstraintOnName)A1;
                    String name = dropConstraintOnName.name();
                    boolean ifExists = dropConstraintOnName.ifExists();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> new SchemaWriteExecutionPlan("DropConstraint", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        block0: {
                            if (ifExists && !ctx.constraintExists(name)) break block0;
                            ctx.dropNamedConstraint(name);
                        }
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateIndex) {
                    CreateIndex createIndex = (CreateIndex)A1;
                    Option source = createIndex.source();
                    LabelName label = createIndex.label();
                    List props = createIndex.propertyKeyNames();
                    Option name = createIndex.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(context, parameterMapping) -> new SchemaWriteExecutionPlan("CreateIndex", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        List propertyKeyIds = (List)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$37(ctx, p)), List$.MODULE$.canBuildFrom());
                        ctx.addIndexRule(labelId, (Seq)propertyKeyIds, name);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$16 -> (ExecutionPlan)((Function2)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$16, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context, parameterMapping)));
                } else if (A1 instanceof DropIndex) {
                    DropIndex dropIndex = (DropIndex)A1;
                    LabelName label = dropIndex.label();
                    List props = dropIndex.propertyKeyNames();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$17, x$18) -> new SchemaWriteExecutionPlan("DropIndex", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        LabelId labelId = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelToId((QueryContext)ctx, label);
                        List propertyKeyIds = (List)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$42(ctx, p)), List$.MODULE$.canBuildFrom());
                        ctx.dropIndexRule(NameId$.MODULE$.toKernelEncode((NameId)labelId), (Seq)propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DropIndexOnName) {
                    DropIndexOnName dropIndexOnName = (DropIndexOnName)A1;
                    String name = dropIndexOnName.name();
                    boolean ifExists = dropIndexOnName.ifExists();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$19, x$20) -> new SchemaWriteExecutionPlan("DropIndex", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        block0: {
                            if (ifExists && !ctx.indexExists(name)) break block0;
                            ctx.dropIndexRule(name);
                        }
                        return SuccessResult$.MODULE$;
                    }, SchemaWriteExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DoNothingIfExistsForIndex) {
                    DoNothingIfExistsForIndex doNothingIfExistsForIndex = (DoNothingIfExistsForIndex)A1;
                    LabelName label = doNothingIfExistsForIndex.label();
                    List propertyKeyNames = doNothingIfExistsForIndex.propertyKeyNames();
                    Option name = doNothingIfExistsForIndex.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$21, x$22) -> new SchemaWriteExecutionPlan("DoNothingIfNotExist", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        List propertyKeyIds;
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        return Try$.MODULE$.apply(() -> anonfun.1.$anonfun$applyOrElse$48(ctx, labelId, propertyKeyIds = (List)propertyKeyNames.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$47(ctx, p)), List$.MODULE$.canBuildFrom()))).isSuccess() ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$49(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$);
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                } else if (A1 instanceof DoNothingIfExistsForConstraint) {
                    DoNothingIfExistsForConstraint doNothingIfExistsForConstraint = (DoNothingIfExistsForConstraint)A1;
                    Either entityType = doNothingIfExistsForConstraint.entityType();
                    Seq props = doNothingIfExistsForConstraint.props();
                    ConstraintType assertion = doNothingIfExistsForConstraint.assertion();
                    Option name = doNothingIfExistsForConstraint.name();
                    intersect = (Function2 & Serializable & scala.Serializable)(x$23, x$24) -> new SchemaWriteExecutionPlan("DoNothingIfNotExist", (Function1<QueryContext, SchemaWriteExecutionResult>)(Function1 & Serializable & scala.Serializable)ctx -> {
                        int n;
                        Either either = entityType;
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            LabelName label = (LabelName)left.value();
                            n = ctx.getOrCreateLabelId(label.name());
                        } else if (either instanceof Right) {
                            Right right = (Right)either;
                            RelTypeName relType = (RelTypeName)right.value();
                            n = ctx.getOrCreateRelTypeId(relType.name());
                        } else {
                            throw new MatchError((Object)either);
                        }
                        int entityId = n;
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$52(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        return ctx.constraintExists(SchemaCommandRuntime$.MODULE$.convertConstraintTypeToConstraintMatcher(assertion), entityId, propertyKeyIds) ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$53(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$);
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                } else {
                    intersect = function1.apply(x1);
                }
                return (B1)intersect;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof CreateNodeKeyConstraint ? true : (logicalPlan instanceof DropNodeKeyConstraint ? true : (logicalPlan instanceof CreateUniquePropertyConstraint ? true : (logicalPlan instanceof DropUniquePropertyConstraint ? true : (logicalPlan instanceof CreateNodePropertyExistenceConstraint ? true : (logicalPlan instanceof DropNodePropertyExistenceConstraint ? true : (logicalPlan instanceof CreateRelationshipPropertyExistenceConstraint ? true : (logicalPlan instanceof DropRelationshipPropertyExistenceConstraint ? true : (logicalPlan instanceof DropConstraintOnName ? true : (logicalPlan instanceof CreateIndex ? true : (logicalPlan instanceof DropIndex ? true : (logicalPlan instanceof DropIndexOnName ? true : (logicalPlan instanceof DoNothingIfExistsForIndex ? true : logicalPlan instanceof DoNothingIfExistsForConstraint))))))))))));
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$3(QueryContext ctx$1, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$1, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$8(QueryContext ctx$2, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$2, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$11(QueryContext ctx$3, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$3, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$16(QueryContext ctx$4, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$4, p.propertyKey()).id();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$19(QueryContext ctx$5, int labelId, int propertyKeyId, Option name) {
                ctx$5.createNodePropertyExistenceConstraint(labelId, propertyKeyId, name);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$27(QueryContext ctx$7, int relTypeId, int propertyKeyId, Option name) {
                ctx$7.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId, name);
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$37(QueryContext ctx$9, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$9, p).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$42(QueryContext ctx$10, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$10, p).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$47(QueryContext ctx$11, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$11, p).id();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$48(QueryContext ctx$11, int labelId$1, List propertyKeyIds$1) {
                return ctx$11.indexReference(labelId$1, (Seq)propertyKeyIds$1).getName();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$49(QueryContext ctx$11, String name) {
                return ctx$11.indexExists(name);
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$52(QueryContext ctx$12, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$12, p.propertyKey()).id();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$53(QueryContext ctx$12, String name) {
                return ctx$12.constraintExists(name);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$6(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$9(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$14(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$17(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$22(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$25(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$30(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$33(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$35(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$40(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$43(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$45(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$50(scala.util.Either scala.collection.Seq org.neo4j.cypher.internal.logical.plans.ConstraintType scala.Option org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping ), $anonfun$applyOrElse$3$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$8$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$7(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$11$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$13(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$10(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$12(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$16$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$15(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$19$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$21(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$18(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$20(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$24(org.neo4j.cypher.internal.runtime.QueryContext int int ), $anonfun$applyOrElse$23(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$27$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$29(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$26(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$28(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$32(org.neo4j.cypher.internal.runtime.QueryContext int int ), $anonfun$applyOrElse$31(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$34(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$37$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$39(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$36(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$38(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.runtime.ParameterMapping org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForIndex ), $anonfun$applyOrElse$42$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$41(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$44(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$47$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$48(org.neo4j.cypher.internal.runtime.QueryContext int scala.collection.immutable.List ), $anonfun$applyOrElse$49$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$46(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext ), $anonfun$applyOrElse$52$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$53$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$51(scala.util.Either scala.collection.Seq org.neo4j.cypher.internal.logical.plans.ConstraintType scala.Option org.neo4j.cypher.internal.runtime.QueryContext )}, serializedLambda);
            }
        };
    }
}

