/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.DefaultPlanStalenessCaller;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r]c\u0001\u0002\u001b6\u0001yB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003Q\u0011!9\u0006A!b\u0001\n\u0003A\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0015\u0005\r\u0001A!b\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\u000e\u0001\u0011\t\u0011)A\u0005\u0003\u000fA!\"a\u0004\u0001\u0005\u000b\u0007I\u0011AA\t\u0011)\tI\u0002\u0001B\u0001B\u0003%\u00111\u0003\u0005\u000b\u00037\u0001!Q1A\u0005\u0002\u0005u\u0001BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002 !Q\u0011Q\u0006\u0001\u0003\u0006\u0004%\t!a\f\t\u0015\u0005\u0005\u0003A!A!\u0002\u0013\t\t\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u0013\u0005e\u0003A1A\u0005\n\u0005m\u0003\u0002CA7\u0001\u0001\u0006I!!\u0018\t\u0013\u0005=\u0004A1A\u0005\n\u0005E\u0004\u0002CA=\u0001\u0001\u0006I!a\u001d\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0004\u0002CAC\u0001\u0001\u0006I!a \t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"I\u0011Q\u0015\u0001C\u0002\u0013%\u0011q\u0015\u0005\t\u0003_\u0003\u0001\u0015!\u0003\u0002*\"I\u0011\u0011\u0017\u0001C\u0002\u0013%\u00111\u0017\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u00026\"I\u0011Q\u0018\u0001C\u0002\u0013%\u0011q\u0018\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002B\"I\u0011\u0011\u001a\u0001C\u0002\u0013%\u00111\u001a\u0005\t\u0003'\u0004\u0001\u0015!\u0003\u0002N\"I\u0011Q\u001b\u0001C\u0002\u0013%\u0011q\u001b\u0005\t\u0003?\u0004\u0001\u0015!\u0003\u0002Z\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\bbBAq\u0001\u0011\u0005!Q\u0004\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0011\u001d\u00119\u0006\u0001C\u0005\u00053BqAa&\u0001\t\u0013\u0011I\nC\u0004\u00034\u0002!IA!.\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"9!1\u001b\u0001\u0005\u0002\tU\u0007b\u0002Bo\u0001\u0011\u0005!q\u001c\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011I\u0010\u0001C\u0005\u0005w<qaa\u000b6\u0011\u0003\u0019iC\u0002\u00045k!\u00051q\u0006\u0005\b\u0003\u0007zC\u0011AB\u0019\u0011%\u0019\u0019d\fb\u0001\n\u0003\u0019)\u0004\u0003\u0005\u0004>=\u0002\u000b\u0011BB\u001c\u0011%\u0019ydLI\u0001\n\u0003\u0019\tEA\bFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\u0015\t1t'\u0001\u0005j]R,'O\\1m\u0015\tA\u0014(\u0001\u0004dsBDWM\u001d\u0006\u0003um\nQA\\3pi)T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0017\u0001D9vKJL8+\u001a:wS\u000e,W#A$\u0011\u0005![U\"A%\u000b\u0005)K\u0014AB6fe:,G.\u0003\u0002M\u0013\nIrI]1qQ\u0012\u000bG/\u00192bg\u0016\fV/\u001a:z'\u0016\u0014h/[2f\u00035\tX/\u001a:z'\u0016\u0014h/[2fA\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005MK\u0014AC7p]&$xN]5oO&\u0011QK\u0015\u0002\t\u001b>t\u0017\u000e^8sg\u0006y1.\u001a:oK2luN\\5u_J\u001c\b%\u0001\u0004ue\u0006\u001cWM]\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A,N\u0001\biJ\f7-\u001b8h\u0013\tq6LA\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJ\fq\u0001\u001e:bG\u0016\u0014\b%A\u0006dC\u000eDW\r\u0016:bG\u0016\u0014X#\u00012\u0011\u0007\r$g-D\u00016\u0013\t)WGA\u0006DC\u000eDW\r\u0016:bG\u0016\u0014\bcA4vq:\u0011\u0001n\u001d\b\u0003SJt!A[9\u000f\u0005-\u0004hB\u00017p\u001b\u0005i'B\u00018>\u0003\u0019a$o\\8u}%\tA(\u0003\u0002;w%\u0011\u0001(O\u0005\u0003m]J!\u0001^\u001b\u0002\u0015E+XM]=DC\u000eDW-\u0003\u0002wo\nA1)Y2iK.+\u0017P\u0003\u0002ukA\u0011\u00110 \b\u0003un\u0004\"\u0001\\!\n\u0005q\f\u0015A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001`!\u0002\u0019\r\f7\r[3Ue\u0006\u001cWM\u001d\u0011\u0002\r\r|gNZ5h+\t\t9\u0001E\u0002d\u0003\u0013I1!a\u00036\u0005M\u0019\u0015\u0010\u001d5fe\u000e{gNZ5hkJ\fG/[8o\u0003\u001d\u0019wN\u001c4jO\u0002\nqbY8na&dWM\u001d'jEJ\f'/_\u000b\u0003\u0003'\u00012aYA\u000b\u0013\r\t9\"\u000e\u0002\u0010\u0007>l\u0007/\u001b7fe2K'M]1ss\u0006\u00012m\\7qS2,'\u000fT5ce\u0006\u0014\u0018\u0010I\u0001\fY><\u0007K]8wS\u0012,'/\u0006\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&e\nq\u0001\\8hO&tw-\u0003\u0003\u0002*\u0005\r\"a\u0003'pOB\u0013xN^5eKJ\fA\u0002\\8h!J|g/\u001b3fe\u0002\nQa\u00197pG.,\"!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005!A/[7f\u0015\t\tY$\u0001\u0003kCZ\f\u0017\u0002BA \u0003k\u0011Qa\u00117pG.\faa\u00197pG.\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002H\u0005%\u00131JA'\u0003\u001f\n\t&a\u0015\u0002V\u0005]\u0003CA2\u0001\u0011\u0015)\u0015\u00031\u0001H\u0011\u0015q\u0015\u00031\u0001Q\u0011\u00159\u0016\u00031\u0001Z\u0011\u0015\u0001\u0017\u00031\u0001c\u0011\u001d\t\u0019!\u0005a\u0001\u0003\u000fAq!a\u0004\u0012\u0001\u0004\t\u0019\u0002C\u0004\u0002\u001cE\u0001\r!a\b\t\u0013\u00055\u0012\u0003%AA\u0002\u0005E\u0012\u0001\b3fM\u0006,H\u000e^)vKJLX\t_3dkRLwN\\'p]&$xN]\u000b\u0003\u0003;\u0002B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0003rk\u0016\u0014\u0018PC\u0002\u0002h%\u000bA![7qY&!\u00111NA1\u0005U\tV/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J\fQ\u0004Z3gCVdG/U;fef,\u00050Z2vi&|g.T8oSR|'\u000fI\u0001\naJ,\u0007+\u0019:tKJ,\"!a\u001d\u0011\u0007\r\f)(C\u0002\u0002xU\u0012\u0011\u0002\u0015:f!\u0006\u00148/\u001a:\u0002\u0015A\u0014X\rU1sg\u0016\u0014\b%A\rmCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014XCAA@!\r\u0019\u0017\u0011Q\u0005\u0004\u0003\u0007+$!\u0007'bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\f!\u0004\\1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3fe\u0002\n\u0001\u0003\u001d7b]J+Wo]1cS2LG/[=\u0015\r\u0005-\u0015\u0011SAN!\r\u0019\u0017QR\u0005\u0004\u0003\u001f+$\u0001\u0005*fkN\f'-\u001b7jif\u001cF/\u0019;f\u0011\u001d\t\u0019\n\u0007a\u0001\u0003+\u000bq\"\u001a=fGV$\u0018M\u00197f#V,'/\u001f\t\u0004G\u0006]\u0015bAAMk\tyQ\t_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010C\u0004\u0002\u001eb\u0001\r!a(\u0002)Q\u0014\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u!\u0011\ty&!)\n\t\u0005\r\u0016\u0011\r\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\u0002\u00071|w-\u0006\u0002\u0002*B!\u0011\u0011EAV\u0013\u0011\ti+a\t\u0003\u00071{w-\u0001\u0003m_\u001e\u0004\u0013a\u00059mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014XCAA[!\u0015\u0019\u0017qWAK\u0013\r\tI,\u000e\u0002\u001b\t\u00164\u0017-\u001e7u!2\fgn\u0015;bY\u0016tWm]:DC2dWM]\u0001\u0015a2\fgn\u0015;bY\u0016tWm]:DC2dWM\u001d\u0011\u0002\u0015E,XM]=DC\u000eDW-\u0006\u0002\u0002BB11-a1g\u0003+K1!!26\u0005)\tV/\u001a:z\u0007\u0006\u001c\u0007.Z\u0001\fcV,'/_\"bG\",\u0007%\u0001\bnCN$XM]\"p[BLG.\u001a:\u0016\u0005\u00055\u0007cA2\u0002P&\u0019\u0011\u0011[\u001b\u0003\u001d5\u000b7\u000f^3s\u0007>l\u0007/\u001b7fe\u0006yQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b%\u0001\u0007tG\",W.\u0019%fYB,'/\u0006\u0002\u0002ZB\u00191-a7\n\u0007\u0005uWG\u0001\u0007TG\",W.\u0019%fYB,'/A\u0007tG\",W.\u0019%fYB,'\u000fI\u0001\bKb,7-\u001e;f)9\t)/a;\u0002n\n\u0005!Q\u0001B\b\u0005'\u0001B!a\u0018\u0002h&!\u0011\u0011^A1\u00059\tV/\u001a:z\u000bb,7-\u001e;j_:Da!a\u0019$\u0001\u0004A\bbBAxG\u0001\u0007\u0011\u0011_\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005M\u0018Q`\u0007\u0003\u0003kTA!a>\u0002z\u00069a/\u001b:uk\u0006d'bAA~s\u00051a/\u00197vKNLA!a@\u0002v\nAQ*\u00199WC2,X\rC\u0004\u0003\u0004\r\u0002\r!a(\u0002\u000f\r|g\u000e^3yi\"9!qA\u0012A\u0002\t%\u0011a\u00029s_\u001aLG.\u001a\t\u0004\u0001\n-\u0011b\u0001B\u0007\u0003\n9!i\\8mK\u0006t\u0007b\u0002B\tG\u0001\u0007!\u0011B\u0001\faJ,\u0007k\u001c9vY\u0006$X\rC\u0004\u0003\u0016\r\u0002\rAa\u0006\u0002\u0015M,(m]2sS\n,'\u000f\u0005\u0003\u0002`\te\u0011\u0002\u0002B\u000e\u0003C\u0012q\"U;fef\u001cVOY:de&\u0014WM\u001d\u000b\u0011\u0003K\u0014yBa\n\u0003*\t-\"Q\u0006B\u001f\u0005\u0003Bq!a\u0019%\u0001\u0004\u0011\t\u0003E\u0002d\u0005GI1A!\n6\u0005A1U\u000f\u001c7z!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010C\u0004\u0002p\u0012\u0002\r!!=\t\u000f\t\rA\u00051\u0001\u0002 \"9!\u0011\u0003\u0013A\u0002\t%\u0001b\u0002B\u0018I\u0001\u0007!\u0011G\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)\u0019!qG\u001b\u0002\u000fI,h\u000e^5nK&!!1\bB\u001b\u0005=Ie\u000e];u\t\u0006$\u0018m\u0015;sK\u0006l\u0007b\u0002B I\u0001\u0007\u0011QL\u0001\rcV,'/_'p]&$xN\u001d\u0005\b\u0005+!\u0003\u0019\u0001B\f\u0003=)\u00070Z2vi\u0016\u001cVOY)vKJLH\u0003EAs\u0005\u000f\u0012IEa\u0013\u0003N\tE#1\u000bB+\u0011\u0019\t\u0019'\na\u0001q\"9\u0011q^\u0013A\u0002\u0005E\bb\u0002B\u0002K\u0001\u0007\u0011q\u0014\u0005\b\u0005\u001f*\u0003\u0019\u0001B\u0005\u0003AI7oT;uKJlwn\u001d;Rk\u0016\u0014\u0018\u0010C\u0004\u0003\b\u0015\u0002\rA!\u0003\t\u000f\tEQ\u00051\u0001\u0003\n!9!QC\u0013A\u0002\t]\u0011aB2m_NLgnZ\u000b\u0005\u00057\u0012\u0019\u0007\u0006\u0004\u0003^\t}$\u0011\u0011\u000b\u0005\u0005?\u0012)\b\u0005\u0003\u0003b\t\rD\u0002\u0001\u0003\b\u0005K2#\u0019\u0001B4\u0005\u0005!\u0016\u0003\u0002B5\u0005_\u00022\u0001\u0011B6\u0013\r\u0011i'\u0011\u0002\b\u001d>$\b.\u001b8h!\r\u0001%\u0011O\u0005\u0004\u0005g\n%aA!os\"A!q\u000f\u0014\u0005\u0002\u0004\u0011I(\u0001\u0003d_\u0012,\u0007#\u0002!\u0003|\t}\u0013b\u0001B?\u0003\nAAHY=oC6,g\bC\u0004\u0003\u0004\u0019\u0002\r!a(\t\u000f\t\re\u00051\u0001\u0003\u0006\u0006QAO]1dK\u00163XM\u001c;\u0011\t\t\u001d%\u0011\u0013\b\u0005\u0005\u0013\u0013iID\u0002i\u0005\u0017K!\u0001X\u001b\n\u0007\t=5,A\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJLAAa%\u0003\u0016\n)\u0012+^3ss\u000e{W\u000e]5mCRLwN\\#wK:$(b\u0001BH7\u0006IAm\\#yK\u000e,H/\u001a\u000b\u0015\u0003K\u0014YJa)\u0003&\n\u001d&\u0011\u0016BV\u0005[\u0013yK!-\t\u000f\u0005\rt\u00051\u0001\u0003\u001eB\u00191Ma(\n\u0007\t\u0005VG\u0001\u0006J]B,H/U;fefDq!a<(\u0001\u0004\t\t\u0010C\u0004\u0003\u0004\u001d\u0002\r!a(\t\u000f\t=s\u00051\u0001\u0003\n!9!\u0011C\u0014A\u0002\t%\u0001b\u0002B\u0018O\u0001\u0007!\u0011\u0007\u0005\b\u0005\u007f9\u0003\u0019AA/\u0011\u00199v\u00051\u0001\u0003\u0006\"9!QC\u0014A\u0002\t]\u0011aI2p[BLG.\u001a:XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8PaRLwN\u001c\u000b\u000b\u0005o\u0013iL!1\u0003D\n\u0015\u0007#B2\u0003:\u0006U\u0015b\u0001B^k\t\u00193i\\7qS2,'oV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+gn\u00149uS>t\u0007b\u0002B`Q\u0001\u0007!QT\u0001\u000bS:\u0004X\u000f^)vKJL\bBB,)\u0001\u0004\u0011)\tC\u0004\u0002\u001e\"\u0002\r!a(\t\u000f\u0005=\b\u00061\u0001\u0002r\u0006aq-\u001a;Pe\u000e{W\u000e]5mKRQ\u0011Q\u0013Bf\u0005\u001b\u0014yM!5\t\u000f\t\r\u0011\u00061\u0001\u0002 \"9!qX\u0015A\u0002\tu\u0005BB,*\u0001\u0004\u0011)\tC\u0004\u0002p&\u0002\r!!=\u0002!\rdW-\u0019:Rk\u0016\u0014\u0018pQ1dQ\u0016\u001cHC\u0001Bl!\r\u0001%\u0011\\\u0005\u0004\u00057\f%\u0001\u0002'p]\u001e\f\u0001#[:QKJLw\u000eZ5d\u0007>lW.\u001b;\u0015\t\t%!\u0011\u001d\u0005\u0007\u0003GZ\u0003\u0019\u0001=\u0002%\u001d,GoQ=qQ\u0016\u0014h)\u001e8di&|gn]\u000b\u0003\u0005O\u0004bA!;\u0003p\nMXB\u0001Bv\u0015\u0011\u0011i/!\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005c\u0014YO\u0001\u0003MSN$\b\u0003BA0\u0005kLAAa>\u0002b\t\u0019b)\u001e8di&|g.\u00138g_Jl\u0017\r^5p]\u0006y1\r[3dWB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0005\u0003~\u000e\r1QBB\t!\r\u0001%q`\u0005\u0004\u0007\u0003\t%\u0001B+oSRDqa!\u0002.\u0001\u0004\u00199!A\u0006rk\u0016\u0014\u0018\u0010U1sC6\u001c\b\u0003\u0002!\u0004\naL1aa\u0003B\u0005\u0015\t%O]1z\u0011\u001d\u0019y!\fa\u0001\u0003c\f1bZ5wK:\u0004\u0016M]1ng\"911C\u0017A\u0002\u0005E\u0018aD3yiJ\f7\r^3e!\u0006\u0014\u0018-\\:)\u000b5\u001a9b!\u000b\u0011\u000b\u0001\u001bIb!\b\n\u0007\rm\u0011I\u0001\u0004uQJ|wo\u001d\t\u0005\u0007?\u0019)#\u0004\u0002\u0004\")\u001911E\u001d\u0002\u0015\u0015D8-\u001a9uS>t7/\u0003\u0003\u0004(\r\u0005\"A\u0007)be\u0006lW\r^3s\u001d>$hi\\;oI\u0016C8-\u001a9uS>t7EAB\u000f\u0003=)\u00050Z2vi&|g.\u00128hS:,\u0007CA20'\tys\b\u0006\u0002\u0004.\u0005\u0019\u0002\u000bT!O?\n+\u0016\n\u0014#J\u001d\u001e{FKU%F'V\u00111q\u0007\t\u0004\u0001\u000ee\u0012bAB\u001e\u0003\n\u0019\u0011J\u001c;\u0002)Ac\u0015IT0C+&cE)\u0013(H?R\u0013\u0016*R*!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u001111\t\u0016\u0005\u0003c\u0019)e\u000b\u0002\u0004HA!1\u0011JB*\u001b\t\u0019YE\u0003\u0003\u0004N\r=\u0013!C;oG\",7m[3e\u0015\r\u0019\t&Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB+\u0007\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<QueryCache.CacheKey<String>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<QueryCache.CacheKey<String>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<QueryCache.CacheKey<String>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<QueryCache.CacheKey<String>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.defaultQueryExecutionMonitor().startProcessing(context.executingQuery());
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.compilerLibrary().supportsAdministrativeCommands();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, this.defaultQueryExecutionMonitor(), queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), () -> executableQuery.planDescription());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0 ? (ExecutableQuery)this.compiledExpressionCompiler$1.apply() : (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() ? new Some(this.compiledExpressionCompiler$1.apply()) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block5: {
            ExecutableQuery executableQuery;
            block4: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                QueryCache.CacheKey<String> cacheKey = new QueryCache.CacheKey<String>(inputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params), tc.kernelTransaction().dataRead().transactionStateHasChanges());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().replan(), inputQuery.description());
                        if (!this.schemaHelper().lockLabels(schemaToken, executableQuery2, inputQuery.options().version(), tc)) continue;
                        executableQuery = executableQuery2;
                        break block4;
                    }
                    break block5;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2(), this.preParser().preParseQuery$default$3());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().executionMode();
        CypherExecutionMode$explain$ cypherExecutionMode$explain$ = CypherExecutionMode$explain$.MODULE$;
        return (cypherExecutionMode == null ? cypherExecutionMode$explain$ != null : !cypherExecutionMode.equals(cypherExecutionMode$explain$)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(informations).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<QueryCache.CacheKey<String>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.operatorEngine(), config.interpretedPipesFallback(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new ExecutionEngineQueryCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheCompile(Object key) {
                CypherCacheHitMonitor.cacheCompile$(this, key);
            }

            public void cacheCompileWithExpressionCodeGen(Object key) {
                CypherCacheHitMonitor.cacheCompileWithExpressionCodeGen$(this, key);
            }

            public void cacheDiscard(QueryCache.CacheKey<String> ignored, String query, int secondsSinceReplan, Option<String> maybeReason) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(66).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds").append(maybeReason.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)r -> new StringBuilder(10).append(". Reason: ").append((String)r).toString())).append(". Query: ").append(query).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheDiscard$1(), $anonfun$cacheDiscard$2(java.lang.String )}, serializedLambda);
            }
        }, new String[0]);
        this.planStalenessCaller = new DefaultPlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext), this.org$neo4j$cypher$internal$ExecutionEngine$$log());
        this.queryCache = new QueryCache<QueryCache.CacheKey<String>, ExecutableQuery>(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.masterCompiler = new MasterCompiler(compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

