/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.DefaultPlanStalenessCaller;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r%d\u0001\u0002\u001b6\u0001yB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003Q\u0011!9\u0006A!b\u0001\n\u0003A\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0011\"a\u0005\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0015\u0005U\u0001A!b\u0001\n\u0003\t9\u0002\u0003\u0006\u0002 \u0001\u0011\t\u0011)A\u0005\u00033A!\"!\t\u0001\u0005\u000b\u0007I\u0011AA\u0012\u0011)\tY\u0003\u0001B\u0001B\u0003%\u0011Q\u0005\u0005\u000b\u0003[\u0001!Q1A\u0005\u0002\u0005=\u0002BCA\u001f\u0001\t\u0005\t\u0015!\u0003\u00022!Q\u0011q\b\u0001\u0003\u0006\u0004%\t!!\u0011\t\u0015\u0005M\u0003A!A!\u0002\u0013\t\u0019\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u0013\u0005-\u0004A1A\u0005\n\u00055\u0004\u0002CA@\u0001\u0001\u0006I!a\u001c\t\u0013\u0005\u0005\u0005A1A\u0005\n\u0005\r\u0005\u0002CAF\u0001\u0001\u0006I!!\"\t\u0013\u00055\u0005A1A\u0005\n\u0005=\u0005\u0002CAL\u0001\u0001\u0006I!!%\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\"I\u0011q\u0017\u0001C\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u0002<\"I\u00111\u0019\u0001C\u0002\u0013%\u0011Q\u0019\u0005\t\u0003\u001b\u0004\u0001\u0015!\u0003\u0002H\"I\u0011q\u001a\u0001C\u0002\u0013%\u0011\u0011\u001b\u0005\t\u00033\u0004\u0001\u0015!\u0003\u0002T\"I\u00111\u001c\u0001C\u0002\u0013%\u0011Q\u001c\u0005\t\u0003K\u0004\u0001\u0015!\u0003\u0002`\"I\u0011q\u001d\u0001C\u0002\u0013%\u0011\u0011\u001e\u0005\t\u0003c\u0004\u0001\u0015!\u0003\u0002l\"9\u00111\u001f\u0001\u0005\u0002\u0005U\bbBAz\u0001\u0011\u0005!q\u0006\u0005\b\u0005+\u0002A\u0011\u0001B,\u0011\u001d\u0011I\u0007\u0001C\u0005\u0005WBqA!+\u0001\t\u0013\u0011Y\u000bC\u0004\u0003F\u0002!IAa2\t\u000f\te\u0007\u0001\"\u0003\u0003\\\"9!Q\u001d\u0001\u0005\u0002\t\u001d\bb\u0002Bx\u0001\u0011\u0005!\u0011\u001f\u0005\b\u0005k\u0004A\u0011\u0001B|\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001b9qa!\u00106\u0011\u0003\u0019yD\u0002\u00045k!\u00051\u0011\t\u0005\b\u0003+zC\u0011AB\"\u0011%\u0019)e\fb\u0001\n\u0003\u00199\u0005\u0003\u0005\u0004P=\u0002\u000b\u0011BB%\u0011%\u0019\tfLI\u0001\n\u0003\u0019\u0019FA\bFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\u0015\t1t'\u0001\u0005j]R,'O\\1m\u0015\tA\u0014(\u0001\u0004dsBDWM\u001d\u0006\u0003um\nQA\\3pi)T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0017\u0001D9vKJL8+\u001a:wS\u000e,W#A$\u0011\u0005![U\"A%\u000b\u0005)K\u0014AB6fe:,G.\u0003\u0002M\u0013\nIrI]1qQ\u0012\u000bG/\u00192bg\u0016\fV/\u001a:z'\u0016\u0014h/[2f\u00035\tX/\u001a:z'\u0016\u0014h/[2fA\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005MK\u0014AC7p]&$xN]5oO&\u0011QK\u0015\u0002\t\u001b>t\u0017\u000e^8sg\u0006y1.\u001a:oK2luN\\5u_J\u001c\b%\u0001\u0004ue\u0006\u001cWM]\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A,N\u0001\biJ\f7-\u001b8h\u0013\tq6LA\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJ\fq\u0001\u001e:bG\u0016\u0014\b%A\u0006dC\u000eDW\r\u0016:bG\u0016\u0014X#\u00012\u0011\u0007\r$g-D\u00016\u0013\t)WGA\u0006DC\u000eDW\r\u0016:bG\u0016\u0014\b\u0003B4n_jl\u0011\u0001\u001b\u0006\u0003S*\f!bY8mY\u0016\u001cG/[8o\u0015\tYG.A\u0004iK2\u0004XM]:\u000b\u0005YJ\u0014B\u00018i\u0005\u0011\u0001\u0016-\u001b:\u0011\u0005A<hBA9v!\t\u0011\u0018)D\u0001t\u0015\t!X(\u0001\u0004=e>|GOP\u0005\u0003m\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011a/\u0011\t\u0004w\u00065ab\u0001?\u0002\n9\u0019Q0a\u0002\u000f\u0007y\f)AD\u0002\u0000\u0003\u0007q1A]A\u0001\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u00027o%\u0019\u00111B\u001b\u0002\u0015E+XM]=DC\u000eDW-\u0003\u0003\u0002\u0010\u0005E!\u0001\u0005)be\u0006lW\r^3s)f\u0004X-T1q\u0015\r\tY!N\u0001\rG\u0006\u001c\u0007.\u001a+sC\u000e,'\u000fI\u0001\u0007G>tg-[4\u0016\u0005\u0005e\u0001cA2\u0002\u001c%\u0019\u0011QD\u001b\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000f\r|gNZ5hA\u0005y1m\\7qS2,'\u000fT5ce\u0006\u0014\u00180\u0006\u0002\u0002&A\u00191-a\n\n\u0007\u0005%RGA\bD_6\u0004\u0018\u000e\\3s\u0019&\u0014'/\u0019:z\u0003A\u0019w.\u001c9jY\u0016\u0014H*\u001b2sCJL\b%A\u0006m_\u001e\u0004&o\u001c<jI\u0016\u0014XCAA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cs\u00059An\\4hS:<\u0017\u0002BA\u001e\u0003k\u00111\u0002T8h!J|g/\u001b3fe\u0006aAn\\4Qe>4\u0018\u000eZ3sA\u0005)1\r\\8dWV\u0011\u00111\t\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0011!\u0018.\\3\u000b\u0005\u00055\u0013\u0001\u00026bm\u0006LA!!\u0015\u0002H\t)1\t\\8dW\u000611\r\\8dW\u0002\na\u0001P5oSRtDCEA-\u00037\ni&a\u0018\u0002b\u0005\r\u0014QMA4\u0003S\u0002\"a\u0019\u0001\t\u000b\u0015\u000b\u0002\u0019A$\t\u000b9\u000b\u0002\u0019\u0001)\t\u000b]\u000b\u0002\u0019A-\t\u000b\u0001\f\u0002\u0019\u00012\t\u000f\u0005U\u0011\u00031\u0001\u0002\u001a!9\u0011\u0011E\tA\u0002\u0005\u0015\u0002bBA\u0017#\u0001\u0007\u0011\u0011\u0007\u0005\n\u0003\u007f\t\u0002\u0013!a\u0001\u0003\u0007\nA\u0004Z3gCVdG/U;fef,\u00050Z2vi&|g.T8oSR|'/\u0006\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!B9vKJL(bAA=\u0013\u0006!\u0011.\u001c9m\u0013\u0011\ti(a\u001d\u0003+E+XM]=Fq\u0016\u001cW\u000f^5p]6{g.\u001b;pe\u0006iB-\u001a4bk2$\u0018+^3ss\u0016CXmY;uS>tWj\u001c8ji>\u0014\b%A\u0005qe\u0016\u0004\u0016M]:feV\u0011\u0011Q\u0011\t\u0004G\u0006\u001d\u0015bAAEk\tI\u0001K]3QCJ\u001cXM]\u0001\u000baJ,\u0007+\u0019:tKJ\u0004\u0013!\u00077bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ,\"!!%\u0011\u0007\r\f\u0019*C\u0002\u0002\u0016V\u0012\u0011\u0004T1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3fe\u0006QB.Y:u\u0007>lW.\u001b;uK\u0012$\u00060\u00133Qe>4\u0018\u000eZ3sA\u0005\u0001\u0002\u000f\\1o%\u0016,8/\u00192jY&$\u0018.\u001f\u000b\u0007\u0003;\u000b\u0019+!,\u0011\u0007\r\fy*C\u0002\u0002\"V\u0012\u0001CU3vg\u0006\u0014\u0017\u000e\\5usN#\u0018\r^3\t\u000f\u0005\u0015\u0006\u00041\u0001\u0002(\u0006yQ\r_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010E\u0002d\u0003SK1!a+6\u0005=)\u00050Z2vi\u0006\u0014G.Z)vKJL\bbBAX1\u0001\u0007\u0011\u0011W\u0001\u0015iJ\fgn]1di&|g.\u00197D_:$X\r\u001f;\u0011\t\u0005E\u00141W\u0005\u0005\u0003k\u000b\u0019H\u0001\u000bUe\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010^\u0001\u0004Y><WCAA^!\u0011\t\u0019$!0\n\t\u0005}\u0016Q\u0007\u0002\u0004\u0019><\u0017\u0001\u00027pO\u0002\n1\u0003\u001d7b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ,\"!a2\u0011\u000b\r\fI-a*\n\u0007\u0005-WG\u0001\u000eEK\u001a\fW\u000f\u001c;QY\u0006t7\u000b^1mK:,7o]\"bY2,'/\u0001\u000bqY\u0006t7\u000b^1mK:,7o]\"bY2,'\u000fI\u0001\u000bcV,'/_\"bG\",WCAAj!\u001d\u0019\u0017Q[8g\u0003OK1!a66\u0005)\tV/\u001a:z\u0007\u0006\u001c\u0007.Z\u0001\fcV,'/_\"bG\",\u0007%\u0001\bnCN$XM]\"p[BLG.\u001a:\u0016\u0005\u0005}\u0007cA2\u0002b&\u0019\u00111]\u001b\u0003\u001d5\u000b7\u000f^3s\u0007>l\u0007/\u001b7fe\u0006yQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b%\u0001\u0007tG\",W.\u0019%fYB,'/\u0006\u0002\u0002lB\u00191-!<\n\u0007\u0005=XG\u0001\u0007TG\",W.\u0019%fYB,'/A\u0007tG\",W.\u0019%fYB,'\u000fI\u0001\bKb,7-\u001e;f)9\t90!@\u0002\u0000\nM!q\u0003B\u0011\u0005K\u0001B!!\u001d\u0002z&!\u00111`A:\u00059\tV/\u001a:z\u000bb,7-\u001e;j_:Da!!\u001e$\u0001\u0004y\u0007b\u0002B\u0001G\u0001\u0007!1A\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\t\u0015!qB\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u00059a/\u001b:uk\u0006d'b\u0001B\u0007s\u00051a/\u00197vKNLAA!\u0005\u0003\b\tAQ*\u00199WC2,X\rC\u0004\u0003\u0016\r\u0002\r!!-\u0002\u000f\r|g\u000e^3yi\"9!\u0011D\u0012A\u0002\tm\u0011a\u00029s_\u001aLG.\u001a\t\u0004\u0001\nu\u0011b\u0001B\u0010\u0003\n9!i\\8mK\u0006t\u0007b\u0002B\u0012G\u0001\u0007!1D\u0001\faJ,\u0007k\u001c9vY\u0006$X\rC\u0004\u0003(\r\u0002\rA!\u000b\u0002\u0015M,(m]2sS\n,'\u000f\u0005\u0003\u0002r\t-\u0012\u0002\u0002B\u0017\u0003g\u0012q\"U;fef\u001cVOY:de&\u0014WM\u001d\u000b\u0011\u0003o\u0014\tD!\u000f\u0003<\tu\"q\bB(\u0005'Bq!!\u001e%\u0001\u0004\u0011\u0019\u0004E\u0002d\u0005kI1Aa\u000e6\u0005A1U\u000f\u001c7z!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010C\u0004\u0003\u0002\u0011\u0002\rAa\u0001\t\u000f\tUA\u00051\u0001\u00022\"9!1\u0005\u0013A\u0002\tm\u0001b\u0002B!I\u0001\u0007!1I\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0005\u000b\u0012Y%\u0004\u0002\u0003H)\u0019!\u0011J\u001b\u0002\u000fI,h\u000e^5nK&!!Q\nB$\u0005=Ie\u000e];u\t\u0006$\u0018m\u0015;sK\u0006l\u0007b\u0002B)I\u0001\u0007\u0011qN\u0001\rcV,'/_'p]&$xN\u001d\u0005\b\u0005O!\u0003\u0019\u0001B\u0015\u0003=)\u00070Z2vi\u0016\u001cVOY)vKJLH\u0003EA|\u00053\u0012YF!\u0018\u0003`\t\r$Q\rB4\u0011\u0019\t)(\na\u0001_\"9!\u0011A\u0013A\u0002\t\r\u0001b\u0002B\u000bK\u0001\u0007\u0011\u0011\u0017\u0005\b\u0005C*\u0003\u0019\u0001B\u000e\u0003AI7oT;uKJlwn\u001d;Rk\u0016\u0014\u0018\u0010C\u0004\u0003\u001a\u0015\u0002\rAa\u0007\t\u000f\t\rR\u00051\u0001\u0003\u001c!9!qE\u0013A\u0002\t%\u0012aB2m_NLgnZ\u000b\u0005\u0005[\u0012)\b\u0006\u0004\u0003p\tE%1\u0013\u000b\u0005\u0005c\u00129\t\u0005\u0003\u0003t\tUD\u0002\u0001\u0003\b\u0005o2#\u0019\u0001B=\u0005\u0005!\u0016\u0003\u0002B>\u0005\u0003\u00032\u0001\u0011B?\u0013\r\u0011y(\u0011\u0002\b\u001d>$\b.\u001b8h!\r\u0001%1Q\u0005\u0004\u0005\u000b\u000b%aA!os\"A!\u0011\u0012\u0014\u0005\u0002\u0004\u0011Y)\u0001\u0003d_\u0012,\u0007#\u0002!\u0003\u000e\nE\u0014b\u0001BH\u0003\nAAHY=oC6,g\bC\u0004\u0003\u0016\u0019\u0002\r!!-\t\u000f\tUe\u00051\u0001\u0003\u0018\u0006QAO]1dK\u00163XM\u001c;\u0011\t\te%1\u0015\b\u0005\u00057\u0013yJD\u0002}\u0005;K!\u0001X\u001b\n\u0007\t\u00056,A\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJLAA!*\u0003(\n)\u0012+^3ss\u000e{W\u000e]5mCRLwN\\#wK:$(b\u0001BQ7\u0006IAm\\#yK\u000e,H/\u001a\u000b\u0015\u0003o\u0014iK!.\u00038\ne&1\u0018B_\u0005\u007f\u0013\tMa1\t\u000f\u0005Ut\u00051\u0001\u00030B\u00191M!-\n\u0007\tMVG\u0001\u0006J]B,H/U;fefDqA!\u0001(\u0001\u0004\u0011\u0019\u0001C\u0004\u0003\u0016\u001d\u0002\r!!-\t\u000f\t\u0005t\u00051\u0001\u0003\u001c!9!1E\u0014A\u0002\tm\u0001b\u0002B!O\u0001\u0007!1\t\u0005\b\u0005#:\u0003\u0019AA8\u0011\u00199v\u00051\u0001\u0003\u0018\"9!qE\u0014A\u0002\t%\u0012aI2p[BLG.\u001a:XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8PaRLwN\u001c\u000b\u000b\u0005\u0013\u0014yMa5\u0003V\n]\u0007#B2\u0003L\u0006\u001d\u0016b\u0001Bgk\t\u00193i\\7qS2,'oV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+gn\u00149uS>t\u0007b\u0002BiQ\u0001\u0007!qV\u0001\u000bS:\u0004X\u000f^)vKJL\bBB,)\u0001\u0004\u00119\nC\u0004\u00020\"\u0002\r!!-\t\u000f\t\u0005\u0001\u00061\u0001\u0003\u0004\u0005aq-\u001a;Pe\u000e{W\u000e]5mKRQ\u0011q\u0015Bo\u0005?\u0014\tOa9\t\u000f\tU\u0011\u00061\u0001\u00022\"9!\u0011[\u0015A\u0002\t=\u0006BB,*\u0001\u0004\u00119\nC\u0004\u0003\u0002%\u0002\rAa\u0001\u0002!\rdW-\u0019:Rk\u0016\u0014\u0018pQ1dQ\u0016\u001cHC\u0001Bu!\r\u0001%1^\u0005\u0004\u0005[\f%\u0001\u0002'p]\u001e\f\u0001#[:QKJLw\u000eZ5d\u0007>lW.\u001b;\u0015\t\tm!1\u001f\u0005\u0007\u0003kZ\u0003\u0019A8\u0002%\u001d,GoQ=qQ\u0016\u0014h)\u001e8di&|gn]\u000b\u0003\u0005s\u0004bAa?\u0004\u0002\r\u0015QB\u0001B\u007f\u0015\u0011\u0011y0a\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007\u0007\u0011iP\u0001\u0003MSN$\b\u0003BA9\u0007\u000fIAa!\u0003\u0002t\t\u0019b)\u001e8di&|g.\u00138g_Jl\u0017\r^5p]\u0006y1\r[3dWB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0005\u0004\u0010\rU1qDB\u0012!\r\u00015\u0011C\u0005\u0004\u0007'\t%\u0001B+oSRDqaa\u0006.\u0001\u0004\u0019I\"A\u0006rk\u0016\u0014\u0018\u0010U1sC6\u001c\b\u0003\u0002!\u0004\u001c=L1a!\bB\u0005\u0015\t%O]1z\u0011\u001d\u0019\t#\fa\u0001\u0005\u0007\t1bZ5wK:\u0004\u0016M]1ng\"91QE\u0017A\u0002\t\r\u0011aD3yiJ\f7\r^3e!\u0006\u0014\u0018-\\:)\u000b5\u001aIca\u000f\u0011\u000b\u0001\u001bYca\f\n\u0007\r5\u0012I\u0001\u0004uQJ|wo\u001d\t\u0005\u0007c\u00199$\u0004\u0002\u00044)\u00191QG\u001d\u0002\u0015\u0015D8-\u001a9uS>t7/\u0003\u0003\u0004:\rM\"A\u0007)be\u0006lW\r^3s\u001d>$hi\\;oI\u0016C8-\u001a9uS>t7EAB\u0018\u0003=)\u00050Z2vi&|g.\u00128hS:,\u0007CA20'\tys\b\u0006\u0002\u0004@\u0005\u0019\u0002\u000bT!O?\n+\u0016\n\u0014#J\u001d\u001e{FKU%F'V\u00111\u0011\n\t\u0004\u0001\u000e-\u0013bAB'\u0003\n\u0019\u0011J\u001c;\u0002)Ac\u0015IT0C+&cE)\u0013(H?R\u0013\u0016*R*!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u00111Q\u000b\u0016\u0005\u0003\u0007\u001a9f\u000b\u0002\u0004ZA!11LB3\u001b\t\u0019iF\u0003\u0003\u0004`\r\u0005\u0014!C;oG\",7m[3e\u0015\r\u0019\u0019'Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB4\u0007;\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<String, Pair<String, QueryCache.ParameterTypeMap>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, Pair<String, QueryCache.ParameterTypeMap>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.defaultQueryExecutionMonitor().startProcessing(context.executingQuery());
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.compilerLibrary().supportsAdministrativeCommands();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, this.defaultQueryExecutionMonitor(), queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), () -> executableQuery.planDescription());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0 ? (ExecutableQuery)this.compiledExpressionCompiler$1.apply() : (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() ? new Some(this.compiledExpressionCompiler$1.apply()) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block5: {
            ExecutableQuery executableQuery;
            block4: {
                Pair cacheKey = Pair.of((Object)inputQuery.cacheKey(), (Object)QueryCache$.MODULE$.extractParameterTypeMap(params));
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale((Pair<String, QueryCache.ParameterTypeMap>)cacheKey, tc, compiler, inputQuery.options().replan(), inputQuery.description());
                        if (!this.schemaHelper().lockLabels(schemaToken, executableQuery2, inputQuery.options().version(), tc)) continue;
                        executableQuery = executableQuery2;
                        break block4;
                    }
                    break block5;
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2(), this.preParser().preParseQuery$default$3());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().executionMode();
        CypherExecutionMode$explain$ cypherExecutionMode$explain$ = CypherExecutionMode$explain$.MODULE$;
        return (cypherExecutionMode == null ? cypherExecutionMode$explain$ != null : !cypherExecutionMode.equals(cypherExecutionMode$explain$)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(informations).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.operatorEngine(), config.interpretedPipesFallback(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new ExecutionEngineQueryCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheCompile(Object key) {
                CypherCacheHitMonitor.cacheCompile$(this, key);
            }

            public void cacheCompileWithExpressionCodeGen(Object key) {
                CypherCacheHitMonitor.cacheCompileWithExpressionCodeGen$(this, key);
            }

            public void cacheDiscard(Pair<String, QueryCache.ParameterTypeMap> ignored, String query, int secondsSinceReplan, Option<String> maybeReason) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(66).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds").append(maybeReason.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)r -> new StringBuilder(10).append(". Reason: ").append((String)r).toString())).append(". Query: ").append(query).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheDiscard$1(), $anonfun$cacheDiscard$2(java.lang.String )}, serializedLambda);
            }
        }, new String[0]);
        this.planStalenessCaller = new DefaultPlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext), this.org$neo4j$cypher$internal$ExecutionEngine$$log());
        this.queryCache = new QueryCache(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.masterCompiler = new MasterCompiler(compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

