/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import org.neo4j.cypher.internal.FineToReuse$;
import org.neo4j.cypher.internal.MaybeReusable;
import org.neo4j.cypher.internal.NeedsReplan;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanFingerprint;
import org.neo4j.cypher.internal.PlanFingerprintReference;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.GraphStatisticsSnapshot;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics$;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.TransactionalContext;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001-\u00111\u0003\u00157b]N#\u0018\r\\3oKN\u001c8)\u00197mKJT!a\u0001\u0003\u0002\u0011%tG/\u001a:oC2T!!\u0002\u0004\u0002\r\rL\b\u000f[3s\u0015\t9\u0001\"A\u0003oK>$$NC\u0001\n\u0003\ry'oZ\u0002\u0001+\taAg\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aD\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0006G2|7m\u001b\t\u0003-mi\u0011a\u0006\u0006\u00031e\tA\u0001^5nK*\t!$\u0001\u0003kCZ\f\u0017B\u0001\u000f\u0018\u0005\u0015\u0019En\\2l\u0011!q\u0002A!A!\u0002\u0013y\u0012A\u00033jm\u0016\u0014x-\u001a8dKB\u0011\u0001eI\u0007\u0002C)\u0011!EA\u0001\tG>l\u0007/\u001b7fe&\u0011A%\t\u0002\u001a'R\fGo\u001d#jm\u0016\u0014x-\u001a8dK\u000e\u000bGnY;mCR|'\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003ea\u0017m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\u0011\u00079A#&\u0003\u0002*\u001f\tIa)\u001e8di&|g\u000e\r\t\u0003\u001d-J!\u0001L\b\u0003\t1{gn\u001a\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005y!/Z;tC\nLG.\u001b;z\u0013:4w\u000eE\u0003\u000faIjt)\u0003\u00022\u001f\tIa)\u001e8di&|gN\r\t\u0003gQb\u0001\u0001B\u00036\u0001\t\u0007aG\u0001\tF1\u0016\u001bU\u000bV!C\u0019\u0016{\u0016+V#S3F\u0011qG\u000f\t\u0003\u001daJ!!O\b\u0003\u000f9{G\u000f[5oOB\u0011abO\u0005\u0003y=\u00111!\u00118z!\tqT)D\u0001@\u0015\t\u0001\u0015)A\u0003rk\u0016\u0014\u0018P\u0003\u0002C\u0007\u0006!\u0011.\u001c9m\u0015\t!e!\u0001\u0004lKJtW\r\\\u0005\u0003\r~\u0012A\u0003\u0016:b]N\f7\r^5p]\u0006d7i\u001c8uKb$\bC\u0001%J\u001b\u0005\u0011\u0011B\u0001&\u0003\u0005A\u0011V-^:bE&d\u0017\u000e^=Ti\u0006$X\rC\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\u0006\u001d>\u0003\u0016K\u0015\t\u0004\u0011\u0002\u0011\u0004\"\u0002\u000bL\u0001\u0004)\u0002\"\u0002\u0010L\u0001\u0004y\u0002\"\u0002\u0014L\u0001\u00049\u0003\"\u0002\u0018L\u0001\u0004y\u0003\"\u0002+\u0001\t\u0003)\u0016!C:uC2,g.Z:t)\r1\u0016l\u0017\t\u0003\u0011^K!\u0001\u0017\u0002\u0003\u0013M#\u0018\r\\3oKN\u001c\b\"\u0002.T\u0001\u0004i\u0014\u0001\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0003]'\u0002\u0007!'A\u000bdC\u000eDW\rZ#yK\u000e,H/\u00192mKF+XM]=\t\u000bQ\u0003A\u0011\u00010\u0015\u0007Y{F\rC\u0003a;\u0002\u0007\u0011-A\u0002sK\u001a\u0004\"\u0001\u00132\n\u0005\r\u0014!\u0001\u0007)mC:4\u0015N\\4feB\u0014\u0018N\u001c;SK\u001a,'/\u001a8dK\"1Q-\u0018CA\u0002\u0019\f!b\u001d;bi&\u001cH/[2t!\rqq-[\u0005\u0003Q>\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f1a\u001d9j\u0015\tq'!A\u0004qY\u0006tg.\u001a:\n\u0005A\\'aD$sCBD7\u000b^1uSN$\u0018nY:\t\u000bI\u0004A\u0011B:\u0002\u000b\rDWmY6\u0015\u0007Q<(\u0010\u0005\u0002\u000fk&\u0011ao\u0004\u0002\b\u0005>|G.Z1o\u0011\u0019A\u0018\u000f\"a\u0001s\u0006!A/Z:u!\rqq\r\u001e\u0005\u0006wF\u0004\r\u0001`\u0001\bS\u001a4\u0015\r\\:f!\rq\u0001& \t\u0003\u001dyL!a`\b\u0003\tUs\u0017\u000e\u001e")
public class PlanStalenessCaller<EXECUTABLE_QUERY> {
    private final Clock clock;
    private final StatsDivergenceCalculator divergence;
    private final Function0<Object> lastCommittedTxIdProvider;
    private final Function2<EXECUTABLE_QUERY, TransactionalContext, ReusabilityState> reusabilityInfo;

    public Staleness staleness(TransactionalContext transactionalContext, EXECUTABLE_QUERY cachedExecutableQuery) {
        Staleness staleness;
        ReusabilityState reusability = (ReusabilityState)this.reusabilityInfo.apply(cachedExecutableQuery, (Object)transactionalContext);
        ReusabilityState reusabilityState = reusability;
        if (reusabilityState instanceof MaybeReusable) {
            MaybeReusable maybeReusable = (MaybeReusable)reusabilityState;
            PlanFingerprintReference ref = maybeReusable.fingerprint();
            KernelTransaction ktx = transactionalContext.kernelTransaction();
            staleness = this.staleness(ref, (Function0<GraphStatistics>)(Function0 & Serializable & scala.Serializable)() -> TransactionBoundGraphStatistics$.MODULE$.apply(ktx.dataRead(), ktx.schemaRead()));
        } else if (FineToReuse$.MODULE$.equals(reusabilityState)) {
            staleness = NotStale$.MODULE$;
        } else if (reusabilityState instanceof NeedsReplan) {
            NeedsReplan needsReplan = (NeedsReplan)reusabilityState;
            int x = needsReplan.secondsSincePlan();
            staleness = new Stale(x);
        } else {
            throw new MatchError((Object)reusabilityState);
        }
        return staleness;
    }

    public Staleness staleness(PlanFingerprintReference ref, Function0<GraphStatistics> statistics) {
        Product product;
        boolean stale;
        LazyLong currentTimeMillis$lzy = new LazyLong();
        LazyLong currentTxId$lzy = new LazyLong();
        PlanFingerprint f = ref.fingerprint();
        boolean bl = stale = this.divergence.shouldCheck(this.currentTimeMillis$1(currentTimeMillis$lzy), f.lastCheckTimeMillis()) && this.check((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.currentTxId$1(currentTxId$lzy) != f.txId(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$1 = this.currentTimeMillis$1(currentTimeMillis$lzy);
            long x$2 = f.copy$default$1();
            long x$3 = f.copy$default$3();
            GraphStatisticsSnapshot x$4 = f.copy$default$4();
            ref.fingerprint_$eq(f.copy(x$2, x$1, x$3, x$4));
        }) && this.check((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> f.snapshot().diverges(f.snapshot().recompute((GraphStatistics)statistics.apply()), $this.divergence.decay(this.currentTimeMillis$1(currentTimeMillis$lzy) - f.creationTimeMillis())), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$5 = this.currentTimeMillis$1(currentTimeMillis$lzy);
            long x$6 = this.currentTxId$1(currentTxId$lzy);
            long x$7 = f.copy$default$1();
            GraphStatisticsSnapshot x$8 = f.copy$default$4();
            ref.fingerprint_$eq(f.copy(x$7, x$5, x$6, x$8));
        });
        if (stale) {
            int secondsSinceReplan = (int)((this.currentTimeMillis$1(currentTimeMillis$lzy) - f.creationTimeMillis()) / 1000L);
            product = new Stale(secondsSinceReplan);
        } else {
            product = NotStale$.MODULE$;
        }
        return product;
    }

    private boolean check(Function0<Object> test, Function0<BoxedUnit> ifFalse) {
        boolean bl;
        if (test.apply$mcZ$sp()) {
            bl = true;
        } else {
            ifFalse.apply$mcV$sp();
            bl = false;
        }
        return bl;
    }

    private final /* synthetic */ long currentTimeMillis$lzycompute$1(LazyLong currentTimeMillis$lzy$1) {
        long l;
        LazyLong lazyLong = currentTimeMillis$lzy$1;
        synchronized (lazyLong) {
            l = currentTimeMillis$lzy$1.initialized() ? currentTimeMillis$lzy$1.value() : currentTimeMillis$lzy$1.initialize(this.clock.millis());
        }
        return l;
    }

    private final long currentTimeMillis$1(LazyLong currentTimeMillis$lzy$1) {
        return currentTimeMillis$lzy$1.initialized() ? currentTimeMillis$lzy$1.value() : this.currentTimeMillis$lzycompute$1(currentTimeMillis$lzy$1);
    }

    private final /* synthetic */ long currentTxId$lzycompute$1(LazyLong currentTxId$lzy$1) {
        long l;
        LazyLong lazyLong = currentTxId$lzy$1;
        synchronized (lazyLong) {
            l = currentTxId$lzy$1.initialized() ? currentTxId$lzy$1.value() : currentTxId$lzy$1.initialize(this.lastCommittedTxIdProvider.apply$mcJ$sp());
        }
        return l;
    }

    private final long currentTxId$1(LazyLong currentTxId$lzy$1) {
        return currentTxId$lzy$1.initialized() ? currentTxId$lzy$1.value() : this.currentTxId$lzycompute$1(currentTxId$lzy$1);
    }

    public PlanStalenessCaller(Clock clock, StatsDivergenceCalculator divergence, Function0<Object> lastCommittedTxIdProvider, Function2<EXECUTABLE_QUERY, TransactionalContext, ReusabilityState> reusabilityInfo) {
        this.clock = clock;
        this.divergence = divergence;
        this.lastCommittedTxIdProvider = lastCommittedTxIdProvider;
        this.reusabilityInfo = reusabilityInfo;
    }
}

