/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.cypher.operations.CursorUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.Nodes;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;

public abstract class CompiledExpandUtils {
    private static final int NOT_DENSE_DEGREE = -1;

    public static RelationshipSelectionCursor connectingRelationships(Read read, AccessMode mode, CursorFactory cursors, NodeCursor nodeCursor, long fromNode, Direction direction, long toNode) {
        int fromDegree = CompiledExpandUtils.nodeGetDegreeIfDense(read, mode, fromNode, nodeCursor, cursors, direction);
        if (fromDegree == 0) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean fromNodeIsDense = fromDegree != -1;
        read.singleNode(toNode, nodeCursor);
        if (!nodeCursor.next()) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean toNodeIsDense = nodeCursor.isDense();
        if (fromNodeIsDense && toNodeIsDense) {
            Direction relDirection;
            long endNode;
            long startNode;
            int toDegree = CompiledExpandUtils.nodeGetDegree(mode, nodeCursor, cursors, direction);
            if (fromDegree < toDegree) {
                startNode = fromNode;
                endNode = toNode;
                relDirection = direction;
            } else {
                startNode = toNode;
                endNode = fromNode;
                relDirection = direction.reverse();
            }
            return CompiledExpandUtils.connectingRelationshipsIterator(CursorUtils.nodeGetRelationships((Read)read, (CursorFactory)cursors, (NodeCursor)nodeCursor, (long)startNode, (Direction)relDirection), endNode);
        }
        if (fromNodeIsDense) {
            return CompiledExpandUtils.connectingRelationshipsIterator(CursorUtils.nodeGetRelationships((Read)read, (CursorFactory)cursors, (NodeCursor)nodeCursor, (long)toNode, (Direction)direction.reverse()), fromNode);
        }
        return CompiledExpandUtils.connectingRelationshipsIterator(CursorUtils.nodeGetRelationships((Read)read, (CursorFactory)cursors, (NodeCursor)nodeCursor, (long)fromNode, (Direction)direction), toNode);
    }

    public static RelationshipSelectionCursor connectingRelationships(Read read, AccessMode mode, CursorFactory cursors, NodeCursor nodeCursor, long fromNode, Direction direction, long toNode, int[] relTypes) {
        int fromDegree = CompiledExpandUtils.calculateTotalDegreeIfDense(read, mode, fromNode, nodeCursor, direction, relTypes, cursors);
        if (fromDegree == 0) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean fromNodeIsDense = fromDegree != -1;
        read.singleNode(toNode, nodeCursor);
        if (!nodeCursor.next()) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean toNodeIsDense = nodeCursor.isDense();
        if (fromNodeIsDense && toNodeIsDense) {
            Direction relDirection;
            long endNode;
            long startNode;
            int toDegree = CompiledExpandUtils.calculateTotalDegree(mode, nodeCursor, direction, relTypes, cursors);
            if (fromDegree < toDegree) {
                startNode = fromNode;
                endNode = toNode;
                relDirection = direction;
            } else {
                startNode = toNode;
                endNode = fromNode;
                relDirection = direction.reverse();
            }
            return CompiledExpandUtils.connectingRelationshipsIterator(CursorUtils.nodeGetRelationships((Read)read, (CursorFactory)cursors, (NodeCursor)nodeCursor, (long)startNode, (Direction)relDirection, (int[])relTypes), endNode);
        }
        if (fromNodeIsDense) {
            return CompiledExpandUtils.connectingRelationshipsIterator(CursorUtils.nodeGetRelationships((Read)read, (CursorFactory)cursors, (NodeCursor)nodeCursor, (long)toNode, (Direction)direction.reverse(), (int[])relTypes), fromNode);
        }
        return CompiledExpandUtils.connectingRelationshipsIterator(CursorUtils.nodeGetRelationships((Read)read, (CursorFactory)cursors, (NodeCursor)nodeCursor, (long)fromNode, (Direction)direction, (int[])relTypes), toNode);
    }

    static int nodeGetDegreeIfDense(Read read, AccessMode mode, long node, NodeCursor nodeCursor, CursorFactory cursors, Direction direction) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return 0;
        }
        if (!nodeCursor.isDense()) {
            return -1;
        }
        return CompiledExpandUtils.nodeGetDegree(mode, nodeCursor, cursors, direction);
    }

    private static int nodeGetDegree(AccessMode mode, NodeCursor nodeCursor, CursorFactory cursors, Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)cursors, (AccessMode)mode);
            }
            case INCOMING: {
                return Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)cursors, (AccessMode)mode);
            }
            case BOTH: {
                return Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)cursors, (AccessMode)mode);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    static int nodeGetDegreeIfDense(Read read, AccessMode mode, long node, NodeCursor nodeCursor, CursorFactory cursors, Direction direction, int type) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return 0;
        }
        if (!nodeCursor.isDense()) {
            return -1;
        }
        return CompiledExpandUtils.nodeGetDegree(mode, nodeCursor, cursors, direction, type);
    }

    private static int nodeGetDegree(AccessMode mode, NodeCursor nodeCursor, CursorFactory cursors, Direction direction, int type) {
        switch (direction) {
            case OUTGOING: {
                return Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)type, (AccessMode)mode);
            }
            case INCOMING: {
                return Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)type, (AccessMode)mode);
            }
            case BOTH: {
                return Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)type, (AccessMode)mode);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    private static int calculateTotalDegreeIfDense(Read read, AccessMode mode, long node, NodeCursor nodeCursor, Direction direction, int[] relTypes, CursorFactory cursors) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return 0;
        }
        if (!nodeCursor.isDense()) {
            return -1;
        }
        return CompiledExpandUtils.calculateTotalDegree(mode, nodeCursor, direction, relTypes, cursors);
    }

    private static int calculateTotalDegree(AccessMode mode, NodeCursor nodeCursor, Direction direction, int[] relTypes, CursorFactory cursors) {
        int degree = 0;
        for (int relType : relTypes) {
            degree += CompiledExpandUtils.nodeGetDegree(mode, nodeCursor, cursors, direction, relType);
        }
        return degree;
    }

    private static RelationshipSelectionCursor connectingRelationshipsIterator(final RelationshipSelectionCursor allRelationships, final long toNode) {
        return new RelationshipSelectionCursor(){

            public void close() {
                this.closeInternal();
                CloseListener closeListener = allRelationships.getCloseListener();
                if (closeListener != null) {
                    closeListener.onClosed((AutoCloseablePlus)this);
                }
            }

            public void closeInternal() {
                allRelationships.close();
            }

            public long relationshipReference() {
                return allRelationships.relationshipReference();
            }

            public int type() {
                return allRelationships.type();
            }

            public long otherNodeReference() {
                return allRelationships.otherNodeReference();
            }

            public long sourceNodeReference() {
                return allRelationships.sourceNodeReference();
            }

            public long targetNodeReference() {
                return allRelationships.targetNodeReference();
            }

            public long propertiesReference() {
                return allRelationships.propertiesReference();
            }

            public boolean next() {
                while (allRelationships.next()) {
                    if (allRelationships.otherNodeReference() != toNode) continue;
                    return true;
                }
                return false;
            }

            public void setTracer(KernelReadTracer tracer) {
                allRelationships.setTracer(tracer);
            }

            public boolean isClosed() {
                return allRelationships.isClosed();
            }

            public void setCloseListener(CloseListener closeListener) {
                allRelationships.setCloseListener(closeListener);
            }

            public CloseListener getCloseListener() {
                return allRelationships.getCloseListener();
            }

            public void setToken(int token) {
                allRelationships.setToken(token);
            }

            public int getToken() {
                return allRelationships.getToken();
            }
        };
    }
}

