/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.v4_0.expressions.functions.Function$;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r}e\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0011AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB!1(Q\"O\u001b\u0005a$BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003\u007f\u0001\u000bq\u0001[3ma\u0016\u00148O\u0003\u0002\u0004\r%\u0011!\t\u0010\u0002\u0005!\u0006L'\u000f\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\r:i\u0011a\u0012\u0006\u0003\u0011*\ta\u0001\u0010:p_Rt\u0014B\u0001&\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)s\u0001CA([\u001d\t\u0001\u0006L\u0004\u0002R/:\u0011!K\u0016\b\u0003'Vs!A\u0012+\n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\tI&!\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016L!a\u0017/\u0003!A\u000b'/Y7fi\u0016\u0014H+\u001f9f\u001b\u0006\u0004(BA-\u0003\u0011!q\u0006A!A!\u0002\u00131\u0014\u0001D2bG\",GK]1dKJ\u0004\u0003\u0002\u00031\u0001\u0005\u000b\u0007I\u0011A1\u0002\r\r|gNZ5h+\u0005\u0011\u0007CA\u001cd\u0013\t!'AA\nDsBDWM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003c\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t![\u0001\u0010G>l\u0007/\u001b7fe2K'M]1ssV\t!\u000e\u0005\u00028W&\u0011AN\u0001\u0002\u0010\u0007>l\u0007/\u001b7fe2K'M]1ss\"Aa\u000e\u0001B\u0001B\u0003%!.\u0001\td_6\u0004\u0018\u000e\\3s\u0019&\u0014'/\u0019:zA!A\u0001\u000f\u0001BC\u0002\u0013\u0005\u0011/A\u0006m_\u001e\u0004&o\u001c<jI\u0016\u0014X#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U4\u0011a\u00027pO\u001eLgnZ\u0005\u0003oR\u00141\u0002T8h!J|g/\u001b3fe\"A\u0011\u0010\u0001B\u0001B\u0003%!/\u0001\u0007m_\u001e\u0004&o\u001c<jI\u0016\u0014\b\u0005\u0003\u0005|\u0001\t\u0015\r\u0011\"\u0001}\u0003\u0015\u0019Gn\\2l+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u0002;j[\u0016T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(!B\"m_\u000e\\\u0007\"CA\u0007\u0001\t\u0005\t\u0015!\u0003~\u0003\u0019\u0019Gn\\2lA!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0011A\u0002\u001fj]&$h\b\u0006\n\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\"!\t\u0002$\u0005\u0015\u0002CA\u001c\u0001\u0011\u0019\u0019\u0012q\u0002a\u0001+!1a$a\u0004A\u0002\u0001Ba!KA\b\u0001\u0004Y\u0003B\u0002\u001b\u0002\u0010\u0001\u0007a\u0007\u0003\u0004a\u0003\u001f\u0001\rA\u0019\u0005\u0007Q\u0006=\u0001\u0019\u00016\t\rA\fy\u00011\u0001s\u0011!Y\u0018q\u0002I\u0001\u0002\u0004i\b\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0003U\tX/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J,\"!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005)\u0011/^3ss*\u0019\u0011qG\f\u0002\t%l\u0007\u000f\\\u0005\u0005\u0003w\t\tDA\u000bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:\t\u0011\u0005}\u0002\u0001)A\u0005\u0003[\ta#];fef,\u00050Z2vi&|g.T8oSR|'\u000f\t\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000b\n\u0011\u0002\u001d:f!\u0006\u00148/\u001a:\u0016\u0005\u0005\u001d\u0003cA\u001c\u0002J%\u0019\u00111\n\u0002\u0003\u0013A\u0013X\rU1sg\u0016\u0014\b\u0002CA(\u0001\u0001\u0006I!a\u0012\u0002\u0015A\u0014X\rU1sg\u0016\u0014\b\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V\u0005IB.Y:u\u0007>lW.\u001b;uK\u0012$\u00060\u00133Qe>4\u0018\u000eZ3s+\t\t9\u0006E\u00028\u00033J1!a\u0017\u0003\u0005ea\u0015m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\t\u0011\u0005}\u0003\u0001)A\u0005\u0003/\n!\u0004\\1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3fe\u0002Bq!a\u0019\u0001\t\u0013\t)'\u0001\tqY\u0006t'+Z;tC\nLG.\u001b;jsR1\u0011qMA7\u0003o\u00022aNA5\u0013\r\tYG\u0001\u0002\u0011%\u0016,8/\u00192jY&$\u0018p\u0015;bi\u0016D\u0001\"a\u001c\u0002b\u0001\u0007\u0011\u0011O\u0001\u0010Kb,7-\u001e;bE2,\u0017+^3ssB\u0019q'a\u001d\n\u0007\u0005U$AA\bFq\u0016\u001cW\u000f^1cY\u0016\fV/\u001a:z\u0011!\tI(!\u0019A\u0002\u0005m\u0014\u0001\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000f\u0005\u0003\u00020\u0005u\u0014\u0002BA@\u0003c\u0011A\u0003\u0016:b]N\f7\r^5p]\u0006d7i\u001c8uKb$\b\"CAB\u0001\t\u0007I\u0011BAC\u0003\rawnZ\u000b\u0003\u0003\u000f\u00032a]AE\u0013\r\tY\t\u001e\u0002\u0004\u0019><\u0007\u0002CAH\u0001\u0001\u0006I!a\"\u0002\t1|w\r\t\u0005\n\u0003'\u0003!\u0019!C\u0005\u0003+\u000b1\u0003\u001d7b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ,\"!a&\u0011\u000b]\nI*!\u001d\n\u0007\u0005m%AA\nQY\u0006t7\u000b^1mK:,7o]\"bY2,'\u000f\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BAL\u0003Q\u0001H.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3sA!I\u00111\u0015\u0001C\u0002\u0013%\u0011QU\u0001\u0014i>\u001cFO]5oO\u000e\u000b7\r[3Ue\u0006\u001cWM]\u000b\u0003\u0003O\u0003Ba\u000e\u001d\u0002*B!1(\u0011\u0007O\u0011!\ti\u000b\u0001Q\u0001\n\u0005\u001d\u0016\u0001\u0006;p'R\u0014\u0018N\\4DC\u000eDW\r\u0016:bG\u0016\u0014\b\u0005C\u0005\u00022\u0002\u0011\r\u0011\"\u0003\u00024\u0006Q\u0011/^3ss\u000e\u000b7\r[3\u0016\u0005\u0005U\u0006\u0003C\u001c\u000282\tI+!\u001d\n\u0007\u0005e&A\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016D\u0001\"!0\u0001A\u0003%\u0011QW\u0001\fcV,'/_\"bG\",\u0007\u0005C\u0005\u0002B\u0002\u0011\r\u0011\"\u0003\u0002D\u0006qQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014XCAAc!\r9\u0014qY\u0005\u0004\u0003\u0013\u0014!AD'bgR,'oQ8na&dWM\u001d\u0005\t\u0003\u001b\u0004\u0001\u0015!\u0003\u0002F\u0006yQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b\u0005C\u0005\u0002R\u0002\u0011\r\u0011\"\u0003\u0002T\u0006a1o\u00195f[\u0006DU\r\u001c9feV\u0011\u0011Q\u001b\t\u0004o\u0005]\u0017bAAm\u0005\ta1k\u00195f[\u0006DU\r\u001c9fe\"A\u0011Q\u001c\u0001!\u0002\u0013\t).A\u0007tG\",W.\u0019%fYB,'\u000f\t\u0005\b\u0003C\u0004A\u0011AAr\u0003\u001d)\u00070Z2vi\u0016$b\"!:\u0002l\u00065(\u0011\u0001B\u0003\u0005\u001f\u0011\u0019\u0002\u0005\u0003\u00020\u0005\u001d\u0018\u0002BAu\u0003c\u0011a\"U;fef,\u00050Z2vi&|g\u000eC\u0004\u00024\u0005}\u0007\u0019A\"\t\u0011\u0005=\u0018q\u001ca\u0001\u0003c\fa\u0001]1sC6\u001c\b\u0003BAz\u0003{l!!!>\u000b\t\u0005]\u0018\u0011`\u0001\bm&\u0014H/^1m\u0015\r\tYPB\u0001\u0007m\u0006dW/Z:\n\t\u0005}\u0018Q\u001f\u0002\t\u001b\u0006\u0004h+\u00197vK\"A!1AAp\u0001\u0004\tY(A\u0004d_:$X\r\u001f;\t\u0011\t\u001d\u0011q\u001ca\u0001\u0005\u0013\tq\u0001\u001d:pM&dW\rE\u0002\u000e\u0005\u0017I1A!\u0004\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001B!\u0005\u0002`\u0002\u0007!\u0011B\u0001\faJ,\u0007k\u001c9vY\u0006$X\r\u0003\u0005\u0003\u0016\u0005}\u0007\u0019\u0001B\f\u0003)\u0019XOY:de&\u0014WM\u001d\t\u0005\u0003_\u0011I\"\u0003\u0003\u0003\u001c\u0005E\"aD)vKJL8+\u001e2tGJL'-\u001a:\t\u000f\u0005\u0005\b\u0001\"\u0001\u0003 Qq\u0011Q\u001dB\u0011\u0005S\u0011YC!\f\u00030\t}\u0002\u0002CA\u001a\u0005;\u0001\rAa\t\u0011\u0007]\u0012)#C\u0002\u0003(\t\u0011\u0001CR;mYf\u0004\u0016M]:fIF+XM]=\t\u0011\u0005=(Q\u0004a\u0001\u0003cD\u0001Ba\u0001\u0003\u001e\u0001\u0007\u00111\u0010\u0005\t\u0005#\u0011i\u00021\u0001\u0003\n!A!\u0011\u0007B\u000f\u0001\u0004\u0011\u0019$A\u0003j]B,H\u000f\u0005\u0003\u00036\tmRB\u0001B\u001c\u0015\r\u0011IDA\u0001\beVtG/[7f\u0013\u0011\u0011iDa\u000e\u0003\u001f%s\u0007/\u001e;ECR\f7\u000b\u001e:fC6D\u0001B!\u0006\u0003\u001e\u0001\u0007!q\u0003\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0003=)\u00070Z2vi\u0016\u001cVOY)vKJLH\u0003EAs\u0005\u000f\u0012IEa\u0013\u0003N\tE#1\u000bB+\u0011\u001d\t\u0019D!\u0011A\u0002\rC\u0001\"a<\u0003B\u0001\u0007\u0011\u0011\u001f\u0005\t\u0005\u0007\u0011\t\u00051\u0001\u0002|!A!q\nB!\u0001\u0004\u0011I!\u0001\tjg>+H/\u001a:n_N$\u0018+^3ss\"A!q\u0001B!\u0001\u0004\u0011I\u0001\u0003\u0005\u0003\u0012\t\u0005\u0003\u0019\u0001B\u0005\u0011!\u0011)B!\u0011A\u0002\t]\u0001b\u0002B-\u0001\u0011%!1L\u0001\bG2|7/\u001b8h+\u0011\u0011iF!\u001a\u0015\r\t}#\u0011\u0011BB)\u0011\u0011\tGa\u001e\u0011\t\t\r$Q\r\u0007\u0001\t!\u00119Ga\u0016C\u0002\t%$!\u0001+\u0012\t\t-$\u0011\u000f\t\u0004\u001b\t5\u0014b\u0001B8\u001d\t9aj\u001c;iS:<\u0007cA\u0007\u0003t%\u0019!Q\u000f\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003z\t]C\u00111\u0001\u0003|\u0005!1m\u001c3f!\u0015i!Q\u0010B1\u0013\r\u0011yH\u0004\u0002\ty\tLh.Y7f}!A!1\u0001B,\u0001\u0004\tY\b\u0003\u0005\u0003\u0006\n]\u0003\u0019\u0001BD\u0003)!(/Y2f\u000bZ,g\u000e\u001e\t\u0005\u0005\u0013\u0013\u0019J\u0004\u0003\u0003\f\n=eb\u0001)\u0003\u000e&\u0011aFA\u0005\u0004\u0005#k\u0013!E\"p[BLG.\u0019;j_:$&/Y2fe&!!Q\u0013BL\u0005U\tV/\u001a:z\u0007>l\u0007/\u001b7bi&|g.\u0012<f]RT1A!%.\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;\u000b\u0011\u0002Z8Fq\u0016\u001cW\u000f^3\u0015%\u0005\u0015(q\u0014BT\u0005S\u0013YK!,\u00030\nE&1\u0017\u0005\t\u0003g\u0011I\n1\u0001\u0003\"B\u0019qGa)\n\u0007\t\u0015&A\u0001\u0006J]B,H/U;fefD\u0001\"a<\u0003\u001a\u0002\u0007\u0011\u0011\u001f\u0005\t\u0005\u0007\u0011I\n1\u0001\u0002|!A!q\nBM\u0001\u0004\u0011I\u0001\u0003\u0005\u0003\u0012\te\u0005\u0019\u0001B\u0005\u0011!\u0011\tD!'A\u0002\tM\u0002bB\u0015\u0003\u001a\u0002\u0007!q\u0011\u0005\t\u0005+\u0011I\n1\u0001\u0003\u0018!9!q\u0017\u0001\u0005\n\te\u0016!C2p[BLG.\u001a:t))\u0011Yla\n\u0004,\r52q\u0006\t\b\u001b\tu&\u0011YB\u0013\u0013\r\u0011yL\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\t\r'1\u001d\b\u0004!\n\u0015wa\u0002Bd\u0005!\u0005!\u0011Z\u0001\u0010\u000bb,7-\u001e;j_:,enZ5oKB\u0019qGa3\u0007\r\u0005\u0011\u0001\u0012\u0001Bg'\r\u0011Y\r\u0004\u0005\t\u0003#\u0011Y\r\"\u0001\u0003RR\u0011!\u0011\u001a\u0005\u000b\u0005+\u0014YM1A\u0005\u0002\t]\u0017a\u0005)M\u0003:{&)V%M\t&sui\u0018+S\u0013\u0016\u001bVC\u0001Bm!\ri!1\\\u0005\u0004\u0005;t!aA%oi\"I!\u0011\u001dBfA\u0003%!\u0011\\\u0001\u0015!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUi\u0015\u0011\u0006\u000f\t\u0015(1\u001a\u0001\u0003h\n\u0001\u0012+^3ss\u000e{W\u000e]5mCRLwN\u001c\t\u0006\u001b\t%\u0018\u0011O\u0005\u0004\u0005Wt!!\u0003$v]\u000e$\u0018n\u001c81\u000b\u001d\u0011yOa3\u0001\u0005c\u0014aBS5u\u0007>l\u0007/\u001b7bi&|g\u000eE\u0004\u000e\u0005g\u0014INa>\n\u0007\tUhBA\u0005Gk:\u001cG/[8ocA)QB!?\u0002r%\u0019!1 \b\u0003\r=\u0003H/[8o\u0011)\u0011yPa3C\u0002\u0013%1\u0011A\u0001\u000e\u001d\u00163VIU0D\u001f6\u0003\u0016\nT#\u0016\u0005\r\r\u0001\u0003BB\u0003\u0005[l!Aa3\t\u0013\r%!1\u001aQ\u0001\n\r\r\u0011A\u0004(F-\u0016\u0013vlQ(N!&cU\t\t\u0005\u000b\u0007\u001b\u0011Y-%A\u0005\u0002\r=\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0004\u0012)\u001aQpa\u0005,\u0005\rU\u0001\u0003BB\f\u0007Ci!a!\u0007\u000b\t\rm1QD\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\b\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007G\u0019IBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004BAa1\u0003n\"A1\u0011\u0006B[\u0001\u0004\u0011\t+\u0001\u0006j]B,H/U;fefDq!\u000bB[\u0001\u0004\u00119\t\u0003\u0005\u0002z\tU\u0006\u0019AA>\u0011!\tyO!.A\u0002\u0005E\bbBB\u001a\u0001\u0011%1QG\u0001\rO\u0016$xJ]\"p[BLG.\u001a\u000b\u000b\u0003c\u001a9d!\u000f\u0004<\ru\u0002\u0002\u0003B\u0002\u0007c\u0001\r!a\u001f\t\u0011\r%2\u0011\u0007a\u0001\u0005CCq!KB\u0019\u0001\u0004\u00119\t\u0003\u0005\u0002p\u000eE\u0002\u0019AAy\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0007\u0007\n\u0001c\u00197fCJ\fV/\u001a:z\u0007\u0006\u001c\u0007.Z:\u0015\u0005\r\u0015\u0003cA\u0007\u0004H%\u00191\u0011\n\b\u0003\t1{gn\u001a\u0005\b\u0007\u001b\u0002A\u0011AB(\u0003AI7\u000fU3sS>$\u0017nY\"p[6LG\u000f\u0006\u0003\u0003\n\rE\u0003bBA\u001a\u0007\u0017\u0002\ra\u0011\u0005\b\u0007+\u0002A\u0011AB,\u0003I9W\r^\"za\",'OR;oGRLwN\\:\u0016\u0005\re\u0003CBB.\u0007C\u001a)'\u0004\u0002\u0004^)!1qLA\u0002\u0003\u0011)H/\u001b7\n\t\r\r4Q\f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u00020\r\u001d\u0014\u0002BB5\u0003c\u00111CR;oGRLwN\\%oM>\u0014X.\u0019;j_:Dqa!\u001c\u0001\t\u0013\u0019y'A\bdQ\u0016\u001c7\u000eU1sC6,G/\u001a:t)!\u0019\tha\u001e\u0004\u0002\u000e\u0015\u0005cA\u0007\u0004t%\u00191Q\u000f\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0007s\u001aY\u00071\u0001\u0004|\u0005Y\u0011/^3ssB\u000b'/Y7t!\u0011i1QP\"\n\u0007\r}dBA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0004\u0004\u000e-\u0004\u0019AAy\u0003-9\u0017N^3o!\u0006\u0014\u0018-\\:\t\u0011\r\u001d51\u000ea\u0001\u0003c\fq\"\u001a=ue\u0006\u001cG/\u001a3QCJ\fWn\u001d\u0015\u0007\u0007W\u001aYi!(\u0011\u000b5\u0019ii!%\n\u0007\r=eB\u0001\u0004uQJ|wo\u001d\t\u0005\u0007'\u001bI*\u0004\u0002\u0004\u0016*\u00191q\u0013\u0004\u0002\u0015\u0015D8-\u001a9uS>t7/\u0003\u0003\u0004\u001c\u000eU%A\u0007)be\u0006lW\r^3s\u001d>$hi\\;oI\u0016C8-\u001a9uS>t7EABI\u0001")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor queryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final CacheTracer<Pair<Object, Map<String, Class<?>>>> toStringCacheTracer;
    private final QueryCache<Object, Pair<Object, Map<String, Class<?>>>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor queryExecutionMonitor() {
        return this.queryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private CacheTracer<Pair<Object, Map<String, Class<?>>>> toStringCacheTracer() {
        return this.toStringCacheTracer;
    }

    private QueryCache<Object, Pair<Object, Map<String, Class<?>>>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.queryExecutionMonitor().start(context.executingQuery());
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QuerySubscriber subscriber) {
        this.queryExecutionMonitor().start(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryTracer, subscriber));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block1: {
            executableQuery = this.getOrCompile(context, query, tracer, params);
            String string = query.options().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block1;
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), () -> executableQuery.planDescription());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, subscriber);
    }

    private Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> compilers(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return inputQuery.options().compileWhenHot() && this.config().recompilationLimit() > 0 ? new Tuple2((Object)interpretedExpressionCompiler, (Function1 & Serializable & scala.Serializable)count -> ExecutionEngine.$anonfun$compilers$3(this, compiledExpressionCompiler, BoxesRunTime.unboxToInt((Object)count))) : (inputQuery.options().compileWhenHot() ? new Tuple2((Object)compiledExpressionCompiler, ExecutionEngine$.MODULE$.org$neo4j$cypher$internal$ExecutionEngine$$NEVER_COMPILE()) : new Tuple2((Object)interpretedExpressionCompiler, ExecutionEngine$.MODULE$.org$neo4j$cypher$internal$ExecutionEngine$$NEVER_COMPILE()));
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block6: {
            ExecutableQuery executableQuery;
            block5: {
                Pair cacheKey = Pair.of((Object)inputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params));
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> tuple2 = this.compilers(inputQuery, tracer, tc, params);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Function0 primaryCompiler = (Function0)tuple2._1();
                        Function1 secondaryCompiler = (Function1)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)primaryCompiler, (Object)secondaryCompiler);
                        Tuple2 tuple23 = tuple22;
                        Function0 primaryCompiler2 = (Function0)tuple23._1();
                        Function1 secondaryCompiler2 = (Function1)tuple23._2();
                        CacheLookup<ExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<ExecutableQuery>)primaryCompiler2, (Function1<Object, Option<ExecutableQuery>>)secondaryCompiler2, inputQuery.description());
                        ExecutableQuery executableQuery2 = cacheLookup.executableQuery();
                        if (!this.schemaHelper().lockLabels(schemaToken, executableQuery2, inputQuery.options().version(), tc)) continue;
                        executableQuery = executableQuery2;
                        break block5;
                    }
                    break block6;
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().executionMode();
        CypherExecutionMode$explain$ cypherExecutionMode$explain$ = CypherExecutionMode$explain$.MODULE$;
        return (cypherExecutionMode == null ? cypherExecutionMode$explain$ != null : !cypherExecutionMode.equals(cypherExecutionMode$explain$)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(informations).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ Option $anonfun$compilers$3(ExecutionEngine $this, Function0 compiledExpressionCompiler$1, int count) {
        return count >= $this.config().recompilationLimit() ? new Some(compiledExpressionCompiler$1.apply()) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.queryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.operatorEngine(), config.interpretedPipesFallback(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheRecompile(Object key) {
                CypherCacheHitMonitor.cacheRecompile$(this, key);
            }

            public void cacheDiscard(Pair<String, Map<String, Class<?>>> ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(59).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds: ").append(query).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext));
        this.toStringCacheTracer = new CacheTracer<Pair<Object, Map<String, Class<?>>>>(this){
            private final /* synthetic */ ExecutionEngine $outer;

            private Pair<String, Map<String, Class<?>>> str(Pair<Object, Map<String, Class<?>>> p) {
                return Pair.of((Object)p.first().toString(), (Object)p.other());
            }

            public void queryCacheHit(Pair<Object, Map<String, Class<?>>> queryKey, String metaData) {
                this.$outer.cacheTracer().queryCacheHit(this.str(queryKey), metaData);
            }

            public void queryCacheMiss(Pair<Object, Map<String, Class<?>>> queryKey, String metaData) {
                this.$outer.cacheTracer().queryCacheMiss(this.str(queryKey), metaData);
            }

            public void queryCacheRecompile(Pair<Object, Map<String, Class<?>>> queryKey, String metaData) {
                this.$outer.cacheTracer().queryCacheRecompile(this.str(queryKey), metaData);
            }

            public void queryCacheStale(Pair<Object, Map<String, Class<?>>> queryKey, int secondsSincePlan, String metaData) {
                this.$outer.cacheTracer().queryCacheStale(this.str(queryKey), secondsSincePlan, metaData);
            }

            public void queryCacheFlush(long sizeOfCacheBeforeFlush) {
                this.$outer.cacheTracer().queryCacheFlush(sizeOfCacheBeforeFlush);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.queryCache = new QueryCache(config.queryCacheSize(), this.planStalenessCaller(), this.toStringCacheTracer());
        this.masterCompiler = new MasterCompiler(config, compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

