/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExecutionMode$explain$;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.v4_0.expressions.functions.Function$;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rMf\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0011AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB!1(Q\"O\u001b\u0005a$BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003\u007f\u0001\u000bq\u0001[3ma\u0016\u00148O\u0003\u0002\u0004\r%\u0011!\t\u0010\u0002\u0005!\u0006L'\u000f\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\r:i\u0011a\u0012\u0006\u0003\u0011*\ta\u0001\u0010:p_Rt\u0014B\u0001&\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)s\u0001CA([\u001d\t\u0001\u0006L\u0004\u0002R/:\u0011!K\u0016\b\u0003'Vs!A\u0012+\n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\tI&!\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016L!a\u0017/\u0003!A\u000b'/Y7fi\u0016\u0014H+\u001f9f\u001b\u0006\u0004(BA-\u0003\u0011!q\u0006A!A!\u0002\u00131\u0014\u0001D2bG\",GK]1dKJ\u0004\u0003\u0002\u00031\u0001\u0005\u000b\u0007I\u0011A1\u0002\r\r|gNZ5h+\u0005\u0011\u0007CA\u001cd\u0013\t!'AA\nDsBDWM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003c\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t![\u0001\u0010G>l\u0007/\u001b7fe2K'M]1ssV\t!\u000e\u0005\u00028W&\u0011AN\u0001\u0002\u0010\u0007>l\u0007/\u001b7fe2K'M]1ss\"Aa\u000e\u0001B\u0001B\u0003%!.\u0001\td_6\u0004\u0018\u000e\\3s\u0019&\u0014'/\u0019:zA!A\u0001\u000f\u0001BC\u0002\u0013\u0005\u0011/A\u0006m_\u001e\u0004&o\u001c<jI\u0016\u0014X#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U4\u0011a\u00027pO\u001eLgnZ\u0005\u0003oR\u00141\u0002T8h!J|g/\u001b3fe\"A\u0011\u0010\u0001B\u0001B\u0003%!/\u0001\u0007m_\u001e\u0004&o\u001c<jI\u0016\u0014\b\u0005\u0003\u0005|\u0001\t\u0015\r\u0011\"\u0001}\u0003\u0015\u0019Gn\\2l+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u0002;j[\u0016T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(!B\"m_\u000e\\\u0007\"CA\u0007\u0001\t\u0005\t\u0015!\u0003~\u0003\u0019\u0019Gn\\2lA!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0011A\u0002\u001fj]&$h\b\u0006\n\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\"!\t\u0002$\u0005\u0015\u0002CA\u001c\u0001\u0011\u0019\u0019\u0012q\u0002a\u0001+!1a$a\u0004A\u0002\u0001Ba!KA\b\u0001\u0004Y\u0003B\u0002\u001b\u0002\u0010\u0001\u0007a\u0007\u0003\u0004a\u0003\u001f\u0001\rA\u0019\u0005\u0007Q\u0006=\u0001\u0019\u00016\t\rA\fy\u00011\u0001s\u0011!Y\u0018q\u0002I\u0001\u0002\u0004i\b\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0003%\u0001(/\u001a)beN,'/\u0006\u0002\u0002.A\u0019q'a\f\n\u0007\u0005E\"AA\u0005Qe\u0016\u0004\u0016M]:fe\"A\u0011Q\u0007\u0001!\u0002\u0013\ti#\u0001\u0006qe\u0016\u0004\u0016M]:fe\u0002B\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\u000231\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM]\u000b\u0003\u0003{\u00012aNA \u0013\r\t\tE\u0001\u0002\u001a\u0019\u0006\u001cHoQ8n[&$H/\u001a3Uq&#\u0007K]8wS\u0012,'\u000f\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001f\u0003ia\u0017m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:!\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017\n\u0001\u0003\u001d7b]J+Wo]1cS2LG/[=\u0015\r\u00055\u00131KA/!\r9\u0014qJ\u0005\u0004\u0003#\u0012!\u0001\u0005*fkN\f'-\u001b7jif\u001cF/\u0019;f\u0011!\t)&a\u0012A\u0002\u0005]\u0013aD3yK\u000e,H/\u00192mKF+XM]=\u0011\u0007]\nI&C\u0002\u0002\\\t\u0011q\"\u0012=fGV$\u0018M\u00197f#V,'/\u001f\u0005\t\u0003?\n9\u00051\u0001\u0002b\u0005!BO]1og\u0006\u001cG/[8oC2\u001cuN\u001c;fqR\u0004B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0003rk\u0016\u0014\u0018PC\u0002\u0002l]\tA![7qY&!\u0011qNA3\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yi\"I\u00111\u000f\u0001C\u0002\u0013%\u0011QO\u0001\u0004Y><WCAA<!\r\u0019\u0018\u0011P\u0005\u0004\u0003w\"(a\u0001'pO\"A\u0011q\u0010\u0001!\u0002\u0013\t9(\u0001\u0003m_\u001e\u0004\u0003\"CAB\u0001\t\u0007I\u0011BAC\u0003M\u0001H.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s+\t\t9\tE\u00038\u0003\u0013\u000b9&C\u0002\u0002\f\n\u00111\u0003\u00157b]N#\u0018\r\\3oKN\u001c8)\u00197mKJD\u0001\"a$\u0001A\u0003%\u0011qQ\u0001\u0015a2\fgn\u0015;bY\u0016tWm]:DC2dWM\u001d\u0011\t\u0013\u0005M\u0005A1A\u0005\n\u0005U\u0015a\u0005;p'R\u0014\u0018N\\4DC\u000eDW\r\u0016:bG\u0016\u0014XCAAL!\u00119\u0004(!'\u0011\tm\nEB\u0014\u0005\t\u0003;\u0003\u0001\u0015!\u0003\u0002\u0018\u0006!Bo\\*ue&twmQ1dQ\u0016$&/Y2fe\u0002B\u0011\"!)\u0001\u0005\u0004%I!a)\u0002\u0015E,XM]=DC\u000eDW-\u0006\u0002\u0002&BAq'a*\r\u00033\u000b9&C\u0002\u0002*\n\u0011!\"U;fef\u001c\u0015m\u00195f\u0011!\ti\u000b\u0001Q\u0001\n\u0005\u0015\u0016aC9vKJL8)Y2iK\u0002B\u0011\"!-\u0001\u0005\u0004%I!a-\u0002\u001d5\f7\u000f^3s\u0007>l\u0007/\u001b7feV\u0011\u0011Q\u0017\t\u0004o\u0005]\u0016bAA]\u0005\tqQ*Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b\u0002CA_\u0001\u0001\u0006I!!.\u0002\u001f5\f7\u000f^3s\u0007>l\u0007/\u001b7fe\u0002B\u0011\"!1\u0001\u0005\u0004%I!a1\u0002\u0019M\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005\u0015\u0007cA\u001c\u0002H&\u0019\u0011\u0011\u001a\u0002\u0003\u0019M\u001b\u0007.Z7b\u0011\u0016d\u0007/\u001a:\t\u0011\u00055\u0007\u0001)A\u0005\u0003\u000b\fQb]2iK6\f\u0007*\u001a7qKJ\u0004\u0003bBAi\u0001\u0011\u0005\u00111[\u0001\bKb,7-\u001e;f)9\t).a7\u0002^\u0006E\u0018Q_A\u0000\u0005\u0007\u0001B!a\u0019\u0002X&!\u0011\u0011\\A3\u00059\tV/\u001a:z\u000bb,7-\u001e;j_:Dq!a\u001a\u0002P\u0002\u00071\t\u0003\u0005\u0002`\u0006=\u0007\u0019AAq\u0003\u0019\u0001\u0018M]1ngB!\u00111]Aw\u001b\t\t)O\u0003\u0003\u0002h\u0006%\u0018a\u0002<jeR,\u0018\r\u001c\u0006\u0004\u0003W4\u0011A\u0002<bYV,7/\u0003\u0003\u0002p\u0006\u0015(\u0001C'baZ\u000bG.^3\t\u0011\u0005M\u0018q\u001aa\u0001\u0003C\nqaY8oi\u0016DH\u000f\u0003\u0005\u0002x\u0006=\u0007\u0019AA}\u0003\u001d\u0001(o\u001c4jY\u0016\u00042!DA~\u0013\r\tiP\u0004\u0002\b\u0005>|G.Z1o\u0011!\u0011\t!a4A\u0002\u0005e\u0018a\u00039sKB{\u0007/\u001e7bi\u0016D\u0001B!\u0002\u0002P\u0002\u0007!qA\u0001\u000bgV\u00147o\u0019:jE\u0016\u0014\b\u0003BA2\u0005\u0013IAAa\u0003\u0002f\ty\u0011+^3ssN+(m]2sS\n,'\u000fC\u0004\u0002R\u0002!\tAa\u0004\u0015\u001d\u0005U'\u0011\u0003B\r\u00057\u0011iBa\b\u00030!A\u0011q\rB\u0007\u0001\u0004\u0011\u0019\u0002E\u00028\u0005+I1Aa\u0006\u0003\u0005A1U\u000f\u001c7z!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010\u0003\u0005\u0002`\n5\u0001\u0019AAq\u0011!\t\u0019P!\u0004A\u0002\u0005\u0005\u0004\u0002\u0003B\u0001\u0005\u001b\u0001\r!!?\t\u0011\t\u0005\"Q\u0002a\u0001\u0005G\tQ!\u001b8qkR\u0004BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S\u0011\u0011a\u0002:v]RLW.Z\u0005\u0005\u0005[\u00119CA\bJ]B,H\u000fR1uCN#(/Z1n\u0011!\u0011)A!\u0004A\u0002\t\u001d\u0001b\u0002B\u001a\u0001\u0011\u0005!QG\u0001\u0010Kb,7-\u001e;f'V\u0014\u0017+^3ssR\u0011\u0012Q\u001bB\u001c\u0005s\u0011YD!\u0010\u0003B\t\r#Q\tB$\u0011\u001d\t9G!\rA\u0002\rC\u0001\"a8\u00032\u0001\u0007\u0011\u0011\u001d\u0005\t\u0003g\u0014\t\u00041\u0001\u0002b!A!q\bB\u0019\u0001\u0004\tI0\u0001\ftQ>,H\u000eZ\"m_N,GK]1og\u0006\u001cG/[8o\u0011!\t9P!\rA\u0002\u0005e\b\u0002\u0003B\u0001\u0005c\u0001\r!!?\t\u0011\t\u0015!\u0011\u0007a\u0001\u0005\u000fA\u0001B!\u0013\u00032\u0001\u0007\u0011\u0011`\u0001\u001cK:\f'\r\\3Rk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:\t\u000f\t5\u0003\u0001\"\u0003\u0003P\u000591\r\\8tS:<W\u0003\u0002B)\u00053\"bAa\u0015\u0003v\t]D\u0003\u0002B+\u0005W\u0002BAa\u0016\u0003Z1\u0001A\u0001\u0003B.\u0005\u0017\u0012\rA!\u0018\u0003\u0003Q\u000bBAa\u0018\u0003fA\u0019QB!\u0019\n\u0007\t\rdBA\u0004O_RD\u0017N\\4\u0011\u00075\u00119'C\u0002\u0003j9\u00111!\u00118z\u0011%\u0011iGa\u0013\u0005\u0002\u0004\u0011y'\u0001\u0003d_\u0012,\u0007#B\u0007\u0003r\tU\u0013b\u0001B:\u001d\tAAHY=oC6,g\b\u0003\u0005\u0002t\n-\u0003\u0019AA1\u0011!\u0011IHa\u0013A\u0002\tm\u0014A\u0003;sC\u000e,WI^3oiB!!Q\u0010BD\u001d\u0011\u0011yHa!\u000f\u0007A\u0013\t)\u0003\u0002/\u0005%\u0019!QQ\u0017\u0002#\r{W\u000e]5mCRLwN\u001c+sC\u000e,'/\u0003\u0003\u0003\n\n-%!F)vKJL8i\\7qS2\fG/[8o\u000bZ,g\u000e\u001e\u0006\u0004\u0005\u000bk\u0003b\u0002BH\u0001\u0011%!\u0011S\u0001\nI>,\u00050Z2vi\u0016$B#!6\u0003\u0014\nm%Q\u0014BP\u0005C\u0013\u0019K!*\u0003(\n%\u0006\u0002CA4\u0005\u001b\u0003\rA!&\u0011\u0007]\u00129*C\u0002\u0003\u001a\n\u0011!\"\u00138qkR\fV/\u001a:z\u0011!\tyN!$A\u0002\u0005\u0005\b\u0002CAz\u0005\u001b\u0003\r!!\u0019\t\u0011\t}\"Q\u0012a\u0001\u0003sD\u0001B!\u0001\u0003\u000e\u0002\u0007\u0011\u0011 \u0005\t\u0005C\u0011i\t1\u0001\u0003$!9\u0011F!$A\u0002\tm\u0004\u0002\u0003B\u0003\u0005\u001b\u0003\rAa\u0002\t\u0011\t%#Q\u0012a\u0001\u0003sDqA!,\u0001\t\u0013\u0011y+A\u0005d_6\u0004\u0018\u000e\\3sgRQ!\u0011WB\u000f\u0007C\u0019\u0019c!\n\u0011\u000f5\u0011\u0019La.\u0004\u001c%\u0019!Q\u0017\b\u0003\rQ+\b\u000f\\33!\u0011\u0011IL!7\u000f\u0007A\u0013YlB\u0004\u0003>\nA\tAa0\u0002\u001f\u0015CXmY;uS>tWI\\4j]\u0016\u00042a\u000eBa\r\u0019\t!\u0001#\u0001\u0003DN\u0019!\u0011\u0019\u0007\t\u0011\u0005E!\u0011\u0019C\u0001\u0005\u000f$\"Aa0\t\u0015\t-'\u0011\u0019b\u0001\n\u0003\u0011i-A\nQ\u0019\u0006suLQ+J\u0019\u0012KejR0U%&+5+\u0006\u0002\u0003PB\u0019QB!5\n\u0007\tMgBA\u0002J]RD\u0011Ba6\u0003B\u0002\u0006IAa4\u0002)Ac\u0015IT0C+&cE)\u0013(H?R\u0013\u0016*R*!\u000b\u001d\u0011YN!1\u0001\u0005;\u0014\u0001#U;fef\u001cu.\u001c9jY\u0006$\u0018n\u001c8\u0011\u000b5\u0011y.a\u0016\n\u0007\t\u0005hBA\u0005Gk:\u001cG/[8oa\u00159!Q\u001dBa\u0001\t\u001d(A\u0004&ji\u000e{W\u000e]5mCRLwN\u001c\t\b\u001b\t%(q\u001aBw\u0013\r\u0011YO\u0004\u0002\n\rVt7\r^5p]F\u0002R!\u0004Bx\u0003/J1A!=\u000f\u0005\u0019y\u0005\u000f^5p]\"Q!Q\u001fBa\u0005\u0004%IAa>\u0002\u001b9+e+\u0012*`\u0007>k\u0005+\u0013'F+\t\u0011I\u0010\u0005\u0003\u0003|\n\rXB\u0001Ba\u0011%\u0011yP!1!\u0002\u0013\u0011I0\u0001\bO\u000bZ+%kX\"P\u001bBKE*\u0012\u0011\t\u0015\r\r!\u0011YI\u0001\n\u0003\u0019)!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007\u000fQ3!`B\u0005W\t\u0019Y\u0001\u0005\u0003\u0004\u000e\r]QBAB\b\u0015\u0011\u0019\tba\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAB\u000b\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\re1q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\u0003\u0002B]\u0005GD\u0001ba\b\u0003,\u0002\u0007!QS\u0001\u000bS:\u0004X\u000f^)vKJL\bbB\u0015\u0003,\u0002\u0007!1\u0010\u0005\t\u0003?\u0012Y\u000b1\u0001\u0002b!A\u0011q\u001cBV\u0001\u0004\t\t\u000fC\u0004\u0004*\u0001!Iaa\u000b\u0002\u0019\u001d,Go\u0014:D_6\u0004\u0018\u000e\\3\u0015\u0015\u0005]3QFB\u0018\u0007c\u0019\u0019\u0004\u0003\u0005\u0002t\u000e\u001d\u0002\u0019AA1\u0011!\u0019yba\nA\u0002\tU\u0005bB\u0015\u0004(\u0001\u0007!1\u0010\u0005\t\u0003?\u001c9\u00031\u0001\u0002b\"91q\u0007\u0001\u0005\u0002\re\u0012\u0001E2mK\u0006\u0014\u0018+^3ss\u000e\u000b7\r[3t)\t\u0019Y\u0004E\u0002\u000e\u0007{I1aa\u0010\u000f\u0005\u0011auN\\4\t\u000f\r\r\u0003\u0001\"\u0001\u0004F\u0005\u0001\u0012n\u001d)fe&|G-[2D_6l\u0017\u000e\u001e\u000b\u0005\u0003s\u001c9\u0005C\u0004\u0002h\r\u0005\u0003\u0019A\"\t\u000f\r-\u0003\u0001\"\u0001\u0004N\u0005\u0011r-\u001a;DsBDWM\u001d$v]\u000e$\u0018n\u001c8t+\t\u0019y\u0005\u0005\u0004\u0004R\r]31L\u0007\u0003\u0007'RAa!\u0016\u0002\u0004\u0005!Q\u000f^5m\u0013\u0011\u0019Ifa\u0015\u0003\t1K7\u000f\u001e\t\u0005\u0003G\u001ai&\u0003\u0003\u0004`\u0005\u0015$a\u0005$v]\u000e$\u0018n\u001c8J]\u001a|'/\\1uS>t\u0007bBB2\u0001\u0011%1QM\u0001\u0010G\",7m\u001b)be\u0006lW\r^3sgRA1qMB7\u0007o\u001aY\bE\u0002\u000e\u0007SJ1aa\u001b\u000f\u0005\u0011)f.\u001b;\t\u0011\r=4\u0011\ra\u0001\u0007c\n1\"];fef\u0004\u0016M]1ngB!Qba\u001dD\u0013\r\u0019)H\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0007s\u001a\t\u00071\u0001\u0002b\u0006Yq-\u001b<f]B\u000b'/Y7t\u0011!\u0019ih!\u0019A\u0002\u0005\u0005\u0018aD3yiJ\f7\r^3e!\u0006\u0014\u0018-\\:)\r\r\u00054\u0011QBJ!\u0015i11QBD\u0013\r\u0019)I\u0004\u0002\u0007i\"\u0014xn^:\u0011\t\r%5qR\u0007\u0003\u0007\u0017S1a!$\u0007\u0003))\u0007pY3qi&|gn]\u0005\u0005\u0007#\u001bYI\u0001\u000eQCJ\fW.\u001a;fe:{GOR8v]\u0012,\u0005pY3qi&|gn\t\u0002\u0004\b\"91q\u0013\u0001\u0005\n\re\u0015\u0001C:vaBd\u0017.\u001a:\u0016\t\rm51\u0016\u000b\u0005\u0007;\u001bi\u000b\u0005\u0004\u0004 \u000e\u00156\u0011V\u0007\u0003\u0007CSAaa)\u0004T\u0005Aa-\u001e8di&|g.\u0003\u0003\u0004(\u000e\u0005&\u0001C*vaBd\u0017.\u001a:\u0011\t\t]31\u0016\u0003\t\u00057\u001a)J1\u0001\u0003^!I1qVBK\t\u0003\u00071\u0011W\u0001\u0002iB)QB!\u001d\u0004*\u0002")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final LogProvider logProvider;
    private final Clock clock;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final CacheTracer<Pair<Object, Map<String, Class<?>>>> toStringCacheTracer;
    private final QueryCache<Object, Pair<Object, Map<String, Class<?>>>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private CacheTracer<Pair<Object, Map<String, Class<?>>>> toStringCacheTracer() {
        return this.toStringCacheTracer;
    }

    private QueryCache<Object, Pair<Object, Map<String, Class<?>>>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber, true);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryTracer, subscriber, true));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean shouldCloseTransaction, boolean profile, boolean prePopulate, QuerySubscriber subscriber, boolean enableQueryExecutionMonitor) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile);
            return this.doExecute(preParsedQuery, params, context, shouldCloseTransaction, prePopulate, (InputDataStream)NoInput$.MODULE$, queryTracer, subscriber, enableQueryExecutionMonitor);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean shouldCloseTransaction, boolean prePopulate, InputDataStream input, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber, boolean enableQueryExecutionMonitor) {
        ExecutableQuery executableQuery = this.getOrCompile(context, query, tracer, params);
        String string = query.options().executionMode().name();
        String string2 = "explain";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
        }
        MapValue combinedParams = params.updatedWith(executableQuery.extractedParams());
        context.executingQuery().compilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), this.supplier((Function0 & Serializable & scala.Serializable)() -> executableQuery.planDescription()));
        return executableQuery.execute(context, shouldCloseTransaction, query.options(), combinedParams, prePopulate, input, subscriber, enableQueryExecutionMonitor);
    }

    private Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> compilers(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return inputQuery.options().compileWhenHot() && this.config().recompilationLimit() > 0 ? new Tuple2((Object)interpretedExpressionCompiler, (Function1 & Serializable & scala.Serializable)count -> ExecutionEngine.$anonfun$compilers$3(this, compiledExpressionCompiler, BoxesRunTime.unboxToInt((Object)count))) : (inputQuery.options().compileWhenHot() ? new Tuple2((Object)compiledExpressionCompiler, ExecutionEngine$.MODULE$.org$neo4j$cypher$internal$ExecutionEngine$$NEVER_COMPILE()) : new Tuple2((Object)interpretedExpressionCompiler, ExecutionEngine$.MODULE$.org$neo4j$cypher$internal$ExecutionEngine$$NEVER_COMPILE()));
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block6: {
            ExecutableQuery executableQuery;
            block5: {
                Pair cacheKey = Pair.of((Object)inputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params));
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> tuple2 = this.compilers(inputQuery, tracer, tc, params);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Function0 primaryCompiler = (Function0)tuple2._1();
                        Function1 secondaryCompiler = (Function1)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)primaryCompiler, (Object)secondaryCompiler);
                        Tuple2 tuple23 = tuple22;
                        Function0 primaryCompiler2 = (Function0)tuple23._1();
                        Function1 secondaryCompiler2 = (Function1)tuple23._2();
                        CacheLookup<ExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<ExecutableQuery>)primaryCompiler2, (Function1<Object, Option<ExecutableQuery>>)secondaryCompiler2, inputQuery.description());
                        ExecutableQuery executableQuery2 = cacheLookup.executableQuery();
                        if (!this.schemaHelper().lockLabels(schemaToken, executableQuery2, inputQuery.options().version(), tc)) continue;
                        executableQuery = executableQuery2;
                        break block5;
                    }
                    break block6;
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().executionMode();
        CypherExecutionMode$explain$ cypherExecutionMode$explain$ = CypherExecutionMode$explain$.MODULE$;
        return (cypherExecutionMode == null ? cypherExecutionMode$explain$ != null : !cypherExecutionMode.equals(cypherExecutionMode$explain$)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(informations).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    private <T> Supplier<T> supplier(Function0<T> t) {
        return new Supplier<T>(null, t){
            private final Function0 t$1;

            public T get() {
                return (T)this.t$1.apply();
            }
            {
                this.t$1 = t$1;
            }
        };
    }

    public static final /* synthetic */ Option $anonfun$compilers$3(ExecutionEngine $this, Function0 compiledExpressionCompiler$1, int count) {
        return count >= $this.config().recompilationLimit() ? new Some(compiledExpressionCompiler$1.apply()) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.operatorEngine(), config.interpretedPipesFallback(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheRecompile(Object key) {
                CypherCacheHitMonitor.cacheRecompile$(this, key);
            }

            public void cacheDiscard(Pair<String, Map<String, Class<?>>> ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(59).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds: ").append(query).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext));
        this.toStringCacheTracer = new CacheTracer<Pair<Object, Map<String, Class<?>>>>(this){
            private final /* synthetic */ ExecutionEngine $outer;

            private Pair<String, Map<String, Class<?>>> str(Pair<Object, Map<String, Class<?>>> p) {
                return Pair.of((Object)p.first().toString(), (Object)p.other());
            }

            public void queryCacheHit(Pair<Object, Map<String, Class<?>>> queryKey, String metaData) {
                this.$outer.cacheTracer().queryCacheHit(this.str(queryKey), metaData);
            }

            public void queryCacheMiss(Pair<Object, Map<String, Class<?>>> queryKey, String metaData) {
                this.$outer.cacheTracer().queryCacheMiss(this.str(queryKey), metaData);
            }

            public void queryCacheRecompile(Pair<Object, Map<String, Class<?>>> queryKey, String metaData) {
                this.$outer.cacheTracer().queryCacheRecompile(this.str(queryKey), metaData);
            }

            public void queryCacheStale(Pair<Object, Map<String, Class<?>>> queryKey, int secondsSincePlan, String metaData) {
                this.$outer.cacheTracer().queryCacheStale(this.str(queryKey), secondsSincePlan, metaData);
            }

            public void queryCacheFlush(long sizeOfCacheBeforeFlush) {
                this.$outer.cacheTracer().queryCacheFlush(sizeOfCacheBeforeFlush);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.queryCache = new QueryCache(config.queryCacheSize(), this.planStalenessCaller(), this.toStringCacheTracer());
        this.masterCompiler = new MasterCompiler(config, compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

