/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.time.Clock;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.javacompat.MonitoringCacheTracer;
import org.neo4j.cypher.internal.tracing.TimingCompilationTracer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;

public class ExecutionEngine
implements QueryExecutionEngine {
    private org.neo4j.cypher.internal.ExecutionEngine inner;

    public ExecutionEngine(GraphDatabaseQueryService queryService, LogProvider logProvider, CompilerFactory compilerFactory) {
        DependencyResolver resolver = queryService.getDependencyResolver();
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        MonitoringCacheTracer cacheTracer = new MonitoringCacheTracer((StringCacheMonitor)monitors.newMonitor(StringCacheMonitor.class, new String[0]));
        Config config = (Config)resolver.resolveDependency(Config.class);
        CypherConfiguration cypherConfiguration = CypherConfiguration.fromConfig(config);
        TimingCompilationTracer tracer = new TimingCompilationTracer((TimingCompilationTracer.EventListener)monitors.newMonitor(TimingCompilationTracer.EventListener.class, new String[0]));
        this.inner = new org.neo4j.cypher.internal.ExecutionEngine(queryService, monitors, tracer, cacheTracer, cypherConfiguration, compilerFactory, logProvider, Clock.systemUTC());
    }

    public Result executeQuery(String query, MapValue parameters, TransactionalContext context) throws QueryExecutionKernelException {
        try {
            return this.inner.execute(query, parameters, context, false);
        }
        catch (CypherException e) {
            throw new QueryExecutionKernelException((Throwable)e);
        }
    }

    public Result profileQuery(String query, MapValue parameters, TransactionalContext context) throws QueryExecutionKernelException {
        try {
            return this.inner.execute(query, parameters, context, true);
        }
        catch (CypherException e) {
            throw new QueryExecutionKernelException((Throwable)e);
        }
    }

    public boolean isPeriodicCommit(String query) {
        return this.inner.isPeriodicCommit(query);
    }

    public long clearQueryCaches() {
        return this.inner.clearQueryCaches();
    }
}

