/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.time.Clock;
import org.neo4j.cypher.CypherExecutionMode;
import org.neo4j.cypher.CypherExpressionEngineOption;
import org.neo4j.cypher.CypherExpressionEngineOption$onlyWhenHot$;
import org.neo4j.cypher.CypherPlannerOption;
import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherUpdateStrategy;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.ParameterNotFoundException;
import org.neo4j.cypher.exceptionHandler;
import org.neo4j.cypher.internal.CacheDisabled;
import org.neo4j.cypher.internal.CacheHit;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheMiss;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.compatibility.CypherCacheFlushingMonitor$class;
import org.neo4j.cypher.internal.compatibility.CypherCacheHitMonitor$class;
import org.neo4j.cypher.internal.runtime.interpreted.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.ResultBuffer;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;
import org.opencypher.v9_0.util.InputPosition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0005a\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r:\u0012AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB!1\b\u0011\"J\u001b\u0005a$BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003\u007f\u0019\tq\u0001[3ma\u0016\u00148/\u0003\u0002By\t!\u0001+Y5s!\t\u0019eI\u0004\u0002\u000e\t&\u0011QID\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F\u001dA\u0011!\n\u0017\b\u0003\u0017Zs!\u0001T+\u000f\u00055#fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\t&\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005]\u0013\u0011AC)vKJL8)Y2iK&\u0011\u0011L\u0017\u0002\u0011!\u0006\u0014\u0018-\\3uKJ$\u0016\u0010]3NCBT!a\u0016\u0002\t\u0011q\u0003!\u0011!Q\u0001\nY\nAbY1dQ\u0016$&/Y2fe\u0002B\u0001B\u0018\u0001\u0003\u0006\u0004%\taX\u0001\u0007G>tg-[4\u0016\u0003\u0001\u0004\"aN1\n\u0005\t\u0014!aE\"za\",'oQ8oM&<WO]1uS>t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u00021\u0002\u000f\r|gNZ5hA!Aa\r\u0001BC\u0002\u0013\u0005q-\u0001\u000bd_6\u0004\u0018\r^5cS2LG/\u001f$bGR|'/_\u000b\u0002QB\u0011q'[\u0005\u0003U\n\u0011qbQ8na&dWM\u001d$bGR|'/\u001f\u0005\tY\u0002\u0011\t\u0011)A\u0005Q\u0006)2m\\7qCRL'-\u001b7jif4\u0015m\u0019;pef\u0004\u0003\u0002\u00038\u0001\u0005\u000b\u0007I\u0011A8\u0002\u00171|w\r\u0015:pm&$WM]\u000b\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\u00111OB\u0001\bY><w-\u001b8h\u0013\t)(OA\u0006M_\u001e\u0004&o\u001c<jI\u0016\u0014\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u00029\u0002\u00191|w\r\u0015:pm&$WM\u001d\u0011\t\u0011e\u0004!Q1A\u0005\u0002i\fQa\u00197pG.,\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018\u0001\u0002;j[\u0016T!!!\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000bi(!B\"m_\u000e\\\u0007\"CA\u0005\u0001\t\u0005\t\u0015!\u0003|\u0003\u0019\u0019Gn\\2lA!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011A\u0002\u001fj]&$h\b\u0006\n\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u0002CA\u001c\u0001\u0011\u0019\u0019\u00121\u0002a\u0001+!1a$a\u0003A\u0002\u0001Ba!KA\u0006\u0001\u0004Y\u0003B\u0002\u001b\u0002\f\u0001\u0007a\u0007\u0003\u0004_\u0003\u0017\u0001\r\u0001\u0019\u0005\u0007M\u0006-\u0001\u0019\u00015\t\r9\fY\u00011\u0001q\u0011!I\u00181\u0002I\u0001\u0002\u0004Y\b\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0003%\u0001(/\u001a)beN,'/\u0006\u0002\u0002*A\u0019q'a\u000b\n\u0007\u00055\"AA\u0005Qe\u0016\u0004\u0016M]:fe\"A\u0011\u0011\u0007\u0001!\u0002\u0013\tI#\u0001\u0006qe\u0016\u0004\u0016M]:fe\u0002B\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\u000231\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM]\u000b\u0003\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0006j]R,'\u000f\u001d:fi\u0016$'bAA\"\u0005\u00059!/\u001e8uS6,\u0017\u0002BA$\u0003{\u0011\u0011\u0004T1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3fe\"A\u00111\n\u0001!\u0002\u0013\tI$\u0001\u000emCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\b\u0005C\u0004\u0002P\u0001!I!!\u0015\u0002!Ad\u0017M\u001c*fkN\f'-\u001b7ji&LHCBA*\u00033\n\u0019\u0007E\u00028\u0003+J1!a\u0016\u0003\u0005A\u0011V-^:bE&d\u0017\u000e^=Ti\u0006$X\r\u0003\u0005\u0002\\\u00055\u0003\u0019AA/\u0003=)\u00070Z2vi\u0006\u0014G.Z)vKJL\bcA\u001c\u0002`%\u0019\u0011\u0011\r\u0002\u0003\u001f\u0015CXmY;uC\ndW-U;fefD\u0001\"!\u001a\u0002N\u0001\u0007\u0011qM\u0001\u0015iJ\fgn]1di&|g.\u00197D_:$X\r\u001f;\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005)\u0011/^3ss*\u0019\u0011\u0011O\f\u0002\t%l\u0007\u000f\\\u0005\u0005\u0003k\nYG\u0001\u000bUe\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010\u001e\u0005\n\u0003s\u0002!\u0019!C\u0005\u0003w\n1\u0001\\8h+\t\ti\bE\u0002r\u0003\u007fJ1!!!s\u0005\raun\u001a\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002~\u0005!An\\4!\u0011%\tI\t\u0001b\u0001\n\u0013\tY)A\nqY\u0006t7\u000b^1mK:,7o]\"bY2,'/\u0006\u0002\u0002\u000eB)q'a$\u0002^%\u0019\u0011\u0011\u0013\u0002\u0003'Ac\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001b\u000bA\u0003\u001d7b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ\u0004\u0003\"CAM\u0001\t\u0007I\u0011BAN\u0003)\tX/\u001a:z\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003;\u0003raNAP\u0005j\ni&C\u0002\u0002\"\n\u0011!\"U;fef\u001c\u0015m\u00195f\u0011!\t)\u000b\u0001Q\u0001\n\u0005u\u0015aC9vKJL8)Y2iK\u0002B\u0011\"!+\u0001\u0005\u0004%I!a+\u0002\u001d5\f7\u000f^3s\u0007>l\u0007/\u001b7feV\u0011\u0011Q\u0016\t\u0004o\u0005=\u0016bAAY\u0005\tqQ*Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b\u0002CA[\u0001\u0001\u0006I!!,\u0002\u001f5\f7\u000f^3s\u0007>l\u0007/\u001b7fe\u0002B\u0011\"!/\u0001\u0005\u0004%I!a/\u0002\u0019M\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005u\u0006cA\u001c\u0002@&\u0019\u0011\u0011\u0019\u0002\u0003\u0019M\u001b\u0007.Z7b\u0011\u0016d\u0007/\u001a:\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003{\u000bQb]2iK6\f\u0007*\u001a7qKJ\u0004\u0003bBAe\u0001\u0011\u0005\u00111Z\u0001\baJ|g-\u001b7f)!\ti-!7\u0002\\\u0006=\b\u0003BAh\u0003+l!!!5\u000b\u0007\u0005Mg!A\u0004he\u0006\u0004\b\u000e\u001a2\n\t\u0005]\u0017\u0011\u001b\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000f\u00055\u0014q\u0019a\u0001\u0005\"A\u0011Q\\Ad\u0001\u0004\ty.\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003\u001d1\u0018N\u001d;vC2T1!!;\u0007\u0003\u00191\u0018\r\\;fg&!\u0011Q^Ar\u0005!i\u0015\r\u001d,bYV,\u0007\u0002CAy\u0003\u000f\u0004\r!a\u001a\u0002\u000f\r|g\u000e^3yi\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018aB3yK\u000e,H/\u001a\u000b\u000b\u0003\u001b\fI0a?\u0002~\u0006}\bbBA7\u0003g\u0004\rA\u0011\u0005\t\u0003;\f\u0019\u00101\u0001\u0002`\"A\u0011\u0011_Az\u0001\u0004\t9\u0007\u0003\u0006\u0002J\u0006M\b\u0013!a\u0001\u0005\u0003\u00012!\u0004B\u0002\u0013\r\u0011)A\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u0010\u0001C\u0001\u0005\u0013!\"Ba\u0003\u0003\u0012\tM!q\u0003B\r!\u0011\tIG!\u0004\n\t\t=\u00111\u000e\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u001d\tiGa\u0002A\u0002\tC\u0001B!\u0006\u0003\b\u0001\u0007\u0011q\\\u0001\n[\u0006\u0004\b+\u0019:b[ND\u0001\"!=\u0003\b\u0001\u0007\u0011q\r\u0005\t\u00057\u00119\u00011\u0001\u0003\u001e\u0005a!/Z:vYR\u0014UO\u001a4feB!\u0011\u0011\u000eB\u0010\u0013\u0011\u0011\t#a\u001b\u0003\u0019I+7/\u001e7u\u0005V4g-\u001a:\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(\u0005I1m\\7qS2,'o\u001d\u000b\u000b\u0005S\u00119E!\u0015\u0003f\t\u001d\u0004cB\u0007\u0003,\t=\"QG\u0005\u0004\u0005[q!A\u0002+va2,'\u0007E\u0003\u000e\u0005c\ti&C\u0002\u000349\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u000f5\u00119Da\u000f\u0003B%\u0019!\u0011\b\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0007\u0003>%\u0019!q\b\b\u0003\u0007%sG\u000fE\u0003\u000e\u0005\u0007\ni&C\u0002\u0003F9\u0011aa\u00149uS>t\u0007\u0002\u0003B%\u0005G\u0001\rAa\u0013\u0002\u001dA\u0014X\rU1sg\u0016$\u0017+^3ssB\u0019qG!\u0014\n\u0007\t=#A\u0001\bQe\u0016\u0004\u0016M]:fIF+XM]=\t\u000f%\u0012\u0019\u00031\u0001\u0003TA!!Q\u000bB0\u001d\u0011\u00119Fa\u0017\u000f\u0007-\u0013I&\u0003\u0002/\u0005%\u0019!QL\u0017\u0002#\r{W\u000e]5mCRLwN\u001c+sC\u000e,'/\u0003\u0003\u0003b\t\r$!F)vKJL8i\\7qS2\fG/[8o\u000bZ,g\u000e\u001e\u0006\u0004\u0005;j\u0003\u0002CA3\u0005G\u0001\r!a\u001a\t\u0011\u0005u'1\u0005a\u0001\u0003?DqAa\u001b\u0001\t\u0013\u0011i'\u0001\u0007hKR|%oQ8na&dW\r\u0006\u0006\u0002^\t=$\u0011\u000fB:\u0005kB\u0001\"!=\u0003j\u0001\u0007\u0011q\r\u0005\t\u0005\u0013\u0012I\u00071\u0001\u0003L!9\u0011F!\u001bA\u0002\tM\u0003\u0002CAo\u0005S\u0002\r!a8\t\u000f\te\u0004\u0001\"\u0001\u0003|\u0005\u00012\r\\3beF+XM]=DC\u000eDWm\u001d\u000b\u0003\u0005{\u00022!\u0004B@\u0013\r\u0011\tI\u0004\u0002\u0005\u0019>tw\rC\u0004\u0003\u0006\u0002!\tAa\"\u0002!%\u001c\b+\u001a:j_\u0012L7mQ8n[&$H\u0003\u0002B\u0001\u0005\u0013Cq!!\u001c\u0003\u0004\u0002\u0007!\tC\u0004\u0003\u000e\u0002!IAa$\u0002\u001f\rDWmY6QCJ\fW.\u001a;feN$\u0002B!%\u0003\u0018\n5&\u0011\u0017\t\u0004\u001b\tM\u0015b\u0001BK\u001d\t!QK\\5u\u0011!\u0011IJa#A\u0002\tm\u0015aC9vKJL\b+\u0019:b[N\u0004RA!(\u0003(\nsAAa(\u0003$:\u0019qJ!)\n\u0003=I1A!*\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LAA!+\u0003,\n\u00191+Z9\u000b\u0007\t\u0015f\u0002\u0003\u0005\u00030\n-\u0005\u0019AAp\u0003-9\u0017N^3o!\u0006\u0014\u0018-\\:\t\u0011\tM&1\u0012a\u0001\u0003?\fq\"\u001a=ue\u0006\u001cG/\u001a3QCJ\fWn\u001d\u0015\u0007\u0005\u0017\u00139L!2\u0011\u000b5\u0011IL!0\n\u0007\tmfB\u0001\u0004uQJ|wo\u001d\t\u0005\u0005\u007f\u0013\t-D\u0001\u0005\u0013\r\u0011\u0019\r\u0002\u0002\u001b!\u0006\u0014\u0018-\\3uKJtu\u000e\u001e$pk:$W\t_2faRLwN\\\u0012\u0003\u0005{C\u0011B!3\u0001#\u0003%\tAa3\u0002#\u0015DXmY;uK\u0012\"WMZ1vYR$C'\u0006\u0002\u0003N*\"!\u0011\u0001BhW\t\u0011\t\u000e\u0005\u0003\u0003T\nuWB\u0001Bk\u0015\u0011\u00119N!7\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bn\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}'Q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,wa\u0002Br\u0005!\u0005!Q]\u0001\u0010\u000bb,7-\u001e;j_:,enZ5oKB\u0019qGa:\u0007\r\u0005\u0011\u0001\u0012\u0001Bu'\r\u00119\u000f\u0004\u0005\t\u0003\u001b\u00119\u000f\"\u0001\u0003nR\u0011!Q\u001d\u0005\u000b\u0005c\u00149O1A\u0005\u0002\tM\u0018a\u0005)M\u0003:{&)V%M\t&sui\u0018+S\u0013\u0016\u001bVC\u0001B\u001e\u0011%\u00119Pa:!\u0002\u0013\u0011Y$\u0001\u000bQ\u0019\u0006suLQ+J\u0019\u0012KejR0U%&+5\u000b\t\u0005\u000b\u0005w\u00149/%A\u0005\u0002\tu\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003\u0000*\u001a1Pa4")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerFactory compatibilityFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<String, Pair<String, Map<String, Class<?>>>, ExecutableQuery> queryCache;
    private final MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerFactory compatibilityFactory() {
        return this.compatibilityFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ReusabilityState org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, Pair<String, Map<String, Class<?>>>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    public MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public Result profile(String query, MapValue params, TransactionalContext context) {
        return this.execute(query, params, context, true);
    }

    /*
     * WARNING - void declaration
     */
    public Result execute(String query, MapValue params, TransactionalContext context, boolean profile2) {
        Result result;
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        try {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile2);
            ExecutableQuery executableQuery = this.getOrCompile(context, preParsedQuery, queryTracer, params);
            String string = preParsedQuery.executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            MapValue combinedParams = params.updatedWith(executableQuery.extractedParams());
            context.executingQuery().compilationCompleted(executableQuery.compilerInfo());
            result = executableQuery.execute(context, preParsedQuery, combinedParams);
            queryTracer.close();
        }
        catch (Throwable throwable) {
            try {
                context.close(false);
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var5_5;
                var5_5.close();
                throw throwable2;
            }
        }
        return result;
    }

    public QueryExecution execute(String query, MapValue mapParams, TransactionalContext context, ResultBuffer resultBuffer) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean execute$default$4() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> compilers(PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        boolean bl = false;
        CypherExpressionEngineOption cypherExpressionEngineOption = null;
        CypherExpressionEngineOption cypherExpressionEngineOption2 = preParsedQuery.expressionEngine();
        if (CypherExpressionEngineOption$onlyWhenHot$.MODULE$.equals(cypherExpressionEngineOption2)) {
            bl = true;
            cypherExpressionEngineOption = cypherExpressionEngineOption2;
            if (this.config().recompilationLimit() > 0) {
                Serializable primary = new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final TransactionalContext transactionalContext$1;
                    private final MapValue params$1;

                    public final ExecutableQuery apply() {
                        return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1, this.tracer$1, this.transactionalContext$1, this.params$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.transactionalContext$1 = transactionalContext$1;
                        this.params$1 = params$1;
                    }
                };
                Serializable secondary = new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final TransactionalContext transactionalContext$1;
                    private final MapValue params$1;

                    public final Option<ExecutableQuery> apply(int count) {
                        None$ none$;
                        if (count > this.$outer.config().recompilationLimit()) {
                            boolean x$4 = true;
                            String x$5 = this.preParsedQuery$1.copy$default$1();
                            InputPosition x$6 = this.preParsedQuery$1.copy$default$2();
                            String x$7 = this.preParsedQuery$1.copy$default$3();
                            boolean x$8 = this.preParsedQuery$1.copy$default$4();
                            CypherVersion x$9 = this.preParsedQuery$1.copy$default$5();
                            CypherExecutionMode x$10 = this.preParsedQuery$1.copy$default$6();
                            CypherPlannerOption x$11 = this.preParsedQuery$1.copy$default$7();
                            CypherRuntimeOption x$12 = this.preParsedQuery$1.copy$default$8();
                            CypherUpdateStrategy x$13 = this.preParsedQuery$1.copy$default$9();
                            CypherExpressionEngineOption x$14 = this.preParsedQuery$1.copy$default$10();
                            Set<String> x$15 = this.preParsedQuery$1.copy$default$11();
                            Some some = new Some((Object)this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1.copy(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$4), this.tracer$1, this.transactionalContext$1, this.params$1));
                            none$ = some;
                        } else {
                            none$ = None$.MODULE$;
                        }
                        return none$;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.transactionalContext$1 = transactionalContext$1;
                        this.params$1 = params$1;
                    }
                };
                return new Tuple2((Object)primary, (Object)secondary);
            }
        }
        if (!bl) return new Tuple2((Object)new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final PreParsedQuery preParsedQuery$1;
            private final CompilationTracer.QueryCompilationEvent tracer$1;
            private final TransactionalContext transactionalContext$1;
            private final MapValue params$1;

            public final ExecutableQuery apply() {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1, this.tracer$1, this.transactionalContext$1, this.params$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.preParsedQuery$1 = preParsedQuery$1;
                this.tracer$1 = tracer$1;
                this.transactionalContext$1 = transactionalContext$1;
                this.params$1 = params$1;
            }
        }, (Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply(int x$2) {
                return None$.MODULE$;
            }
        });
        return new Tuple2((Object)new Serializable(this, preParsedQuery, tracer, transactionalContext, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final PreParsedQuery preParsedQuery$1;
            private final CompilationTracer.QueryCompilationEvent tracer$1;
            private final TransactionalContext transactionalContext$1;
            private final MapValue params$1;

            public final ExecutableQuery apply() {
                boolean x$16 = true;
                String x$17 = this.preParsedQuery$1.copy$default$1();
                InputPosition x$18 = this.preParsedQuery$1.copy$default$2();
                String x$19 = this.preParsedQuery$1.copy$default$3();
                boolean x$20 = this.preParsedQuery$1.copy$default$4();
                CypherVersion x$21 = this.preParsedQuery$1.copy$default$5();
                CypherExecutionMode x$22 = this.preParsedQuery$1.copy$default$6();
                CypherPlannerOption x$23 = this.preParsedQuery$1.copy$default$7();
                CypherRuntimeOption x$24 = this.preParsedQuery$1.copy$default$8();
                CypherUpdateStrategy x$25 = this.preParsedQuery$1.copy$default$9();
                CypherExpressionEngineOption x$26 = this.preParsedQuery$1.copy$default$10();
                Set<String> x$27 = this.preParsedQuery$1.copy$default$11();
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1.copy(x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$16), this.tracer$1, this.transactionalContext$1, this.params$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.preParsedQuery$1 = preParsedQuery$1;
                this.tracer$1 = tracer$1;
                this.transactionalContext$1 = transactionalContext$1;
                this.params$1 = params$1;
            }
        }, (Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply(int x$1) {
                return None$.MODULE$;
            }
        });
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        Pair cacheKey = Pair.of((Object)preParsedQuery.statementWithVersionAndPlanner(), QueryCache$.MODULE$.extractParameterTypeMap(params));
        TransactionalContext tc = context.getOrBeginNewIfClosed();
        try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
            for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                long schemaToken = this.schemaHelper().readSchemaToken(tc);
                Tuple2<Function0<ExecutableQuery>, Function1<Object, Option<ExecutableQuery>>> tuple2 = this.compilers(preParsedQuery, tracer, tc, params);
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple22;
                    Function0 primaryCompiler = (Function0)tuple2._1();
                    Function1 secondaryCompiler = (Function1)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)primaryCompiler, (Object)secondaryCompiler);
                    Function0 primaryCompiler2 = (Function0)tuple23._1();
                    Function1 secondaryCompiler2 = (Function1)tuple23._2();
                    CacheLookup<ExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<ExecutableQuery>)primaryCompiler2, (Function1<Object, Option<ExecutableQuery>>)secondaryCompiler2, preParsedQuery.rawStatement());
                    CacheLookup<ExecutableQuery> cacheLookup2 = cacheLookup;
                    boolean bl = cacheLookup2 instanceof CacheHit ? true : cacheLookup2 instanceof CacheDisabled;
                    if (bl) {
                        ExecutableQuery executableQuery = cacheLookup.executableQuery();
                        if (this.schemaHelper().lockLabels(schemaToken, executableQuery, preParsedQuery.version(), tc)) {
                            tc.cleanForReuse();
                            return executableQuery;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (cacheLookup2 instanceof CacheMiss) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw new MatchError(cacheLookup2);
                }
                throw new MatchError(tuple2);
            }
            throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
        }
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        return this.preParser().preParseQuery(query, false).isPeriodicCommit();
    }

    private void checkParameters(Seq<String> queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        Serializable x$28 = new Serializable(this, queryParams, givenParams, extractedParams){
            public static final long serialVersionUID = 0L;
            private final Seq queryParams$1;
            public final MapValue givenParams$1;
            public final MapValue extractedParams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq missingKeys = (Seq)((SeqLike)this.queryParams$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkParameters$1 $outer;

                    public final boolean apply(String key) {
                        return !this.$outer.givenParams$1.containsKey(key) && !this.$outer.extractedParams$1.containsKey(key);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).distinct();
                if (missingKeys.nonEmpty()) {
                    throw new ParameterNotFoundException(new StringBuilder().append((Object)"Expected parameter(s): ").append((Object)missingKeys.mkString(", ")).toString());
                }
            }
            {
                this.queryParams$1 = queryParams$1;
                this.givenParams$1 = givenParams$1;
                this.extractedParams$1 = extractedParams$1;
            }
        };
        Function1 x$29 = exceptionHandler.runSafely$.MODULE$.apply$default$2((Function0)x$28);
        exceptionHandler.runSafely$.MODULE$.apply((Function0)x$28, x$29);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer, CypherConfiguration config, CompilerFactory compatibilityFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compatibilityFactory = compatibilityFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.expressionEngineOption(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor$class.cacheFlushDetected(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor$class.cacheHit(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor$class.cacheMiss(this, key);
            }

            public void cacheRecompile(Object key) {
                CypherCacheHitMonitor$class.cacheRecompile(this, key);
            }

            public void cacheDiscard(Pair<String, Map<String, Class<?>>> ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarded stale query from the query cache after ", " seconds: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)secondsSinceReplan), query})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor$class.$init$(this);
                CypherCacheFlushingMonitor$class.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;

            public final ReusabilityState apply(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(executableQuery, transactionalContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.queryCache = new QueryCache(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler = new MasterCompiler(queryService, kernelMonitors, config, logProvider, new CompilerLibrary(compatibilityFactory));
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

