/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.StringCacheMonitor;

public class MonitoringCacheTracer
implements CacheTracer<String> {
    private final StringCacheMonitor monitor;

    public MonitoringCacheTracer(StringCacheMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void queryCacheHit(String queryKey, String metaData) {
        this.monitor.cacheHit(queryKey);
    }

    @Override
    public void queryCacheMiss(String queryKey, String metaData) {
        this.monitor.cacheMiss(queryKey);
    }

    @Override
    public void queryCacheStale(String queryKey, int secondsSincePlan, String metaData) {
        this.monitor.cacheDiscard(queryKey, metaData, secondsSincePlan);
    }

    @Override
    public void queryCacheFlush(long sizeOfCacheBeforeFlush) {
        this.monitor.cacheFlushDetected(sizeOfCacheBeforeFlush);
    }
}

