/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.time.Clock;
import org.neo4j.cypher.ParameterNotFoundException;
import org.neo4j.cypher.exceptionHandler;
import org.neo4j.cypher.internal.CacheDisabled;
import org.neo4j.cypher.internal.CacheHit;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheMiss;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.compatibility.CypherCacheFlushingMonitor$class;
import org.neo4j.cypher.internal.compatibility.CypherCacheHitMonitor$class;
import org.neo4j.cypher.internal.runtime.interpreted.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.ResultBuffer;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r:\u0012AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB\u00111H\u0010\b\u0003\u001bqJ!!\u0010\b\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{9A\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAN\u0001\rG\u0006\u001c\u0007.\u001a+sC\u000e,'\u000f\t\u0005\t\t\u0002\u0011)\u0019!C\u0001\u000b\u000611m\u001c8gS\u001e,\u0012A\u0012\t\u0003o\u001dK!\u0001\u0013\u0002\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011)\u0003!\u0011!Q\u0001\n\u0019\u000bqaY8oM&<\u0007\u0005\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0003Q\u0019w.\u001c9bi&\u0014\u0017\u000e\\5us\u001a\u000b7\r^8ssV\ta\n\u0005\u00028\u001f&\u0011\u0001K\u0001\u0002\u0010\u0007>l\u0007/\u001b7fe\u001a\u000b7\r^8ss\"A!\u000b\u0001B\u0001B\u0003%a*A\u000bd_6\u0004\u0018\r^5cS2LG/\u001f$bGR|'/\u001f\u0011\t\u0011Q\u0003!Q1A\u0005\u0002U\u000b1\u0002\\8h!J|g/\u001b3feV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z\r\u00059An\\4hS:<\u0017BA.Y\u0005-aun\u001a)s_ZLG-\u001a:\t\u0011u\u0003!\u0011!Q\u0001\nY\u000bA\u0002\\8h!J|g/\u001b3fe\u0002B\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001Y\u0001\u0006G2|7m[\u000b\u0002CB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0005i&lWMC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'!B\"m_\u000e\\\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B1\u0002\r\rdwnY6!\u0011\u0015a\u0007\u0001\"\u0001n\u0003\u0019a\u0014N\\5u}QIan\u001c9reN$XO\u001e\t\u0003o\u0001AQaE6A\u0002UAQAH6A\u0002\u0001BQ!K6A\u0002-BQ\u0001N6A\u0002YBQ\u0001R6A\u0002\u0019CQ\u0001T6A\u00029CQ\u0001V6A\u0002YCqaX6\u0011\u0002\u0003\u0007\u0011\rC\u0004y\u0001\t\u0007I\u0011B=\u0002\u0013A\u0014X\rU1sg\u0016\u0014X#\u0001>\u0011\u0005]Z\u0018B\u0001?\u0003\u0005%\u0001&/\u001a)beN,'\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA_\u0001\u000baJ,\u0007+\u0019:tKJ\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0003ea\u0017m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\fS:$XM\u001d9sKR,GMC\u0002\u0002\u0010\t\tqA];oi&lW-\u0003\u0003\u0002\u0014\u0005%!!\u0007'bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJD\u0001\"a\u0006\u0001A\u0003%\u0011QA\u0001\u001bY\u0006\u001cHoQ8n[&$H/\u001a3Uq&#\u0007K]8wS\u0012,'\u000f\t\u0005\b\u00037\u0001A\u0011BA\u000f\u0003A\u0001H.\u00198SKV\u001c\u0018MY5mSRL\u0017\u0010\u0006\u0004\u0002 \u0005\u0015\u0012q\u0006\t\u0004o\u0005\u0005\u0012bAA\u0012\u0005\t\u0001\"+Z;tC\nLG.\u001b;z'R\fG/\u001a\u0005\t\u0003O\tI\u00021\u0001\u0002*\u0005yQ\r_3dkR\f'\r\\3Rk\u0016\u0014\u0018\u0010E\u00028\u0003WI1!!\f\u0003\u0005=)\u00050Z2vi\u0006\u0014G.Z)vKJL\b\u0002CA\u0019\u00033\u0001\r!a\r\u0002)Q\u0014\u0018M\\:bGRLwN\\1m\u0007>tG/\u001a=u!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tQ!];fefT1!!\u0010\u0018\u0003\u0011IW\u000e\u001d7\n\t\u0005\u0005\u0013q\u0007\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0013a\u00017pOV\u0011\u0011\u0011\n\t\u0004/\u0006-\u0013bAA'1\n\u0019Aj\\4\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0013\nA\u0001\\8hA!I\u0011Q\u000b\u0001C\u0002\u0013%\u0011qK\u0001\u0014a2\fgn\u0015;bY\u0016tWm]:DC2dWM]\u000b\u0003\u00033\u0002RaNA.\u0003SI1!!\u0018\u0003\u0005M\u0001F.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s\u0011!\t\t\u0007\u0001Q\u0001\n\u0005e\u0013\u0001\u00069mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014\b\u0005C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h\u0005Q\u0011/^3ss\u000e\u000b7\r[3\u0016\u0005\u0005%\u0004CB\u001c\u0002li\nI#C\u0002\u0002n\t\u0011!\"U;fef\u001c\u0015m\u00195f\u0011!\t\t\b\u0001Q\u0001\n\u0005%\u0014aC9vKJL8)Y2iK\u0002B\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\u0002\u001d5\f7\u000f^3s\u0007>l\u0007/\u001b7feV\u0011\u0011\u0011\u0010\t\u0004o\u0005m\u0014bAA?\u0005\tqQ*Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b\u0002CAA\u0001\u0001\u0006I!!\u001f\u0002\u001f5\f7\u000f^3s\u0007>l\u0007/\u001b7fe\u0002B\u0011\"!\"\u0001\u0005\u0004%I!a\"\u0002\u0019M\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005%\u0005cA\u001c\u0002\f&\u0019\u0011Q\u0012\u0002\u0003\u0019M\u001b\u0007.Z7b\u0011\u0016d\u0007/\u001a:\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u0013\u000bQb]2iK6\f\u0007*\u001a7qKJ\u0004\u0003bBAK\u0001\u0011\u0005\u0011qS\u0001\baJ|g-\u001b7f)!\tI*!*\u0002(\u0006m\u0006\u0003BAN\u0003Ck!!!(\u000b\u0007\u0005}e!A\u0004he\u0006\u0004\b\u000e\u001a2\n\t\u0005\r\u0016Q\u0014\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000f\u0005e\u00121\u0013a\u0001u!A\u0011\u0011VAJ\u0001\u0004\tY+\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u001d1\u0018N\u001d;vC2T1!!.\u0007\u0003\u00191\u0018\r\\;fg&!\u0011\u0011XAX\u0005!i\u0015\r\u001d,bYV,\u0007\u0002CA_\u0003'\u0003\r!a\r\u0002\u000f\r|g\u000e^3yi\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0017aB3yK\u000e,H/\u001a\u000b\u000b\u00033\u000b)-a2\u0002J\u0006-\u0007bBA\u001d\u0003\u007f\u0003\rA\u000f\u0005\t\u0003S\u000by\f1\u0001\u0002,\"A\u0011QXA`\u0001\u0004\t\u0019\u0004\u0003\u0006\u0002\u0016\u0006}\u0006\u0013!a\u0001\u0003\u001b\u00042!DAh\u0013\r\t\tN\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\r\u0001C\u0001\u0003+$\"\"a6\u0002^\u0006}\u00171]As!\u0011\t)$!7\n\t\u0005m\u0017q\u0007\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u001d\tI$a5A\u0002iB\u0001\"!9\u0002T\u0002\u0007\u00111V\u0001\n[\u0006\u0004\b+\u0019:b[ND\u0001\"!0\u0002T\u0002\u0007\u00111\u0007\u0005\t\u0003O\f\u0019\u000e1\u0001\u0002j\u0006a!/Z:vYR\u0014UO\u001a4feB!\u0011QGAv\u0013\u0011\ti/a\u000e\u0003\u0019I+7/\u001e7u\u0005V4g-\u001a:\t\u000f\u0005E\b\u0001\"\u0003\u0002t\u0006aq-\u001a;Pe\u000e{W\u000e]5mKRA\u0011\u0011FA{\u0003o\u0014\t\u0001\u0003\u0005\u0002>\u0006=\b\u0019AA\u001a\u0011!\tI0a<A\u0002\u0005m\u0018A\u00049sKB\u000b'o]3e#V,'/\u001f\t\u0004o\u0005u\u0018bAA\u0000\u0005\tq\u0001K]3QCJ\u001cX\rZ)vKJL\bbB\u0015\u0002p\u0002\u0007!1\u0001\t\u0005\u0005\u000b\u0011)C\u0004\u0003\u0003\b\t\u0005b\u0002\u0002B\u0005\u0005?qAAa\u0003\u0003\u001e9!!Q\u0002B\u000e\u001d\u0011\u0011yA!\u0007\u000f\t\tE!qC\u0007\u0003\u0005'Q1A!\u0006\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!A\f\u0002\n\u0007\t\rR&A\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJLAAa\n\u0003*\t)\u0012+^3ss\u000e{W\u000e]5mCRLwN\\#wK:$(b\u0001B\u0012[!9!Q\u0006\u0001\u0005\u0002\t=\u0012\u0001E2mK\u0006\u0014\u0018+^3ss\u000e\u000b7\r[3t)\t\u0011\t\u0004E\u0002\u000e\u0005gI1A!\u000e\u000f\u0005\u0011auN\\4\t\u000f\te\u0002\u0001\"\u0001\u0003<\u0005\u0001\u0012n\u001d)fe&|G-[2D_6l\u0017\u000e\u001e\u000b\u0005\u0003\u001b\u0014i\u0004C\u0004\u0002:\t]\u0002\u0019\u0001\u001e\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D\u0005y1\r[3dWB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0005\u0003F\t-#\u0011\rB3!\ri!qI\u0005\u0004\u0005\u0013r!\u0001B+oSRD\u0001B!\u0014\u0003@\u0001\u0007!qJ\u0001\fcV,'/\u001f)be\u0006l7\u000fE\u0003\u0003R\tm#H\u0004\u0003\u0003T\t]c\u0002\u0002B\t\u0005+J\u0011aD\u0005\u0004\u00053r\u0011a\u00029bG.\fw-Z\u0005\u0005\u0005;\u0012yFA\u0002TKFT1A!\u0017\u000f\u0011!\u0011\u0019Ga\u0010A\u0002\u0005-\u0016aC4jm\u0016t\u0007+\u0019:b[ND\u0001Ba\u001a\u0003@\u0001\u0007\u00111V\u0001\u0010Kb$(/Y2uK\u0012\u0004\u0016M]1ng\"2!q\bB6\u0005s\u0002R!\u0004B7\u0005cJ1Aa\u001c\u000f\u0005\u0019!\bN]8xgB!!1\u000fB;\u001b\u0005!\u0011b\u0001B<\t\tQ\u0002+\u0019:b[\u0016$XM\u001d(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]\u000e\u0012!\u0011\u000f\u0005\n\u0005{\u0002\u0011\u0013!C\u0001\u0005\u007f\n\u0011#\u001a=fGV$X\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\tI\u000b\u0003\u0002N\n\r5F\u0001BC!\u0011\u00119I!%\u000e\u0005\t%%\u0002\u0002BF\u0005\u001b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=e\"\u0001\u0006b]:|G/\u0019;j_:LAAa%\u0003\n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u000f\t]%\u0001#\u0001\u0003\u001a\u0006yQ\t_3dkRLwN\\#oO&tW\rE\u00028\u000573a!\u0001\u0002\t\u0002\tu5c\u0001BN\u0019!9ANa'\u0005\u0002\t\u0005FC\u0001BM\u0011)\u0011)Ka'C\u0002\u0013\u0005!qU\u0001\u0014!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUiU\u000b\u0003\u0005S\u00032!\u0004BV\u0013\r\u0011iK\u0004\u0002\u0004\u0013:$\b\"\u0003BY\u00057\u0003\u000b\u0011\u0002BU\u0003Q\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#TA!Q!Q\u0017BN#\u0003%\tAa.\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011ILK\u0002b\u0005\u0007\u0003")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<String> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerFactory compatibilityFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<String, ExecutableQuery> queryCache;
    private final MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<String> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerFactory compatibilityFactory() {
        return this.compatibilityFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ReusabilityState org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    public MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public Result profile(String query, MapValue params, TransactionalContext context) {
        return this.execute(query, params, context, true);
    }

    /*
     * WARNING - void declaration
     */
    public Result execute(String query, MapValue params, TransactionalContext context, boolean profile) {
        Result result;
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        try {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile);
            ExecutableQuery executableQuery = this.getOrCompile(context, preParsedQuery, queryTracer);
            String string = preParsedQuery.executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            MapValue combinedParams = params.updatedWith(executableQuery.extractedParams());
            context.executingQuery().compilationCompleted(executableQuery.compilerInfo());
            result = executableQuery.execute(context, preParsedQuery.executionMode(), combinedParams);
            queryTracer.close();
        }
        catch (Throwable throwable) {
            try {
                context.close(false);
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var5_5;
                var5_5.close();
                throw throwable2;
            }
        }
        return result;
    }

    public QueryExecution execute(String query, MapValue mapParams, TransactionalContext context, ResultBuffer resultBuffer) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean execute$default$4() {
        return false;
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer) {
        String cacheKey = preParsedQuery.statementWithVersionAndPlanner();
        TransactionalContext tc = context.getOrBeginNewIfClosed();
        try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
            for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                BoxedUnit boxedUnit;
                long schemaToken = this.schemaHelper().readSchemaToken(tc);
                CacheLookup<ExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<ExecutableQuery>)new Serializable(this, preParsedQuery, tracer, tc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final TransactionalContext tc$1;

                    public final ExecutableQuery apply() {
                        return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1, this.tracer$1, this.tc$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.tc$1 = tc$1;
                    }
                }, preParsedQuery.rawStatement());
                CacheLookup<ExecutableQuery> cacheLookup2 = cacheLookup;
                boolean bl = cacheLookup2 instanceof CacheHit ? true : cacheLookup2 instanceof CacheDisabled;
                if (bl) {
                    ExecutableQuery executableQuery = cacheLookup.executableQuery();
                    if (this.schemaHelper().lockLabels(schemaToken, executableQuery, preParsedQuery.version(), tc)) {
                        tc.cleanForReuse();
                        return executableQuery;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (cacheLookup2 instanceof CacheMiss) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError(cacheLookup2);
            }
            throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
        }
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        return this.preParser().preParseQuery(query, false).isPeriodicCommit();
    }

    private void checkParameters(Seq<String> queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        Serializable x$1 = new Serializable(this, queryParams, givenParams, extractedParams){
            public static final long serialVersionUID = 0L;
            private final Seq queryParams$1;
            public final MapValue givenParams$1;
            public final MapValue extractedParams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq missingKeys = (Seq)this.queryParams$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkParameters$1 $outer;

                    public final boolean apply(String key) {
                        return !this.$outer.givenParams$1.containsKey(key) && !this.$outer.extractedParams$1.containsKey(key);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (missingKeys.nonEmpty()) {
                    throw new ParameterNotFoundException(new StringBuilder().append((Object)"Expected parameter(s): ").append((Object)missingKeys.mkString(", ")).toString());
                }
            }
            {
                this.queryParams$1 = queryParams$1;
                this.givenParams$1 = givenParams$1;
                this.extractedParams$1 = extractedParams$1;
            }
        };
        Function1 x$2 = exceptionHandler.runSafely$.MODULE$.apply$default$2((Function0)x$1);
        exceptionHandler.runSafely$.MODULE$.apply((Function0)x$1, x$2);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<String> cacheTracer, CypherConfiguration config, CompilerFactory compatibilityFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compatibilityFactory = compatibilityFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor$class.cacheFlushDetected(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor$class.cacheHit(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor$class.cacheMiss(this, key);
            }

            public void cacheDiscard(String ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarded stale query from the query cache after ", " seconds: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)secondsSinceReplan), query})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor$class.$init$(this);
                CypherCacheFlushingMonitor$class.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;

            public final ReusabilityState apply(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(executableQuery, transactionalContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.queryCache = new QueryCache<String, ExecutableQuery>(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler = new MasterCompiler(queryService, kernelMonitors, config, logProvider, new CompilerLibrary(compatibilityFactory));
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

