/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.time.Duration;
import org.neo4j.cypher.CypherPlannerOption;
import org.neo4j.cypher.CypherPlannerOption$;
import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherRuntimeOption$;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.CypherVersion$;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.compiler.v3_5.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.compiler.v3_5.StatsDivergenceCalculator$;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple13;
import scala.runtime.BoxesRunTime;

public final class CypherConfiguration$
implements Serializable {
    public static final CypherConfiguration$ MODULE$;

    static {
        new CypherConfiguration$();
    }

    public CypherConfiguration fromConfig(Config config) {
        return new CypherConfiguration((CypherVersion)CypherVersion$.MODULE$.apply((String)config.get(GraphDatabaseSettings.cypher_parser_version)), (CypherPlannerOption)CypherPlannerOption$.MODULE$.apply((String)config.get(GraphDatabaseSettings.cypher_planner)), (CypherRuntimeOption)CypherRuntimeOption$.MODULE$.apply((String)config.get(GraphDatabaseSettings.cypher_runtime)), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseSettings.query_cache_size)), this.statsDivergenceFromConfig(config), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_hints_error)), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseSettings.cypher_idp_solver_table_threshold)), Predef$.MODULE$.Long2long((Long)config.get(GraphDatabaseSettings.cypher_idp_solver_duration_threshold)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_exhaustive_shortestpath)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.forbid_shortestpath_common_nodes)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.csv_legacy_quote_escaping)), Predef$.MODULE$.Integer2int((Integer)config.get(GraphDatabaseSettings.csv_buffer_size)), Predef$.MODULE$.Boolean2boolean((Boolean)config.get(GraphDatabaseSettings.cypher_plan_with_minimum_cardinality_estimates)));
    }

    public StatsDivergenceCalculator statsDivergenceFromConfig(Config config) {
        double divergenceThreshold = (Double)config.get(GraphDatabaseSettings.query_statistics_divergence_threshold);
        double targetThreshold = (Double)config.get(GraphDatabaseSettings.query_statistics_divergence_target);
        long minReplanTime = Predef$.MODULE$.long2Long(((Duration)config.get(GraphDatabaseSettings.cypher_min_replan_interval)).toMillis());
        long targetReplanTime = Predef$.MODULE$.long2Long(((Duration)config.get(GraphDatabaseSettings.cypher_replan_interval_target)).toMillis());
        String divergenceAlgorithm = (String)config.get(GraphDatabaseSettings.cypher_replan_algorithm);
        return StatsDivergenceCalculator$.MODULE$.divergenceCalculatorFor(divergenceAlgorithm, divergenceThreshold, targetThreshold, minReplanTime, targetReplanTime);
    }

    public CypherConfiguration apply(CypherVersion version, CypherPlannerOption planner, CypherRuntimeOption runtime, int queryCacheSize, StatsDivergenceCalculator statsDivergenceCalculator, boolean useErrorsOverWarnings, int idpMaxTableSize, long idpIterationDuration, boolean errorIfShortestPathFallbackUsedAtRuntime, boolean errorIfShortestPathHasCommonNodesAtRuntime, boolean legacyCsvQuoteEscaping, int csvBufferSize, boolean planWithMinimumCardinalityEstimates) {
        return new CypherConfiguration(version, planner, runtime, queryCacheSize, statsDivergenceCalculator, useErrorsOverWarnings, idpMaxTableSize, idpIterationDuration, errorIfShortestPathFallbackUsedAtRuntime, errorIfShortestPathHasCommonNodesAtRuntime, legacyCsvQuoteEscaping, csvBufferSize, planWithMinimumCardinalityEstimates);
    }

    public Option<Tuple13<CypherVersion, CypherPlannerOption, CypherRuntimeOption, Object, StatsDivergenceCalculator, Object, Object, Object, Object, Object, Object, Object, Object>> unapply(CypherConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple13((Object)x$0.version(), (Object)x$0.planner(), (Object)x$0.runtime(), (Object)BoxesRunTime.boxToInteger((int)x$0.queryCacheSize()), (Object)x$0.statsDivergenceCalculator(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useErrorsOverWarnings()), (Object)BoxesRunTime.boxToInteger((int)x$0.idpMaxTableSize()), (Object)BoxesRunTime.boxToLong((long)x$0.idpIterationDuration()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.errorIfShortestPathFallbackUsedAtRuntime()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.errorIfShortestPathHasCommonNodesAtRuntime()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.legacyCsvQuoteEscaping()), (Object)BoxesRunTime.boxToInteger((int)x$0.csvBufferSize()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.planWithMinimumCardinalityEstimates())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CypherConfiguration$() {
        MODULE$ = this;
    }
}

