/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.v3_1;

import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v3_1.spi.StatisticsCompletingGraphStatistics;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.NameId;
import org.neo4j.cypher.internal.frontend.v3_1.NameId$;
import org.neo4j.cypher.internal.frontend.v3_1.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_1.RelTypeId;
import org.neo4j.cypher.internal.spi.v3_1.TransactionBoundGraphStatistics$;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015r!B\u0001\u0003\u0011\u0003y\u0011a\b+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg*\u00111\u0001B\u0001\u0005mNz\u0016G\u0003\u0002\u0006\r\u0005\u00191\u000f]5\u000b\u0005\u001dA\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%Q\u0011AB2za\",'O\u0003\u0002\f\u0019\u0005)a.Z85U*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051CA\u0010Ue\u0006t7/Y2uS>t'i\\;oI\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\u001c\"!\u0005\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0011\u0015Y\u0012\u0003\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0003\u001f#\u0011\u0005q$A\u0003baBd\u0017\u0010\u0006\u0002!QA\u0011\u0011EJ\u0007\u0002E)\u0011Qa\t\u0006\u0003\u0007\u0011R!!\n\u0004\u0002\u0011\r|W\u000e]5mKJL!a\n\u0012\u0003GM#\u0018\r^5ti&\u001c7oQ8na2,G/\u001b8h\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\")\u0011&\ba\u0001U\u0005!BO]1og\u0006\u001cG/[8oC2\u001cuN\u001c;fqR\u0004\"a\u000b\u001a\u000e\u00031R!!\f\u0018\u0002\u000bE,XM]=\u000b\u0005=\u0002\u0014\u0001B5na2T!!\r\u0006\u0002\r-,'O\\3m\u0013\t\u0019DF\u0001\u000bUe\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010\u001e\u0005\u0006=E!\t!\u000e\u000b\u0004AY\u0002\u0005\"B\u001c5\u0001\u0004A\u0014\u0001\u0002:fC\u0012\u0004\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u0007\u0005\u0004\u0018N\u0003\u00022{)\u0011qAC\u0005\u0003\u007fi\u0012AAU3bI\")\u0011\t\u000ea\u0001\u0005\u0006Q1o\u00195f[\u0006\u0014V-\u00193\u0011\u0005e\u001a\u0015B\u0001#;\u0005)\u00196\r[3nCJ+\u0017\r\u001a\u0004\u0005\rF!qIA\u0012CCN,GK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u0014\u0007\u0015#\u0002\n\u0005\u0002\"\u0013&\u0011!J\t\u0002\u0010\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\"Aq'\u0012B\u0001B\u0003%\u0001\b\u0003\u0005B\u000b\n\u0005\t\u0015!\u0003C\u0011\u0015YR\t\"\u0001O)\ry\u0015K\u0015\t\u0003!\u0016k\u0011!\u0005\u0005\u0006o5\u0003\r\u0001\u000f\u0005\u0006\u00036\u0003\rA\u0011\u0005\u0006)\u0016#\t!V\u0001\u0011S:$W\r_*fY\u0016\u001cG/\u001b<jif$2AV1k!\r)r+W\u0005\u00031Z\u0011aa\u00149uS>t\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u001dawnZ5dC2T!AX\u0012\u0002\u000fAd\u0017M\u001c8fe&\u0011\u0001m\u0017\u0002\f'\u0016dWm\u0019;jm&$\u0018\u0010C\u0003c'\u0002\u00071-A\u0003mC\n,G\u000e\u0005\u0002eQ6\tQM\u0003\u0002\u0004M*\u0011qMB\u0001\tMJ|g\u000e^3oI&\u0011\u0011.\u001a\u0002\b\u0019\u0006\u0014W\r\\%e\u0011\u0015Y7\u000b1\u0001m\u0003!\u0001(o\u001c9feRL\bC\u00013n\u0013\tqWMA\u0007Qe>\u0004XM\u001d;z\u0017\u0016L\u0018\n\u001a\u0005\u0006a\u0016#\t!]\u0001\u001fS:$W\r\u001f)s_B,'\u000f^=Fq&\u001cHo]*fY\u0016\u001cG/\u001b<jif$2A\u0016:t\u0011\u0015\u0011w\u000e1\u0001d\u0011\u0015Yw\u000e1\u0001m\u0011\u0015)X\t\"\u0001w\u0003eqw\u000eZ3t/&$\b\u000eT1cK2\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=\u0015\u0005]T\bC\u0001.y\u0013\tI8LA\u0006DCJ$\u0017N\\1mSRL\b\"B>u\u0001\u0004a\u0018a\u00027bE\u0016d\u0017\n\u001a\t\u0004+]\u001b\u0007\"\u0002@F\t\u0003y\u0018AJ2be\u0012Lg.\u00197jif\u0014\u0015\u0010T1cK2\u001c\u0018I\u001c3SK2\fG/[8og\"L\u0007\u000fV=qKR9q/!\u0001\u0002\u0006\u0005E\u0001BBA\u0002{\u0002\u0007A0A\u0005ge>lG*\u00192fY\"9\u0011qA?A\u0002\u0005%\u0011!\u0003:fYRK\b/Z%e!\u0011)r+a\u0003\u0011\u0007\u0011\fi!C\u0002\u0002\u0010\u0015\u0014\u0011BU3m)f\u0004X-\u00133\t\r\u0005MQ\u00101\u0001}\u0003\u001d!x\u000eT1cK2Dq!a\u0006F\t\u0013\tI\"\u0001\u0006bi2+\u0017m\u001d;P]\u0016$2a^A\u000e\u0011!\ti\"!\u0006A\u0002\u0005}\u0011!B2pk:$\bcA\u000b\u0002\"%\u0019\u00111\u0005\f\u0003\r\u0011{WO\u00197f\u0001")
public final class TransactionBoundGraphStatistics {
    public static StatisticsCompletingGraphStatistics apply(Read read, SchemaRead schemaRead) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(read, schemaRead);
    }

    public static StatisticsCompletingGraphStatistics apply(TransactionalContext transactionalContext) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(transactionalContext);
    }

    public static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics {
        private final Read read;
        private final SchemaRead schemaRead;

        public Option<Selectivity> indexSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                double labeledNodes = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                double indexEntrySelectivity = this.schemaRead.indexUniqueValuesSelectivity(this.schemaRead.indexReferenceUnchecked(label.id(), new int[]{property.id()}));
                double frequencyOfNodesWithSameValue = 1.0 / indexEntrySelectivity;
                double indexSelectivity2 = frequencyOfNodesWithSameValue / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity2);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Option<Selectivity> indexPropertyExistsSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                double labeledNodes = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                long indexSize = this.schemaRead.indexSize(this.schemaRead.indexReferenceUnchecked(label.id(), new int[]{property.id()}));
                double indexSelectivity2 = (double)indexSize / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity2);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> labelId) {
            return this.atLeastOne(this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode(labelId)));
        }

        public Cardinality cardinalityByLabelsAndRelationshipType(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return this.atLeastOne(this.read.countsForRelationshipWithoutTxState(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        private Cardinality atLeastOne(double count) {
            return count < 1.0 ? Cardinality$.MODULE$.SINGLE() : new Cardinality(count);
        }

        public BaseTransactionBoundGraphStatistics(Read read, SchemaRead schemaRead) {
            this.read = read;
            this.schemaRead = schemaRead;
        }
    }
}

