/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.cypher.internal.codegen.CompiledMaterializeValueMapper;
import org.neo4j.cypher.internal.codegen.PrimitiveEntityStream;
import org.neo4j.cypher.internal.codegen.PrimitiveNodeStream;
import org.neo4j.cypher.internal.codegen.PrimitiveRelationshipStream;
import org.neo4j.cypher.internal.runtime.interpreted.makeValueNeoSafe;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.RelationshipProxyWrappingValue;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import org.opencypher.v9_0.util.CypherTypeException;
import org.opencypher.v9_0.util.IncomparableValuesException;

public abstract class CompiledConversionUtils {
    public static boolean coerceToPredicate(Object value) {
        if (value == null || value == Values.NO_VALUE) {
            return false;
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).booleanValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof ArrayValue) {
            return ((ArrayValue)value).length() > 0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        throw new CypherTypeException("Don't know how to treat that as a predicate: " + value.toString(), null);
    }

    public static Set<?> toSet(Object value) {
        if (value == null || value == Values.NO_VALUE) {
            return Collections.emptySet();
        }
        if (value instanceof SequenceValue) {
            HashSet<AnyValue> set;
            SequenceValue sequenceValue = (SequenceValue)value;
            Iterator iterator = sequenceValue.iterator();
            if (sequenceValue.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                int length = sequenceValue.length();
                set = new HashSet(length);
                for (int i = 0; i < length; ++i) {
                    set.add(sequenceValue.value(i));
                }
            } else {
                set = new HashSet<AnyValue>();
                while (iterator.hasNext()) {
                    AnyValue element = (AnyValue)iterator.next();
                    set.add(element);
                }
            }
            return set;
        }
        if (value instanceof Collection) {
            return new HashSet((Collection)value);
        }
        if (value instanceof LongStream) {
            LongStream stream = (LongStream)value;
            return stream.boxed().collect(Collectors.toSet());
        }
        if (value instanceof IntStream) {
            IntStream stream = (IntStream)value;
            return stream.boxed().collect(Collectors.toSet());
        }
        if (value instanceof DoubleStream) {
            DoubleStream stream = (DoubleStream)value;
            return stream.boxed().collect(Collectors.toSet());
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            HashSet<Object> collection = new HashSet<Object>(len);
            for (int i = 0; i < len; ++i) {
                collection.add(Array.get(value, i));
            }
            return collection;
        }
        throw new CypherTypeException("Don't know how to create a set out of " + value.getClass().getSimpleName(), null);
    }

    public static CompositeKey compositeKey(long ... keys) {
        return new CompositeKey(keys);
    }

    public static Boolean equals(Object lhs, Object rhs) {
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return null;
        }
        boolean lhsVirtualNodeValue = lhs instanceof VirtualNodeValue;
        if (lhsVirtualNodeValue || rhs instanceof VirtualNodeValue || lhs instanceof VirtualRelationshipValue || rhs instanceof VirtualRelationshipValue) {
            if (lhsVirtualNodeValue && !(rhs instanceof VirtualNodeValue) || rhs instanceof VirtualNodeValue && !lhsVirtualNodeValue || lhs instanceof VirtualRelationshipValue && !(rhs instanceof VirtualRelationshipValue) || rhs instanceof VirtualRelationshipValue && !(lhs instanceof VirtualRelationshipValue)) {
                throw new IncomparableValuesException(lhs.getClass().getSimpleName(), rhs.getClass().getSimpleName());
            }
            return lhs.equals(rhs);
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        return lhsValue.ternaryEquals(rhsValue);
    }

    public static Boolean or(Object lhs, Object rhs) {
        Boolean l = CompiledConversionUtils.toBooleanOrNull(lhs);
        Boolean r = CompiledConversionUtils.toBooleanOrNull(rhs);
        if (l == null && r == null) {
            return null;
        }
        if (l == null) {
            return r != false ? Boolean.valueOf(true) : null;
        }
        if (r == null) {
            return l != false ? Boolean.valueOf(true) : null;
        }
        return l != false || r != false;
    }

    public static Boolean not(Object predicate) {
        Boolean b = CompiledConversionUtils.toBooleanOrNull(predicate);
        if (b == null) {
            return null;
        }
        return b == false;
    }

    private static Boolean toBooleanOrNull(Object o) {
        if (o == null || o == Values.NO_VALUE) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof BooleanValue) {
            return ((BooleanValue)o).booleanValue();
        }
        throw new CypherTypeException("Don't know how to treat that as a boolean: " + o.toString(), null);
    }

    public static AnyValue materializeAnyResult(EmbeddedProxySPI proxySpi, Object anyValue) {
        if (anyValue == null || anyValue == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (anyValue instanceof AnyValue) {
            return CompiledConversionUtils.materializeAnyValueResult(proxySpi, anyValue);
        }
        if (anyValue instanceof List) {
            return VirtualValues.fromList(((List)anyValue).stream().map(v -> CompiledConversionUtils.materializeAnyResult(proxySpi, v)).collect(Collectors.toList()));
        }
        if (anyValue instanceof Map) {
            Map incoming = (Map)anyValue;
            MapValueBuilder builder = new MapValueBuilder(incoming.size());
            for (Map.Entry entry : incoming.entrySet()) {
                builder.add((String)entry.getKey(), CompiledConversionUtils.materializeAnyResult(proxySpi, entry.getValue()));
            }
            return builder.build();
        }
        if (anyValue instanceof PrimitiveNodeStream) {
            return VirtualValues.fromList(((PrimitiveNodeStream)anyValue).longStream().mapToObj(id -> ValueUtils.fromNodeProxy((Node)proxySpi.newNodeProxy(id))).collect(Collectors.toList()));
        }
        if (anyValue instanceof PrimitiveRelationshipStream) {
            return VirtualValues.fromList(((PrimitiveRelationshipStream)anyValue).longStream().mapToObj(id -> ValueUtils.fromRelationshipProxy((Relationship)proxySpi.newRelationshipProxy(id))).collect(Collectors.toList()));
        }
        if (anyValue instanceof LongStream) {
            long[] array = ((LongStream)anyValue).toArray();
            return Values.longArray((long[])array);
        }
        if (anyValue instanceof DoubleStream) {
            double[] array = ((DoubleStream)anyValue).toArray();
            return Values.doubleArray((double[])array);
        }
        if (anyValue instanceof IntStream) {
            return VirtualValues.fromList(((IntStream)anyValue).mapToObj(i -> Values.booleanValue((i != 0 ? 1 : 0) != 0)).collect(Collectors.toList()));
        }
        if (anyValue.getClass().isArray()) {
            Class<?> componentType = anyValue.getClass().getComponentType();
            int length = Array.getLength(anyValue);
            if (componentType.isPrimitive()) {
                Object copy = Array.newInstance(componentType, length);
                System.arraycopy(anyValue, 0, copy, 0, length);
                return ValueUtils.of((Object)copy);
            }
            if (anyValue instanceof String[]) {
                return Values.stringArray((String[])((String[])anyValue));
            }
            AnyValue[] copy = new AnyValue[length];
            for (int i2 = 0; i2 < length; ++i2) {
                copy[i2] = CompiledConversionUtils.materializeAnyResult(proxySpi, Array.get(anyValue, i2));
            }
            return VirtualValues.list((AnyValue[])copy);
        }
        return ValueUtils.of((Object)anyValue);
    }

    public static AnyValue materializeAnyValueResult(EmbeddedProxySPI proxySpi, Object anyValue) {
        if (anyValue instanceof VirtualNodeValue) {
            if (anyValue instanceof NodeValue) {
                return (AnyValue)anyValue;
            }
            return ValueUtils.fromNodeProxy((Node)proxySpi.newNodeProxy(((VirtualNodeValue)anyValue).id()));
        }
        if (anyValue instanceof VirtualRelationshipValue) {
            if (anyValue instanceof RelationshipValue) {
                return (AnyValue)anyValue;
            }
            return ValueUtils.fromRelationshipProxy((Relationship)proxySpi.newRelationshipProxy(((VirtualRelationshipValue)anyValue).id()));
        }
        if (anyValue instanceof ListValue && !((ListValue)anyValue).storable() || anyValue instanceof MapValue) {
            return CompiledMaterializeValueMapper.mapAnyValue(proxySpi, (AnyValue)anyValue);
        }
        return (AnyValue)anyValue;
    }

    public static NodeValue materializeNodeValue(EmbeddedProxySPI proxySpi, Object anyValue) {
        if (anyValue instanceof NodeValue) {
            return (NodeValue)anyValue;
        }
        if (anyValue instanceof VirtualNodeValue) {
            return ValueUtils.fromNodeProxy((Node)proxySpi.newNodeProxy(((VirtualNodeValue)anyValue).id()));
        }
        if (anyValue instanceof Node) {
            return ValueUtils.fromNodeProxy((Node)((Node)anyValue));
        }
        throw new IllegalArgumentException("Do not know how to materialize node value from type " + anyValue.getClass().getName());
    }

    public static RelationshipValue materializeRelationshipValue(EmbeddedProxySPI proxySpi, Object anyValue) {
        if (anyValue instanceof RelationshipValue) {
            return (RelationshipValue)anyValue;
        }
        if (anyValue instanceof VirtualRelationshipValue) {
            return ValueUtils.fromRelationshipProxy((Relationship)proxySpi.newRelationshipProxy(((VirtualRelationshipValue)anyValue).id()));
        }
        if (anyValue instanceof Relationship) {
            return ValueUtils.fromRelationshipProxy((Relationship)((Relationship)anyValue));
        }
        throw new IllegalArgumentException("Do not know how to materialize relationship value from type " + anyValue.getClass().getName());
    }

    public static Iterator iteratorFrom(Object iterable) {
        if (iterable instanceof Iterable) {
            return ((Iterable)iterable).iterator();
        }
        if (iterable instanceof PrimitiveEntityStream) {
            return ((PrimitiveEntityStream)iterable).iterator();
        }
        if (iterable instanceof LongStream) {
            return ((LongStream)iterable).iterator();
        }
        if (iterable instanceof DoubleStream) {
            return ((DoubleStream)iterable).iterator();
        }
        if (iterable instanceof IntStream) {
            return ((IntStream)iterable).iterator();
        }
        if (iterable == null || iterable == Values.NO_VALUE) {
            return Collections.emptyIterator();
        }
        if (iterable.getClass().isArray()) {
            return new ArrayIterator(iterable);
        }
        return Stream.of(iterable).iterator();
    }

    public static LongStream toLongStream(Object list) {
        if (list == null) {
            return LongStream.empty();
        }
        if (list instanceof SequenceValue) {
            throw new IllegalArgumentException("Need to implement support for SequenceValue in CompiledConversionUtils.toLongStream");
        }
        if (list instanceof List) {
            return ((List)list).stream().mapToLong(n -> ((Number)n).longValue());
        }
        if (Object[].class.isAssignableFrom(list.getClass())) {
            return Arrays.stream((Object[])list).mapToLong(n -> ((Number)n).longValue());
        }
        if (list instanceof byte[]) {
            byte[] array = (byte[])list;
            return IntStream.range(0, array.length).mapToLong(i -> array[i]);
        }
        if (list instanceof short[]) {
            short[] array = (short[])list;
            return IntStream.range(0, array.length).mapToLong(i -> array[i]);
        }
        if (list instanceof int[]) {
            return IntStream.of((int[])list).mapToLong(i -> i);
        }
        if (list instanceof long[]) {
            return LongStream.of((long[])list);
        }
        throw new IllegalArgumentException(String.format("Can not be converted to stream: %s", list.getClass().getName()));
    }

    public static DoubleStream toDoubleStream(Object list) {
        if (list == null) {
            return DoubleStream.empty();
        }
        if (list instanceof SequenceValue) {
            throw new IllegalArgumentException("Need to implement support for SequenceValue in CompiledConversionUtils.toDoubleStream");
        }
        if (list instanceof List) {
            return ((List)list).stream().mapToDouble(n -> ((Number)n).doubleValue());
        }
        if (Object[].class.isAssignableFrom(list.getClass())) {
            return Arrays.stream((Object[])list).mapToDouble(n -> ((Number)n).doubleValue());
        }
        if (list instanceof float[]) {
            float[] array = (float[])list;
            return IntStream.range(0, array.length).mapToDouble(i -> array[i]);
        }
        if (list instanceof double[]) {
            return DoubleStream.of((double[])list);
        }
        throw new IllegalArgumentException(String.format("Can not be converted to stream: %s", list.getClass().getName()));
    }

    public static IntStream toBooleanStream(Object list) {
        if (list == null) {
            return IntStream.empty();
        }
        if (list instanceof SequenceValue) {
            throw new IllegalArgumentException("Need to implement support for SequenceValue in CompiledConversionUtils.toBooleanStream");
        }
        if (list instanceof List) {
            return ((List)list).stream().mapToInt(n -> ((Number)n).intValue());
        }
        if (Object[].class.isAssignableFrom(list.getClass())) {
            return Arrays.stream((Object[])list).mapToInt(n -> ((Number)n).intValue());
        }
        if (list instanceof boolean[]) {
            boolean[] array = (boolean[])list;
            return IntStream.range(0, array.length).map(i -> array[i] ? 1 : 0);
        }
        throw new IllegalArgumentException(String.format("Can not be converted to stream: %s", list.getClass().getName()));
    }

    public static long unboxNodeOrNull(VirtualNodeValue value) {
        if (value == null) {
            return -1L;
        }
        return value.id();
    }

    public static long unboxRelationshipOrNull(VirtualRelationshipValue value) {
        if (value == null) {
            return -1L;
        }
        return value.id();
    }

    public static long extractLong(Object obj) {
        if (obj == null || obj == Values.NO_VALUE) {
            return -1L;
        }
        if (obj instanceof VirtualNodeValue) {
            return ((VirtualNodeValue)obj).id();
        }
        if (obj instanceof VirtualRelationshipValue) {
            return ((VirtualRelationshipValue)obj).id();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        throw new IllegalArgumentException(String.format("Can not be converted to long: %s", obj.getClass().getName()));
    }

    public static Object makeValueNeoSafe(Object object) {
        AnyValue value = object instanceof AnyValue ? (AnyValue)object : ValueUtils.of((Object)object);
        return makeValueNeoSafe.apply((AnyValue)value);
    }

    public static Object mapGetProperty(Object object, String key) {
        if (object instanceof MapValue) {
            MapValue map = (MapValue)object;
            return map.get(key);
        }
        if (object instanceof NodeProxyWrappingNodeValue) {
            return Values.of((Object)((NodeProxyWrappingNodeValue)object).nodeProxy().getProperty(key));
        }
        if (object instanceof RelationshipProxyWrappingValue) {
            return Values.of((Object)((RelationshipProxyWrappingValue)object).relationshipProxy().getProperty(key));
        }
        if (object instanceof PropertyContainer) {
            return Values.of((Object)((PropertyContainer)object).getProperty(key));
        }
        if (object instanceof NodeValue) {
            return ((NodeValue)object).properties().get(key);
        }
        if (object instanceof RelationshipValue) {
            return ((RelationshipValue)object).properties().get(key);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.get(key);
        }
        if (object instanceof TemporalValue) {
            return ((TemporalValue)object).get(key);
        }
        if (object instanceof DurationValue) {
            return ((DurationValue)object).get(key);
        }
        if (object instanceof PointValue) {
            return ((PointValue)object).get(key);
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", object), null);
    }

    static class ArrayIterator
    implements Iterator {
        private int position = 0;
        private final int len;
        private final Object array;

        private ArrayIterator(Object array) {
            this.len = Array.getLength(array);
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.len;
        }

        public Object next() {
            if (this.position >= this.len) {
                throw new NoSuchElementException();
            }
            int offset = this.position++;
            return Array.get(this.array, offset);
        }
    }

    public static class CompositeKey {
        private final long[] key;

        private CompositeKey(long[] key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }
    }
}

