/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.v3_1;

import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity;
import org.neo4j.cypher.internal.compiler.v3_1.planner.logical.Selectivity$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v3_1.spi.StatisticsCompletingGraphStatistics;
import org.neo4j.cypher.internal.frontend.v3_1.LabelId;
import org.neo4j.cypher.internal.frontend.v3_1.NameId;
import org.neo4j.cypher.internal.frontend.v3_1.NameId$;
import org.neo4j.cypher.internal.frontend.v3_1.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v3_1.RelTypeId;
import org.neo4j.cypher.internal.spi.v3_1.TransactionBoundGraphStatistics$;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.store.DefaultIndexReference;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-q!B\u0001\u0003\u0011\u0003y\u0011a\b+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg*\u00111\u0001B\u0001\u0005mNz\u0016G\u0003\u0002\u0006\r\u0005\u00191\u000f]5\u000b\u0005\u001dA\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%Q\u0011AB2za\",'O\u0003\u0002\f\u0019\u0005)a.Z85U*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051CA\u0010Ue\u0006t7/Y2uS>t'i\\;oI\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\u001c\"!\u0005\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0011\u0015Y\u0012\u0003\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0003\u001f#\u0011\u0005q$A\u0003baBd\u0017\u0010F\u0002!QM\u0002\"!\t\u0014\u000e\u0003\tR!!B\u0012\u000b\u0005\r!#BA\u0013\u0007\u0003!\u0019w.\u001c9jY\u0016\u0014\u0018BA\u0014#\u0005\r\u001aF/\u0019;jgRL7m]\"p[BdW\r^5oO\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGNDQ!K\u000fA\u0002)\nAA]3bIB\u00111&M\u0007\u0002Y)\u0011QFL\u0001\u0004CBL'BA\u00181\u0003\u0019YWM\u001d8fY*\u0011qAC\u0005\u0003e1\u0012AAU3bI\")A'\ba\u0001k\u0005Q1o\u00195f[\u0006\u0014V-\u00193\u0011\u0005-2\u0014BA\u001c-\u0005)\u00196\r[3nCJ+\u0017\r\u001a\u0004\u0005sE!!HA\u0012CCN,GK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u0014\u0007a\"2\b\u0005\u0002\"y%\u0011QH\t\u0002\u0010\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\"A\u0011\u0006\u000fB\u0001B\u0003%!\u0006\u0003\u00055q\t\u0005\t\u0015!\u00036\u0011\u0015Y\u0002\b\"\u0001B)\r\u0011E)\u0012\t\u0003\u0007bj\u0011!\u0005\u0005\u0006S\u0001\u0003\rA\u000b\u0005\u0006i\u0001\u0003\r!\u000e\u0005\u0006\u000fb\"\t\u0001S\u0001\u0011S:$W\r_*fY\u0016\u001cG/\u001b<jif$2!\u0013+^!\r)\"\nT\u0005\u0003\u0017Z\u0011aa\u00149uS>t\u0007CA'S\u001b\u0005q%BA(Q\u0003\u001dawnZ5dC2T!!U\u0012\u0002\u000fAd\u0017M\u001c8fe&\u00111K\u0014\u0002\f'\u0016dWm\u0019;jm&$\u0018\u0010C\u0003V\r\u0002\u0007a+A\u0003mC\n,G\u000e\u0005\u0002X76\t\u0001L\u0003\u0002\u00043*\u0011!LB\u0001\tMJ|g\u000e^3oI&\u0011A\f\u0017\u0002\b\u0019\u0006\u0014W\r\\%e\u0011\u0015qf\t1\u0001`\u0003!\u0001(o\u001c9feRL\bCA,a\u0013\t\t\u0007LA\u0007Qe>\u0004XM\u001d;z\u0017\u0016L\u0018\n\u001a\u0005\u0006Gb\"\t\u0001Z\u0001\u001fS:$W\r\u001f)s_B,'\u000f^=Fq&\u001cHo]*fY\u0016\u001cG/\u001b<jif$2!S3g\u0011\u0015)&\r1\u0001W\u0011\u0015q&\r1\u0001`\u0011\u0015A\u0007\b\"\u0001j\u0003eqw\u000eZ3t/&$\b\u000eT1cK2\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=\u0015\u0005)l\u0007CA'l\u0013\tagJA\u0006DCJ$\u0017N\\1mSRL\b\"\u00028h\u0001\u0004y\u0017a\u00027bE\u0016d\u0017\n\u001a\t\u0004+)3\u0006\"B99\t\u0003\u0011\u0018AJ2be\u0012Lg.\u00197jif\u0014\u0015\u0010T1cK2\u001c\u0018I\u001c3SK2\fG/[8og\"L\u0007\u000fV=qKR!!n];|\u0011\u0015!\b\u000f1\u0001p\u0003%1'o\\7MC\n,G\u000eC\u0003wa\u0002\u0007q/A\u0005sK2$\u0016\u0010]3JIB\u0019QC\u0013=\u0011\u0005]K\u0018B\u0001>Y\u0005%\u0011V\r\u001c+za\u0016LE\rC\u0003}a\u0002\u0007q.A\u0004u_2\u000b'-\u001a7\t\u000byDD\u0011B@\u0002\u0015\u0005$H*Z1ti>sW\rF\u0002k\u0003\u0003Aq!a\u0001~\u0001\u0004\t)!A\u0003d_VtG\u000fE\u0002\u0016\u0003\u000fI1!!\u0003\u0017\u0005\u0019!u.\u001e2mK\u0002")
public final class TransactionBoundGraphStatistics {
    public static StatisticsCompletingGraphStatistics apply(Read read, SchemaRead schemaRead) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(read, schemaRead);
    }

    public static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics {
        private final Read read;
        private final SchemaRead schemaRead;

        public Option<Selectivity> indexSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                double labeledNodes = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                double indexEntrySelectivity = this.schemaRead.indexUniqueValuesSelectivity(DefaultIndexReference.general((int)label.id(), (int[])new int[]{property.id()}));
                double frequencyOfNodesWithSameValue = 1.0 / indexEntrySelectivity;
                double indexSelectivity2 = frequencyOfNodesWithSameValue / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity2);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Option<Selectivity> indexPropertyExistsSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                double labeledNodes = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                long indexSize = this.schemaRead.indexSize(DefaultIndexReference.general((int)label.id(), (int[])new int[]{property.id()}));
                double indexSelectivity2 = (double)indexSize / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity2);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> labelId) {
            return this.atLeastOne(this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode(labelId)));
        }

        public Cardinality cardinalityByLabelsAndRelationshipType(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return this.atLeastOne(this.read.countsForRelationshipWithoutTxState(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        private Cardinality atLeastOne(double count) {
            return count < 1.0 ? Cardinality$.MODULE$.SINGLE() : new Cardinality(count);
        }

        public BaseTransactionBoundGraphStatistics(Read read, SchemaRead schemaRead) {
            this.read = read;
            this.schemaRead = schemaRead;
        }
    }
}

