/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.cypher.internal.codegen.CompiledCursorUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;

public abstract class CompiledExpandUtils {
    public static RelationshipSelectionCursor connectingRelationships(ReadOperations readOperations, Read read, CursorFactory cursors, NodeCursor nodeCursor, long fromNode, Direction direction, long toNode) {
        try {
            Direction relDirection;
            long endNode;
            long startNode;
            int fromDegree = readOperations.nodeGetDegree(fromNode, direction);
            if (fromDegree == 0) {
                return RelationshipSelectionCursor.EMPTY;
            }
            int toDegree = readOperations.nodeGetDegree(toNode, direction.reverse());
            if (toDegree == 0) {
                return RelationshipSelectionCursor.EMPTY;
            }
            if (fromDegree < toDegree) {
                startNode = fromNode;
                endNode = toNode;
                relDirection = direction;
            } else {
                startNode = toNode;
                endNode = fromNode;
                relDirection = direction.reverse();
            }
            RelationshipSelectionCursor selectionCursor = CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, startNode, relDirection);
            return CompiledExpandUtils.connectingRelationshipsIterator(selectionCursor, endNode);
        }
        catch (EntityNotFoundException ignore) {
            return RelationshipSelectionCursor.EMPTY;
        }
    }

    public static RelationshipSelectionCursor connectingRelationships(ReadOperations readOperations, Read read, CursorFactory cursors, NodeCursor nodeCursor, long fromNode, Direction direction, long toNode, int[] relTypes) {
        try {
            Direction relDirection;
            long endNode;
            long startNode;
            int fromDegree = CompiledExpandUtils.calculateTotalDegree(readOperations, fromNode, direction, relTypes);
            if (fromDegree == 0) {
                return RelationshipSelectionCursor.EMPTY;
            }
            int toDegree = CompiledExpandUtils.calculateTotalDegree(readOperations, toNode, direction.reverse(), relTypes);
            if (toDegree == 0) {
                return RelationshipSelectionCursor.EMPTY;
            }
            if (fromDegree < toDegree) {
                startNode = fromNode;
                endNode = toNode;
                relDirection = direction;
            } else {
                startNode = toNode;
                endNode = fromNode;
                relDirection = direction.reverse();
            }
            RelationshipSelectionCursor selectionCursor = CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, startNode, relDirection, relTypes);
            return CompiledExpandUtils.connectingRelationshipsIterator(selectionCursor, endNode);
        }
        catch (EntityNotFoundException ignore) {
            return RelationshipSelectionCursor.EMPTY;
        }
    }

    private static int calculateTotalDegree(ReadOperations readOperations, long fromNode, Direction direction, int[] relTypes) throws EntityNotFoundException {
        int degree = 0;
        for (int relType2 : relTypes) {
            degree += readOperations.nodeGetDegree(fromNode, direction, relType2);
        }
        return degree;
    }

    private static RelationshipSelectionCursor connectingRelationshipsIterator(final RelationshipSelectionCursor allRelationships, final long toNode) {
        return new RelationshipSelectionCursor(){

            public void close() {
                allRelationships.close();
            }

            public long relationshipReference() {
                return allRelationships.relationshipReference();
            }

            public int type() {
                return allRelationships.type();
            }

            public long otherNodeReference() {
                return allRelationships.otherNodeReference();
            }

            public long sourceNodeReference() {
                return allRelationships.sourceNodeReference();
            }

            public long targetNodeReference() {
                return allRelationships.targetNodeReference();
            }

            public boolean next() {
                while (allRelationships.next()) {
                    if (allRelationships.otherNodeReference() != toNode) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

