/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class CompiledCursorUtils {
    private CompiledCursorUtils() {
        throw new UnsupportedOperationException();
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        CompiledCursorUtils.singleNode(read, nodeCursor, node);
        nodeCursor.properties(propertyCursor);
        while (propertyCursor.next()) {
            if (propertyCursor.propertyKey() != prop) continue;
            return propertyCursor.propertyValue();
        }
        return Values.NO_VALUE;
    }

    public static boolean nodeHasLabel(Read read, NodeCursor nodeCursor, long node, int label) throws EntityNotFoundException {
        if (label == -1) {
            return false;
        }
        CompiledCursorUtils.singleNode(read, nodeCursor, node);
        return nodeCursor.labels().contains(label);
    }

    public static RelationshipSelectionCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction, int[] types) {
        read.singleNode(nodeId, node);
        if (!node.next()) {
            return RelationshipSelectionCursor.EMPTY;
        }
        switch (direction) {
            case OUTGOING: {
                return RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types);
            }
            case INCOMING: {
                return RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types);
            }
            case BOTH: {
                return RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    public static RelationshipSelectionCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction) {
        return CompiledCursorUtils.nodeGetRelationships(read, cursors, node, nodeId, direction, null);
    }

    private static void singleNode(Read read, NodeCursor nodeCursor, long node) throws EntityNotFoundException {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
    }
}

